/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import java.util.List;

final class CheckBadContextualUsagePass
extends CompilerFileSetPass {
    private static final SoyErrorKind CALLS_HTML_FROM_NON_HTML = SoyErrorKind.of("Calling HTML templates from non-HTML context is not allowed. You have these options: 1. Mark the called template with kind=\"text\" or more appropriate kind. 2. Convert the HTML to plain text by '{let $html kind=\"html\"}{call ...}{/let}{htmlToText($html)}', e.g. inside <title>. 3. Stringify the HTML by '{let $html kind=\"html\"}{call ...}{/let}{'''' + $html}', e.g. inside <pre>.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PRINTS_HTML_FROM_NON_HTML = SoyErrorKind.of("Printing HTML from non-HTML context is not allowed. You have these options: 1. Change the type to non-HTML, e.g. to string or uri. 2. Convert the HTML to plain text by htmlToText($html), e.g. inside <title>. 3. Stringify the HTML by outputting '''' + $html, e.g. inside <pre>.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CALLS_CSS_FROM_NON_CSS = SoyErrorKind.of("Calling CSS templates from non-CSS context is not allowed. You likely need to change the kind to \"text\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PRINTS_CSS_FROM_NON_CSS = SoyErrorKind.of("Printing CSS from non-CSS context is not allowed. You likely need to change the type to string (kind=\"text\").", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private static final ImmutableMultimap<SanitizedContentKind, HtmlContext> ALLOWED_CONTEXTS = ImmutableMultimap.of((Object)((Object)SanitizedContentKind.HTML), (Object)((Object)HtmlContext.HTML_PCDATA), (Object)((Object)SanitizedContentKind.HTML), (Object)((Object)HtmlContext.HTML_HTML_ATTR_VALUE), (Object)((Object)SanitizedContentKind.CSS), (Object)((Object)HtmlContext.CSS));

    CheckBadContextualUsagePass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode template : fileNode.getChildren()) {
                for (AbstractParentCommandNode node : SoyTreeUtils.getAllNodesOfType(template, CallNode.class)) {
                    this.checkCallNode((CallNode)node, registry, SanitizedContentKind.HTML, CALLS_HTML_FROM_NON_HTML);
                    this.checkCallNode((CallNode)node, registry, SanitizedContentKind.CSS, CALLS_CSS_FROM_NON_CSS);
                }
                for (AbstractParentCommandNode node : SoyTreeUtils.getAllNodesOfType(template, PrintNode.class)) {
                    this.checkPrintNode((PrintNode)node, SanitizedContentKind.HTML, PRINTS_HTML_FROM_NON_HTML);
                    this.checkPrintNode((PrintNode)node, SanitizedContentKind.CSS, PRINTS_CSS_FROM_NON_CSS);
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkCallNode(CallNode node, TemplateRegistry registry, SanitizedContentKind contentKind, SoyErrorKind errorKind) {
        Optional<SanitizedContentKind> calleeContentKind;
        if (!ALLOWED_CONTEXTS.containsEntry((Object)contentKind, (Object)node.getHtmlContext()) && (calleeContentKind = registry.getCallContentKind(node)).orNull() == contentKind) {
            this.errorReporter.report(node.getSourceLocation(), errorKind, new Object[0]);
        }
    }

    private void checkPrintNode(PrintNode node, SanitizedContentKind contentKind, SoyErrorKind errorKind) {
        SoyType type;
        SanitizedContent.ContentKind contentKindOfPrintDirectives;
        boolean report;
        if (!ALLOWED_CONTEXTS.containsEntry((Object)contentKind, (Object)node.getHtmlContext()) && (report = (contentKindOfPrintDirectives = this.getContentKindOfPrintDirectives(node)) == null ? !(type = node.getExpr().getRoot().getType()).isAssignableFrom(AnyType.getInstance()) && type.isAssignableFrom(SanitizedType.getTypeForContentKind(contentKind)) : contentKindOfPrintDirectives.name().equals(contentKind.name()))) {
            this.errorReporter.report(node.getSourceLocation(), errorKind, new Object[0]);
        }
    }

    private SanitizedContent.ContentKind getContentKindOfPrintDirectives(PrintNode node) {
        for (PrintDirectiveNode printDirectiveNode : Lists.reverse((List)node.getChildren())) {
            if (printDirectiveNode.isSynthetic()) continue;
            SoyPrintDirective printDirective = printDirectiveNode.getPrintDirective();
            return printDirective instanceof SanitizedContentOperator ? ((SanitizedContentOperator)((Object)printDirective)).getContentKind() : SanitizedContent.ContentKind.TEXT;
        }
        return null;
    }
}

