/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;

final class AssertStrictAutoescapingPass
extends CompilerFilePass {
    private static final SoyErrorKind INVALID_AUTOESCAPING = SoyErrorKind.of("Invalid use of non-strict when strict autoescaping is required.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    AssertStrictAutoescapingPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode node : file.getChildren()) {
            if (node.getAutoescapeMode() == AutoescapeMode.STRICT) continue;
            this.errorReporter.report(node.getSourceLocation(), INVALID_AUTOESCAPING, new Object[0]);
        }
    }
}

