/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_DerivedNameAndContext;
import com.google.template.soy.parsepasses.contextautoesc.AutoValue_InferenceEngine_InferencesAndContext;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.RawTextContextUpdater;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Iterator;
import java.util.List;

final class InferenceEngine {
    private final AutoescapeMode autoescapeMode;
    private final AutoescapeMode templateAutoescapeMode;
    private final Inferences inferences;
    private final ErrorReporter errorReporter;

    public static Context inferTemplateEndContext(TemplateNode templateNode, Context startContext, Inferences inferences, ErrorReporter errorReporter) {
        AutoescapeMode autoescapeMode = templateNode.getAutoescapeMode();
        InferenceEngine inferenceEngine = new InferenceEngine(autoescapeMode, autoescapeMode, inferences, errorReporter);
        return inferenceEngine.infer(templateNode, startContext);
    }

    private static void checkBlockEndContext(SoyNode.RenderUnitNode node, Context endContext) {
        if (!endContext.isValidEndContextForContentKind((SanitizedContentKind)((Object)MoreObjects.firstNonNull((Object)((Object)node.getContentKind()), (Object)((Object)SanitizedContentKind.HTML))))) {
            String msg = node.getContentKind() == null ? String.format("A deprecated-contextual block cannot end in context %s. Likely cause is %s.", endContext, endContext.getLikelyEndContextMismatchCause(SanitizedContentKind.HTML)) : String.format("A strict block of kind=\"%s\" cannot end in context %s. Likely cause is %s.", node.getContentKind().asAttributeValue(), endContext, endContext.getLikelyEndContextMismatchCause(node.getContentKind()));
            throw SoyAutoescapeException.createWithNode(msg, node);
        }
    }

    static void inferStrictRenderUnitNode(AutoescapeMode templateAutoescapeMode, SoyNode.RenderUnitNode node, Inferences inferences, ErrorReporter errorReporter) {
        InferenceEngine inferenceEngine = new InferenceEngine(AutoescapeMode.STRICT, templateAutoescapeMode, inferences, errorReporter);
        Context endContext = inferenceEngine.inferChildren(node, Context.getStartContextForContentKind(node.getContentKind()));
        InferenceEngine.checkBlockEndContext(node, endContext);
    }

    private InferenceEngine(AutoescapeMode autoescapeMode, AutoescapeMode templateAutoescapeMode, Inferences inferences, ErrorReporter errorReporter) {
        this.autoescapeMode = autoescapeMode;
        this.templateAutoescapeMode = templateAutoescapeMode;
        this.inferences = inferences;
        this.errorReporter = errorReporter;
    }

    private Context infer(SoyNode node, Context context) {
        return new ContextPropagatingVisitor(context).exec(node);
    }

    private Context inferChildren(SoyNode node, Context context) {
        ContextPropagatingVisitor contextPropagatingVisitor = new ContextPropagatingVisitor(context);
        return contextPropagatingVisitor.execChildren(node);
    }

    @AutoValue
    static abstract class InferencesAndContext {
        InferencesAndContext() {
        }

        static InferencesAndContext create(Inferences inferences, Context context) {
            return new AutoValue_InferenceEngine_InferencesAndContext(inferences, context);
        }

        abstract Inferences inferences();

        abstract Context context();
    }

    @AutoValue
    static abstract class DerivedNameAndContext {
        DerivedNameAndContext() {
        }

        static DerivedNameAndContext create(String derivedName, Context context) {
            return new AutoValue_InferenceEngine_DerivedNameAndContext(derivedName, context);
        }

        abstract String derivedName();

        abstract Context context();
    }

    private final class ContextPropagatingVisitor
    extends AbstractSoyNodeVisitor<Context> {
        private Context context;
        private RawTextNode uriStart = null;

        public ContextPropagatingVisitor(Context context) {
            this.context = context;
        }

        @Override
        public Context exec(SoyNode node) {
            this.visit(node);
            return this.context;
        }

        public Context execChildren(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
            return this.context;
        }

        @Override
        protected void visitTemplateNode(TemplateNode templateNode) {
            Preconditions.checkState((templateNode.getAutoescapeMode() == InferenceEngine.this.autoescapeMode ? 1 : 0) != 0, (Object)"Same ContextPropagatingVisitor cannot be reused for multiple escaping modes.");
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT) {
                Preconditions.checkState((boolean)this.context.isValidStartContextForContentKind(templateNode.getContentKind()), (Object)"Strict templates may only be visited in the context for their declared content kind.");
                this.context = Context.getStartContextForContentKind(templateNode.getContentKind());
            }
            this.visitChildren(templateNode);
            InferenceEngine.checkBlockEndContext(templateNode, this.context);
        }

        @Override
        protected void visitRawTextNode(RawTextNode rawTextNode) {
            this.context = RawTextContextUpdater.processRawText(rawTextNode, this.context);
            if (this.context.uriPart == Context.UriPart.TRUSTED_RESOURCE_URI_END) {
                this.uriStart = rawTextNode;
            }
        }

        @Override
        protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
            this.checkUriEnd();
            Optional<Context.MsgEscapingStrategy> maybeStrategy = this.context.getMsgEscapingStrategy(node);
            if (!maybeStrategy.isPresent()) {
                throw SoyAutoescapeException.createWithNode("Messages are not supported in this context, because it would mean asking translators to write source code; if this is desired, try factoring the message into a {let} block: " + this.context, node);
            }
            Context.MsgEscapingStrategy strategy = (Context.MsgEscapingStrategy)maybeStrategy.get();
            InferenceEngine.this.inferences.setEscapingDirectives(node, this.context, (List<EscapingMode>)strategy.escapingModesForFullMessage);
            Context msgEndContext = new InferenceEngine(InferenceEngine.this.autoescapeMode, InferenceEngine.this.templateAutoescapeMode, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter).inferChildren(node, strategy.childContext);
            if (!msgEndContext.equals(strategy.childContext)) {
                throw SoyAutoescapeException.createWithNode("Message text should not alter the escaping context. " + this.context + " != " + strategy.childContext, node);
            }
        }

        @Override
        protected void visitCallNode(CallNode callNode) {
            this.checkUriEnd();
            this.checkHtmlHtmlAttributePosition(callNode);
            callNode.setHtmlContext(this.context.state);
            String calleeName = callNode instanceof CallBasicNode ? ((CallBasicNode)callNode).getCalleeName() : ((CallDelegateNode)callNode).getDelCalleeName();
            this.context = this.inferCallSite(callNode, this.context, calleeName, InferenceEngine.this.inferences);
            this.visitChildren(callNode);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        private void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            switch (InferenceEngine.this.autoescapeMode) {
                case CONTEXTUAL: {
                    if (node.getContentKind() == null) {
                        this.inferInContextualModeForHtml(node);
                        break;
                    }
                    this.inferInStrictMode(node);
                    break;
                }
                case STRICT: {
                    this.inferInStrictMode(node);
                }
            }
        }

        @Override
        protected void visitIfNode(IfNode ifNode) {
            this.propagateAcrossDisjunction(ifNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode switchNode) {
            this.propagateAcrossDisjunction(switchNode);
        }

        @Override
        protected void visitForNode(ForNode forNode) {
            Context ifemptyContext;
            Optional<Context> combined;
            ForIfemptyNode ieNode;
            List foreachChildren = forNode.getChildren();
            ForNonemptyNode neNode = (ForNonemptyNode)foreachChildren.get(0);
            if (foreachChildren.size() == 2) {
                ieNode = (ForIfemptyNode)foreachChildren.get(1);
            } else if (foreachChildren.size() == 1) {
                ieNode = null;
            } else {
                throw new AssertionError();
            }
            Context afterBody = this.context;
            if (neNode != null) {
                afterBody = InferenceEngine.this.infer(neNode, this.context);
                Context elseContext = InferenceEngine.this.infer(neNode, afterBody);
                combined = Context.union(elseContext, afterBody);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode("{" + forNode.getCommandName() + "} body does not end in the same context after repeated entries.", forNode);
                }
                afterBody = (Context)combined.get();
            }
            if (!(combined = Context.union(ifemptyContext = ieNode != null ? InferenceEngine.this.infer(ieNode, this.context) : this.context, afterBody)).isPresent()) {
                throw SoyAutoescapeException.createWithNode("{" + forNode.getCommandName() + "} body " + (ieNode == null ? "changes context." : "does not end in the same context as {ifempty}."), ieNode == null ? forNode : ieNode);
            }
            this.context = (Context)combined.get();
        }

        @Override
        protected void visitPrintNode(PrintNode printNode) {
            printNode.setHtmlContext(this.context.state);
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT && this.context.state != HtmlContext.TEXT) {
                for (PrintDirectiveNode printDirective : printNode.getChildren()) {
                    if (!printDirective.getName().equals("|noAutoescape") || InferenceEngine.this.templateAutoescapeMode != AutoescapeMode.STRICT) continue;
                    SanitizedContentKind recommendedKind = this.context.getMostAppropriateContentKind();
                    String recommendedKindStr = recommendedKind == SanitizedContentKind.TEXT ? "appropriate kind=\"...\"" : "kind=\"" + recommendedKind.asAttributeValue() + "\"";
                    throw SoyAutoescapeException.createWithNode("noAutoescape is not allowed in strict autoescaping mode. Instead, pass in a {param} with " + recommendedKindStr + " or SanitizedContent.", printNode);
                }
            }
            this.checkUriEnd();
            this.checkHtmlHtmlAttributePosition(printNode);
            ImmutableList<EscapingMode> escapingModes = InferenceEngine.this.inferences.getEscapingMode(printNode);
            Context prev = this.context;
            if (escapingModes.isEmpty()) {
                ImmutableList<EscapingMode> escapingModesToSet = null;
                escapingModesToSet = this.context.getEscapingModes(printNode, printNode.getChildren());
                escapingModes = escapingModesToSet;
                InferenceEngine.this.inferences.setEscapingDirectives(printNode, prev, (List<EscapingMode>)escapingModesToSet);
            } else if (!this.context.isCompatibleWith((EscapingMode)((Object)escapingModes.get(0)))) {
                String msg = String.format("Escaping modes %s not compatible with %s.", escapingModes, this.context);
                throw SoyAutoescapeException.createWithNode(msg, printNode);
            }
            this.context = this.context.getContextAfterDynamicValue();
        }

        private void checkUriEnd() {
            if (this.context.uriPart == Context.UriPart.TRUSTED_RESOURCE_URI_END) {
                throw SoyAutoescapeException.createWithNode("TrustedResourceUris containing dynamic content must have a fixed scheme (https) and host using one of the following formats:\n  * https://foo/\n  * //foo/\n  * /foo\nor move the calculation of this URL outside of the template and use an ordaining API.", this.uriStart);
            }
        }

        private void checkHtmlHtmlAttributePosition(SoyNode node) {
            if (this.context.htmlHtmlAttributePosition == Context.HtmlHtmlAttributePosition.NOT_START) {
                throw SoyAutoescapeException.createWithNode("HTML attribute values containing HTML can use dynamic expressions only at the start of the value.", node);
            }
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            this.visitHtmlTagNode(node);
        }

        @Override
        protected void visitHtmlCommentNode(HtmlCommentNode node) {
            this.context = this.context.transitionToState(HtmlContext.HTML_COMMENT);
            this.visitChildren(node);
            this.context = this.context.transitionToState(HtmlContext.HTML_PCDATA);
        }

        private void visitHtmlTagNode(HtmlTagNode tag) {
            this.context = this.context.transitionToState(tag.getKind() == SoyNode.Kind.HTML_OPEN_TAG_NODE ? HtmlContext.HTML_BEFORE_OPEN_TAG_NAME : HtmlContext.HTML_BEFORE_CLOSE_TAG_NAME);
            if (tag.getTagName().isStatic()) {
                this.context = this.context.transitionToTagName(tag);
            } else {
                this.visit((SoyNode)tag.getChild(0));
            }
            Preconditions.checkArgument((this.context.elType != Context.ElementType.NONE ? 1 : 0) != 0);
            this.context = this.context.transitionToTagBody();
            for (int i = 1; i < tag.numChildren(); ++i) {
                this.visit((SoyNode)tag.getChild(i));
            }
            this.context = this.context.transitionToAfterTag();
        }

        @Override
        protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
            Node first = node.getChild(0);
            if (first.getKind() == SoyNode.Kind.RAW_TEXT_NODE) {
                this.context = this.context.transitionToAttrName(((RawTextNode)first).getRawText());
            } else {
                this.visit((SoyNode)first);
            }
            if (node.hasValue()) {
                this.visit((SoyNode)node.getChild(1));
            }
            this.context = this.context.transitionToTagBody();
        }

        @Override
        protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
            Context.AttributeEndDelimiter delim;
            switch (node.getQuotes()) {
                case DOUBLE: {
                    delim = Context.AttributeEndDelimiter.DOUBLE_QUOTE;
                    break;
                }
                case NONE: {
                    delim = Context.AttributeEndDelimiter.SPACE_OR_TAG_END;
                    break;
                }
                case SINGLE: {
                    delim = Context.AttributeEndDelimiter.SINGLE_QUOTE;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.context = this.context.transitionToAttrValue(delim);
            this.visitChildren(node);
            this.context = this.context.transitionToTagBody();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private SanitizedContentKind getCommonContentKindIfStrict(List<TemplateMetadata> templates) {
            if (templates.isEmpty()) {
                return null;
            }
            SanitizedContentKind contentKind = templates.get(0).getContentKind();
            for (TemplateMetadata template : templates) {
                Preconditions.checkArgument((template.getContentKind() == contentKind ? 1 : 0) != 0);
            }
            return contentKind;
        }

        private Context inferCallSite(CallNode callNode, Context startContext, String templateName, Inferences inferences) {
            ImmutableList<TemplateMetadata> targets = inferences.lookupTemplates(callNode);
            SanitizedContentKind calleeStrictContentKind = this.getCommonContentKindIfStrict((List<TemplateMetadata>)targets);
            if (InferenceEngine.this.autoescapeMode == AutoescapeMode.STRICT) {
                if (calleeStrictContentKind != null && startContext.isValidStartContextForContentKind(calleeStrictContentKind)) {
                    return startContext.getContextAfterDynamicValue();
                }
                if (calleeStrictContentKind != null || targets.isEmpty()) {
                    inferences.setEscapingDirectives(callNode, startContext, (List<EscapingMode>)startContext.getEscapingModes(callNode, (List<PrintDirectiveNode>)ImmutableList.of()));
                    return startContext.getContextAfterDynamicValue();
                }
                throw SoyAutoescapeException.createWithNode("Soy strict autoescaping currently forbids calls to non-strict templates. Please migrate the callee to strict.", callNode);
            }
            if (targets.isEmpty()) {
                return startContext;
            }
            if (calleeStrictContentKind != null) {
                if (!startContext.isValidStartContextForContentKindLoose(calleeStrictContentKind)) {
                    String msg = String.format("Cannot call strictly autoescaped template %s of kind=\"%s\" from incompatible context %s. Strict templates generate extra code to safely call templates of other content kinds, but non-strict templates do not.", templateName, calleeStrictContentKind.asAttributeValue(), startContext);
                    throw SoyAutoescapeException.createWithNode(msg, callNode);
                }
                return startContext;
            }
            if (!startContext.equals(Context.HTML_PCDATA)) {
                throw SoyAutoescapeException.createWithNode("Attempting to call non-strict template '" + templateName + "' from a non-strict template in context '" + (Object)((Object)startContext.state) + "'. This is no longer supported. Please migrate to strict autoescaping.", callNode);
            }
            return Context.HTML_PCDATA;
        }

        private void propagateAcrossDisjunction(SoyNode.ParentSoyNode<?> node) {
            Iterator childIt = node.getChildren().iterator();
            SoyNode firstBranch = (SoyNode)childIt.next();
            Context out = InferenceEngine.this.infer(firstBranch, this.context);
            boolean sawElseOrDefault = false;
            while (childIt.hasNext()) {
                SoyNode branch = (SoyNode)childIt.next();
                Context brOut = InferenceEngine.this.infer(branch, this.context);
                Optional<Context> combined = Context.union(out, brOut);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode((node instanceof IfNode ? "{if} command branch ends in a different context than preceding branches:" : "{switch} command case ends in a different context than preceding cases:") + " " + branch.toSourceString(), branch);
                }
                out = (Context)combined.get();
                if (!(branch instanceof IfElseNode) && !(branch instanceof SwitchDefaultNode)) continue;
                sawElseOrDefault = true;
            }
            if (!sawElseOrDefault) {
                Optional<Context> combined = Context.union(this.context, out);
                if (!combined.isPresent()) {
                    throw SoyAutoescapeException.createWithNode(node instanceof IfNode ? "{if} command without {else} changes context." : "{switch} command without {default} changes context.", node);
                }
                out = (Context)combined.get();
            }
            this.context = out;
        }

        private void inferInStrictMode(SoyNode.RenderUnitNode node) {
            InferenceEngine.inferStrictRenderUnitNode(InferenceEngine.this.templateAutoescapeMode, node, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter);
        }

        private void inferInContextualModeForHtml(SoyNode.CommandNode node) {
            Context paramContentNodeEndContext = new InferenceEngine(AutoescapeMode.CONTEXTUAL, InferenceEngine.this.templateAutoescapeMode, InferenceEngine.this.inferences, InferenceEngine.this.errorReporter).inferChildren(node, Context.HTML_PCDATA);
            if (!paramContentNodeEndContext.equals(Context.HTML_PCDATA)) {
                throw SoyAutoescapeException.createWithNode("Blocks should start and end in HTML context.", node);
            }
        }
    }
}

