/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;

@Immutable
public class SoyTemplateInfo {
    private final String name;
    private final ImmutableMap<String, ParamRequisiteness> paramMap;
    private final String autoescapeMode;

    protected SoyTemplateInfo(String name, ImmutableMap<String, ParamRequisiteness> paramMap, String autoescapeMode) {
        this.name = name;
        Preconditions.checkArgument((name.lastIndexOf(46) > 0 ? 1 : 0) != 0);
        this.paramMap = paramMap;
        this.autoescapeMode = autoescapeMode;
    }

    public String getName() {
        return this.name;
    }

    public String getPartialName() {
        return this.name.substring(this.name.lastIndexOf(46));
    }

    public ImmutableMap<String, ParamRequisiteness> getParams() {
        return this.paramMap;
    }

    public String getAutoescapeMode() {
        return this.autoescapeMode;
    }

    public static enum ParamRequisiteness {
        REQUIRED,
        OPTIONAL;

    }
}

