/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.ibm.icu.text.PluralRules;
import com.ibm.icu.util.ULocale;
import java.util.Objects;
import javax.annotation.Nullable;

public final class SoyMsgPluralPart
extends SoyMsgPart {
    private final String pluralVarName;
    private final int offset;
    private final ImmutableList<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> cases;

    public SoyMsgPluralPart(String pluralVarName, int offset, Iterable<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> cases) {
        this.pluralVarName = pluralVarName;
        this.offset = offset;
        this.cases = ImmutableList.copyOf(cases);
    }

    public String getPluralVarName() {
        return this.pluralVarName;
    }

    public int getOffset() {
        return this.offset;
    }

    public ImmutableList<SoyMsgPart.Case<SoyMsgPluralCaseSpec>> getCases() {
        return this.cases;
    }

    public ImmutableList<SoyMsgPart> lookupCase(long pluralValue, @Nullable ULocale locale) {
        ImmutableList<SoyMsgPart> caseParts = null;
        boolean hasNonExplicitCases = false;
        ImmutableList<SoyMsgPart> otherCaseParts = null;
        for (SoyMsgPart.Case case0 : this.getCases()) {
            SoyMsgPluralCaseSpec pluralCaseSpec = (SoyMsgPluralCaseSpec)case0.spec();
            SoyMsgPluralCaseSpec.Type caseType = pluralCaseSpec.getType();
            if (caseType == SoyMsgPluralCaseSpec.Type.EXPLICIT) {
                if (pluralCaseSpec.getExplicitValue() != pluralValue) continue;
                caseParts = case0.parts();
                break;
            }
            if (caseType == SoyMsgPluralCaseSpec.Type.OTHER) {
                otherCaseParts = case0.parts();
                continue;
            }
            hasNonExplicitCases = true;
        }
        if (caseParts == null && hasNonExplicitCases) {
            String pluralKeyword = PluralRules.forLocale((ULocale)locale).select((double)(pluralValue - (long)this.offset));
            SoyMsgPluralCaseSpec.Type correctCaseType = new SoyMsgPluralCaseSpec(pluralKeyword).getType();
            for (SoyMsgPart.Case case0 : this.getCases()) {
                if (((SoyMsgPluralCaseSpec)case0.spec()).getType() != correctCaseType) continue;
                caseParts = case0.parts();
                break;
            }
        }
        if (caseParts == null) {
            caseParts = otherCaseParts;
        }
        return (ImmutableList)Preconditions.checkNotNull(caseParts);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoyMsgPluralPart)) {
            return false;
        }
        SoyMsgPluralPart otherPlural = (SoyMsgPluralPart)other;
        return this.offset == otherPlural.offset && this.pluralVarName.equals(otherPlural.pluralVarName) && this.cases.equals(otherPlural.cases);
    }

    public int hashCode() {
        return Objects.hash(SoyMsgPluralPart.class, this.offset, this.pluralVarName, this.cases);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"Plural").omitNullValues().addValue((Object)this.pluralVarName).add("cases", this.cases).add("offset", this.offset == 0 ? null : Integer.toString(this.offset)).toString();
    }
}

