/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class JavaScriptValueFactoryImpl
extends JavaScriptValueFactory {
    private static final JavaScriptValueImpl ERROR_VALUE = new JavaScriptValueImpl(Expression.fromExpr(new JsExpr("(function(){throw new Error('if you see this, the soy compiler has swallowed an error :-(');})()", Integer.MAX_VALUE), (Iterable<GoogRequire>)ImmutableList.of()));
    private static final SoyErrorKind NULL_RETURN = SoyErrorKind.of(JavaScriptValueFactoryImpl.formatPlain("{2}.applyForJavaScriptSource returned null."), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of(JavaScriptValueFactoryImpl.formatPlain("{2}"), SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter reporter;
    private final SoyJsSrcOptions jsSrcOptions;
    private final BidiGlobalDir dir;

    private static String formatPlain(String innerFmt) {
        return "Error in plugin implementation for function ''{0}''.\n" + innerFmt + "\nPlugin implementation: {1}";
    }

    private JavaScriptPluginContext createContext(final CodeChunk.Generator codeGenerator) {
        return new JavaScriptPluginContext(){

            @Override
            public JavaScriptValue getBidiDir() {
                if (JavaScriptValueFactoryImpl.this.dir.isStaticValue()) {
                    return new JavaScriptValueImpl(Expression.number(JavaScriptValueFactoryImpl.this.dir.getStaticValue()));
                }
                return new JavaScriptValueImpl(Expression.ifExpression(JsRuntime.SOY_IS_LOCALE_RTL, Expression.number(-1L)).setElse(Expression.number(1L)).build(codeGenerator));
            }
        };
    }

    public JavaScriptValueFactoryImpl(SoyJsSrcOptions jsSrcOptions, BidiGlobalDir dir, ErrorReporter reporter) {
        this.dir = dir;
        this.jsSrcOptions = jsSrcOptions;
        this.reporter = reporter;
    }

    Expression applyFunction(SourceLocation location, String name, SoyJavaScriptSourceFunction fn, List<Expression> args, CodeChunk.Generator codeGenerator) {
        JavaScriptValueImpl result;
        try {
            result = (JavaScriptValueImpl)fn.applyForJavaScriptSource(this, JavaScriptValueFactoryImpl.wrapParams(args), this.createContext(codeGenerator));
            if (result == null) {
                this.report(location, name, fn, NULL_RETURN, fn.getClass().getSimpleName());
                result = ERROR_VALUE;
            }
        }
        catch (Throwable t) {
            BaseUtils.trimStackTraceTo(t, this.getClass());
            this.report(location, name, fn, UNEXPECTED_ERROR, Throwables.getStackTraceAsString((Throwable)t));
            result = ERROR_VALUE;
        }
        return result.impl;
    }

    private void report(SourceLocation location, String name, SoyJavaScriptSourceFunction fn, SoyErrorKind error, Object ... additionalArgs) {
        Object[] args = new Object[additionalArgs.length + 2];
        args[0] = name;
        args[1] = fn.getClass().getName();
        System.arraycopy(additionalArgs, 0, args, 2, additionalArgs.length);
        this.reporter.report(location, error, args);
    }

    private Expression chainedDotAccess(Expression base, String suffix) {
        for (String part : Splitter.on((char)'.').splitToList((CharSequence)suffix)) {
            base = base.dotAccess(part);
        }
        return base;
    }

    private Expression referenceModuleExport(String moduleName, String export) {
        Expression module;
        if (this.jsSrcOptions.shouldGenerateGoogModules()) {
            String alias = "$" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, moduleName.replace('.', '_'));
            module = GoogRequire.createWithAlias(moduleName, alias).reference();
        } else {
            module = GoogRequire.create(moduleName).googModuleGet();
        }
        return this.chainedDotAccess(module, export);
    }

    @Override
    public JavaScriptValue getModuleExport(String moduleName, String export) {
        return new JavaScriptValueImpl(this.referenceModuleExport(moduleName, export));
    }

    @Override
    public JavaScriptValue callModuleFunction(String moduleName, String functionName, JavaScriptValue ... params) {
        return new JavaScriptValueImpl(this.referenceModuleExport(moduleName, functionName).call(JavaScriptValueFactoryImpl.unwrapParams(Arrays.asList(params))));
    }

    @Override
    public JavaScriptValue callNamespaceFunction(String googProvide, String fullFunctionName, JavaScriptValue ... params) {
        Preconditions.checkArgument((fullFunctionName.startsWith(googProvide) && (fullFunctionName.length() == googProvide.length() || fullFunctionName.charAt(googProvide.length()) == '.') ? 1 : 0) != 0, (String)"expected '%s' to be in the namespace of '%s'. '%s' should be fully qualified", (Object)fullFunctionName, (Object)googProvide, (Object)fullFunctionName);
        GoogRequire require = GoogRequire.create(googProvide);
        Expression function = fullFunctionName.length() == googProvide.length() ? require.reference() : this.chainedDotAccess(require.reference(), fullFunctionName.substring(googProvide.length() + 1));
        return new JavaScriptValueImpl(function.call(JavaScriptValueFactoryImpl.unwrapParams(Arrays.asList(params))));
    }

    @Override
    public JavaScriptValueImpl unsafeUncheckedExpression(String expr) {
        return new JavaScriptValueImpl(Expression.fromExpr(new JsExpr(expr, 0), (Iterable<GoogRequire>)ImmutableList.of()));
    }

    @Override
    public JavaScriptValueImpl constant(long num) {
        return new JavaScriptValueImpl(Expression.number(num));
    }

    @Override
    public JavaScriptValueImpl constant(double num) {
        return new JavaScriptValueImpl(Expression.number(num));
    }

    @Override
    public JavaScriptValueImpl constant(String str) {
        return new JavaScriptValueImpl(Expression.stringLiteral(str));
    }

    @Override
    public JavaScriptValueImpl constant(boolean bool) {
        return new JavaScriptValueImpl(bool ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE);
    }

    @Override
    public JavaScriptValue constantNull() {
        return new JavaScriptValueImpl(Expression.LITERAL_NULL);
    }

    @Override
    public JavaScriptValueImpl global(String globalSymbol) {
        return new JavaScriptValueImpl(Expression.dottedIdNoRequire(globalSymbol));
    }

    private static List<Expression> unwrapParams(List<JavaScriptValue> params) {
        ArrayList<Expression> exprs = new ArrayList<Expression>(params.size());
        for (JavaScriptValue v : params) {
            exprs.add(((JavaScriptValueImpl)v).impl);
        }
        return exprs;
    }

    private static List<JavaScriptValue> wrapParams(List<Expression> params) {
        ArrayList<JavaScriptValue> exprs = new ArrayList<JavaScriptValue>(params.size());
        for (Expression e : params) {
            exprs.add(new JavaScriptValueImpl(e));
        }
        return exprs;
    }

    @VisibleForTesting
    static final class JavaScriptValueImpl
    implements JavaScriptValue {
        @VisibleForTesting
        final Expression impl;

        JavaScriptValueImpl(Expression impl) {
            this.impl = (Expression)Preconditions.checkNotNull((Object)impl);
        }

        @Override
        public JavaScriptValueImpl isNonNull() {
            return new JavaScriptValueImpl(this.impl.doubleNotEquals(Expression.LITERAL_NULL));
        }

        @Override
        public JavaScriptValueImpl isNull() {
            return new JavaScriptValueImpl(this.impl.doubleEquals(Expression.LITERAL_NULL));
        }

        @Override
        public Optional<String> asStringLiteral() {
            return this.impl.asStringLiteral();
        }

        @Override
        public JavaScriptValueImpl coerceToString() {
            return new JavaScriptValueImpl(CodeChunkUtils.concatChunksForceString((List<? extends Expression>)ImmutableList.of((Object)this.impl)));
        }

        @Override
        public JavaScriptValueImpl invokeMethod(String methodName, JavaScriptValue ... args) {
            return new JavaScriptValueImpl(this.impl.dotAccess(methodName).call(JavaScriptValueFactoryImpl.unwrapParams(Arrays.asList(args))));
        }

        @Override
        public JavaScriptValueImpl accessProperty(String ident) {
            return new JavaScriptValueImpl(this.impl.dotAccess(ident));
        }

        public String toString() {
            return this.impl.getCode();
        }
    }
}

