/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Switch;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import javax.annotation.Nullable;

@Immutable
@AutoValue
abstract class Switch
extends Statement {
    Switch() {
    }

    abstract Expression switchOn();

    abstract ImmutableList<CaseClause> caseClauses();

    @Nullable
    abstract CodeChunk defaultCaseBody();

    static Switch create(Expression switchOn, ImmutableList<CaseClause> caseClauses, @Nullable CodeChunk defaultCaseBody) {
        return new AutoValue_Switch(switchOn, caseClauses, defaultCaseBody);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        block41: {
            ctx.appendInitialStatements(this.switchOn());
            for (CaseClause caseClause : this.caseClauses()) {
                for (Expression caseLabel : caseClause.caseLabels) {
                    ctx.appendInitialStatements(caseLabel);
                }
            }
            ctx.append("switch (").appendOutputExpression(this.switchOn()).append(") ");
            try (FormattingContext ignored = ctx.enterBlock();){
                for (CaseClause caseClause : this.caseClauses()) {
                    for (int i = 0; i < caseClause.caseLabels.size(); ++i) {
                        ctx.append("case ").appendOutputExpression((Expression)caseClause.caseLabels.get(i)).append(":");
                        if (i >= caseClause.caseLabels.size() - 1) continue;
                        ctx.endLine();
                    }
                    try (FormattingContext ignored2 = ctx.enterCaseBody();){
                        ctx.appendAll(caseClause.caseBody).endLine().append("break;").endLine();
                    }
                    ctx.endLine();
                }
                if (this.defaultCaseBody() == null) break block41;
                ctx.append("default:");
                try (FormattingContext ignored2 = ctx.enterCaseBody();){
                    ctx.appendAll(this.defaultCaseBody());
                }
            }
        }
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.switchOn().collectRequires(collector);
        for (CaseClause caseClause : this.caseClauses()) {
            for (Expression caseLabel : caseClause.caseLabels) {
                caseLabel.collectRequires(collector);
            }
            caseClause.caseBody.collectRequires(collector);
        }
        if (this.defaultCaseBody() != null) {
            this.defaultCaseBody().collectRequires(collector);
        }
    }

    @Immutable
    static final class CaseClause {
        private final ImmutableList<Expression> caseLabels;
        private final Statement caseBody;

        CaseClause(ImmutableList<Expression> caseLabels, Statement caseBody) {
            this.caseLabels = caseLabels;
            this.caseBody = caseBody;
        }
    }
}

