/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.template.soy.jssrc.dsl.AutoValue_StatementList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;

@AutoValue
abstract class StatementList
extends Statement {
    private static final StatementList EMPTY = new AutoValue_StatementList((ImmutableList<? extends Statement>)ImmutableList.of());

    StatementList() {
    }

    abstract ImmutableList<? extends Statement> statements();

    static StatementList create(Iterable<? extends Statement> statements) {
        if (Iterables.isEmpty(statements)) {
            return EMPTY;
        }
        ImmutableList.Builder unrolled = ImmutableList.builder();
        for (Statement statement : statements) {
            if (statement instanceof StatementList) {
                unrolled.addAll(((StatementList)statement).statements());
                continue;
            }
            unrolled.add((Object)statement);
        }
        return new AutoValue_StatementList((ImmutableList<? extends Statement>)unrolled.build());
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (Statement statement : this.statements()) {
            statement.collectRequires(collector);
        }
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (Statement statement : this.statements()) {
            ctx.appendAll(statement);
        }
    }
}

