/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_FieldDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class FieldDeclaration
extends Expression {
    abstract String fieldName();

    abstract JsDoc jsDoc();

    @Nullable
    abstract Expression value();

    public static FieldDeclaration createWithoutValue(String fieldName, JsDoc jsDoc) {
        return new AutoValue_FieldDeclaration((ImmutableList<Statement>)ImmutableList.of(), fieldName, jsDoc, null);
    }

    public static FieldDeclaration create(String fieldName, JsDoc jsDoc, Expression value) {
        return new AutoValue_FieldDeclaration((ImmutableList<Statement>)ImmutableList.of(), fieldName, jsDoc, value);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        if (this.value() != null) {
            this.value().collectRequires(collector);
        }
        this.jsDoc().collectRequires(collector);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(this.jsDoc());
        Expression assignment = Expression.id("this").dotAccess(this.fieldName());
        if (this.value() != null) {
            assignment = assignment.assign(this.value());
        }
        ctx.appendOutputExpression(assignment);
    }
}

