/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Conditional;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.IfThenPair;
import com.google.template.soy.jssrc.dsl.Statement;
import javax.annotation.Nullable;

@Immutable
@AutoValue
abstract class Conditional
extends Statement {
    Conditional() {
    }

    abstract ImmutableList<IfThenPair<Statement>> conditions();

    @Nullable
    abstract Statement trailingElse();

    static Conditional create(ImmutableList<IfThenPair<Statement>> conditions, @Nullable Statement trailingElse) {
        Preconditions.checkArgument((!conditions.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Conditional(conditions, trailingElse);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        this.formatIfClause(ctx);
        int numRightBracesToClose = 0;
        Expression firstPredicate = ((IfThenPair)this.conditions().get((int)0)).predicate;
        for (IfThenPair condition : this.conditions().subList(1, this.conditions().size())) {
            if (firstPredicate.initialStatements().containsAll(condition.predicate.initialStatements())) {
                Conditional.formatElseIfClauseWithNoDependencies(condition, ctx);
                continue;
            }
            Conditional.formatElseIfClauseWithDependencies(condition, ctx);
            ++numRightBracesToClose;
        }
        this.formatElseClause(ctx);
        for (int i = 0; i < numRightBracesToClose; ++i) {
            ctx.close();
        }
        ctx.endLine();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (IfThenPair child : this.conditions()) {
            child.predicate.collectRequires(collector);
            ((CodeChunk)child.consequent).collectRequires(collector);
        }
        if (this.trailingElse() != null) {
            this.trailingElse().collectRequires(collector);
        }
    }

    private void formatIfClause(FormattingContext ctx) {
        IfThenPair first = (IfThenPair)this.conditions().get(0);
        ctx.appendInitialStatements(first.predicate).append("if (").appendOutputExpression(first.predicate).append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll((CodeChunk)first.consequent);
        }
    }

    private static void formatElseIfClauseWithNoDependencies(IfThenPair<?> condition, FormattingContext ctx) {
        ctx.append(" else if (").appendOutputExpression(condition.predicate).append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll((CodeChunk)condition.consequent);
        }
    }

    private static void formatElseIfClauseWithDependencies(IfThenPair<?> condition, FormattingContext ctx) {
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendInitialStatements(condition.predicate).append("if (").appendOutputExpression(condition.predicate).append(") ");
            ctx.enterBlock();
            ctx.appendAll((CodeChunk)condition.consequent);
        }
    }

    private void formatElseClause(FormattingContext ctx) {
        if (this.trailingElse() == null) {
            return;
        }
        ctx.append(" else ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.trailingElse());
        }
        ctx.endLine();
    }
}

