/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.runtime;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.SoyVisualElementData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.SoyString;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.runtime.DetachableContentProvider;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.internal.ShortCircuitable;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.ibm.icu.util.ULocale;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class JbcSrcRuntime {
    private static final Logger logger = Logger.getLogger(JbcSrcRuntime.class.getName());
    public static final SoyValueProvider NULL_PROVIDER = new SoyValueProvider(){

        @Override
        public RenderResult status() {
            return RenderResult.done();
        }

        @Override
        public SoyValue resolve() {
            return null;
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
            appendable.append("null");
            return RenderResult.done();
        }

        public String toString() {
            return "NULL_PROVIDER";
        }
    };
    private static final LoggingAdvisingAppendable LOGGER = new AbstractLoggingAdvisingAppendable(){

        @Override
        public final boolean softLimitReached() {
            return false;
        }

        @Override
        protected final void doAppend(char c) throws IOException {
            System.out.append(c);
        }

        @Override
        protected final void doAppend(CharSequence csq, int start, int end) throws IOException {
            System.out.append(csq, start, end);
        }

        @Override
        protected final void doAppend(CharSequence csq) throws IOException {
            System.out.append(csq);
        }

        @Override
        protected final void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected final void doExitLoggableElement() {
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            String val = funCall.placeholderValue();
            for (Function directive : escapers) {
                val = (String)directive.apply((Object)val);
            }
            System.out.append(val);
        }
    };

    public static AssertionError unexpectedStateError(int state) {
        return new AssertionError((Object)("Unexpected state requested: " + state));
    }

    public static void debugger(String fileName, int lineNumber) {
        logger.log(Level.WARNING, String.format("Hit {debugger} statement at %s:%d. Put a breakpoint here to halt Soy rendering.", fileName, lineNumber), new Exception());
    }

    public static boolean stringEqualsAsNumber(String expr, double number) {
        if (expr == null) {
            return false;
        }
        try {
            return Double.parseDouble(expr) == number;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static SoyValue resolveSoyValueProvider(SoyValueProvider provider) {
        SoyValue value = provider.resolve();
        return JbcSrcRuntime.handleTofuNull(value);
    }

    private static SoyValue handleTofuNull(SoyValue value) {
        if (value instanceof NullData | value instanceof UndefinedData) {
            return null;
        }
        return value;
    }

    public static SoyValueProvider getFieldProvider(SoyRecord record, String field) {
        if (record == null) {
            throw new NullPointerException("Attempted to access field '" + field + "' of null");
        }
        SoyValueProvider provider = record.getFieldProvider(field);
        return provider == null | provider instanceof NullData ? NULL_PROVIDER : provider;
    }

    public static SoyValue getProtoField(SoyProtoValue proto, String field) {
        if (proto == null) {
            throw new NullPointerException("Attempted to access field '" + field + "' of null");
        }
        return JbcSrcRuntime.handleTofuNull(proto.getProtoField(field));
    }

    public static SoyString checkSoyString(Object o) {
        if (o instanceof SoyString && o instanceof SanitizedContent && ((SanitizedContent)o).getContentKind() != SanitizedContent.ContentKind.TEXT && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, String.format("Passing in sanitized content into a template that accepts only string is forbidden.  Please modify the template to take in %s.", new Object[]{((SanitizedContent)o).getContentKind()}), new Exception());
        }
        return (SoyString)o;
    }

    public static SoyValue callLegacySoyFunction(LegacyFunctionAdapter fnAdapter, List<SoyValue> args) {
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return JbcSrcRuntime.handleTofuNull(fnAdapter.computeForJava(args));
    }

    public static SoyValue applyPrintDirective(SoyJavaPrintDirective directive, SoyValue value, List<SoyValue> args) {
        value = value == null ? NullData.INSTANCE : value;
        for (int i = 0; i < args.size(); ++i) {
            if (args.get(i) != null) continue;
            args.set(i, NullData.INSTANCE);
        }
        return directive.applyForJava(value, args);
    }

    public static CompiledTemplate applyEscapers(CompiledTemplate delegate, ImmutableList<SoyJavaPrintDirective> directives) {
        SanitizedContent.ContentKind kind = delegate.kind();
        if (JbcSrcRuntime.canSkipEscaping(directives, kind)) {
            return delegate;
        }
        return new EscapedCompiledTemplate(delegate, (List<SoyJavaPrintDirective>)directives, kind);
    }

    private static boolean canSkipEscaping(ImmutableList<SoyJavaPrintDirective> directives, @Nullable SanitizedContent.ContentKind kind) {
        if (kind == null) {
            return false;
        }
        for (SoyJavaPrintDirective directive : directives) {
            if (directive instanceof ShortCircuitable && ((ShortCircuitable)((Object)directive)).isNoopForKind(kind)) continue;
            return false;
        }
        return true;
    }

    public static SoyValueProvider getSoyListItem(List<SoyValueProvider> list, long index) {
        if (list == null) {
            throw new NullPointerException("Attempted to access list item '" + index + "' of null");
        }
        int size = list.size();
        if (index < (long)size & index >= 0L) {
            SoyValueProvider soyValueProvider = list.get((int)index);
            return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
        }
        return NULL_PROVIDER;
    }

    public static RenderResult getListStatus(List<? extends SoyValueProvider> soyValueProviders) {
        int size = soyValueProviders.size();
        for (int i = 0; i < size; ++i) {
            RenderResult result = soyValueProviders.get(i).status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static RenderResult getMapStatus(Map<String, ? extends SoyValueProvider> soyValueProviders) {
        for (SoyValueProvider soyValueProvider : soyValueProviders.values()) {
            RenderResult result = soyValueProvider.status();
            if (result.isDone()) continue;
            return result;
        }
        return RenderResult.done();
    }

    public static SoyValueProvider getSoyMapItem(SoyMap soyMap, SoyValue key) {
        SoyValueProvider soyValueProvider;
        if (soyMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        if (key == null) {
            key = NullData.INSTANCE;
        }
        return (soyValueProvider = soyMap.getProvider(key)) == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static SoyValueProvider getSoyLegacyObjectMapItem(SoyLegacyObjectMap legacyObjectMap, SoyValue key) {
        if (legacyObjectMap == null) {
            throw new NullPointerException("Attempted to access map item '" + key + "' of null");
        }
        SoyValueProvider soyValueProvider = legacyObjectMap.getItemProvider(key);
        return soyValueProvider == null ? NULL_PROVIDER : soyValueProvider;
    }

    public static boolean compareNullableString(@Nullable String string, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return Objects.equals(string, other.toString());
        }
        if (other instanceof NumberData) {
            if (string == null) {
                return false;
            }
            try {
                return Double.parseDouble(string) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    public static LoggingAdvisingAppendable logger() {
        return LOGGER;
    }

    public static int rangeLoopLength(int start, int end, int step) {
        int length = end - start;
        if ((length ^ step) < 0) {
            return 0;
        }
        return length / step + (length % step == 0 ? 0 : 1);
    }

    public static boolean coerceToBoolean(double v) {
        return v != 0.0 & !Double.isNaN(v);
    }

    public static String coerceToString(@Nullable SoyValue v) {
        return v == null ? "null" : v.coerceToString();
    }

    public static ClosePropagatingAppendable propagateClose(LoggingAdvisingAppendable delegate, ImmutableList<Closeable> closeables) {
        return new ClosePropagatingAppendable(delegate, closeables);
    }

    public static LogStatement createLogStatement(SoyVisualElementData veData, boolean logOnly) {
        return LogStatement.create(veData.ve().id(), veData.data(), logOnly);
    }

    private static final class ClosePropagatingAppendable
    extends ForwardingLoggingAdvisingAppendable
    implements Closeable {
        final ImmutableList<Closeable> closeables;

        ClosePropagatingAppendable(LoggingAdvisingAppendable delegate, ImmutableList<Closeable> closeables) {
            super(delegate);
            this.closeables = closeables;
        }

        @Override
        public void close() throws IOException {
            for (Closeable c : this.closeables) {
                c.close();
            }
        }
    }

    private static final class EscapedCompiledTemplate
    implements CompiledTemplate {
        private final CompiledTemplate delegate;
        private final ImmutableList<SoyJavaPrintDirective> directives;
        @Nullable
        private final SanitizedContent.ContentKind kind;
        private final LoggingAdvisingAppendable buffer = LoggingAdvisingAppendable.buffering();

        EscapedCompiledTemplate(CompiledTemplate delegate, List<SoyJavaPrintDirective> directives, @Nullable SanitizedContent.ContentKind kind) {
            this.delegate = delegate;
            this.directives = ImmutableList.copyOf(directives);
            this.kind = kind;
        }

        @Override
        public RenderResult render(LoggingAdvisingAppendable appendable, RenderContext context) throws IOException {
            RenderResult result = this.delegate.render(this.buffer, context);
            if (result.isDone()) {
                SoyValue resultData = this.kind == null ? StringData.forValue(this.buffer.toString()) : UnsafeSanitizedContentOrdainer.ordainAsSafe(this.buffer.toString(), this.kind);
                for (SoyJavaPrintDirective directive : this.directives) {
                    resultData = directive.applyForJava(resultData, (List<SoyValue>)ImmutableList.of());
                }
                appendable.append(resultData.coerceToString());
            }
            return result;
        }

        @Override
        @Nullable
        public SanitizedContent.ContentKind kind() {
            return this.kind;
        }
    }

    public static final class PlrSelMsgRenderer
    extends MsgRenderer {
        private boolean resolvedCases;
        private long remainder = -1L;

        public PlrSelMsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders) {
            super(msgId, msgParts, locale, numPlaceholders);
        }

        @Override
        public RenderResult doRender(LoggingAdvisingAppendable out) throws IOException {
            if (!this.resolvedCases) {
                ImmutableList<SoyMsgPart> parts = this.msgParts;
                while (!parts.isEmpty()) {
                    SoyMsgPart first = (SoyMsgPart)parts.get(0);
                    if (first instanceof SoyMsgSelectPart) {
                        SoyMsgSelectPart selectPart = (SoyMsgSelectPart)first;
                        String selectCase = this.getSelectCase(selectPart.getSelectVarName());
                        parts = selectPart.lookupCase(selectCase);
                        continue;
                    }
                    if (!(first instanceof SoyMsgPluralPart)) break;
                    SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)first;
                    long pluralValue = this.getPlural(pluralPart.getPluralVarName());
                    parts = pluralPart.lookupCase(pluralValue, this.locale);
                    this.remainder = pluralValue - (long)pluralPart.getOffset();
                }
                this.msgParts = parts;
                this.resolvedCases = true;
            }
            return super.doRender(out);
        }

        @Override
        long getPluralRemainder() {
            return this.remainder;
        }

        private String getSelectCase(String selectVarName) {
            String selectCase = (String)this.placeholders.get(selectVarName);
            if (selectCase == null) {
                throw new IllegalArgumentException("No value provided for select: '" + selectVarName + "'");
            }
            return selectCase;
        }

        private long getPlural(String pluralVarName) {
            IntegerData pluralValue = (IntegerData)this.placeholders.get(pluralVarName);
            if (pluralValue == null) {
                throw new IllegalArgumentException("No value provided for plural: '" + pluralVarName + "'");
            }
            return pluralValue.longValue();
        }
    }

    public static class MsgRenderer
    extends DetachableContentProvider {
        ImmutableList<SoyMsgPart> msgParts;
        final ULocale locale;
        private int partIndex;
        private SoyValueProvider pendingRender;
        final Map<String, Object> placeholders;
        @Nullable
        Set<String> startPlaceholders;
        @Nullable
        Multiset<String> startPlaceholderRenderCount;
        @Nullable
        SetMultimap<String, String> endPlaceholderToStartPlaceholder;
        private final long msgId;

        public MsgRenderer(long msgId, ImmutableList<SoyMsgPart> msgParts, @Nullable ULocale locale, int numPlaceholders) {
            super(null);
            this.msgId = msgId;
            this.msgParts = msgParts;
            this.locale = locale;
            this.placeholders = Maps.newLinkedHashMapWithExpectedSize((int)numPlaceholders);
        }

        public void setPlaceholder(String placeholderName, Object placeholderValue) {
            Object prev = this.placeholders.put(placeholderName, placeholderValue);
            if (prev != null) {
                throw new IllegalArgumentException("found multiple placeholders: " + prev + " and " + placeholderValue + " for key " + placeholderName);
            }
        }

        public void setPlaceholderAndOrdering(String placeholderName, Object placeholderValue, String endPlaceholder) {
            if (this.endPlaceholderToStartPlaceholder == null) {
                this.startPlaceholders = new HashSet<String>();
                this.endPlaceholderToStartPlaceholder = HashMultimap.create();
                this.startPlaceholderRenderCount = HashMultiset.create();
            }
            if (this.endPlaceholderToStartPlaceholder.containsKey((Object)placeholderName)) {
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order contraints should not be transitive.", placeholderName, this.endPlaceholderToStartPlaceholder.get((Object)placeholderName).iterator().next(), endPlaceholder));
            }
            if (this.startPlaceholders.contains(endPlaceholder)) {
                String beforePlaceholder = null;
                for (Map.Entry entry : this.endPlaceholderToStartPlaceholder.entries()) {
                    if (!endPlaceholder.equals(entry.getValue())) continue;
                    beforePlaceholder = (String)entry.getKey();
                    break;
                }
                throw new IllegalArgumentException(String.format("%s is supposed to come after %s but before %s. Order contraints should not be transitive.", endPlaceholder, placeholderName, beforePlaceholder));
            }
            this.setPlaceholder(placeholderName, placeholderValue);
            this.endPlaceholderToStartPlaceholder.put((Object)endPlaceholder, (Object)placeholderName);
            this.startPlaceholders.add(placeholderName);
        }

        @Override
        public RenderResult doRender(LoggingAdvisingAppendable out) throws IOException {
            if (this.pendingRender != null) {
                RenderResult result = this.pendingRender.renderAndResolve(out, false);
                if (!result.isDone()) {
                    return result;
                }
                this.pendingRender = null;
            }
            for (int i = this.partIndex; i < this.msgParts.size(); ++i) {
                SoyMsgPart msgPart = (SoyMsgPart)this.msgParts.get(i);
                if (msgPart instanceof SoyMsgRawTextPart) {
                    out.append(((SoyMsgRawTextPart)msgPart).getRawText());
                    continue;
                }
                if (msgPart instanceof SoyMsgPlaceholderPart) {
                    String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                    if (this.endPlaceholderToStartPlaceholder != null) {
                        if (this.startPlaceholders.contains(placeholderName)) {
                            this.startPlaceholderRenderCount.add((Object)placeholderName);
                        } else {
                            Set startPlaceholders = this.endPlaceholderToStartPlaceholder.get((Object)placeholderName);
                            if (!startPlaceholders.isEmpty()) {
                                boolean matched = false;
                                for (String startPlaceholder : startPlaceholders) {
                                    if (!this.startPlaceholderRenderCount.remove((Object)startPlaceholder)) continue;
                                    matched = true;
                                    break;
                                }
                                if (!matched) {
                                    throw new IllegalStateException(String.format("Expected placeholder '%s' to come after one of %s, in message %d", placeholderName, startPlaceholders, this.msgId));
                                }
                            }
                        }
                    }
                    SoyValueProvider placeholderValue = (SoyValueProvider)this.placeholders.get(placeholderName);
                    try {
                        RenderResult result = placeholderValue.renderAndResolve(out, false);
                        if (result.isDone()) continue;
                        this.partIndex = i + 1;
                        this.pendingRender = placeholderValue;
                        return result;
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException(placeholderName, e);
                    }
                }
                if (msgPart instanceof SoyMsgPluralRemainderPart) {
                    out.append(String.valueOf(this.getPluralRemainder()));
                    continue;
                }
                throw new AssertionError((Object)("unexpected part: " + msgPart));
            }
            if (this.startPlaceholderRenderCount != null && !this.startPlaceholderRenderCount.isEmpty()) {
                throw new IllegalStateException(String.format("The following placeholders never had their matching placeholders rendered in message %d: %s", this.msgId, this.startPlaceholderRenderCount.elementSet()));
            }
            return RenderResult.done();
        }

        long getPluralRemainder() {
            throw new UnsupportedOperationException("this is not a plural message so remainder don't make sense");
        }
    }
}

