/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

public abstract class SoyRuntimeType {
    private static final LoadingCache<SoyType, Optional<PrimitiveSoyType>> primitiveTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SoyType, Optional<PrimitiveSoyType>>(){

        public Optional<PrimitiveSoyType> load(SoyType key) throws Exception {
            return Optional.fromNullable((Object)SoyRuntimeType.unboxedTypeImpl(key));
        }
    });
    private static final LoadingCache<SoyType, BoxedSoyType> boxedTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SoyType, BoxedSoyType>(){

        public BoxedSoyType load(SoyType key) throws Exception {
            return SoyRuntimeType.boxedSoyTypeImpl(key);
        }
    });
    private final SoyType soyType;
    private final Type runtimeType;

    public static Optional<SoyRuntimeType> getUnboxedType(SoyType soyType) {
        Optional typed = (Optional)primitiveTypeCache.getUnchecked((Object)soyType);
        return typed;
    }

    public static SoyRuntimeType getBoxedType(SoyType soyType) {
        return (SoyRuntimeType)boxedTypeCache.getUnchecked((Object)soyType);
    }

    @Nullable
    private static BoxedSoyType boxedSoyTypeImpl(SoyType soyType) {
        Optional primitive = (Optional)primitiveTypeCache.getUnchecked((Object)soyType);
        if (primitive.isPresent()) {
            return ((PrimitiveSoyType)primitive.get()).box();
        }
        switch (soyType.getKind()) {
            case LIST: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_LIST_TYPE);
            }
            case LEGACY_OBJECT_MAP: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_LEGACY_OBJECT_MAP_TYPE);
            }
            case MAP: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_MAP_TYPE);
            }
            case RECORD: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_RECORD_TYPE);
            }
            case VE: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_VISUAL_ELEMENT_TYPE);
            }
            case VE_DATA: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_VISUAL_ELEMENT_DATA_TYPE);
            }
            case UNION: {
                SoyType nonNullType = SoyTypes.removeNull(soyType);
                if (!nonNullType.equals(soyType)) {
                    BoxedSoyType boxedType = (BoxedSoyType)SoyRuntimeType.getBoxedType(nonNullType);
                    return new BoxedSoyType(soyType, boxedType.runtimeType());
                }
                SoyRuntimeType memberType = null;
                for (SoyType member : ((UnionType)soyType).getMembers()) {
                    BoxedSoyType boxed = (BoxedSoyType)SoyRuntimeType.getBoxedType(member);
                    if (memberType == null) {
                        memberType = boxed;
                        continue;
                    }
                    if (memberType.runtimeType().equals((Object)boxed.runtimeType())) continue;
                    memberType = null;
                    break;
                }
                if (memberType != null) {
                    return new BoxedSoyType(soyType, memberType.runtimeType());
                }
            }
            case UNKNOWN: 
            case ANY: {
                return new BoxedSoyType(soyType, BytecodeUtils.SOY_VALUE_TYPE);
            }
        }
        throw new AssertionError((Object)("can't map " + soyType + " to a boxed soy runtime type"));
    }

    @Nullable
    private static PrimitiveSoyType unboxedTypeImpl(SoyType soyType) {
        switch (soyType.getKind()) {
            case NULL: {
                return new PrimitiveSoyType((SoyType)NullType.getInstance(), BytecodeUtils.OBJECT.type(), BytecodeUtils.SOY_VALUE_TYPE);
            }
            case BOOL: {
                return new PrimitiveSoyType((SoyType)BoolType.getInstance(), Type.BOOLEAN_TYPE, Type.getType(BooleanData.class));
            }
            case STRING: {
                return new PrimitiveSoyType((SoyType)StringType.getInstance(), BytecodeUtils.STRING_TYPE, BytecodeUtils.SOY_STRING_TYPE);
            }
            case INT: {
                return new PrimitiveSoyType((SoyType)IntType.getInstance(), Type.LONG_TYPE, BytecodeUtils.INTEGER_DATA_TYPE);
            }
            case FLOAT: {
                return new PrimitiveSoyType((SoyType)FloatType.getInstance(), Type.DOUBLE_TYPE, Type.getType(FloatData.class));
            }
            case PROTO_ENUM: {
                return SoyRuntimeType.enumType((SoyProtoEnumType)soyType);
            }
            case ATTRIBUTES: 
            case CSS: 
            case URI: 
            case HTML: 
            case JS: 
            case TRUSTED_RESOURCE_URI: {
                return SoyRuntimeType.sanitizedType((SanitizedType)soyType);
            }
            case PROTO: {
                return SoyRuntimeType.protoType((SoyProtoType)soyType);
            }
            case LIST: {
                return new PrimitiveSoyType(soyType, BytecodeUtils.LIST_TYPE, BytecodeUtils.SOY_LIST_TYPE);
            }
            case LEGACY_OBJECT_MAP: 
            case MAP: 
            case RECORD: 
            case VE: 
            case VE_DATA: {
                return null;
            }
            case UNION: {
                PrimitiveSoyType primitive;
                SoyType nonNullType = SoyTypes.removeNull(soyType);
                if (!nonNullType.equals(soyType) && (primitive = (PrimitiveSoyType)SoyRuntimeType.getUnboxedType(nonNullType).orNull()) != null && !BytecodeUtils.isPrimitive(primitive.runtimeType())) {
                    return new PrimitiveSoyType(soyType, primitive.runtimeType(), primitive.box().runtimeType());
                }
                SoyRuntimeType memberType = null;
                for (SoyType member : ((UnionType)soyType).getMembers()) {
                    PrimitiveSoyType primitive2 = (PrimitiveSoyType)SoyRuntimeType.getUnboxedType(member).orNull();
                    if (primitive2 == null) {
                        return null;
                    }
                    if (memberType == null) {
                        memberType = primitive2;
                        continue;
                    }
                    if (memberType.runtimeType().equals((Object)primitive2.runtimeType()) && ((PrimitiveSoyType)memberType).box().runtimeType().equals((Object)primitive2.box().runtimeType())) continue;
                    memberType = null;
                    break;
                }
                if (memberType != null) {
                    return new PrimitiveSoyType(soyType, memberType.runtimeType(), ((PrimitiveSoyType)memberType).box().runtimeType());
                }
            }
            case UNKNOWN: 
            case ANY: {
                return null;
            }
        }
        throw new AssertionError((Object)("can't map " + soyType + " to an unboxed soy runtime type"));
    }

    private static PrimitiveSoyType protoType(SoyProtoType soyType) {
        return new PrimitiveSoyType((SoyType)soyType, Type.getType((String)('L' + soyType.getNameForBackend(SoyBackendKind.JBC_SRC).replace('.', '/') + ';')), BytecodeUtils.SOY_PROTO_VALUE_TYPE);
    }

    private static PrimitiveSoyType sanitizedType(SanitizedType soyType) {
        return new PrimitiveSoyType((SoyType)soyType, BytecodeUtils.STRING_TYPE, Type.getType(SanitizedContent.class));
    }

    private static PrimitiveSoyType enumType(SoyProtoEnumType enumType) {
        return new PrimitiveSoyType((SoyType)enumType, Type.INT_TYPE, BytecodeUtils.INTEGER_DATA_TYPE);
    }

    private SoyRuntimeType(SoyType soyType, Type runtimeType) {
        this.soyType = (SoyType)Preconditions.checkNotNull((Object)soyType);
        this.runtimeType = (Type)Preconditions.checkNotNull((Object)runtimeType);
    }

    public final SoyType soyType() {
        return this.soyType;
    }

    public final Type runtimeType() {
        return this.runtimeType;
    }

    public boolean assignableToNullableInt() {
        return this.assignableToNullableType(IntType.getInstance());
    }

    public boolean assignableToNullableFloat() {
        return this.assignableToNullableType(FloatType.getInstance());
    }

    public boolean assignableToNullableNumber() {
        return this.assignableToNullableType(SoyTypes.NUMBER_TYPE);
    }

    public boolean assignableToNullableString() {
        return this.soyType.getKind().isKnownStringOrSanitizedContent() || this.soyType.getKind() == SoyType.Kind.UNION && SoyTypes.removeNull(this.soyType).getKind().isKnownStringOrSanitizedContent();
    }

    private boolean assignableToNullableType(SoyType type) {
        return type.isAssignableFrom(this.soyType) || this.soyType.getKind() == SoyType.Kind.UNION && type.isAssignableFrom(SoyTypes.removeNull(this.soyType));
    }

    public boolean isKnownString() {
        return this.soyType.getKind() == SoyType.Kind.STRING;
    }

    public boolean isKnownStringOrSanitizedContent() {
        if (this.soyType.getKind().isKnownStringOrSanitizedContent()) {
            return true;
        }
        if (this.soyType.getKind() == SoyType.Kind.UNION) {
            for (SoyType member : ((UnionType)this.soyType).getMembers()) {
                if (member.getKind().isKnownStringOrSanitizedContent()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isKnownSanitizedContent() {
        return this.soyType.getKind().isKnownSanitizedContent();
    }

    public boolean isKnownInt() {
        return this.soyType.getKind() == SoyType.Kind.INT;
    }

    public final boolean isKnownFloat() {
        return this.soyType.getKind() == SoyType.Kind.FLOAT;
    }

    public final boolean isKnownListOrUnionOfLists() {
        return this.isTypeOfKind(SoyType.Kind.LIST);
    }

    public final ListType asListType() {
        Preconditions.checkState((boolean)this.isKnownListOrUnionOfLists());
        if (this.soyType instanceof ListType) {
            return (ListType)this.soyType;
        }
        ArrayList<SoyType> members = new ArrayList<SoyType>();
        for (SoyType member : ((UnionType)this.soyType).getMembers()) {
            ListType memberAsList = (ListType)member;
            if (memberAsList.getElementType() == null) continue;
            members.add(memberAsList.getElementType());
        }
        return ListType.of(UnionType.of(members));
    }

    public final boolean isKnownLegacyObjectMapOrUnionOfMaps() {
        return this.isTypeOfKind(SoyType.Kind.LEGACY_OBJECT_MAP);
    }

    public final boolean isKnownMapOrUnionOfMaps() {
        return this.isTypeOfKind(SoyType.Kind.MAP);
    }

    public final boolean isKnownBool() {
        return this.soyType.getKind() == SoyType.Kind.BOOL;
    }

    public final boolean isKnownProtoOrUnionOfProtos() {
        return this.isTypeOfKind(SoyType.Kind.PROTO);
    }

    private boolean isTypeOfKind(SoyType.Kind kind) {
        if (this.soyType.getKind() == kind) {
            return true;
        }
        if (this.soyType.getKind() == SoyType.Kind.UNION) {
            for (SoyType member : ((UnionType)this.soyType).getMembers()) {
                if (member.getKind() == kind) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean isKnownNumber() {
        return SoyTypes.NUMBER_TYPE.isAssignableFrom(this.soyType);
    }

    public final SoyRuntimeType asNonNullable() {
        return this.withNewSoyType(SoyTypes.removeNull(this.soyType));
    }

    public final SoyRuntimeType asNullable() {
        return this.withNewSoyType(SoyTypes.makeNullable(this.soyType));
    }

    private SoyRuntimeType withNewSoyType(SoyType newSoyType) {
        if (newSoyType != this.soyType) {
            if (this.isBoxed()) {
                return SoyRuntimeType.getBoxedType(newSoyType);
            }
            return (SoyRuntimeType)SoyRuntimeType.getUnboxedType(newSoyType).get();
        }
        return this;
    }

    abstract boolean isBoxed();

    abstract SoyRuntimeType box();

    public String toString() {
        return "SoyRuntimeType{" + this.soyType + ", " + this.runtimeType + "}";
    }

    private static final class BoxedSoyType
    extends SoyRuntimeType {
        BoxedSoyType(SoyType soyType, Type runtimeType) {
            super(soyType, runtimeType);
        }

        @Override
        public boolean isBoxed() {
            return true;
        }

        @Override
        SoyRuntimeType box() {
            return this;
        }
    }

    private static final class PrimitiveSoyType
    extends SoyRuntimeType {
        private final BoxedSoyType boxedType;

        PrimitiveSoyType(SoyType soyType, Type runtimeType, Type boxedType) {
            super(soyType, runtimeType);
            this.boxedType = new BoxedSoyType(soyType, boxedType);
        }

        @Override
        public boolean isBoxed() {
            return false;
        }

        @Override
        BoxedSoyType box() {
            return this.boxedType;
        }
    }
}

