/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionLite;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeProducer;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.MapType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class ProtoUtils {
    private static final Type BYTE_STRING_TYPE = Type.getType(ByteString.class);
    private static final Type EXTENSION_TYPE = Type.getType(GeneratedMessage.GeneratedExtension.class);
    private static final Type[] NO_METHOD_ARGS = new Type[0];
    private static final Type[] ONE_INT_ARG = new Type[]{Type.INT_TYPE};
    private static final MethodRef BASE_ENCODING_BASE_64 = MethodRef.create(BaseEncoding.class, "base64", new Class[0]).asNonNullable().asCheap();
    private static final MethodRef BASE_ENCODING_DECODE = MethodRef.create(BaseEncoding.class, "decode", CharSequence.class).asNonNullable().asCheap();
    private static final MethodRef BASE_ENCODING_ENCODE = MethodRef.create(BaseEncoding.class, "encode", byte[].class).asNonNullable().asCheap();
    private static final MethodRef BYTE_STRING_COPY_FROM = MethodRef.create(ByteString.class, "copyFrom", byte[].class).asNonNullable();
    private static final MethodRef BYTE_STRING_TO_BYTE_ARRAY = MethodRef.create(ByteString.class, "toByteArray", new Class[0]).asNonNullable();
    private static final MethodRef EXTENDABLE_BUILDER_ADD_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableBuilder.class, "addExtension", ExtensionLite.class, Object.class).asNonNullable();
    private static final MethodRef EXTENDABLE_BUILDER_SET_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableBuilder.class, "setExtension", ExtensionLite.class, Object.class).asNonNullable();
    private static final MethodRef EXTENDABLE_MESSAGE_GET_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableMessage.class, "getExtension", ExtensionLite.class).asNonNullable().asCheap();
    private static final MethodRef EXTENDABLE_MESSAGE_HAS_EXTENSION = MethodRef.create(GeneratedMessage.ExtendableMessage.class, "hasExtension", ExtensionLite.class).asNonNullable().asCheap();
    private static final ImmutableMap<String, MethodRef> SAFE_PROTO_TO_ACCESSOR = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(SafeHtmlProto.class)).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(SafeScriptProto.class)).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(SafeStyleProto.class)).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(SafeStyleSheetProto.class)).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(SafeUrlProto.class)).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)ProtoUtils.createSafeAccessor(TrustedResourceUrlProto.class)).build();
    private static final ImmutableMap<String, MethodRef> SANITIZED_CONTENT_TO_PROTO = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeHtmlProto", new Class[0])).put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeScriptProto", new Class[0])).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeStyleProto", new Class[0])).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeStyleSheetProto", new Class[0])).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toSafeUrlProto", new Class[0])).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)MethodRef.create(SanitizedContent.class, "toTrustedResourceUrlProto", new Class[0])).build();

    ProtoUtils() {
    }

    private static MethodRef createSafeAccessor(Class<?> clazz) {
        String simpleName = clazz.getSimpleName();
        simpleName = simpleName.substring(0, simpleName.length() - "Proto".length());
        return MethodRef.create(clazz, "getPrivateDoNotAccessOrElse" + simpleName + "WrappedValue", new Class[0]).asNonNullable().asCheap();
    }

    static SoyExpression accessField(SoyProtoType protoType, SoyExpression baseExpr, FieldAccessNode node) {
        return new AccessorGenerator(protoType, baseExpr, node).generate();
    }

    static SoyExpression createProto(ProtoInitNode node, Function<ExprNode, SoyExpression> compilerFunction, Supplier<? extends ExpressionDetacher> detacher, TemplateVariableManager varManager) {
        return new ProtoInitGenerator(node, compilerFunction, detacher, varManager).generate();
    }

    private static boolean shouldConvertBetweenStringAndLong(Descriptors.FieldDescriptor descriptor) {
        DescriptorProtos.FieldOptions.JSType jsType;
        return com.google.template.soy.internal.proto.ProtoUtils.hasJsType(descriptor) && (jsType = com.google.template.soy.internal.proto.ProtoUtils.getJsType(descriptor)) == DescriptorProtos.FieldOptions.JSType.JS_STRING;
    }

    private static TypeInfo messageRuntimeType(Descriptors.Descriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.create(className);
    }

    private static TypeInfo enumRuntimeType(Descriptors.EnumDescriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.create(className);
    }

    private static TypeInfo builderRuntimeType(Descriptors.Descriptor descriptor) {
        String className = JavaQualifiedNames.getClassName(descriptor);
        return TypeInfo.create(className + "$Builder");
    }

    private static Type getRuntimeType(Descriptors.FieldDescriptor field) {
        switch (field.getJavaType()) {
            case BOOLEAN: {
                return Type.BOOLEAN_TYPE;
            }
            case BYTE_STRING: {
                return BYTE_STRING_TYPE;
            }
            case DOUBLE: {
                return Type.DOUBLE_TYPE;
            }
            case ENUM: {
                return ProtoUtils.isProto3EnumField(field) ? Type.INT_TYPE : TypeInfo.create(JavaQualifiedNames.getClassName(field.getEnumType())).type();
            }
            case FLOAT: {
                return Type.FLOAT_TYPE;
            }
            case INT: {
                return Type.INT_TYPE;
            }
            case LONG: {
                return Type.LONG_TYPE;
            }
            case MESSAGE: {
                return TypeInfo.create(JavaQualifiedNames.getClassName(field.getMessageType())).type();
            }
            case STRING: {
                return BytecodeUtils.STRING_TYPE;
            }
        }
        throw new AssertionError((Object)"unexpected type");
    }

    private static MethodRef getGetterMethod(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkArgument((!descriptor.isExtension() ? 1 : 0) != 0, (String)"extensions do not have getter methods. %s", (Object)descriptor);
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        boolean isProto3Enum = ProtoUtils.isProto3EnumField(descriptor);
        return MethodRef.createInstanceMethod(message, new Method("get" + JavaQualifiedNames.getFieldName(descriptor, true) + (isProto3Enum ? "Value" : ""), isProto3Enum ? Type.INT_TYPE : ProtoUtils.getRuntimeType(descriptor), NO_METHOD_ARGS)).asNonNullable().asCheap();
    }

    private static boolean isProto3EnumField(Descriptors.FieldDescriptor descriptor) {
        return descriptor.getType() == Descriptors.FieldDescriptor.Type.ENUM && descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3;
    }

    private static MethodRef getHasserMethod(Descriptors.FieldDescriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(message, new Method("has" + JavaQualifiedNames.getFieldName(descriptor, true), Type.BOOLEAN_TYPE, NO_METHOD_ARGS)).asCheap();
    }

    private static MethodRef getOneOfCaseMethod(Descriptors.OneofDescriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(message, new Method("get" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true) + "Case", TypeInfo.create(JavaQualifiedNames.getCaseEnumClassName(descriptor)).type(), NO_METHOD_ARGS)).asCheap();
    }

    private static MethodRef getBuilderMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor);
        return MethodRef.createStaticMethod(message, new Method("newBuilder", builder.type(), NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getDefaultInstanceMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        return MethodRef.createStaticMethod(message, new Method("getDefaultInstance", message.type(), NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getPutMethod(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkState((boolean)descriptor.isMapField());
        List mapFields = descriptor.getMessageType().getFields();
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor.getContainingType());
        return MethodRef.createInstanceMethod(builder, new Method("put" + JavaQualifiedNames.getFieldName(descriptor, true), builder.type(), new Type[]{ProtoUtils.getRuntimeType((Descriptors.FieldDescriptor)mapFields.get(0)), ProtoUtils.getRuntimeType((Descriptors.FieldDescriptor)mapFields.get(1))}));
    }

    private static MethodRef getSetOrAddMethod(Descriptors.FieldDescriptor descriptor) {
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor.getContainingType());
        String prefix = descriptor.isRepeated() ? "add" : "set";
        boolean isProto3EnumField = ProtoUtils.isProto3EnumField(descriptor);
        String suffix = isProto3EnumField ? "Value" : "";
        return MethodRef.createInstanceMethod(builder, new Method(prefix + JavaQualifiedNames.getFieldName(descriptor, true) + suffix, builder.type(), new Type[]{isProto3EnumField ? Type.INT_TYPE : ProtoUtils.getRuntimeType(descriptor)})).asNonNullable();
    }

    private static MethodRef getBuildMethod(Descriptors.Descriptor descriptor) {
        TypeInfo message = ProtoUtils.messageRuntimeType(descriptor);
        TypeInfo builder = ProtoUtils.builderRuntimeType(descriptor);
        return MethodRef.createInstanceMethod(builder, new Method("build", message.type(), NO_METHOD_ARGS)).asNonNullable();
    }

    private static MethodRef getForNumberMethod(Descriptors.EnumDescriptor descriptor) {
        TypeInfo enumType = ProtoUtils.enumRuntimeType(descriptor);
        return MethodRef.createStaticMethod(enumType, new Method("forNumber", enumType.type(), ONE_INT_ARG)).asNonNullable().asCheap();
    }

    private static FieldRef getExtensionField(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkArgument((boolean)descriptor.isExtension(), (String)"%s is not an extension", (Object)descriptor);
        String extensionFieldName = JavaQualifiedNames.getFieldName(descriptor, false);
        if (descriptor.getExtensionScope() != null) {
            TypeInfo owner = ProtoUtils.messageRuntimeType(descriptor.getExtensionScope());
            return FieldRef.createPublicStaticField(owner, extensionFieldName, EXTENSION_TYPE);
        }
        String containingClass = JavaQualifiedNames.getPackage(descriptor.getFile()) + "." + JavaQualifiedNames.getOuterClassname(descriptor.getFile());
        return FieldRef.createPublicStaticField(TypeInfo.create(containingClass), extensionFieldName, EXTENSION_TYPE);
    }

    private static final class ProtoInitGenerator {
        private final ProtoInitNode node;
        private final Function<ExprNode, SoyExpression> compilerFunction;
        private final Supplier<? extends ExpressionDetacher> detacher;
        private final TemplateVariableManager varManager;
        private final SoyProtoType protoType;
        private final Descriptors.Descriptor descriptor;

        ProtoInitGenerator(ProtoInitNode node, Function<ExprNode, SoyExpression> compilerFunction, Supplier<? extends ExpressionDetacher> detacher, TemplateVariableManager varManager) {
            this.node = node;
            this.compilerFunction = compilerFunction;
            this.detacher = detacher;
            this.varManager = varManager;
            this.protoType = (SoyProtoType)node.getType();
            this.descriptor = this.protoType.getDescriptor();
        }

        private SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerFunction.apply((Object)expr);
        }

        SoyExpression generate() {
            if (this.node.numChildren() == 0) {
                Expression defaultInstance = ProtoUtils.getDefaultInstanceMethod(this.descriptor).invoke(new Expression[0]);
                return SoyExpression.forProto((SoyRuntimeType)SoyRuntimeType.getUnboxedType(this.protoType).get(), defaultInstance);
            }
            final Expression newBuilderCall = ProtoUtils.getBuilderMethod(this.descriptor).invoke(new Expression[0]);
            final ImmutableList<Statement> setters = this.getFieldSetters();
            final MethodRef buildCall = ProtoUtils.getBuildMethod(this.descriptor);
            Expression expression = new Expression(ProtoUtils.messageRuntimeType(this.descriptor).type()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    newBuilderCall.gen(cb);
                    for (Statement setter : setters) {
                        setter.gen(cb);
                    }
                    buildCall.invokeUnchecked(cb);
                }
            }.asNonNullable();
            return SoyExpression.forProto((SoyRuntimeType)SoyRuntimeType.getUnboxedType(this.protoType).get(), expression);
        }

        private ImmutableList<Statement> getFieldSetters() {
            ImmutableList.Builder setters = ImmutableList.builder();
            for (int i = 0; i < this.node.numChildren(); ++i) {
                Descriptors.FieldDescriptor field = this.protoType.getFieldDescriptor(this.node.getParamName(i).identifier());
                ExprNode baseArg = this.node.getChild(i);
                Statement setter = field.isRepeated() ? this.handleRepeated(baseArg, field) : (field.isExtension() ? this.handleExtension(this.compile(baseArg), field) : this.handleNormalSetter(this.compile(baseArg), field));
                setters.add((Object)setter);
            }
            return setters.build();
        }

        private Statement handleMapSetter(final SoyExpression keyArg, final SoyExpression valueArg, Descriptors.FieldDescriptor field) {
            final MethodRef putMethod = ProtoUtils.getPutMethod(field);
            List descriptors = field.getMessageType().getFields();
            final Descriptors.FieldDescriptor keyDescriptor = (Descriptors.FieldDescriptor)descriptors.get(0);
            final Descriptors.FieldDescriptor valueDescriptor = (Descriptors.FieldDescriptor)descriptors.get(1);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    keyArg.gen(cb);
                    ProtoInitGenerator.unboxAndCoerce(cb, keyArg, keyDescriptor);
                    valueArg.gen(cb);
                    ProtoInitGenerator.unboxAndCoerce(cb, valueArg, valueDescriptor);
                    putMethod.invokeUnchecked(cb);
                }
            };
        }

        private Statement handleNormalSetter(final SoyExpression baseArg, final Descriptors.FieldDescriptor field) {
            final MethodRef setterMethod = ProtoUtils.getSetOrAddMethod(field);
            final boolean isNullable = !baseArg.isNonNullable();
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    Label argIsNull = null;
                    Label end = null;
                    if (isNullable) {
                        argIsNull = new Label();
                        end = new Label();
                        cb.dup();
                        cb.ifNull(argIsNull);
                    }
                    ProtoInitGenerator.unboxAndCoerce(cb, baseArg, field);
                    setterMethod.invokeUnchecked(cb);
                    if (isNullable) {
                        cb.goTo(end);
                        cb.mark(argIsNull);
                        cb.pop();
                        cb.mark(end);
                    }
                }
            };
        }

        private Statement handleMapSetterNotNull(SoyExpression mapArg, Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument((boolean)mapArg.isNonNullable());
            Expression resolved = ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProviderMap(mapArg.invoke(MethodRef.SOY_MAP_IMPL_AS_JAVA_MAP, new Expression[0]));
            TemplateVariableManager.Scope scope = this.varManager.enterScope();
            final TemplateVariableManager.Variable map = scope.createTemporary(field.getName() + "__map", resolved);
            final TemplateVariableManager.Variable iter = scope.createTemporary(field.getName() + "__iter", map.local().invoke(MethodRef.MAP_ENTRY_SET, new Expression[0]).invoke(MethodRef.GET_ITERATOR, new Expression[0]));
            final TemplateVariableManager.Variable mapEntry = scope.createTemporary(field.getName() + "__mapEntry", iter.local().invoke(MethodRef.ITERATOR_NEXT, new Expression[0]).checkedCast(BytecodeUtils.MAP_ENTRY_TYPE));
            final Statement scopeExit = scope.exitScope();
            MapType mapType = (MapType)mapArg.soyType();
            SoyType keyType = mapType.getKeyType();
            SoyRuntimeType keyRuntimeType = SoyRuntimeType.getBoxedType(keyType);
            SoyType valueType = mapType.getValueType();
            SoyRuntimeType valueRuntimeType = SoyRuntimeType.getBoxedType(valueType);
            Expression getMapKey = mapEntry.local().invoke(MethodRef.MAP_GET_KEY, new Expression[0]).checkedCast(keyRuntimeType.runtimeType()).asNonNullable();
            SoyExpression mapKey = SoyExpression.forSoyValue(keyType, getMapKey);
            Expression getAndResolveMapValue = mapEntry.local().invoke(MethodRef.MAP_GET_VALUE, new Expression[0]).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).checkedCast(valueRuntimeType.runtimeType());
            SoyExpression mapValue = SoyExpression.forSoyValue(valueType, getAndResolveMapValue).asNonNullable();
            final Expression iterHasNext = iter.local().invoke(MethodRef.ITERATOR_HAS_NEXT, new Expression[0]);
            final Statement putOne = this.handleMapSetter(mapKey, mapValue, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    map.initializer().gen(cb);
                    iter.initializer().gen(cb);
                    Label loopStart = cb.mark();
                    iterHasNext.gen(cb);
                    Label end = new Label();
                    cb.ifZCmp(153, end);
                    mapEntry.initializer().gen(cb);
                    putOne.gen(cb);
                    cb.goTo(loopStart);
                    cb.mark(end);
                    scopeExit.gen(cb);
                }
            };
        }

        private Statement handleRepeated(ExprNode argNode, Descriptors.FieldDescriptor field) {
            if (argNode.getKind() == ExprNode.Kind.LIST_LITERAL_NODE) {
                Preconditions.checkState((!field.isMapField() ? 1 : 0) != 0);
                ArrayList<Statement> additions = new ArrayList<Statement>();
                ListLiteralNode list = (ListLiteralNode)argNode;
                for (ExprNode element : list.getChildren()) {
                    SoyExpression expression = this.compile(element).asNonNullable();
                    additions.add(field.isExtension() ? this.handleExtension(expression, field) : this.handleNormalSetter(expression, field));
                }
                return Statement.concat(additions);
            }
            if (argNode.getKind() == ExprNode.Kind.MAP_LITERAL_NODE) {
                Preconditions.checkState((boolean)field.isMapField());
                ArrayList<Statement> puts = new ArrayList<Statement>();
                MapLiteralNode map = (MapLiteralNode)argNode;
                for (int i = 0; i < map.numChildren(); i += 2) {
                    SoyExpression key = this.compile(map.getChild(i));
                    SoyExpression value = this.compile(map.getChild(i + 1));
                    puts.add(this.handleMapSetter(key, value, field));
                }
                return Statement.concat(puts);
            }
            final SoyExpression baseArg = this.compile(argNode);
            if (baseArg.soyType().equals(ListType.EMPTY_LIST) || baseArg.soyType().equals(MapType.EMPTY_MAP)) {
                return Statement.NULL_STATEMENT;
            }
            if (baseArg.isNonNullable()) {
                return field.isMapField() ? this.handleMapSetterNotNull(baseArg, field) : this.handleRepeatedNotNull(baseArg, field);
            }
            final Label isNonNull = new Label();
            final Label end = new Label();
            SoyExpression nonNull = baseArg.withSource(new Expression(baseArg.resultType(), baseArg.features()){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    cb.dup();
                    cb.ifNonNull(isNonNull);
                    cb.pop();
                    cb.goTo(end);
                    cb.mark(isNonNull);
                }
            }).asNonNullable();
            final Statement handle = field.isMapField() ? this.handleMapSetterNotNull(nonNull, field) : this.handleRepeatedNotNull(nonNull, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    handle.gen(cb);
                    cb.mark(end);
                }
            };
        }

        private Statement handleRepeatedNotNull(SoyExpression listArg, Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument((boolean)listArg.isNonNullable());
            SoyExpression unboxed = listArg.unboxAsList();
            Expression resolved = ((ExpressionDetacher)this.detacher.get()).resolveSoyValueProviderList(unboxed);
            TemplateVariableManager.Scope scope = this.varManager.enterScope();
            final TemplateVariableManager.Variable list = scope.createTemporary(field.getName() + "__list", resolved);
            final TemplateVariableManager.Variable index = scope.createTemporary(field.getName() + "__index", BytecodeUtils.constant(0));
            final TemplateVariableManager.Variable listSize = scope.createTemporary(field.getName() + "__size", MethodRef.LIST_SIZE.invoke(list.local()));
            final Statement scopeExit = scope.exitScope();
            SoyType elementSoyType = ((ListType)unboxed.soyType()).getElementType();
            SoyRuntimeType elementType = SoyRuntimeType.getBoxedType(elementSoyType);
            Expression getAndResolve = list.local().invoke(MethodRef.LIST_GET, index.local()).checkedCast(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE).invoke(MethodRef.SOY_VALUE_PROVIDER_RESOLVE, new Expression[0]).checkedCast(elementType.runtimeType());
            SoyExpression soyValue = SoyExpression.forSoyValue(elementType.soyType(), getAndResolve).asNonNullable();
            final Statement getAndAddOne = field.isExtension() ? this.handleExtension(soyValue, field) : this.handleNormalSetter(soyValue, field);
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    list.initializer().gen(cb);
                    listSize.initializer().gen(cb);
                    listSize.local().gen(cb);
                    Label listIsEmpty = new Label();
                    cb.ifZCmp(153, listIsEmpty);
                    index.initializer().gen(cb);
                    Label loopStart = cb.mark();
                    getAndAddOne.gen(cb);
                    cb.iinc(index.local().index(), 1);
                    index.local().gen(cb);
                    listSize.local().gen(cb);
                    cb.ifICmp(155, loopStart);
                    cb.mark(listIsEmpty);
                    scopeExit.gen(cb);
                }
            };
        }

        private Statement handleExtension(final SoyExpression baseArg, final Descriptors.FieldDescriptor field) {
            final Expression extensionIdentifier = ProtoUtils.getExtensionField(field).accessor();
            final MethodRef setterMethod = field.isRepeated() ? EXTENDABLE_BUILDER_ADD_EXTENSION : EXTENDABLE_BUILDER_SET_EXTENSION;
            final boolean isNullable = !baseArg.isNonNullable();
            return new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    baseArg.gen(cb);
                    Label argIsNull = null;
                    Label end = null;
                    if (isNullable) {
                        argIsNull = new Label();
                        end = new Label();
                        cb.dup();
                        cb.ifNull(argIsNull);
                    }
                    ProtoInitGenerator.unboxAndCoerce(cb, baseArg, field);
                    extensionIdentifier.gen(cb);
                    cb.swap();
                    setterMethod.invokeUnchecked(cb);
                    if (isNullable) {
                        cb.goTo(end);
                        cb.mark(argIsNull);
                        cb.pop();
                        cb.mark(end);
                    }
                    cb.checkCast(ProtoUtils.builderRuntimeType(descriptor).type());
                }
            };
        }

        private static void unboxAndCoerce(CodeBuilder cb, SoyExpression baseArg, Descriptors.FieldDescriptor field) {
            Type currentType = !ProtoInitGenerator.isSafeProto(field) ? (baseArg.isBoxed() ? BytecodeUtils.unboxUnchecked(cb, baseArg.soyRuntimeType(), ProtoInitGenerator.classToUnboxTo(field)) : baseArg.resultType()) : baseArg.resultType();
            ProtoInitGenerator.coerce(cb, currentType, field);
        }

        @Nullable
        private static Class<?> classToUnboxTo(Descriptors.FieldDescriptor field) {
            switch (field.getJavaType()) {
                case BOOLEAN: {
                    return Boolean.TYPE;
                }
                case FLOAT: 
                case DOUBLE: {
                    return Double.TYPE;
                }
                case ENUM: 
                case INT: {
                    return Long.TYPE;
                }
                case LONG: {
                    return ProtoUtils.shouldConvertBetweenStringAndLong(field) ? String.class : Long.TYPE;
                }
                case STRING: 
                case BYTE_STRING: {
                    return String.class;
                }
                case MESSAGE: {
                    if (ProtoInitGenerator.isSafeProto(field)) {
                        throw new IllegalStateException("SanitizedContent objects shouldn't be unboxed");
                    }
                    return Message.class;
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + field));
        }

        private static void coerce(CodeBuilder cb, Type currentType, Descriptors.FieldDescriptor field) {
            Type fieldType;
            switch (field.getJavaType()) {
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: {
                    break;
                }
                case FLOAT: {
                    if (currentType.equals((Object)Type.FLOAT_TYPE)) break;
                    cb.cast(currentType, Type.FLOAT_TYPE);
                    break;
                }
                case INT: {
                    Preconditions.checkState((boolean)currentType.equals((Object)Type.LONG_TYPE));
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(field)) {
                        MethodRef.UNSIGNED_INTS_SATURATED_CAST.invokeUnchecked(cb);
                        break;
                    }
                    cb.cast(currentType, Type.INT_TYPE);
                    break;
                }
                case LONG: {
                    if (!ProtoUtils.shouldConvertBetweenStringAndLong(field)) break;
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(field)) {
                        MethodRef.UNSIGNED_LONGS_PARSE_UNSIGNED_LONG.invokeUnchecked(cb);
                        break;
                    }
                    MethodRef.LONG_PARSE_LONG.invokeUnchecked(cb);
                    break;
                }
                case BYTE_STRING: {
                    BASE_ENCODING_BASE_64.invokeUnchecked(cb);
                    cb.swap();
                    BASE_ENCODING_DECODE.invokeUnchecked(cb);
                    BYTE_STRING_COPY_FROM.invokeUnchecked(cb);
                    break;
                }
                case MESSAGE: {
                    ProtoInitGenerator.coerceToMessage(cb, currentType, field);
                    break;
                }
                case ENUM: {
                    if (!currentType.equals((Object)Type.INT_TYPE)) {
                        cb.cast(currentType, Type.INT_TYPE);
                    }
                    if (!ProtoUtils.isProto3EnumField(field)) {
                        ProtoUtils.getForNumberMethod(field.getEnumType()).invokeUnchecked(cb);
                    }
                    return;
                }
            }
            if (field.isExtension() && BytecodeUtils.isPrimitive(fieldType = ProtoUtils.getRuntimeType(field))) {
                cb.valueOf(fieldType);
            }
        }

        private static void coerceToMessage(CodeBuilder cb, Type currentType, Descriptors.FieldDescriptor field) {
            Type runtimeFieldType = ProtoUtils.getRuntimeType(field);
            if (ProtoInitGenerator.isSafeProto(field)) {
                MethodRef toProto = (MethodRef)SANITIZED_CONTENT_TO_PROTO.get((Object)field.getMessageType().getFullName());
                if (!currentType.equals((Object)BytecodeUtils.SANITIZED_CONTENT_TYPE)) {
                    cb.checkCast(BytecodeUtils.SANITIZED_CONTENT_TYPE);
                }
                toProto.invokeUnchecked(cb);
                currentType = toProto.returnType();
            }
            if (!currentType.equals((Object)runtimeFieldType)) {
                cb.checkCast(runtimeFieldType);
            }
        }

        private static boolean isSafeProto(Descriptors.FieldDescriptor field) {
            return field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && SAFE_PROTO_TO_ACCESSOR.containsKey((Object)field.getMessageType().getFullName());
        }
    }

    private static final class AccessorGenerator {
        final SoyRuntimeType unboxedRuntimeType;
        final SoyExpression baseExpr;
        final FieldAccessNode node;
        final Descriptors.FieldDescriptor descriptor;
        final boolean shouldCheckForFieldPresence;

        AccessorGenerator(SoyProtoType protoType, SoyExpression baseExpr, FieldAccessNode node) {
            this.unboxedRuntimeType = (SoyRuntimeType)SoyRuntimeType.getUnboxedType(protoType).get();
            this.baseExpr = baseExpr;
            this.node = node;
            this.descriptor = protoType.getFieldDescriptor(node.getFieldName());
            this.shouldCheckForFieldPresence = protoType.shouldCheckFieldPresenceToEmulateJspbNullability(node.getFieldName());
        }

        SoyExpression generate() {
            SoyExpression typedBaseExpr;
            if (this.descriptor.isRepeated()) {
                return this.handleRepeated();
            }
            if (this.baseExpr.isBoxed()) {
                typedBaseExpr = SoyExpression.forProto(this.unboxedRuntimeType, this.baseExpr.invoke(MethodRef.SOY_PROTO_VALUE_GET_PROTO, new Expression[0]).checkedCast(this.unboxedRuntimeType.runtimeType()));
            } else if (this.baseExpr.soyRuntimeType().equals(this.unboxedRuntimeType)) {
                typedBaseExpr = this.baseExpr;
            } else {
                throw new AssertionError((Object)"should be impossible");
            }
            if (this.descriptor.isExtension()) {
                return this.handleExtension(typedBaseExpr);
            }
            return this.handleNormalField(typedBaseExpr);
        }

        private SoyExpression handleNormalField(final SoyExpression typedBaseExpr) {
            BytecodeProducer hasCheck;
            final MethodRef getMethodRef = ProtoUtils.getGetterMethod(this.descriptor);
            if (!this.shouldCheckForFieldPresence) {
                return this.interpretField(typedBaseExpr.invoke(getMethodRef, new Expression[0]));
            }
            final Label hasFieldLabel = new Label();
            Descriptors.OneofDescriptor containingOneof = this.descriptor.getContainingOneof();
            if (containingOneof != null) {
                final MethodRef getCaseRef = ProtoUtils.getOneOfCaseMethod(containingOneof);
                final Expression fieldNumber = BytecodeUtils.constant(this.descriptor.getNumber());
                hasCheck = new BytecodeProducer(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        getCaseRef.invokeUnchecked(adapter);
                        adapter.visitMethodInsn(182, getCaseRef.returnType().getInternalName(), "getNumber", "()I", false);
                        fieldNumber.gen(adapter);
                        adapter.ifCmp(Type.INT_TYPE, 153, hasFieldLabel);
                    }
                };
            } else {
                final MethodRef hasMethodRef = ProtoUtils.getHasserMethod(this.descriptor);
                hasCheck = new BytecodeProducer(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        hasMethodRef.invokeUnchecked(adapter);
                        adapter.ifZCmp(154, hasFieldLabel);
                    }
                };
            }
            final Label endLabel = new Label();
            SoyExpression interpretedField = this.interpretField(new Expression(getMethodRef.returnType(), getMethodRef.features().minus(Expression.Feature.NON_NULLABLE)){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    typedBaseExpr.gen(adapter);
                    adapter.dup();
                    hasCheck.gen(adapter);
                    adapter.pop();
                    adapter.visitInsn(1);
                    adapter.goTo(endLabel);
                    adapter.mark(hasFieldLabel);
                    getMethodRef.invokeUnchecked(adapter);
                }
            });
            if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                interpretedField = interpretedField.box();
            }
            return interpretedField.labelEnd(endLabel).asNullable();
        }

        private SoyExpression interpretField(Expression field) {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: {
                    return SoyExpression.forFloat(BytecodeUtils.numericConversion(field, Type.DOUBLE_TYPE));
                }
                case DOUBLE: {
                    return SoyExpression.forFloat(field);
                }
                case ENUM: {
                    if (ProtoUtils.isProto3EnumField(this.descriptor)) {
                        return SoyExpression.forInt(BytecodeUtils.numericConversion(field, Type.LONG_TYPE));
                    }
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.invoke(MethodRef.PROTOCOL_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: {
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                        return SoyExpression.forInt(MethodRef.UNSIGNED_INTS_TO_LONG.invoke(field));
                    }
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field, Type.LONG_TYPE));
                }
                case LONG: {
                    if (ProtoUtils.shouldConvertBetweenStringAndLong(this.descriptor)) {
                        if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                            return SoyExpression.forString(MethodRef.UNSIGNED_LONGS_TO_STRING.invoke(field));
                        }
                        return SoyExpression.forString(MethodRef.LONG_TO_STRING.invoke(field));
                    }
                    return SoyExpression.forInt(field);
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field);
                }
                case STRING: {
                    return SoyExpression.forString(field);
                }
                case MESSAGE: {
                    return this.messageToSoyExpression(field);
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field);
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression handleExtension(final SoyExpression typedBaseExpr) {
            FieldRef extensionField = ProtoUtils.getExtensionField(this.descriptor);
            final Expression extensionFieldAccessor = extensionField.accessor();
            if (!this.descriptor.hasDefaultValue()) {
                final Label endLabel = new Label();
                SoyExpression interpretedField = this.interpretExtensionField(new Expression(EXTENDABLE_MESSAGE_GET_EXTENSION.returnType(), EXTENDABLE_MESSAGE_GET_EXTENSION.features().minus(Expression.Feature.NON_NULLABLE)){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        typedBaseExpr.gen(adapter);
                        adapter.dup();
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_HAS_EXTENSION.invokeUnchecked(adapter);
                        Label hasFieldLabel = new Label();
                        adapter.ifZCmp(154, hasFieldLabel);
                        adapter.pop();
                        adapter.visitInsn(1);
                        adapter.goTo(endLabel);
                        adapter.mark(hasFieldLabel);
                        extensionFieldAccessor.gen(adapter);
                        EXTENDABLE_MESSAGE_GET_EXTENSION.invokeUnchecked(adapter);
                    }
                });
                if (BytecodeUtils.isPrimitive(interpretedField.resultType())) {
                    interpretedField = interpretedField.box();
                }
                return interpretedField.labelEnd(endLabel).asNullable();
            }
            return this.interpretExtensionField(typedBaseExpr.invoke(EXTENDABLE_MESSAGE_GET_EXTENSION, extensionFieldAccessor));
        }

        private SoyExpression interpretExtensionField(Expression field) {
            switch (this.descriptor.getJavaType()) {
                case FLOAT: 
                case DOUBLE: {
                    return SoyExpression.forFloat(field.checkedCast(Number.class).invoke(MethodRef.NUMBER_DOUBLE_VALUE, new Expression[0]));
                }
                case ENUM: {
                    return SoyExpression.forInt(BytecodeUtils.numericConversion(field.checkedCast(ProtocolMessageEnum.class).invoke(MethodRef.PROTOCOL_ENUM_GET_NUMBER, new Expression[0]), Type.LONG_TYPE));
                }
                case INT: {
                    if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                        return SoyExpression.forInt(MethodRef.UNSIGNED_INTS_TO_LONG.invoke(field.checkedCast(Integer.class).invoke(MethodRef.NUMBER_INT_VALUE, new Expression[0])));
                    }
                    return SoyExpression.forInt(field.checkedCast(Integer.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0]));
                }
                case LONG: {
                    if (ProtoUtils.shouldConvertBetweenStringAndLong(this.descriptor)) {
                        if (com.google.template.soy.internal.proto.ProtoUtils.isUnsigned(this.descriptor)) {
                            return SoyExpression.forString(MethodRef.UNSIGNED_LONGS_TO_STRING.invoke(field.checkedCast(Long.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0])));
                        }
                        return SoyExpression.forString(field.invoke(MethodRef.OBJECT_TO_STRING, new Expression[0]));
                    }
                    return SoyExpression.forInt(field.checkedCast(Number.class).invoke(MethodRef.NUMBER_LONG_VALUE, new Expression[0]));
                }
                case BOOLEAN: {
                    return SoyExpression.forBool(field.checkedCast(Boolean.class).invoke(MethodRef.BOOLEAN_VALUE, new Expression[0]));
                }
                case STRING: {
                    return SoyExpression.forString(field.checkedCast(String.class));
                }
                case MESSAGE: {
                    return this.messageToSoyExpression(field);
                }
                case BYTE_STRING: {
                    return this.byteStringToBase64String(field.checkedCast(ByteString.class));
                }
            }
            throw new AssertionError((Object)("unsupported field type: " + this.descriptor));
        }

        private SoyExpression byteStringToBase64String(Expression byteString) {
            byteString.checkAssignableTo(BYTE_STRING_TYPE);
            final Expression byteArray = byteString.invoke(BYTE_STRING_TO_BYTE_ARRAY, new Expression[0]);
            return SoyExpression.forString(new Expression(BytecodeUtils.STRING_TYPE, Expression.Feature.NON_NULLABLE, new Expression.Feature[0]){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    byteArray.gen(adapter);
                    BASE_ENCODING_BASE_64.invokeUnchecked(adapter);
                    adapter.swap();
                    BASE_ENCODING_ENCODE.invokeUnchecked(adapter);
                }
            });
        }

        private SoyExpression messageToSoyExpression(Expression field) {
            if (this.node.getType().getKind() == SoyType.Kind.PROTO) {
                SoyProtoType fieldProtoType = (SoyProtoType)this.node.getType();
                SoyRuntimeType protoRuntimeType = (SoyRuntimeType)SoyRuntimeType.getUnboxedType(fieldProtoType).get();
                return SoyExpression.forProto(protoRuntimeType, field.checkedCast(protoRuntimeType.runtimeType()));
            }
            SanitizedContentKind kind = ((SanitizedType)this.node.getType()).getContentKind();
            Descriptors.Descriptor messageType = this.descriptor.getMessageType();
            MethodRef methodRef = (MethodRef)SAFE_PROTO_TO_ACCESSOR.get((Object)messageType.getFullName());
            return SoyExpression.forSanitizedString(field.checkedCast(methodRef.owner().type()).invoke(methodRef, new Expression[0]), kind);
        }

        private SoyExpression handleRepeated() {
            SoyRuntimeType boxedType = SoyRuntimeType.getBoxedType(this.node.getType());
            return SoyExpression.forSoyValue(this.node.getType(), MethodRef.SOY_PROTO_VALUE_GET_PROTO_FIELD.invoke(this.baseExpr.box(), BytecodeUtils.constant(this.node.getFieldName())).checkedCast(boxedType.runtimeType()));
        }
    }
}

