/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.jbcsrc.AutoValue_PrintDirectives_DirectiveWithArgs;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.runtime.JbcSrcRuntime;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import java.util.ArrayList;
import java.util.List;

final class PrintDirectives {
    private static final MethodRef RUNTIME_PROPAGATE_CLOSE = MethodRef.create(JbcSrcRuntime.class, "propagateClose", LoggingAdvisingAppendable.class, ImmutableList.class);

    static boolean areAllPrintDirectivesStreamable(PrintNode node) {
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            if (directiveNode.getPrintDirective() instanceof SoyJbcSrcPrintDirective.Streamable) continue;
            return false;
        }
        return true;
    }

    static boolean areAllPrintDirectivesStreamable(CallNode node) {
        return PrintDirectives.areAllPrintDirectivesStreamable(node.getEscapingDirectives());
    }

    static boolean areAllPrintDirectivesStreamable(MsgFallbackGroupNode node) {
        return PrintDirectives.areAllPrintDirectivesStreamable(node.getEscapingDirectives());
    }

    static boolean areAllPrintDirectivesStreamable(ImmutableList<SoyPrintDirective> escapingDirectives) {
        for (SoyPrintDirective directive : escapingDirectives) {
            if (directive instanceof SoyJbcSrcPrintDirective.Streamable) continue;
            return false;
        }
        return true;
    }

    static SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyStreamingEscapingDirectives(List<SoyPrintDirective> directives, Expression appendable, JbcSrcPluginContext context, TemplateVariableManager variables) {
        ArrayList<DirectiveWithArgs> directivesToApply = new ArrayList<DirectiveWithArgs>();
        for (SoyPrintDirective directive : directives) {
            directivesToApply.add(DirectiveWithArgs.create((SoyJbcSrcPrintDirective.Streamable)directive));
        }
        return PrintDirectives.applyStreamingPrintDirectivesTo(directivesToApply, appendable, context, variables);
    }

    static SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyStreamingPrintDirectives(List<PrintDirectiveNode> directives, Expression appendable, ExpressionCompiler.BasicExpressionCompiler basic, JbcSrcPluginContext renderContext, TemplateVariableManager variables) {
        ArrayList<DirectiveWithArgs> directivesToApply = new ArrayList<DirectiveWithArgs>();
        for (PrintDirectiveNode directive : directives) {
            directivesToApply.add(DirectiveWithArgs.create((SoyJbcSrcPrintDirective.Streamable)directive.getPrintDirective(), basic.compileToList(directive.getArgs())));
        }
        return PrintDirectives.applyStreamingPrintDirectivesTo(directivesToApply, appendable, renderContext, variables);
    }

    private static SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyStreamingPrintDirectivesTo(List<DirectiveWithArgs> directivesToApply, Expression appendable, JbcSrcPluginContext context, TemplateVariableManager variableManager) {
        boolean closeable;
        Expression appendableExpression;
        ArrayList<LocalVariable> closeables = new ArrayList<LocalVariable>();
        final ArrayList<TemplateVariableManager.Variable> appendableVars = new ArrayList<TemplateVariableManager.Variable>();
        TemplateVariableManager.Scope scope = variableManager.enterScope();
        SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions prev = SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(appendable);
        TemplateVariableManager.Variable prevVar = scope.createTemporary("tmp_appendable", appendable);
        appendableVars.add(prevVar);
        for (DirectiveWithArgs directiveToApply : Lists.reverse(directivesToApply)) {
            SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions curr = directiveToApply.apply(context, prevVar.local());
            TemplateVariableManager.Variable currVar = scope.createTemporary("tmp_appendable", curr.appendable());
            appendableVars.add(currVar);
            if (curr.closeable()) {
                closeables.add(currVar.local());
            }
            prev = curr;
            prevVar = currVar;
        }
        if (closeables.isEmpty()) {
            appendableExpression = prev.appendable();
            closeable = false;
        } else if (closeables.size() == 1 && prev.closeable()) {
            appendableExpression = prev.appendable();
            closeable = true;
        } else {
            appendableExpression = RUNTIME_PROPAGATE_CLOSE.invoke(((TemplateVariableManager.Variable)Iterables.getLast(appendableVars)).local(), BytecodeUtils.asImmutableList(Lists.reverse(closeables)));
            closeable = true;
        }
        final Statement exitScope = scope.exitScope();
        Expression result = new Expression(appendableExpression.resultType()){

            @Override
            protected void doGen(CodeBuilder adapter) {
                for (TemplateVariableManager.Variable var : appendableVars) {
                    var.initializer().gen(adapter);
                }
                appendableExpression.gen(adapter);
                exitScope.gen(adapter);
            }
        };
        if (closeable) {
            return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.createCloseable(result);
        }
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(result);
    }

    private PrintDirectives() {
    }

    @AutoValue
    static abstract class DirectiveWithArgs {
        DirectiveWithArgs() {
        }

        static DirectiveWithArgs create(SoyJbcSrcPrintDirective.Streamable directive) {
            return new AutoValue_PrintDirectives_DirectiveWithArgs(directive, (List<SoyExpression>)ImmutableList.of());
        }

        static DirectiveWithArgs create(SoyJbcSrcPrintDirective.Streamable directive, List<SoyExpression> arguments) {
            return new AutoValue_PrintDirectives_DirectiveWithArgs(directive, arguments);
        }

        abstract SoyJbcSrcPrintDirective.Streamable directive();

        abstract List<SoyExpression> arguments();

        SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions apply(JbcSrcPluginContext context, Expression appendable) {
            return this.directive().applyForJbcSrcStreaming(context, appendable, this.arguments());
        }
    }
}

