/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.incrementaldomsrc.IncrementalDomTranslateExprNodeVisitor;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.ClassExpression;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.passes.ShouldEnsureDataIsDefinedVisitor;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlCommentNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private static final ImmutableList<HtmlContext> STRINGLIKE_KINDS = ImmutableList.of((Object)((Object)HtmlContext.URI), (Object)((Object)HtmlContext.TEXT), (Object)((Object)HtmlContext.HTML_ATTRIBUTE_NAME), (Object)((Object)HtmlContext.HTML_NORMAL_ATTR_VALUE));
    private ArrayDeque<Holder<Integer>> keyCounterStack;
    private int staticsCounter = 0;
    private String alias = "";
    private List<CodeChunk> staticsDeclarations;

    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, JavaScriptValueFactoryImpl javaScriptValueFactory, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        super(jsSrcOptions, javaScriptValueFactory, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, typeRegistry);
    }

    @Override
    protected JsCodeBuilder createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    @Override
    protected IncrementalDomCodeBuilder createChildJsCodeBuilder() {
        return new IncrementalDomCodeBuilder(this.getJsCodeBuilder());
    }

    @Override
    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected JsType getJsTypeForParamForDeclaration(SoyType paramType) {
        return JsType.forIncrementalDomState(paramType);
    }

    @Override
    protected JsType getJsTypeForParamTypeCheck(SoyType paramType) {
        return JsType.forIncrementalDom(paramType);
    }

    @Override
    protected void visit(SoyNode node) {
        try {
            super.visit(node);
        }
        catch (RuntimeException e) {
            throw new Error("error from : " + (Object)((Object)node.getKind()) + " @ " + node.getSourceLocation(), e);
        }
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (this.isTextContent(node.getContentKind())) {
            return super.getTemplateReturnType(node);
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.keyCounterStack = new ArrayDeque();
        this.keyCounterStack.push(new Holder<Integer>(0));
        this.staticsCounter = 0;
        this.staticsDeclarations = new ArrayList<CodeChunk>();
        SanitizedContentKind kind = node.getContentKind();
        this.getJsCodeBuilder().setContentKind(kind);
        this.alias = node instanceof TemplateDelegateNode ? node.getPartialTemplateName().substring(1) : this.templateAliases.get(node.getTemplateName());
        super.visitTemplateNode(node);
        if (kind == SanitizedContentKind.HTML || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression type = kind == SanitizedContentKind.HTML ? IncrementalDomRuntime.SOY_IDOM_TYPE_HTML : IncrementalDomRuntime.SOY_IDOM_TYPE_ATTRIBUTE;
            this.getJsCodeBuilder().append(Statement.assign(this.alias + ".contentKind", type));
        }
        if (node instanceof TemplateElementNode) {
            TemplateElementNode element = (TemplateElementNode)node;
            String elementName = this.getSoyElementClassName();
            String elementAccessor = elementName + "Interface";
            this.getJsCodeBuilder().appendLine(new String[0]);
            this.getJsCodeBuilder().append(this.generateAccessorInterface(elementAccessor, element));
            this.getJsCodeBuilder().append(this.generateExportsForSoyElement(elementAccessor));
            this.getJsCodeBuilder().append(this.generateClassForSoyElement(elementName, elementAccessor, element));
            this.getJsCodeBuilder().append(this.generateExportsForSoyElement(elementName));
        }
        for (CodeChunk entry : this.staticsDeclarations) {
            this.getJsCodeBuilder().append(entry);
        }
    }

    @Override
    protected JsDoc generateFunctionJsDoc(TemplateNode node, String alias) {
        JsDoc.Builder jsDocBuilder = JsDoc.builder();
        SanitizedContentKind kind = node.getContentKind();
        if (kind == SanitizedContentKind.HTML || kind == SanitizedContentKind.ATTRIBUTES) {
            jsDocBuilder.addGoogRequire(IncrementalDomRuntime.INCREMENTAL_DOM_LIB);
            jsDocBuilder.addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer");
        }
        boolean noRequiredParams = new ShouldEnsureDataIsDefinedVisitor().exec(node);
        if (node.getParams().isEmpty()) {
            jsDocBuilder.addParam("opt_data", noRequiredParams ? "?Object<string, *>=" : "null=");
        } else if (!node.hasStrictParams()) {
            jsDocBuilder.addParam("opt_data", "?=");
        } else if (noRequiredParams) {
            jsDocBuilder.addParam("opt_data", "?" + alias + ".Params=");
        } else {
            jsDocBuilder.addParam("opt_data", "!" + alias + ".Params");
        }
        jsDocBuilder.addGoogRequire(GoogRequire.createTypeRequire("soy"));
        jsDocBuilder.addParam("opt_ijData", "!soy.IjData=");
        String returnType = this.getTemplateReturnType(node);
        jsDocBuilder.addParameterizedAnnotation("return", returnType);
        jsDocBuilder.addParameterizedAnnotation("suppress", "checkTypes");
        return jsDocBuilder.build();
    }

    @Override
    protected Statement generateFunctionBody(TemplateNode node) {
        ImmutableList.Builder bodyStatements = ImmutableList.builder();
        if (new ShouldEnsureDataIsDefinedVisitor().exec(node)) {
            bodyStatements.add((Object)Statement.assign("opt_data", JsRuntime.OPT_DATA.or(Expression.EMPTY_OBJECT_LITERAL, this.templateTranslationContext.codeGenerator())));
        }
        bodyStatements.add((Object)(node instanceof TemplateElementNode ? this.generateFunctionBodyForSoyElement(node) : this.generateIncrementalDomRenderCalls(node)));
        return Statement.of((Iterable<Statement>)bodyStatements.build());
    }

    private Statement generateIncrementalDomRenderCalls(TemplateNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = this.isTextContent(node.getContentKind());
        Statement typeChecks = this.genParamTypeChecks(node);
        if (isTextTemplate) {
            jsCodeBuilder.pushOutputVar("output").setOutputVarInited();
        }
        Statement body = this.visitChildrenReturningCodeChunk(node);
        if (isTextTemplate) {
            VariableDeclaration declare = VariableDeclaration.builder("output").setRhs(Expression.LITERAL_EMPTY_STRING).build();
            jsCodeBuilder.popOutputVar();
            body = Statement.of(declare, body, Statement.returnValue(this.sanitize(declare.ref(), node.getContentKind())));
        }
        return Statement.of(typeChecks, body);
    }

    private Statement generateFunctionBodyForSoyElement(TemplateNode node) {
        String soyElementClassName = this.getSoyElementClassName();
        Expression firstElementKey = JsRuntime.XID.call(Expression.stringLiteral(node.getTemplateName() + "-0"));
        VariableDeclaration elementInstanceDeclaration = VariableDeclaration.builder("element").setRhs(IncrementalDomRuntime.SOY_IDOM.dotAccess("$$tryGetElement").call(IncrementalDomRuntime.INCREMENTAL_DOM, Expression.id(soyElementClassName), firstElementKey)).build();
        Statement maybeCreateElement = Statement.ifStatement(elementInstanceDeclaration.ref().tripleEquals(Expression.LITERAL_NULL), elementInstanceDeclaration.ref().assign(Expression.construct(Expression.id(soyElementClassName), JsRuntime.OPT_DATA, JsRuntime.OPT_IJ_DATA)).asStatement()).build();
        Statement elementRenderInvocation = elementInstanceDeclaration.ref().dotAccess("renderInternal").call(IncrementalDomRuntime.INCREMENTAL_DOM, JsRuntime.OPT_DATA).asStatement();
        return Statement.of(maybeCreateElement, elementInstanceDeclaration, elementRenderInvocation);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private VariableDeclaration generateClassForSoyElement(String soyElementClassName, String soyElementAccessorName, TemplateElementNode node) {
        String paramsType = node.hasStrictParams() ? "!" + this.alias + ".Params" : "null";
        String optIjDataType = "!soy.IjData=";
        ImmutableList.Builder stateMethods = ImmutableList.builder();
        for (TemplateStateVar stateVar : node.getStateVars()) {
            stateMethods.addAll(this.generateStateMethodsForSoyElementClass(soyElementClassName, stateVar));
        }
        ImmutableList.Builder parameterMethods = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            parameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(param, false));
        }
        ImmutableList.Builder stateVarInitializations = ImmutableList.builder();
        for (TemplateStateVar stateVar : node.getStateVars()) {
            JsType jsType = JsType.forIncrementalDomState(stateVar.type());
            JsDoc stateVarJsdoc = JsDoc.builder().addParameterizedAnnotation("private", jsType.typeExpr()).build();
            stateVarInitializations.add((Object)Statement.assign("this.state_" + stateVar.name(), this.translateExpr(stateVar.defaultValue()), stateVarJsdoc));
        }
        Statement ctorBody = Statement.of(Expression.id("super").call(JsRuntime.OPT_DATA, JsRuntime.OPT_IJ_DATA).asStatement(), Statement.of((Iterable<Statement>)stateVarInitializations.build()));
        ClassExpression.MethodDeclaration constructorMethod = ClassExpression.MethodDeclaration.create("constructor", JsDoc.builder().addParam("opt_data", paramsType).addParam("opt_ijData", optIjDataType).build(), ctorBody);
        Statement maybeRender = Statement.ifStatement(Expression.id("super").dotAccess("renderInternal").call(IncrementalDomRuntime.INCREMENTAL_DOM, JsRuntime.OPT_DATA, Expression.id("ignoreSkipHandler")), Statement.returnValue(Expression.LITERAL_TRUE)).build();
        ClassExpression.MethodDeclaration renderInternalMethod = ClassExpression.MethodDeclaration.create("renderInternal", JsDoc.builder().addParam("idomRenderer", "!incrementaldomlib.IncrementalDomRenderer").addParam("opt_data", paramsType).addParam("ignoreSkipHandler", "boolean=").addAnnotation("protected").addAnnotation("override").addParameterizedAnnotation("suppress", "checkTypes").build(), Statement.of(maybeRender, VariableDeclaration.builder("opt_ijData").setRhs(Expression.THIS.dotAccess("ijData")).build(), this.generateIncrementalDomRenderCalls(node), Statement.returnValue(Expression.LITERAL_FALSE)));
        ClassExpression soyElementClass = ClassExpression.create(IncrementalDomRuntime.SOY_IDOM.dotAccess("$SoyElement"), (ImmutableList<ClassExpression.MethodDeclaration>)ImmutableList.builder().add((Object[])new ClassExpression.MethodDeclaration[]{constructorMethod, renderInternalMethod}).addAll((Iterable)stateMethods.build()).addAll((Iterable)parameterMethods.build()).build());
        String elementAccessor = soyElementClassName + "Interface";
        VariableDeclaration classExpression = VariableDeclaration.builder(soyElementClassName).setJsDoc(JsDoc.builder().addAnnotation("extends", "{soyIdom.$SoyElement<" + paramsType + ",!" + elementAccessor + ">}").addParameterizedAnnotation("implements", soyElementAccessorName).build()).setRhs(soyElementClass).build();
        return classExpression;
    }

    private VariableDeclaration generateAccessorInterface(String className, TemplateElementNode node) {
        ImmutableList.Builder parameterMethods = ImmutableList.builder();
        for (TemplateParam param : node.getParams()) {
            parameterMethods.add((Object)this.generateGetParamMethodForSoyElementClass(param, true));
        }
        ClassExpression soyElementClass = ClassExpression.create((ImmutableList<ClassExpression.MethodDeclaration>)ImmutableList.copyOf((Collection)parameterMethods.build()));
        VariableDeclaration classExpression = VariableDeclaration.builder(className).setJsDoc(JsDoc.builder().addAnnotation("interface").build()).setRhs(soyElementClass).build();
        return classExpression;
    }

    private Statement generateExportsForSoyElement(String soyElementClassName) {
        return Statement.assign("exports." + soyElementClassName.substring(1), Expression.id(soyElementClassName));
    }

    private ImmutableList<ClassExpression.MethodDeclaration> generateStateMethodsForSoyElementClass(String soyElementClassName, TemplateStateVar stateVar) {
        JsType jsType = JsType.forIncrementalDomState(stateVar.type());
        String stateAccessorSuffix = Ascii.toUpperCase((String)stateVar.name().substring(0, 1)) + stateVar.name().substring(1);
        Expression stateValue = Expression.id("this").dotAccess("state_" + stateVar.name());
        ClassExpression.MethodDeclaration getStateMethod = ClassExpression.MethodDeclaration.create("get" + stateAccessorSuffix, JsDoc.builder().addParameterizedAnnotation("return", jsType.typeExpr()).build(), Statement.returnValue(stateValue));
        jsType = JsType.forIncrementalDomState(stateVar.type());
        ImmutableList.Builder setStateMethodStatements = ImmutableList.builder();
        Optional<Expression> typeAssertion = jsType.getSoyTypeAssertion(Expression.id(stateVar.name()), stateVar.name(), this.templateTranslationContext.codeGenerator());
        if (typeAssertion.isPresent()) {
            setStateMethodStatements.add((Object)((Expression)typeAssertion.get()).asStatement());
        }
        setStateMethodStatements.add((Object[])new Statement[]{stateValue.assign(Expression.id(stateVar.name())).asStatement(), Statement.returnValue(Expression.id("this"))});
        ClassExpression.MethodDeclaration setStateMethod = ClassExpression.MethodDeclaration.create("set" + stateAccessorSuffix, JsDoc.builder().addParam(stateVar.name(), jsType.typeExpr()).addParameterizedAnnotation("return", "!" + soyElementClassName).build(), Statement.of((Iterable<Statement>)setStateMethodStatements.build()));
        return ImmutableList.of((Object)getStateMethod, (Object)setStateMethod);
    }

    private ClassExpression.MethodDeclaration generateGetParamMethodForSoyElementClass(TemplateParam param, boolean isAbstract) {
        JsType jsType = JsType.forIncrementalDomState(param.type());
        String accessorSuffix = Ascii.toUpperCase((String)param.name().substring(0, 1)) + param.name().substring(1);
        if (isAbstract) {
            return ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("abstract").addParameterizedAnnotation("return", jsType.typeExpr()).build(), Statement.of((Iterable<Statement>)ImmutableList.of()));
        }
        Expression value = Expression.id("this").dotAccess("data").dotAccess(param.name());
        ClassExpression.MethodDeclaration getParamMethod = ClassExpression.MethodDeclaration.create("get" + accessorSuffix, JsDoc.builder().addAnnotation("override").addAnnotation("public").build(), Statement.returnValue(value));
        return getParamMethod;
    }

    private String getSoyElementClassName() {
        Preconditions.checkState((boolean)this.alias.startsWith("$"), (Object)"Alias should start with '$', or template class name may be malformed.");
        return "$" + Ascii.toUpperCase((char)this.alias.charAt(1)) + this.alias.substring(2) + "Element";
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        Statement definition;
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind prevContentKind = jsCodeBuilder.getContentKind();
        jsCodeBuilder.setContentKind(node.getContentKind());
        VariableDeclaration.Builder builder = VariableDeclaration.builder(generatedVarName);
        SanitizedContentKind kind = node.getContentKind();
        if (kind == SanitizedContentKind.HTML || kind == SanitizedContentKind.ATTRIBUTES) {
            Expression constructor = kind == SanitizedContentKind.HTML ? IncrementalDomRuntime.SOY_IDOM_MAKE_HTML : IncrementalDomRuntime.SOY_IDOM_MAKE_ATTRIBUTES;
            JsDoc jsdoc = JsDoc.builder().addParam("idomRenderer", "incrementaldomlib.IncrementalDomRenderer").build();
            definition = builder.setRhs(constructor.call(Expression.arrowFunction(jsdoc, this.visitChildrenReturningCodeChunk(node)))).build();
        } else {
            String outputVarName = generatedVarName + "_output";
            jsCodeBuilder.pushOutputVar(outputVarName).setOutputVarInited();
            definition = Statement.of(VariableDeclaration.builder(outputVarName).setRhs(Expression.LITERAL_EMPTY_STRING).build(), this.visitChildrenReturningCodeChunk(node), builder.setRhs(JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(Expression.id(outputVarName))).build());
            jsCodeBuilder.popOutputVar();
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.append(definition);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), Expression.id(generatedVarName));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        Expression call;
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        Optional<SanitizedContentKind> kind = this.templateRegistry.getCallContentKind(node);
        Expression callee = this.genCallCodeUtils.genCallee(node, this.templateAliases, this.getExprTranslator());
        Expression objToPass = this.genCallCodeUtils.genObjToPass(node, this.templateAliases, this.templateTranslationContext, this.errorReporter, this.getExprTranslator());
        boolean shouldPushKey = false;
        if (STRINGLIKE_KINDS.contains((Object)node.getHtmlContext()) && (!kind.isPresent() || kind.get() == SanitizedContentKind.ATTRIBUTES || kind.get() == SanitizedContentKind.HTML)) {
            call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_TEXT.call(callee, objToPass, JsRuntime.OPT_IJ_DATA);
        } else if (kind.isPresent() && (kind.get() == SanitizedContentKind.HTML || kind.get() == SanitizedContentKind.ATTRIBUTES)) {
            call = callee.call(IncrementalDomRuntime.INCREMENTAL_DOM, objToPass, JsRuntime.OPT_IJ_DATA);
            shouldPushKey = true;
        } else {
            call = callee.call(objToPass, JsRuntime.OPT_IJ_DATA);
        }
        if (STRINGLIKE_KINDS.contains((Object)node.getHtmlContext())) {
            call = GenCallCodeUtils.applyEscapingDirectives(call, node);
            this.getJsCodeBuilder().addChunkToOutputVar(call);
        } else {
            switch (node.getHtmlContext()) {
                case HTML_TAG: {
                    if (kind.isPresent() && kind.get() == SanitizedContentKind.ATTRIBUTES) break;
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_ATTRIBUTES.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee, objToPass, JsRuntime.OPT_IJ_DATA);
                    break;
                }
                case CSS: {
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_CSS.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee, objToPass, JsRuntime.OPT_IJ_DATA);
                    break;
                }
                case JS: {
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_JS.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee, objToPass, JsRuntime.OPT_IJ_DATA);
                    break;
                }
                default: {
                    if (kind.isPresent() && kind.get() == SanitizedContentKind.HTML) break;
                    call = IncrementalDomRuntime.SOY_IDOM_CALL_DYNAMIC_HTML.call(IncrementalDomRuntime.INCREMENTAL_DOM, callee, objToPass, JsRuntime.OPT_IJ_DATA);
                    shouldPushKey = true;
                }
            }
            TemplateNode template = node.getNearestAncestor(TemplateNode.class);
            if (shouldPushKey) {
                Expression key = node.getKeyExpr() != null ? this.translateExpr(node.getKeyExpr()) : this.incrementKeyForTemplate(template);
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_KEY.call(key));
            }
            this.getJsCodeBuilder().append(call);
            if (shouldPushKey) {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_POP_KEY.call(new Expression[0]));
            }
        }
    }

    @Override
    protected void visitIfNode(IfNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind currentContentKind = jsCodeBuilder.getContentKind();
        if (!this.isTextContent(currentContentKind)) {
            super.generateNonExpressionIfNode(node);
        } else {
            super.visitIfNode(node);
        }
    }

    private boolean isTextContent(SanitizedContentKind contentKind) {
        return contentKind != SanitizedContentKind.HTML && contentKind != SanitizedContentKind.ATTRIBUTES;
    }

    @Override
    protected TranslateExprNodeVisitor getExprTranslator() {
        return new IncrementalDomTranslateExprNodeVisitor(this.javaScriptValueFactory, this.templateTranslationContext, this.errorReporter);
    }

    @Override
    protected void visitHtmlCommentNode(HtmlCommentNode node) {
        String id = "html_comment_" + node.getId();
        this.getJsCodeBuilder().append(VariableDeclaration.builder(id).setRhs(Expression.LITERAL_EMPTY_STRING).build());
        this.getJsCodeBuilder().pushOutputVar(id).setOutputVarInited();
        SanitizedContentKind prev = this.getJsCodeBuilder().getContentKind();
        this.getJsCodeBuilder().setContentKind(SanitizedContentKind.TEXT);
        for (int i = 0; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_VISIT_HTML_COMMENT.call(IncrementalDomRuntime.INCREMENTAL_DOM, Expression.id(id)));
        this.getJsCodeBuilder().popOutputVar();
        this.getJsCodeBuilder().setContentKind(prev);
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.hasValue()) {
            Preconditions.checkState((boolean)((Boolean)this.isComputableAsJsExprsVisitor.exec(node.getChild(0))));
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(this.genJsExprsVisitor.exec((SoyNode)node.getChild(0)).get(0), CodeChunkUtils.concatChunksForceString(this.getAttributeValues(node))));
        } else {
            this.visitChildren(node);
        }
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.visitChildren(node);
    }

    private List<Expression> getAttributeValues(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return ImmutableList.of((Object)Expression.LITERAL_EMPTY_STRING);
        }
        SoyNode.ParentSoyNode value = (SoyNode.ParentSoyNode)node.getChild(1);
        String outputVar = "html_attribute_" + node.getId();
        boolean needsToBeCoerced = false;
        for (Object n : value.getChildren()) {
            if (!(n instanceof CallNode)) continue;
            Optional<SanitizedContentKind> kind = this.templateRegistry.getCallContentKind((CallNode)n);
            needsToBeCoerced = !kind.isPresent() || kind.get() == SanitizedContentKind.HTML || kind.get() == SanitizedContentKind.ATTRIBUTES;
        }
        if (!this.isComputableAsJsExprsVisitor.execOnChildren(value).booleanValue() || needsToBeCoerced) {
            this.getJsCodeBuilder().pushOutputVar(outputVar).setOutputVarInited();
            SanitizedContentKind prev = this.getJsCodeBuilder().getContentKind();
            this.getJsCodeBuilder().setContentKind(SanitizedContentKind.TEXT);
            IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
            jsCodeBuilder.append(VariableDeclaration.builder(outputVar).setRhs(Expression.LITERAL_EMPTY_STRING).build());
            this.visit(value);
            this.getJsCodeBuilder().popOutputVar();
            this.getJsCodeBuilder().setContentKind(prev);
            return ImmutableList.of((Object)Expression.id(outputVar));
        }
        return this.genJsExprsVisitor.exec(value);
    }

    private void emitOpenAndVisitAttributes(HtmlOpenTagNode node, Expression tagName) {
        boolean isFirstHtmlOpenTagNode;
        Expression openTagExpr;
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        TemplateNode template = node.getNearestAncestor(TemplateNode.class);
        ArrayList<Expression> args = new ArrayList<Expression>();
        args.add(tagName);
        ImmutableMap<String, Expression> staticAttributes = this.getStaticAttributes(node);
        ImmutableList.Builder staticsBuilder = ImmutableList.builder();
        for (Map.Entry entry : staticAttributes.entrySet()) {
            staticsBuilder.add((Object)Expression.stringLiteral((String)entry.getKey()));
            staticsBuilder.add(entry.getValue());
        }
        KeyNode keyNode = node.getKeyNode();
        Expression key = this.incrementKeyForTemplate(template);
        if (keyNode != null) {
            key = this.translateExpr(keyNode.getExpr());
            this.keyCounterStack.push(new Holder<Integer>(0));
        }
        args.add(key);
        if (!staticAttributes.isEmpty()) {
            String id = "_statics_" + this.staticsCounter++;
            Expression idExpr = Expression.id(this.alias + id);
            Expression lazyAssignment = idExpr.or(idExpr.assign(Expression.arrayLiteral((Iterable<? extends Expression>)staticsBuilder.build())), null);
            this.staticsDeclarations.add(VariableDeclaration.builder(this.alias + id).build());
            args.add(lazyAssignment);
        }
        if (node.numChildren() == 1) {
            openTagExpr = IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN.call(args);
        } else {
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN_START.call(args));
            jsCodeBuilder.increaseIndentTwice();
            for (int i = 1; i < node.numChildren(); ++i) {
                this.visit((SoyNode)node.getChild(i));
            }
            jsCodeBuilder.decreaseIndentTwice();
            openTagExpr = IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN_END.call(new Expression[0]);
        }
        VeLogNode velogNode = (VeLogNode)template.firstChildThatMatches(n -> n.getKind() == SoyNode.Kind.VE_LOG_NODE);
        boolean bl = isFirstHtmlOpenTagNode = velogNode != null ? node.equals(velogNode.firstChildThatMatches(n -> n.getKind() == SoyNode.Kind.HTML_OPEN_TAG_NODE)) : node.equals(template.firstChildThatMatches(n -> n.getKind() == SoyNode.Kind.HTML_OPEN_TAG_NODE));
        if (template instanceof TemplateElementNode && isFirstHtmlOpenTagNode) {
            this.getJsCodeBuilder().append(Expression.id("this").dotAccess("setNodeInternal").call(openTagExpr));
        } else {
            this.getJsCodeBuilder().append(openTagExpr);
        }
    }

    private Expression incrementKeyForTemplate(TemplateNode template) {
        Holder<Integer> keyCounter = this.keyCounterStack.peek();
        Expression[] expressionArray = new Expression[1];
        Holder<Integer> holder = keyCounter;
        Integer n = (Integer)holder.value;
        holder.value = (Integer)holder.value + 1;
        Integer n2 = holder.value;
        expressionArray[0] = Expression.stringLiteral(template.getTemplateName() + "-" + n);
        return JsRuntime.XID.call(expressionArray);
    }

    private ImmutableMap<String, Expression> getStaticAttributes(HtmlOpenTagNode node) {
        ArrayList<HtmlAttributeNode> nodesToRemove = new ArrayList<HtmlAttributeNode>();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 1; i < node.numChildren(); ++i) {
            if (!(node.getChild(i) instanceof HtmlAttributeNode)) continue;
            HtmlAttributeNode attrNode = (HtmlAttributeNode)node.getChild(i);
            String attributeKey = attrNode.getStaticKey();
            Expression value = this.getStaticContent(attrNode);
            if (attributeKey == null || value == null) continue;
            nodesToRemove.add(attrNode);
            builder.put((Object)attributeKey, (Object)value);
        }
        for (HtmlAttributeNode child : nodesToRemove) {
            node.removeChild(child);
        }
        return builder.build();
    }

    private Expression getStaticContent(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return Expression.stringLiteral("");
        }
        if (!(node.getChild(1) instanceof HtmlAttributeValueNode)) {
            return null;
        }
        HtmlAttributeValueNode attrValue = (HtmlAttributeValueNode)node.getChild(1);
        if (attrValue.numChildren() == 0) {
            return Expression.stringLiteral("");
        }
        for (int i = 0; i < attrValue.numChildren(); ++i) {
            if (attrValue.getChild(i) instanceof RawTextNode) continue;
            if (attrValue.getChild(i) instanceof PrintNode) {
                PrintNode n = (PrintNode)attrValue.getChild(i);
                if (n.getExpr().getRoot() instanceof FunctionNode) {
                    FunctionNode fnNode = (FunctionNode)n.getExpr().getRoot();
                    if (fnNode.getSoyFunction() == BuiltinFunction.XID || fnNode.getSoyFunction() == BuiltinFunction.CSS) continue;
                    return null;
                }
                return null;
            }
            return null;
        }
        return CodeChunkUtils.concatChunksForceString(this.getAttributeValues(node));
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        Expression tagCodeChunk = this.getTagNameCodeChunk(node.getTagName());
        this.emitOpenAndVisitAttributes(node, tagCodeChunk);
        if (node.getKeyNode() != null) {
            Expression key = this.translateExpr(node.getKeyNode().getExpr());
            this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_PUSH_MANUAL_KEY.call(key));
        }
        if (node.isSelfClosing() || node.getTagName().isDefinitelyVoid()) {
            this.emitClose(tagCodeChunk);
        }
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        HtmlOpenTagNode openTag;
        if (node.getTaggedPairs().size() == 1 && (openTag = (HtmlOpenTagNode)node.getTaggedPairs().get(0)).getKeyNode() != null) {
            this.keyCounterStack.pop();
            this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_POP_MANUAL_KEY.call(new Expression[0]));
        }
        if (!node.getTagName().isDefinitelyVoid()) {
            this.emitClose(this.getTagNameCodeChunk(node.getTagName()));
        }
    }

    private void emitClose(Expression tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE.call(tagName));
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        Expression textArg = Expression.stringLiteral(node.getRawText());
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        switch (node.getHtmlContext()) {
            case CSS: 
            case JS: 
            case HTML_RCDATA: 
            case HTML_PCDATA: {
                jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(textArg));
                break;
            }
            case HTML_TAG: {
                jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(textArg, Expression.stringLiteral("")));
                break;
            }
            default: {
                jsCodeBuilder.addChunkToOutputVar(textArg);
            }
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        List<Expression> chunks = this.genJsExprsVisitor.exec(node);
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT_DYNAMIC_ATTR.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks)));
                break;
            }
            case CSS: 
            case JS: 
            case HTML_PCDATA: {
                if (node.numChildren() > 0 && ((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective() instanceof SanitizedContentOperator && ((SanitizedContentOperator)((Object)((PrintDirectiveNode)node.getChild(node.numChildren() - 1)).getPrintDirective())).getContentKind() == SanitizedContent.ContentKind.HTML) {
                    this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks), Expression.LITERAL_TRUE));
                    break;
                }
                this.getJsCodeBuilder().append(IncrementalDomRuntime.SOY_IDOM_PRINT.call(IncrementalDomRuntime.INCREMENTAL_DOM, CodeChunkUtils.concatChunks(chunks)));
                break;
            }
            case HTML_RCDATA: {
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expression.id("String").call(CodeChunkUtils.concatChunks(chunks))));
                break;
            }
            default: {
                super.visitPrintNode(node);
            }
        }
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        VeLogStateHolder state = this.openVeLogNode(node);
        this.getJsCodeBuilder().append(state.enterStatement);
        this.visitChildren(node);
        this.getJsCodeBuilder().append(this.exitVeLogNode(node, state.logOnlyConditional));
    }

    VeLogStateHolder openVeLogNode(VeLogNode node) {
        Expression isLogOnly = Expression.LITERAL_FALSE;
        VariableDeclaration isLogOnlyVar = null;
        Expression isLogOnlyReference = null;
        if (node.getLogonlyExpression() != null) {
            String idName = "velog_" + this.staticsCounter++;
            isLogOnlyReference = Expression.id(idName);
            isLogOnly = (Expression)this.getExprTranslator().exec(node.getLogonlyExpression());
            isLogOnlyVar = VariableDeclaration.builder(idName).setRhs(isLogOnly).build();
            this.getJsCodeBuilder().append(Statement.of(isLogOnlyVar, Statement.ifStatement(IncrementalDomRuntime.INCREMENTAL_DOM_VERIFY_LOGONLY.call(isLogOnlyVar.ref()), Statement.assign("idomRenderer", IncrementalDomRuntime.INCREMENTAL_DOM_TONULL.call(new Expression[0]))).build()));
        }
        Expression veData = (Expression)this.getExprTranslator().exec(node.getVeDataExpression());
        return new VeLogStateHolder(isLogOnlyReference, IncrementalDomRuntime.INCREMENTAL_DOM_ENTER.call(veData, isLogOnly).asStatement());
    }

    Statement exitVeLogNode(VeLogNode node, Expression isLogOnly) {
        Statement exit = IncrementalDomRuntime.INCREMENTAL_DOM_EXIT.call(new Expression[0]).asStatement();
        if (isLogOnly != null) {
            return Statement.of(exit, Statement.ifStatement(isLogOnly, Statement.assign("idomRenderer", IncrementalDomRuntime.INCREMENTAL_DOM_TODEFAULT.call(new Expression[0]))).build());
        }
        return exit;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                String id = "_msg_" + this.alias + "_" + this.staticsCounter++;
                VariableDeclaration staticDecl = VariableDeclaration.builder(id).setRhs(Expression.objectLiteral((Iterable<? extends Expression>)ImmutableList.of(), (Iterable<? extends Expression>)ImmutableList.of())).build();
                this.staticsDeclarations.add(staticDecl);
                CodeChunk chunk = new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter, id).generateMsgGroupCode(node);
                this.getJsCodeBuilder().append(chunk);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                Expression msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(msgExpression));
                break;
            }
            case HTML_RCDATA: {
                Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(Expression.id("String").call(msgExpression)));
                break;
            }
            default: {
                Expression msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(msgExpression);
            }
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    private Expression getTagNameCodeChunk(TagName tagName) {
        return this.genJsExprsVisitor.exec(tagName.getNode()).get(0);
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
            super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
        }

        @Override
        protected Expression genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
            Expression toEscape = super.genGoogMsgPlaceholder(msgPhNode);
            return JsRuntime.SOY_ESCAPE_HTML.call(toEscape);
        }
    }

    static class VeLogStateHolder {
        Expression logOnlyConditional;
        Statement enterStatement;

        public VeLogStateHolder(Expression logOnlyConditional, Statement enterStatement) {
            this.logOnlyConditional = logOnlyConditional;
            this.enterStatement = enterStatement;
        }
    }

    private static class Holder<T> {
        T value;

        public Holder(T value) {
            this.value = value;
        }
    }
}

