/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;

public final class FieldAccessNode
extends DataAccessNode {
    private final String fieldName;

    public FieldAccessNode(ExprNode base, String fieldName, SourceLocation location, boolean isNullSafe) {
        super(base, location, isNullSafe);
        Preconditions.checkArgument((fieldName != null ? 1 : 0) != 0);
        this.fieldName = fieldName;
    }

    private FieldAccessNode(FieldAccessNode orig, CopyState copyState) {
        super(orig, copyState);
        this.fieldName = orig.fieldName;
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.FIELD_ACCESS_NODE;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getSourceStringSuffix() {
        return (this.isNullSafe ? "?." : ".") + this.fieldName;
    }

    @Override
    public FieldAccessNode copy(CopyState copyState) {
        return new FieldAccessNode(this, copyState);
    }
}

