/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.AutoValue_LoggingAdvisingAppendable_BufferingAppendable_LoggingFunctionCommand;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class LoggingAdvisingAppendable
implements AdvisingAppendable {
    private SanitizedContent.ContentKind kind;
    private Dir contentDir;
    private boolean contentDirSet;

    public static BufferingAppendable buffering() {
        return new BufferingAppendable();
    }

    public static LoggingAdvisingAppendable delegating(Appendable appendable) {
        return new DelegatingToAppendable(appendable, null);
    }

    public static LoggingAdvisingAppendable stringCoercing(LoggingAdvisingAppendable delegate) {
        return new ForwardingLoggingAdvisingAppendable(delegate){

            @Override
            protected void notifyContentDirectionality(@Nullable Dir contentDir) {
            }

            @Override
            public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
                return this;
            }

            @Override
            public LoggingAdvisingAppendable exitLoggableElement() {
                return this;
            }

            @Override
            public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
                return this.append(1.escapePlaceholder(funCall.placeholderValue(), escapers));
            }
        };
    }

    @Override
    public abstract LoggingAdvisingAppendable append(CharSequence var1) throws IOException;

    @Override
    public abstract LoggingAdvisingAppendable append(CharSequence var1, int var2, int var3) throws IOException;

    @Override
    public abstract LoggingAdvisingAppendable append(char var1) throws IOException;

    public abstract LoggingAdvisingAppendable enterLoggableElement(LogStatement var1);

    public abstract LoggingAdvisingAppendable exitLoggableElement();

    public final LoggingAdvisingAppendable setSanitizedContentKind(SanitizedContent.ContentKind kind) throws IOException {
        Preconditions.checkNotNull((Object)((Object)kind));
        if (this.kind == null) {
            this.kind = kind;
            this.notifyContentKind(kind);
        }
        return this;
    }

    @ForOverride
    protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
    }

    @Nullable
    public final SanitizedContent.ContentKind getSantizedContentKind() {
        return this.kind;
    }

    public final LoggingAdvisingAppendable setSanitizedContentDirectionality(@Nullable Dir contentDir) throws IOException {
        if (!this.contentDirSet) {
            this.contentDirSet = true;
            this.contentDir = contentDir;
            this.notifyContentDirectionality(contentDir);
        }
        return this;
    }

    @ForOverride
    protected void notifyContentDirectionality(Dir contentDir) throws IOException {
    }

    @Nullable
    public final Dir getSanitizedContentDirectionality() {
        return this.contentDir;
    }

    public abstract LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation var1, ImmutableList<Function<String, String>> var2) throws IOException;

    protected static String escapePlaceholder(String placeholder, List<Function<String, String>> escapers) {
        for (Function<String, String> escaper : escapers) {
            placeholder = (String)escaper.apply((Object)placeholder);
        }
        return placeholder;
    }

    public static final class BufferingAppendable
    extends DelegatingToAppendable<StringBuilder> {
        private static final Object EXIT_LOG_STATEMENT_MARKER = new Object();
        private static final Object SET_SANITIZED_CONTENT_DIRECTIONALITY_NULL_MARKER = new Object();
        private List<Object> commands;

        BufferingAppendable() {
            super(new StringBuilder(), null);
        }

        private List<Object> getCommandsAndAddPendingStringData() {
            if (this.commands == null) {
                this.commands = new ArrayList<Object>();
            }
            if (((StringBuilder)this.delegate).length() != 0) {
                this.commands.add(((StringBuilder)this.delegate).toString());
                ((StringBuilder)this.delegate).setLength(0);
            }
            return this.commands;
        }

        @Override
        protected void notifyContentKind(SanitizedContent.ContentKind kind) throws IOException {
            this.getCommandsAndAddPendingStringData().add((Object)kind);
        }

        @Override
        protected void notifyContentDirectionality(@Nullable Dir contentDir) throws IOException {
            if (contentDir == null) {
                this.getCommandsAndAddPendingStringData().add(SET_SANITIZED_CONTENT_DIRECTIONALITY_NULL_MARKER);
            } else {
                this.getCommandsAndAddPendingStringData().add((Object)contentDir);
            }
        }

        @Override
        protected final void doEnterLoggableElement(LogStatement statement) {
            this.getCommandsAndAddPendingStringData().add(statement);
        }

        @Override
        protected final void doExitLoggableElement() {
            this.getCommandsAndAddPendingStringData().add(EXIT_LOG_STATEMENT_MARKER);
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            this.getCommandsAndAddPendingStringData().add(LoggingFunctionCommand.create(funCall, escapers));
        }

        public void replayOn(LoggingAdvisingAppendable appendable) throws IOException {
            if (this.commands != null) {
                for (Object o : this.getCommandsAndAddPendingStringData()) {
                    if (o instanceof String) {
                        appendable.append((String)o);
                        continue;
                    }
                    if (o instanceof LoggingFunctionCommand) {
                        ((LoggingFunctionCommand)o).replayOn(appendable);
                        continue;
                    }
                    if (o == EXIT_LOG_STATEMENT_MARKER) {
                        appendable.exitLoggableElement();
                        continue;
                    }
                    if (o instanceof LogStatement) {
                        appendable.enterLoggableElement((LogStatement)o);
                        continue;
                    }
                    if (o instanceof SanitizedContent.ContentKind) {
                        appendable.setSanitizedContentKind((SanitizedContent.ContentKind)((Object)o));
                        continue;
                    }
                    if (o instanceof Dir) {
                        appendable.setSanitizedContentDirectionality((Dir)((Object)o));
                        continue;
                    }
                    if (o == SET_SANITIZED_CONTENT_DIRECTIONALITY_NULL_MARKER) {
                        appendable.setSanitizedContentDirectionality(null);
                        continue;
                    }
                    throw new AssertionError((Object)("unexpected command object: " + o));
                }
            } else {
                appendable.append((CharSequence)((Object)this.delegate));
            }
        }

        @VisibleForTesting
        public String getAndClearBuffer() {
            if (this.commands != null) {
                BufferingAppendable.appendCommandsToBuilder(this.getCommandsAndAddPendingStringData(), (StringBuilder)this.delegate);
                this.commands = null;
            }
            String value = ((StringBuilder)this.delegate).toString();
            ((StringBuilder)this.delegate).setLength(0);
            return value;
        }

        public String toString() {
            if (this.commands != null) {
                StringBuilder builder = new StringBuilder();
                BufferingAppendable.appendCommandsToBuilder(this.commands, builder);
                builder.append((CharSequence)((Object)this.delegate));
                return builder.toString();
            }
            return ((StringBuilder)this.delegate).toString();
        }

        private static void appendCommandsToBuilder(List<Object> commands, StringBuilder builder) {
            for (Object o : commands) {
                if (o instanceof String) {
                    builder.append((String)o);
                    continue;
                }
                if (!(o instanceof LoggingFunctionCommand)) continue;
                LoggingFunctionCommand command = (LoggingFunctionCommand)o;
                builder.append(BufferingAppendable.escapePlaceholder(command.fn().placeholderValue(), command.escapers()));
            }
        }

        @AutoValue
        static abstract class LoggingFunctionCommand {
            LoggingFunctionCommand() {
            }

            static LoggingFunctionCommand create(LoggingFunctionInvocation fn, ImmutableList<Function<String, String>> escapers) {
                return new AutoValue_LoggingAdvisingAppendable_BufferingAppendable_LoggingFunctionCommand(fn, escapers);
            }

            abstract LoggingFunctionInvocation fn();

            abstract ImmutableList<Function<String, String>> escapers();

            LoggingAdvisingAppendable replayOn(LoggingAdvisingAppendable appendable) throws IOException {
                return appendable.appendLoggingFunctionInvocation(this.fn(), this.escapers());
            }
        }
    }

    private static class DelegatingToAppendable<T extends Appendable>
    extends AbstractLoggingAdvisingAppendable {
        final T delegate;

        private DelegatingToAppendable(T delegate) {
            this.delegate = (Appendable)Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final void doAppend(CharSequence s) throws IOException {
            this.delegate.append(s);
        }

        @Override
        protected final void doAppend(CharSequence s, int start, int end) throws IOException {
            this.delegate.append(s, start, end);
        }

        @Override
        protected final void doAppend(char c) throws IOException {
            this.delegate.append(c);
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            DelegatingToAppendable.escapePlaceholder(funCall.placeholderValue(), escapers);
        }

        @Override
        protected void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected void doExitLoggableElement() {
        }

        @Override
        public boolean softLimitReached() {
            return false;
        }

        /* synthetic */ DelegatingToAppendable(Appendable x0, 1 x1) {
            this(x0);
        }
    }
}

