

package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TemplateMetadata extends TemplateMetadata {

  private final SoyFileKind soyFileKind;

  private final SourceLocation sourceLocation;

  private final TemplateMetadata.Kind templateKind;

  private final String templateName;

  private final String delTemplateName;

  private final String delTemplateVariant;

  private final SanitizedContentKind contentKind;

  private final boolean strictHtml;

  private final Visibility visibility;

  private final String delPackageName;

  private final TemplateNode templateNode;

  private final ImmutableList<TemplateMetadata.Parameter> parameters;

  private final boolean hasSoyDocParams;

  private final ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations;

  private AutoValue_TemplateMetadata(
      SoyFileKind soyFileKind,
      SourceLocation sourceLocation,
      TemplateMetadata.Kind templateKind,
      String templateName,
      @Nullable String delTemplateName,
      @Nullable String delTemplateVariant,
      @Nullable SanitizedContentKind contentKind,
      boolean strictHtml,
      Visibility visibility,
      @Nullable String delPackageName,
      @Nullable TemplateNode templateNode,
      ImmutableList<TemplateMetadata.Parameter> parameters,
      boolean hasSoyDocParams,
      ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations) {
    this.soyFileKind = soyFileKind;
    this.sourceLocation = sourceLocation;
    this.templateKind = templateKind;
    this.templateName = templateName;
    this.delTemplateName = delTemplateName;
    this.delTemplateVariant = delTemplateVariant;
    this.contentKind = contentKind;
    this.strictHtml = strictHtml;
    this.visibility = visibility;
    this.delPackageName = delPackageName;
    this.templateNode = templateNode;
    this.parameters = parameters;
    this.hasSoyDocParams = hasSoyDocParams;
    this.dataAllCallSituations = dataAllCallSituations;
  }

  @Override
  public SoyFileKind getSoyFileKind() {
    return soyFileKind;
  }

  @Override
  public SourceLocation getSourceLocation() {
    return sourceLocation;
  }

  @Override
  public TemplateMetadata.Kind getTemplateKind() {
    return templateKind;
  }

  @Override
  public String getTemplateName() {
    return templateName;
  }

  @Nullable
  @Override
  public String getDelTemplateName() {
    return delTemplateName;
  }

  @Nullable
  @Override
  public String getDelTemplateVariant() {
    return delTemplateVariant;
  }

  @Nullable
  @Override
  public SanitizedContentKind getContentKind() {
    return contentKind;
  }

  @Override
  public boolean isStrictHtml() {
    return strictHtml;
  }

  @Override
  public Visibility getVisibility() {
    return visibility;
  }

  @Nullable
  @Override
  public String getDelPackageName() {
    return delPackageName;
  }

  @Nullable
  @Override
  public TemplateNode getTemplateNode() {
    return templateNode;
  }

  @Override
  public ImmutableList<TemplateMetadata.Parameter> getParameters() {
    return parameters;
  }

  @Override
  public boolean getHasSoyDocParams() {
    return hasSoyDocParams;
  }

  @Override
  public ImmutableList<TemplateMetadata.DataAllCallSituation> getDataAllCallSituations() {
    return dataAllCallSituations;
  }

  @Override
  public String toString() {
    return "TemplateMetadata{"
         + "soyFileKind=" + soyFileKind + ", "
         + "sourceLocation=" + sourceLocation + ", "
         + "templateKind=" + templateKind + ", "
         + "templateName=" + templateName + ", "
         + "delTemplateName=" + delTemplateName + ", "
         + "delTemplateVariant=" + delTemplateVariant + ", "
         + "contentKind=" + contentKind + ", "
         + "strictHtml=" + strictHtml + ", "
         + "visibility=" + visibility + ", "
         + "delPackageName=" + delPackageName + ", "
         + "templateNode=" + templateNode + ", "
         + "parameters=" + parameters + ", "
         + "hasSoyDocParams=" + hasSoyDocParams + ", "
         + "dataAllCallSituations=" + dataAllCallSituations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TemplateMetadata) {
      TemplateMetadata that = (TemplateMetadata) o;
      return (this.soyFileKind.equals(that.getSoyFileKind()))
           && (this.sourceLocation.equals(that.getSourceLocation()))
           && (this.templateKind.equals(that.getTemplateKind()))
           && (this.templateName.equals(that.getTemplateName()))
           && ((this.delTemplateName == null) ? (that.getDelTemplateName() == null) : this.delTemplateName.equals(that.getDelTemplateName()))
           && ((this.delTemplateVariant == null) ? (that.getDelTemplateVariant() == null) : this.delTemplateVariant.equals(that.getDelTemplateVariant()))
           && ((this.contentKind == null) ? (that.getContentKind() == null) : this.contentKind.equals(that.getContentKind()))
           && (this.strictHtml == that.isStrictHtml())
           && (this.visibility.equals(that.getVisibility()))
           && ((this.delPackageName == null) ? (that.getDelPackageName() == null) : this.delPackageName.equals(that.getDelPackageName()))
           && ((this.templateNode == null) ? (that.getTemplateNode() == null) : this.templateNode.equals(that.getTemplateNode()))
           && (this.parameters.equals(that.getParameters()))
           && (this.hasSoyDocParams == that.getHasSoyDocParams())
           && (this.dataAllCallSituations.equals(that.getDataAllCallSituations()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= soyFileKind.hashCode();
    h$ *= 1000003;
    h$ ^= sourceLocation.hashCode();
    h$ *= 1000003;
    h$ ^= templateKind.hashCode();
    h$ *= 1000003;
    h$ ^= templateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateName == null) ? 0 : delTemplateName.hashCode();
    h$ *= 1000003;
    h$ ^= (delTemplateVariant == null) ? 0 : delTemplateVariant.hashCode();
    h$ *= 1000003;
    h$ ^= (contentKind == null) ? 0 : contentKind.hashCode();
    h$ *= 1000003;
    h$ ^= strictHtml ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= visibility.hashCode();
    h$ *= 1000003;
    h$ ^= (delPackageName == null) ? 0 : delPackageName.hashCode();
    h$ *= 1000003;
    h$ ^= (templateNode == null) ? 0 : templateNode.hashCode();
    h$ *= 1000003;
    h$ ^= parameters.hashCode();
    h$ *= 1000003;
    h$ ^= hasSoyDocParams ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= dataAllCallSituations.hashCode();
    return h$;
  }

  @Override
  public TemplateMetadata.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TemplateMetadata.Builder {
    private SoyFileKind soyFileKind;
    private SourceLocation sourceLocation;
    private TemplateMetadata.Kind templateKind;
    private String templateName;
    private String delTemplateName;
    private String delTemplateVariant;
    private SanitizedContentKind contentKind;
    private Boolean strictHtml;
    private Visibility visibility;
    private String delPackageName;
    private TemplateNode templateNode;
    private ImmutableList<TemplateMetadata.Parameter> parameters;
    private Boolean hasSoyDocParams;
    private ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations;
    Builder() {
    }
    private Builder(TemplateMetadata source) {
      this.soyFileKind = source.getSoyFileKind();
      this.sourceLocation = source.getSourceLocation();
      this.templateKind = source.getTemplateKind();
      this.templateName = source.getTemplateName();
      this.delTemplateName = source.getDelTemplateName();
      this.delTemplateVariant = source.getDelTemplateVariant();
      this.contentKind = source.getContentKind();
      this.strictHtml = source.isStrictHtml();
      this.visibility = source.getVisibility();
      this.delPackageName = source.getDelPackageName();
      this.templateNode = source.getTemplateNode();
      this.parameters = source.getParameters();
      this.hasSoyDocParams = source.getHasSoyDocParams();
      this.dataAllCallSituations = source.getDataAllCallSituations();
    }
    @Override
    public TemplateMetadata.Builder setSoyFileKind(SoyFileKind soyFileKind) {
      if (soyFileKind == null) {
        throw new NullPointerException("Null soyFileKind");
      }
      this.soyFileKind = soyFileKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setSourceLocation(SourceLocation sourceLocation) {
      if (sourceLocation == null) {
        throw new NullPointerException("Null sourceLocation");
      }
      this.sourceLocation = sourceLocation;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateKind(TemplateMetadata.Kind templateKind) {
      if (templateKind == null) {
        throw new NullPointerException("Null templateKind");
      }
      this.templateKind = templateKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateName(String templateName) {
      if (templateName == null) {
        throw new NullPointerException("Null templateName");
      }
      this.templateName = templateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateName(String delTemplateName) {
      this.delTemplateName = delTemplateName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelTemplateVariant(String delTemplateVariant) {
      this.delTemplateVariant = delTemplateVariant;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setContentKind(@Nullable SanitizedContentKind contentKind) {
      this.contentKind = contentKind;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setStrictHtml(boolean strictHtml) {
      this.strictHtml = strictHtml;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setVisibility(Visibility visibility) {
      if (visibility == null) {
        throw new NullPointerException("Null visibility");
      }
      this.visibility = visibility;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDelPackageName(@Nullable String delPackageName) {
      this.delPackageName = delPackageName;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setTemplateNode(@Nullable TemplateNode templateNode) {
      this.templateNode = templateNode;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setParameters(ImmutableList<TemplateMetadata.Parameter> parameters) {
      if (parameters == null) {
        throw new NullPointerException("Null parameters");
      }
      this.parameters = parameters;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setHasSoyDocParams(boolean hasSoyDocParams) {
      this.hasSoyDocParams = hasSoyDocParams;
      return this;
    }
    @Override
    public TemplateMetadata.Builder setDataAllCallSituations(ImmutableList<TemplateMetadata.DataAllCallSituation> dataAllCallSituations) {
      if (dataAllCallSituations == null) {
        throw new NullPointerException("Null dataAllCallSituations");
      }
      this.dataAllCallSituations = dataAllCallSituations;
      return this;
    }
    @Override
    TemplateMetadata autobuild() {
      String missing = "";
      if (this.soyFileKind == null) {
        missing += " soyFileKind";
      }
      if (this.sourceLocation == null) {
        missing += " sourceLocation";
      }
      if (this.templateKind == null) {
        missing += " templateKind";
      }
      if (this.templateName == null) {
        missing += " templateName";
      }
      if (this.strictHtml == null) {
        missing += " strictHtml";
      }
      if (this.visibility == null) {
        missing += " visibility";
      }
      if (this.parameters == null) {
        missing += " parameters";
      }
      if (this.hasSoyDocParams == null) {
        missing += " hasSoyDocParams";
      }
      if (this.dataAllCallSituations == null) {
        missing += " dataAllCallSituations";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TemplateMetadata(
          this.soyFileKind,
          this.sourceLocation,
          this.templateKind,
          this.templateName,
          this.delTemplateName,
          this.delTemplateVariant,
          this.contentKind,
          this.strictHtml,
          this.visibility,
          this.delPackageName,
          this.templateNode,
          this.parameters,
          this.hasSoyDocParams,
          this.dataAllCallSituations);
    }
  }

}
