/* SoyFileParser.java */
/* Generated By:JavaCC: Do not edit this line. SoyFileParser.java */
package com.google.template.soy.soyparse;

import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.base.Preconditions.checkState;
import static com.google.template.soy.exprtree.Operator.createOperatorNode;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.ErrorReporter.Checkpoint;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrorKind.StyleAllowance;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprNode.PrimitiveNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode.StandaloneNode;
import com.google.template.soy.soytree.SoyNode.StatementNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNode.SoyFileHeaderInfo;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.HeaderParam;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

/**
 * This parser's specification is in SoyFileParser.jj, which is read by JavaCC and transformed
 * into SoyFileParser.java. To modify this parser, please edit SoyFileParser.jj. Do not edit
 * SoyFileParser.java directly.
 *
 * <p> Important: Do not use outside of Soy code (treat as superpackage-private).
 *
 * <pre>
 * This parser parses the following Soy file structure:
 *
 * 1. Delegate package (delpackage):
 *    + Optional.
 *    + The file must contain 0 or 1 delpackage declaration.
 *    + It must appear before the namespace declaration.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:  {delpackage MySecretFeature}
 *
 * 2. Namespace:
 *    + The file must contain exactly one namespace declaration.
 *    + It must appear before any templates.
 *    + It must appear on its own line and start at the start of a line.
 *    Example:
 *    {namespace boo.foo}
 *
 * 3. Alias:
 *    + Alias declarations must appear after the namespace declaration.
 *    + They must appear before any templates.
 *    + Each must appear on its own line and start at the start of a line.
 *    Examples:
 *    {alias boo.foo.goo.moo}
 *    {alias boo.foo.goo.moo as zoo}
 *
 * 4. SoyDoc:
 *    + Starts with slash-star-star (/**) and ends with star-slash (*&#47;) like JavaDoc.
 *    + SoyDoc must appear on its own line(s) and start at the start of a line.
 *    + Currently recognizes two tags: "&#64;param keyName" and "&#64;param? optionalKeyName".
 *    Example:
 *    /**
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *
 * 5. Template:
 *    + Each template must be immediately preceded by a SoyDoc block.
 *    + The {template} tag and the {/template} tag must each appear on its own line(s) and start
 *      at the start of a line.
 *    Examples:
 *    /**
 *     * &#64;param boo Something scary.
 *     * &#64;param? goo Something slimy (optional).
 *     *&#47;
 *    {template .foo autoescape="..."}
 *      {msg desc=""}
 *        {$boo} has a friend named {$goo.firstName}.
 *      {/msg}
 *    {/template}
 *
 * 6. Misc:
 *    + Other than the items specified above, everything else is ignored.
 *    + SoyDoc blocks not immediately followed by a template are ignored.
 *    + The file must end with a newline.
 *
 * Template contents are parsed as follows:
 *
 * Header:
 *
 * 1. Comments:
 *    + Standard "//" for a rest-of-line comment. Must appear at start of line or after a space.
 *    + Standard slash-star (/*) ... star-slash (*&#47;) for a block comment.
 *    + Doc comments are not allowed, except when attached to a valid declaration.
 *
 * 2. Param declaration:
 *    + Soy tag with command name "@param" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@param' tag.
 *    Examples:
 *    {@param foo: bool}
 *    {@param foo: list<int>}  /** A list of numbers. *&#47;
 *    {@param? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 3. Injected param declaration:
 *    + Works exactly like @param except that parameter values are taken from the
 *      implicit $ij scope.
 *    + Soy tag with command name "@inject" and command text "key: type".
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the param tag, or must start on the same line as the end of the '@inject' tag.
 *    Examples:
 *    {@inject foo: bool}
 *    {@inject foo: list<int>}  /** A list of numbers. *&#47;
 *    {@inject? foo:
 *        list<int>}  /**
 *        A list of numbers. *&#47;
 *
 * 4. State variable declaration:
 *    + Soy tag with command name "@state" and command text "key: type".
 *    + State variables must be explicitly initialized.
 *    + Optional desc string is written as a block doc comment, which either must
 *      precede the state tag, or must start on the same line as the end of the '@state' tag.
 *    Examples:
 *    {@state foo: bool = true}
 *    {@state foo: list<int> = [1, 2, 3]}  /** A list of numbers. *&#47;
 *
 * Body:
 *
 * 1. Soy tag format:
 *    + Can be delimited by single braces "{...}".
 *    + } characters are only allowed in tags if they're inside string literals.
 *    + Some Soy tags are allowed to end in "/}" to denote immediate ending of a block.
 *    + It is an error to use "/}" when it's not applicable to the command.
 *    + If there is a command name, it must come immediately after the opening delimiter.
 *    + The command name must be followed by either the closing delimiter (if the command does not
 *      take any command text) or a whitespace (if the command takes command text).
 *    Examples:
 *    {print $boo}   // explicit 'print' command
 *    {$boo.foo}   // implicit 'print' command
 *    {printer}   // implicit 'print' command (the prefix 'print' here is not a command name)
 *    {\n}   // a command that doesn't take any command text
 *    {call .gooMoo data="all" /}   // self-ending block
 *    {call .gooMoo data="all"}...{/call}   // block with separate start and end tags
 *
 * 2. Raw text:
 *    + Raw text is fixed text that will be part of the template output. There are 3 types.
 *    + Any text outside of Soy tags is raw text.
 *    + There are 8 special character commands that produce raw text strings:
 *      {sp} = space   {nil} = empty string   {\n} = newline (line feed)   {\r} = carriage return
 *      {\t} = tab   {lb} = left brace   {rb} = right brace   {nbsp} = non-breaking space
 *    + A section of raw text (may contain braces) can be enclosed within a 'literal' block:
 *      {literal}...{/literal}
 *
 * 3. Msg blocks:
 *    + A block between {msg} and {/msg} tags represents a message for translation.
 *    + It is an error to nest {msg} blocks.
 *    + Within a {msg} block, the parsing of Soy tags is the same. The only difference is that we
 *      also recognize "&lt;" and "&gt;" as opening and closing an HTML tag. This is because each
 *      HTML tag as a whole needs to be turned into a single placeholder in the message.
 *    + A {msg} block may have a {plural} or {select} block as its only content.
 *    + A {msg} block may be followed by one optional additional {fallbackmsg} block.
 *    Example:
 *    {msg desc="Event title."}
 *      Join event &lt;a href="{$event.url}"&gt;{$event.title}&lt;/a&gt;.
 *    {fallbackmsg desc="Event title."}
 *      Join event {$event.title}.
 *    {/msg}
 *
 * 4. Other Soy commands:
 *    {print ...}
 *    {...}    // implied 'print' command
 *    {xid ...}
 *    {css ...}
 *    {let ... /}
 *    {let ...}...{/let}
 *    {if ...}...{elseif ...}...{else ...}...{/if}
 *    {switch ...}{case ...}...{default}...{/switch}
 *    {foreach ...}...{ifempty}...{/foreach}
 *    {for ...}...{/for}
 *    {call ... /}
 *    {delcall ... /}
 *    {call ...}{param ... /}{param ...}...{/param}{/call}
 *    {delcall ...}{param ... /}{param ...}...{/param}{/delcall}
 *    {log}...{/log}
 *    {debugger}
 *    {velog ...}....{/velog}
 *    {key ...}
 *
 * 5. Misc:
 *    + The following commands are not allowed to appear in a template:
 *      {alias ...}   {namespace ...}   {delpackage ...}   {template ...}   {deltemplate ...}
 *
 * Expressions:
 *
 * A. Variable:
 *    + A dollar sign "$" followed by an identifier (no space between).
 *
 * B. Data reference:
 *    + The first part must be "$" followed by the first key name (no space between).
 *    + The first key name cannot be a number.
 *    + A variable will only have the first part. A data reference may have subsequent parts.
 *    + Subsequent parts may be:
 *       - A dot "." or question-dot "?." followed by a key name or array index (spaces between are
 *         allowed).
 *       - Brackets "[ ]" or question-brackets "?[ ]" with any expression inside the brackets (see
 *         below for definition of expression).
 *    + A special case is when the first key name is "ij". In this case, it's a reference to
 *      injected data, and the reference is considered to start from the second key (i.e. the second
 *      key actually becomes the first key in the parsed node).
 *    Examples:   $aaa   $ij.aaa   $aaa.bbb.0.ccc.12   $aaa[0]['bbb'].ccc   $aaa[$bbb + $ccc]
 *
 * C. Global:
 *    + One or more identifiers. If more than one, a dot "." is used to separate them.
 *    + Must not be preceded by a dollar sign "$".
 *    Examples:   AAA   aaa.bbb.CCC   a22.b88_
 *
 * D. Expression list:
 *    + A comma-separated list of one or more expressions (see below for definition of expression).
 *    Examples:   $aaa, $bbb.ccc + 1, round(3.14)
 *
 * E. Named parameter list:
 *    + A named parameter list, used only for proto initialization calls.
 *    + A comma-separate list of named expressions, in which names and expressions are separated by
 *      a colon ":".
 *    + Named and unnamed expressions cannot be mixed within the same function call.
 *    Examples:   foo: $aaa, bar: $bbb.ccc + 1, baz: round(3.14)
 *
 * F. Expression:
 *
 *    1. Data reference:
 *       + See above for definition.
 *
 *    2. Global:
 *       + See above for definition.
 *
 *    3. Null:   null
 *
 *    4. Boolean:   false   true
 *
 *    5. Integer:
 *       + No octal numbers.
 *       + Hex numbers have strict lower case "x" in "0x" and "A-F" or "a-f".
 *       Examples:   0   26   -729   0x1a2B
 *
 *    6. Float:
 *       + Decimal numbers only.
 *       + Must have digits on both sides of decimal point.
 *       + Exponents have strict lower case "e".
 *       Examples:   0.0   3.14159   -20.0   6.03e23   -3e-3
 *
 *    7. String:
 *       + Single quotes only.
 *       + Escape sequences:   \\   \'   \"   \n   \r   \t   \b   \f
 *       + Unicode escape:   \ u ####   (backslash, "u", four hex digits -- no spaces in between)
 *       Examples:   ''   'abc'   'blah bleh bluh'   'aa\\bb\'cc\ndd'   '☺'
 *
 *    8. List literal:
 *       + Delimited by brackets.
 *       Examples:   []   ['blah', 123, $foo]
 *
 *    9. Record literal:
 *       + Delimited by record().
 *       + Keys must be identifiers.
 *       Examples:   record()   record(aaa: 'blah', bbb: 123, boo: $foo)
 *
 *    10. Operator:
 *       + Parentheses can be used to override precedence rules:   ( )
 *       + Precedence 8:   - (unary)   not
 *       + Precedence 7:   *   /   %
 *       + Precedence 6:   +   - (binary)
 *       + Precedence 5:   <   >   <=   >=
 *       + Precedence 4:   ==   !=
 *       + Precedence 3:   and
 *       + Precedence 2:   or
 *       + Precedence 1:   ?: (binary)   ? : (ternary)
 *
 *    11. Function:
 *       + Function name, open parenthesis, optional expression list, close parenthesis.
 *       + The function name is one or more identifiers, separated by dots.
 *       + See above for the definition of an expression list.
 *       Examples:   foo()   isFirst($item)   my.new.Proto(a: 'str', b: $foo)
 *
 *    12. Proto initialization:
 *       + Fully qualified proto name, open parenthesis, optional named parameter list,
 *         close parenthesis.
 *       + See above for the definition of a named parameter list.
 *       Examples:   proto()   my.new.Proto(a: 'str', b: $foo)*
 * </pre>
 *
 */
public class SoyFileParser implements SoyFileParserConstants {

  // Template errors:
  private static final SoyErrorKind INVALID_ALIAS_NAME =
      SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.");
  private static final SoyErrorKind INVALID_CALLEE_NAME =
      SoyErrorKind.of("Invalid callee name ''{0}''.");
  private static final SoyErrorKind INVALID_DELTEMPLATE_NAME =
      SoyErrorKind.of("Deltemplate ''{0}'' must have a fully qualified name.");
  private static final SoyErrorKind INVALID_TEMPLATE_NAME =
      SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot "
          + "followed by an identifier.");
  private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK =
      SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.");
  private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS =
      SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.");
  private static final SoyErrorKind PLURAL_CASE_MALFORMED =
      SoyErrorKind.of("Invalid number in ''plural case'' command text.");
  private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS =
      SoyErrorKind.of("The ''offset'' for plural must be a positive integer.");
  private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER =
      SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.");
  private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE =
      SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.");
  private static final SoyErrorKind CSS_XID_MIGRATION =
      SoyErrorKind.of("The ''{0}'' command is {1}, please switch to using the {0} function."
  );
  // There's nothing technical preventing us from allowing default values on injected parameters,
  // but we're not sure if that's something we want in the language, so we're preventing it for now.
  private static final SoyErrorKind INJECT_DEFAULT_PARAM =
      SoyErrorKind.of("Default parameters are not supported on injected parameters.");
  private static final SoyErrorKind OPTIONAL_DEFAULT_PARAM =
      SoyErrorKind.of(
          "Default parameters are not supported on optional parameters. Did you mean "
          + "'''{@param ...}'''?");
  private static final SoyErrorKind STATE_IN_TEMPLATE =
      SoyErrorKind.of("@state declarations are only allowed in elements.");
  private static final SoyErrorKind STATE_REQUIRES_VALUE =
      SoyErrorKind.of("@state declarations require an initial value.");

  // Expression errors:
  private static final SoyErrorKind DUPLICATE_KEY_NAME =
      SoyErrorKind.of("Duplicate {0} ''{1}''.");
  private static final SoyErrorKind INVALID_KEY_NAME = SoyErrorKind.of(
      "Invalid {0} ''{1}''.{2}", StyleAllowance.NO_PUNCTUATION);
  private static final SoyErrorKind INTEGER_OUT_OF_RANGE =
      SoyErrorKind.of(
          "Soy integers are constrained to the range of JavaScript integers: "
              + "https://www.ecma-international.org/ecma-262/5.1/#sec-8.5",
          StyleAllowance.NO_PUNCTUATION);
  private static final SoyErrorKind INVALID_PARAM_NAME =
      SoyErrorKind.of("Invalid param name ''{0}''.");
  private static final SoyErrorKind INVALID_VAR_NAME_IJ =
      SoyErrorKind.of("Invalid var name ''ij'' (''ij'' is for injected data ref).");
  private static final SoyErrorKind UNEXPECTED_PIPE =
      SoyErrorKind.of("Unexpected ''|''. Print directives should not have whitespace after ''|''.");
  private static final SoyErrorKind OLD_RECORD_LITERAL_SYNTAX =
      SoyErrorKind.of(
          "Parse error at '':''. If this is a record literal, use the new syntax: "
              + "''record(key1: \"value1\", key2: 2)''. If this is a legacy_object_map literal, "
              + "there is no syntax for that, consider using ''map()'' instead.");

  private static final SoyErrorKind FOREACH_IS_DISABLED = SoyErrorKind.of(
      "foreach loops are no longer supported, please switch to the for loop."
      , StyleAllowance.NO_CAPS);

  // Error message that mimics a ParseException
  private static final SoyErrorKind PARSER_ERROR =
      SoyErrorKind.of(
          "parse error at ''{0}'': expected {1}",
          StyleAllowance.NO_CAPS,
          StyleAllowance.NO_PUNCTUATION);

  /** Names of attributes whose values should be parsed as expressions. */
  private static final ImmutableSet<String> EXPR_ATTR_NAMES =
      ImmutableSet.of("data", "genders", "key", "logonly", "variant");

  /** Attempts to parse the given input as a Soy expression. */
  public static ExprNode parseExprOrDie(String exprText) {
    return parseExpression(exprText, ErrorReporter.exploding());
  }

  /** Attempts to parse the given input as a Soy expression. Returns null if parsing fails. */
  @Nullable
  public static ExprNode parseExpression(
      String exprText, ErrorReporter errorReporter) {
    String filePath = "expression parser";
    SoyFileParser parser = new SoyFileParser(exprText, filePath, errorReporter);
    try {
      return parser.ExprInput();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(
          errorReporter, filePath, e, parser.token_source.curLexState);
      return null;
    }
  }

  /** Attempts to parse the given input as a type node. Returns null if parsing fails. */
  @Nullable
  public static TypeNode parseType(
      String typeText,
      String filePath,
      ErrorReporter errorReporter) {
    SoyFileParser parser = new SoyFileParser(typeText, filePath, errorReporter);
    try {
      return parser.TypeExpr();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(
          errorReporter, filePath, e, parser.token_source.curLexState);
      return null;
    }
  }

  /** Node id generator for the tree being built. */
  private IdGenerator nodeIdGen;

  /** Path of source being parsed. This is descriptive, not a means to refetch source. */
  private String filePath;

  /** Controls how to handle whitespaces (e.g. whether to join lines or preserve whitespace). */
  private WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;

  /** For reporting errors during parsing. */
  private ErrorReporter errorReporter;

  /** The header info for the file we are parsing. */
  private SoyFileHeaderInfo headerInfo;

  /**
   * Constructor that takes a reader object providing the input.
   *
   * @param nodeIdGen The node id generator for the tree being built.
   * @param input The input to parse.
   * @param filePath The path of the source being parsed. Used for reporting.
   * @param errorReporter For reporting parse errors.
   */
  public SoyFileParser(
      IdGenerator nodeIdGen,
      Reader input,
      String filePath,
      ErrorReporter errorReporter) {
    this(input);
    this.nodeIdGen = checkNotNull(nodeIdGen);
    this.filePath = checkNotNull(filePath);
    this.errorReporter = checkNotNull(errorReporter);
  }

  /** Constructor for use by parseExpression() and parseType() only. */
  private SoyFileParser(
      String input,
      String filePath,
      ErrorReporter errorReporter) {
    // this starts the lexer in a particular state instead of DEFAULT
    this(new SoyFileParserTokenManager(
        new SimpleCharStream(new StringReader(input), 1, 1), EXPR));
    this.filePath = filePath;
    this.errorReporter = checkNotNull(errorReporter);
    // Some part of the parser assume that header info is not null.
    this.headerInfo = SoyFileHeaderInfo.EMPTY;
  }

  /** Attempts to parse the given input as a Soy file. Returns null if parsing fails. */
  @Nullable
  public SoyFileNode parseSoyFile() {
    checkNotNull(nodeIdGen);
    Checkpoint checkpoint = errorReporter.checkpoint();
    SoyFileNode soyFileNode = null;
    try {
      soyFileNode = SoyFile();
    } catch (ParseException e) {
      ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, token_source.curLexState);
    } catch (TokenMgrError e) {
      ParseErrors.reportTokenMgrError(errorReporter, filePath, e);
    }

    // our callers expect us to return null when encountering parsing errors.
    if (errorReporter.errorsSince(checkpoint)) {
      return null;
    }
    // Parse the html tags
    // See comments on HtmlRewriter for why this isn't deeply integrated into this parser.
    HtmlRewriter.rewrite(soyFileNode, nodeIdGen, errorReporter);
    return soyFileNode;
  }

  /**
   * Reports the error and skips to the given token.
   *
   * See https://javacc.org/tutorials/errorrecovery
   */
  private void reportFileErrorAndSkipTo(ParseException error, int skipTo) {
    ParseErrors.reportSoyFileParseException(
        errorReporter, filePath, error, token_source.curLexState);
    Token t;
    do {
      t = getNextToken();
    // We need to halt when observing EOF.  The behavior of the token manager is to keep returning
    // EOF from getNextToken(), so if we don't check for it this will become an infinite loop.
    } while (t.kind != skipTo && t.kind != EOF);
  }

  /**
   * Reports the error and skips to the given token if it observes the end of a template, throws an
   * exception to halt parsing.
   *
   * See https://javacc.org/tutorials/errorrecovery
   */
  private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int... kinds) {
    ParseErrors.reportSoyFileParseException(
        errorReporter, filePath, error, token_source.curLexState);
    return skipToTemplateToken(kinds);
  }

  private Token skipToTemplateToken(int... kinds) {
    ImmutableSet<Integer> skipTo = ImmutableSet.copyOf(Ints.asList(kinds));
    Token t;
    while (true) {
      t = getNextToken();
      if (skipTo.contains(t.kind)) {
        return t;
      }
      // We need to halt when observing EOF.  The behavior of the token manager is to keep returning
      // EOF from getNextToken(), so if we don't check for it this will become an infinite loop.
      if (t.kind == CMD_CLOSE_TEMPLATE || t.kind == CMD_CLOSE_DELTEMPLATE || t.kind == EOF) {
        throw new AbortParsingError();
      }
    }
  }

  /** Create a SourceLocation spanning all given tokens. */
  private SourceLocation createSrcLoc(Token tok1, Token... rest) {
    return Tokens.createSrcLoc(filePath, tok1, rest);
  }

  /** Create an error ExprNode at the location of the given tokens. */
  private VarRefNode errorExpr(Token tok1, Token... rest) {
    return VarRefNode.error(createSrcLoc(tok1, rest));
  }

  // An error that can be thrown to abort parsing.  This is useful if an error has been reported
  // and it is known that parsing cannot continue.
  private static final class AbortParsingError extends Error {}

  final private SoyFileNode SoyFile() throws ParseException {Identifier delpackageName = null;
  NamespaceDeclaration namespace;
  AliasDeclaration alias;
  List<AliasDeclaration> aliases = ImmutableList.of();
  TemplateNode template;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DELPACKAGE_OPEN:{
      delpackageName = DelPackage();
      break;
      }
    default:
      jj_la1[0] = jj_gen;
      ;
    }
    namespace = Namespace();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ALIAS_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      alias = Alias();
if (aliases.isEmpty()) {
        aliases = new ArrayList<AliasDeclaration>();
      }
      if (alias != null) {
        aliases.add(alias);
      }
    }
headerInfo = new SoyFileHeaderInfo(errorReporter, delpackageName, namespace, aliases);
    SoyFileNode sfn = new SoyFileNode(nodeIdGen.genId(), filePath, namespace, headerInfo);
    label_2:
    while (true) {
      template = Template(headerInfo);
if (template != null) {
        // it will be null if a parsing error occurred
        sfn.addChild(template);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DELTEMPLATE_OPEN:
      case TEMPLATE_OPEN:
      case ELEMENT_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
    }
    jj_consume_token(0);
{if ("" != null) return sfn;}
    throw new Error("Missing return statement in function");
  }

  final private AliasDeclaration Alias() throws ParseException {Token open, close;
  Identifier namespace, alias = null;
    open = jj_consume_token(ALIAS_OPEN);
    namespace = Identifier();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      Keyword("as");
      alias = Identifier();
      break;
      }
    default:
      jj_la1[3] = jj_gen;
      ;
    }
    close = jj_consume_token(CMD_END);
SourceLocation srcLoc = createSrcLoc(open, close);

    if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
      errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
      {if ("" != null) return null;}
    }

    if (alias == null) {  // Implicit alias is the last part of the namespace.
      alias = namespace.extractPartAfterLastDot();
    }
    {if ("" != null) return AliasDeclaration.create(namespace, alias);}
    throw new Error("Missing return statement in function");
  }

  final private NamespaceDeclaration Namespace() throws ParseException {Token open, close;
  Identifier name;
  List<CommandTagAttribute> attributes;
    open = jj_consume_token(NAMESPACE_OPEN);
    name = DottedIdent();
    attributes = Attributes();
    close = jj_consume_token(CMD_END);
{if ("" != null) return new NamespaceDeclaration(name, attributes, errorReporter);}
    throw new Error("Missing return statement in function");
  }

  final private List<CommandTagAttribute> Attributes() throws ParseException {CommandTagAttribute attr;
  List<CommandTagAttribute> attributes = ImmutableList.of();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:
      case IDENT:{
        ;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      attr = Attribute();
if (attributes.isEmpty()) {
        attributes = new ArrayList<CommandTagAttribute>();
      }
      attributes.add(attr);
    }
CommandTagAttribute.removeDuplicatesAndReportErrors(attributes, errorReporter);
    {if ("" != null) return attributes;}
    throw new Error("Missing return statement in function");
  }

  final private CommandTagAttribute Attribute() throws ParseException {Identifier name;
  Token nameToken, value;
  ImmutableList<ExprNode> exprList = ImmutableList.of();
  Token qToken;
  QuoteStyle quoteStyle;
checkState(token_source.curLexState == IN_CMD_TAG || token_source.curLexState == EXPR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      nameToken = jj_consume_token(NAME);
      break;
      }
    case IDENT:{
      nameToken = jj_consume_token(IDENT);
      break;
      }
    default:
      jj_la1[5] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
name = Identifier.create(nameToken.image, createSrcLoc(nameToken));
    // At this point we have an attribute, so make sure we're in the IN_CMD_TAG lexical state, which
    // is required to parse the attribute (this will switch EXPR to IN_CMD_TAG, if already in
    // IN_CMD_TAG this is a no-op). We only want to do this when we're sure we have an attribute
    // because if there is no attribute, the next token will be a "}", which will switch the lexical
    // state to TEMPLATE_DEFAULT so we can parse the template contents. At this point, if the next
    // token is a "}" it will already have been tokenized and the lexical state will have already
    // switched to TEMPLATE_DEFAULT, so we don't override that here.
    token_source.SwitchTo(IN_CMD_TAG);
    jj_consume_token(CMD_EQ);
    if (EXPR_ATTR_NAMES.contains(name.identifier())) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOUBLE_QUOTE:{
        jj_consume_token(CMD_DOUBLE_QUOTE);
quoteStyle = QuoteStyle.DOUBLE;
        token_source.SwitchTo(EXPR_NO_DOUBLE_QUOTE);
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NULL:
          case TRUE:
          case FALSE:
          case DEC_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case SINGLE_QUOTE:
          case DOUBLE_QUOTE:
          case MINUS:
          case NOT:
          case LBRACKET:
          case LPAREN:
          case IDENT:
          case IJ:
          case DOLLAR_IDENT:{
            exprList = ExprList();
            break;
            }
          default:
            jj_la1[6] = jj_gen;
            ;
          }
          qToken = jj_consume_token(END_DQ_EXPR_ATTR);
token_source.SwitchTo(IN_CMD_TAG);
        } catch (ParseException e) {
token_source.SwitchTo(IN_CMD_TAG);
        exprList = ImmutableList.of(errorExpr(e.currentToken));
        qToken = reportTemplateBodyErrorAndSkipTo(e, DOUBLE_QUOTE);
        }
        break;
        }
      case CMD_SINGLE_QUOTE:{
        jj_consume_token(CMD_SINGLE_QUOTE);
quoteStyle = QuoteStyle.SINGLE;
        token_source.SwitchTo(EXPR_NO_SINGLE_QUOTE);
        try {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NULL:
          case TRUE:
          case FALSE:
          case DEC_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case SINGLE_QUOTE:
          case DOUBLE_QUOTE:
          case MINUS:
          case NOT:
          case LBRACKET:
          case LPAREN:
          case IDENT:
          case IJ:
          case DOLLAR_IDENT:{
            exprList = ExprList();
            break;
            }
          default:
            jj_la1[7] = jj_gen;
            ;
          }
          qToken = jj_consume_token(END_SQ_EXPR_ATTR);
token_source.SwitchTo(IN_CMD_TAG);
        } catch (ParseException e) {
token_source.SwitchTo(IN_CMD_TAG);
        exprList = ImmutableList.of(errorExpr(e.currentToken));
        qToken = reportTemplateBodyErrorAndSkipTo(e, SINGLE_QUOTE);
        }
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (exprList.isEmpty()) {
        errorReporter.report(createSrcLoc(qToken), PARSER_ERROR, qToken.image, "an expression");
        exprList = ImmutableList.of(errorExpr(qToken));
      }
      {if ("" != null) return new CommandTagAttribute(
          Identifier.create(name.identifier(), name.location()),
          quoteStyle,
          exprList);}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOUBLE_QUOTE:
      case CMD_SINGLE_QUOTE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_DOUBLE_QUOTE:{
          jj_consume_token(CMD_DOUBLE_QUOTE);
token_source.pushState(IN_DQ_ATTRIBUTE_VALUE);
          value = jj_consume_token(DQ_ATTRIBUTE_VALUE);
quoteStyle = QuoteStyle.DOUBLE;
          break;
          }
        case CMD_SINGLE_QUOTE:{
          jj_consume_token(CMD_SINGLE_QUOTE);
token_source.pushState(IN_SQ_ATTRIBUTE_VALUE);
          value = jj_consume_token(SQ_ATTRIBUTE_VALUE);
quoteStyle = QuoteStyle.SINGLE;
          break;
          }
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
{if ("" != null) return new CommandTagAttribute(name, quoteStyle, value.image, createSrcLoc(value));}
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final private Identifier DelPackage() throws ParseException {Identifier name;
    jj_consume_token(DELPACKAGE_OPEN);
    name = DottedIdent();
    jj_consume_token(CMD_END);
{if ("" != null) return name;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateNode Template(SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {Token open, close = null;
  TemplateNode templateNode = null;
  RawTextNode initialWhitespace = null;
  List<StandaloneNode> templateBodyNodes = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TEMPLATE_OPEN:{
      open = jj_consume_token(TEMPLATE_OPEN);
TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, false);
whitespaceMode = builder.getWhitespaceMode();
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ false);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_TEMPLATE);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_TEMPLATE);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    case DELTEMPLATE_OPEN:{
      open = jj_consume_token(DELTEMPLATE_OPEN);
TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, true);
whitespaceMode = builder.getWhitespaceMode();
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ false);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_DELTEMPLATE);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_DELTEMPLATE);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    case ELEMENT_OPEN:{
      open = jj_consume_token(ELEMENT_OPEN);
TemplateElementNodeBuilder builder = new TemplateElementNodeBuilder(soyFileHeaderInfo, errorReporter);
      try {
        TemplateOpenTagHelper(builder, open, false);
        initialWhitespace = TemplateHeader(builder, /* allowState=*/ true);
        templateBodyNodes = TemplateBlock();
        close = jj_consume_token(CMD_CLOSE_ELEMENT);
builder.setSourceLocation(createSrcLoc(open, close));
        templateNode = builder.build();
      } catch (ParseException e) {
reportFileErrorAndSkipTo(e, CMD_CLOSE_ELEMENT);
      {if ("" != null) return null;}  // continue trying to parse other templates

      } catch (AbortParsingError e) {
// do nothing, continue trying to parse other templates
      {if ("" != null) return null;}
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (initialWhitespace != null) {
      templateNode.addChild(initialWhitespace);
    }
    if (templateBodyNodes != null) {
      templateNode.addChildren(templateBodyNodes);
    }
    {if ("" != null) return templateNode;}
    throw new Error("Missing return statement in function");
  }

  final private void TemplateOpenTagHelper(TemplateNodeBuilder builder, Token open, boolean isDeltemplate) throws ParseException {Identifier templateName;
  List<CommandTagAttribute> attributes;
  Token close;
// eagerly fetch the id to be backwards compatible.  if we delay allocating, all the ids in the
    // file will change.  TODO(user): remove ids
    builder.setId(nodeIdGen.genId());
    templateName = TemplateNameInDef(isDeltemplate);
    attributes = Attributes();
builder.setCommandValues(templateName, attributes);
    // We can't set soy doc until after setCommandValues due to conditions in the builder.
    // --- Set the SoyDoc. ---
    // special tokens are accessible from the non-special tokens that come after them.
    Token soyDoc = open.specialToken;
    if (soyDoc != null && soyDoc.kind == SOYDOC) {
      builder.setSoyDoc(soyDoc.image, createSrcLoc(soyDoc));
    }
    close = jj_consume_token(CMD_END);
builder.setOpenTagLocation(createSrcLoc(open, close));
  }

  final private Identifier TemplateNameInDef(boolean isDeltemplate) throws ParseException {Identifier templateName;
    templateName = TemplateName();
if (!isDeltemplate && templateName.type() != Identifier.Type.DOT_IDENT) {
      errorReporter.report(
          templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
    } else if (isDeltemplate && templateName.type() == Identifier.Type.DOT_IDENT) {
      errorReporter.report(
          templateName.location(), INVALID_DELTEMPLATE_NAME, templateName.identifier());
    }
{if ("" != null) return templateName;}
    throw new Error("Missing return statement in function");
  }

  final private Identifier TemplateName() throws ParseException {Token dot, name;
  Identifier ident;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_DOT:{
      // Partial name.
          dot = jj_consume_token(CMD_DOT);
      name = jj_consume_token(NAME);
ident = Identifier.create("." + name.image, createSrcLoc(dot, name));
      break;
      }
    case NAME:{
      // Fully qualified name.
          ident = DottedIdent();
      break;
      }
    default:
      jj_la1[12] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return ident;}
    throw new Error("Missing return statement in function");
  }

  final private Identifier DottedIdent() throws ParseException {StringBuilder sb = null;
  Token dot, name, next = null;
    name = jj_consume_token(NAME);
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_DOT:{
        ;
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        break label_4;
      }
      dot = jj_consume_token(CMD_DOT);
      next = jj_consume_token(NAME);
if (sb == null) {
        sb = new StringBuilder();
        sb.append(name.image);
      }
      sb.append('.').append(next.image);
    }
{if ("" != null) return sb == null
      ? Identifier.create(name.image, createSrcLoc(name))
      : Identifier.create(sb.toString(), createSrcLoc(name, next));}
    throw new Error("Missing return statement in function");
  }

  final private void SkipWhitespace() throws ParseException {
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TOKEN_WS:{
        ;
        break;
        }
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      jj_consume_token(TOKEN_WS);
    }
  }

  final private RawTextNode RawText() throws ParseException {Token token;
  RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TOKEN_NOT_WS:{
          token = jj_consume_token(TOKEN_NOT_WS);
          break;
          }
        case TOKEN_WS:{
          token = jj_consume_token(TOKEN_WS);
          break;
          }
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
builder.addBasic(token);
        break;
        }
      case CMD_OPEN_LITERAL:{
        jj_consume_token(CMD_OPEN_LITERAL);
        token = jj_consume_token(LITERAL_RAW_TEXT_CONTENT);
builder.addLiteral(token);
        break;
        }
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_FULL_SP:{
          token = jj_consume_token(CMD_FULL_SP);
          break;
          }
        case CMD_FULL_NIL:{
          token = jj_consume_token(CMD_FULL_NIL);
          break;
          }
        case CMD_FULL_CR:{
          token = jj_consume_token(CMD_FULL_CR);
          break;
          }
        case CMD_FULL_LF:{
          token = jj_consume_token(CMD_FULL_LF);
          break;
          }
        case CMD_FULL_TAB:{
          token = jj_consume_token(CMD_FULL_TAB);
          break;
          }
        case CMD_FULL_LB:{
          token = jj_consume_token(CMD_FULL_LB);
          break;
          }
        case CMD_FULL_RB:{
          token = jj_consume_token(CMD_FULL_RB);
          break;
          }
        case CMD_FULL_NBSP:{
          token = jj_consume_token(CMD_FULL_NBSP);
          break;
          }
        default:
          jj_la1[16] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
builder.addTextualCommand(token);
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        ;
        break;
        }
      default:
        jj_la1[18] = jj_gen;
        break label_6;
      }
    }
{if ("" != null) return builder.build();}
    throw new Error("Missing return statement in function");
  }

  final private RawTextNode TemplateHeader(TemplateNodeBuilder templateBuilder, boolean allowState) throws ParseException {Token tok;
  TemplateHeaderVarDefn param;
  List<HeaderParam> params = ImmutableList.of();
  RawTextNode whitespace = null;
  String soyDoc = null;
  List<TemplateStateVar> stateVars = ImmutableList.of();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DECL_BEGIN_PARAM:
      case DECL_BEGIN_OPT_PARAM:
      case DECL_BEGIN_INJECT_PARAM:
      case DECL_BEGIN_OPT_INJECT_PARAM:
      case DECL_BEGIN_STATE_VAR:
      case TOKEN_WS:{
        ;
        break;
        }
      default:
        jj_la1[19] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TOKEN_WS:{
RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
        label_8:
        while (true) {
          // prefer staying in the loop
                  tok = jj_consume_token(TOKEN_WS);
if (tok.specialToken != null) {
            soyDoc = tok.specialToken.image;
          }
          builder.addBasic(tok);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case TOKEN_WS:{
            ;
            break;
            }
          default:
            jj_la1[20] = jj_gen;
            break label_8;
          }
        }
whitespace = builder.build();
        break;
        }
      case DECL_BEGIN_PARAM:
      case DECL_BEGIN_OPT_PARAM:
      case DECL_BEGIN_INJECT_PARAM:
      case DECL_BEGIN_OPT_INJECT_PARAM:
      case DECL_BEGIN_STATE_VAR:{
        param = ParamDecl(soyDoc);
switch (param.kind()) {
          case PARAM:
            // we just parsed a param, preceding whitespace/doc comments are not important
            whitespace = null;
            soyDoc = null;
            if (params.isEmpty()) {
              params = new ArrayList<HeaderParam>();
            }
            params.add((HeaderParam) param);
            break;
          case STATE:
            if (allowState) {
              if (stateVars.isEmpty()) {
                stateVars = new ArrayList<TemplateStateVar>();
              }
              stateVars.add((TemplateStateVar) param);
            } else {
              errorReporter.report(param.nameLocation(), STATE_IN_TEMPLATE);
            }
            break;
          case IJ_PARAM:
          case LOCAL_VAR:
          case UNDECLARED:
            {if (true) throw new AssertionError("unexpected var kind: " + param.kind());}
        }
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
templateBuilder.addParams(params);
    if (allowState) {
      ((TemplateElementNodeBuilder) templateBuilder).setStateVars(stateVars);
    }
    {if ("" != null) return whitespace;}
    throw new Error("Missing return statement in function");
  }

  final private TemplateHeaderVarDefn ParamDecl(@Nullable String desc) throws ParseException {Token tagBegin, name;
  TypeNode paramTypeNode = null;
  ExprNode value = null;
  boolean optional = false;
  boolean inject = false;
  boolean stateVar = false;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DECL_BEGIN_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_PARAM);
      break;
      }
    case DECL_BEGIN_OPT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_PARAM);
optional = true;
      break;
      }
    case DECL_BEGIN_INJECT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_INJECT_PARAM);
inject = true;
      break;
      }
    case DECL_BEGIN_OPT_INJECT_PARAM:{
      tagBegin = jj_consume_token(DECL_BEGIN_OPT_INJECT_PARAM);
inject = true; optional = true;
      break;
      }
    case DECL_BEGIN_STATE_VAR:{
      tagBegin = jj_consume_token(DECL_BEGIN_STATE_VAR);
stateVar = true;
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
if (tagBegin.specialToken != null) {
      desc = tagBegin.specialToken.image;
    }
    name = jj_consume_token(NAME);
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_COLON:{
        jj_consume_token(CMD_COLON);
        paramTypeNode = TypeExpr();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EQ:{
          jj_consume_token(EQ);
          value = Expr();
          break;
          }
        default:
          jj_la1[23] = jj_gen;
          ;
        }
        break;
        }
      case CMD_COLON_EQ:{
        jj_consume_token(CMD_COLON_EQ);
        value = Expr();
        break;
        }
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(CMD_END);
    } catch (ParseException parseException) {
reportTemplateBodyErrorAndSkipTo(parseException, CMD_END);
    }
if (desc != null) {
      // trim the leading /** and trailing */ as well as the whitespace from the doc comment.
      desc = desc.substring(3, desc.length() - 2).trim();
    }
    if (stateVar) {
      if (value == null) {
        errorReporter.report(createSrcLoc(tagBegin), STATE_REQUIRES_VALUE);
        value = errorExpr(name);
      }
      {if ("" != null) return new TemplateStateVar(
          name.image,
          paramTypeNode,
          value,
          desc,
          createSrcLoc(name));}
    } else {
      boolean isNullable = false;
      if (paramTypeNode instanceof UnionTypeNode) {
        UnionTypeNode utn = (UnionTypeNode) paramTypeNode;
        for (TypeNode tn : utn.candidates()) {
          if (tn instanceof NamedTypeNode && ((NamedTypeNode) tn).name().equals("null")) {
            isNullable = true;
            break;
          }
        }
      } else if (paramTypeNode instanceof NamedTypeNode
          && ((NamedTypeNode) paramTypeNode).name().equals("null")) {
        isNullable = true;
      }
      // Optional params become nullable
      if (optional && !isNullable && paramTypeNode != null) {
        NamedTypeNode nullType = NamedTypeNode.create(createSrcLoc(tagBegin), "null");
        paramTypeNode = paramTypeNode instanceof UnionTypeNode
            ? UnionTypeNode.create(
                ImmutableList.<TypeNode>builder()
                    .addAll(((UnionTypeNode) paramTypeNode).candidates())
                    .add(nullType)
                    .build())
            : UnionTypeNode.create(ImmutableList.of(paramTypeNode, nullType));
      }
      if (value != null) {
        if (inject) {
          errorReporter.report(createSrcLoc(tagBegin), INJECT_DEFAULT_PARAM);
        } else if (optional) {
          errorReporter.report(createSrcLoc(tagBegin), OPTIONAL_DEFAULT_PARAM);
        }
      }
      {if ("" != null) return new HeaderParam(
          name.image,
          createSrcLoc(name),
          // Optional params become nullable
          paramTypeNode,
          // the param is required if there isn't a default value, it isn't optional and the parsed
          // type isn't nullable.
          value == null && !optional && !isNullable,
          inject,
          desc,
          value);}
    }
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlock() throws ParseException {StandaloneNode node;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_XID:
      case CMD_BEGIN_CSS:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_BEGIN_FOREACH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        ;
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        break label_9;
      }
      node = TemplateBlockItem();
if (templateBlock.isEmpty()) {
        templateBlock = new ArrayList<StandaloneNode>();
      }
      templateBlock.add(node);
    }
{if ("" != null) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private StandaloneNode TemplateBlockItem() throws ParseException {StandaloneNode node;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_SP:
    case CMD_FULL_NIL:
    case CMD_FULL_LF:
    case CMD_FULL_CR:
    case CMD_FULL_TAB:
    case CMD_FULL_LB:
    case CMD_FULL_RB:
    case CMD_FULL_NBSP:
    case CMD_OPEN_LITERAL:
    case TOKEN_WS:
    case TOKEN_NOT_WS:{
      node = RawText();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:
    case CMD_BEGIN_MSG:
    case CMD_BEGIN_XID:
    case CMD_BEGIN_CSS:
    case CMD_BEGIN_IF:
    case CMD_BEGIN_LET:
    case CMD_BEGIN_FOR:
    case CMD_BEGIN_SWITCH:
    case CMD_BEGIN_FOREACH:
    case CMD_OPEN_LOG:
    case CMD_FULL_DEBUGGER:
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:
    case CMD_BEGIN_KEY:
    case CMD_BEGIN_VELOG:{
      node = Stmt();
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode Stmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_LET:
    case CMD_OPEN_LOG:
    case CMD_FULL_DEBUGGER:
    case CMD_BEGIN_KEY:
    case CMD_BEGIN_VELOG:{
      stmt = NonPrintableStmt();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:
    case CMD_BEGIN_MSG:
    case CMD_BEGIN_XID:
    case CMD_BEGIN_CSS:
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:{
      stmt = PrintableStmt();
      break;
      }
    case CMD_BEGIN_IF:
    case CMD_BEGIN_FOR:
    case CMD_BEGIN_SWITCH:
    case CMD_BEGIN_FOREACH:{
      stmt = ControlFlowStmt();
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode NonPrintableStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_LET:{
      stmt = LetStmt();
      break;
      }
    case CMD_OPEN_LOG:{
      stmt = LogStmt();
      break;
      }
    case CMD_FULL_DEBUGGER:{
      stmt = DebuggerStmt();
      break;
      }
    case CMD_BEGIN_VELOG:{
      stmt = VeLogStmt();
      break;
      }
    case CMD_BEGIN_KEY:{
      stmt = KeyStmt();
      break;
      }
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode PrintableStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_MSG:{
      stmt = MsgStmt();
      break;
      }
    case CMD_BEGIN_XID:{
      stmt = XidStmt();
      break;
      }
    case CMD_BEGIN_CSS:{
      stmt = CssStmt();
      break;
      }
    case CMD_BEGIN_CALL:
    case CMD_BEGIN_DELCALL:{
      stmt = CallStmt();
      break;
      }
    case CMD_BEGIN_PRINT:
    case CMD_BEGIN_IMPLICIT_PRINT:{
      stmt = PrintStmt();
      break;
      }
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private StatementNode ControlFlowStmt() throws ParseException {StatementNode stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_IF:{
      stmt = IfStmt();
      break;
      }
    case CMD_BEGIN_SWITCH:{
      stmt = SwitchStmt();
      break;
      }
    case CMD_BEGIN_FOR:{
      stmt = ForStmt();
      break;
      }
    case CMD_BEGIN_FOREACH:{
      stmt = ForeachStmt();
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
  }

  final private MsgFallbackGroupNode MsgStmt() throws ParseException {Token tagBegin, tagEnd;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_MSG);
    try {
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
SourceLocation loc = createSrcLoc(tagBegin, tagEnd);
    MsgFallbackGroupNode msgGroup = new MsgFallbackGroupNode(nodeIdGen.genId(), loc);

    MsgNode msg = new MsgNode(nodeIdGen.genId(), loc, "msg", attributes, errorReporter);
    msgGroup.addChild(msg);
    templateBlock = TemplateBlockForMsg();
msg.addChildren(templateBlock);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_FALLBACK_MSG:{
      tagBegin = jj_consume_token(CMD_BEGIN_FALLBACK_MSG);
      try {
        attributes = Attributes();
        tagEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
      }
loc = createSrcLoc(tagBegin, tagEnd);
      MsgNode fallback =
          new MsgNode(nodeIdGen.genId(), loc, "fallbackmsg", attributes, errorReporter);
      msgGroup.addChild(fallback);
      templateBlock = TemplateBlockForMsg();
fallback.addChildren(templateBlock);
      break;
      }
    default:
      jj_la1[31] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_MSG);
{if ("" != null) return msgGroup;}
    throw new Error("Missing return statement in function");
  }

  final private List<StandaloneNode> TemplateBlockForMsg() throws ParseException {RawTextNode rawText;
  StandaloneNode stmt;
  StandaloneNode msgPluralOrSelectNode;
  // The index of the plural or select node, if any
  int pluralOrSelectIndex = -1;
  // Whether or not the first node is just whitespace.
  boolean firstNodeIsWhitespace = false;
  List<StandaloneNode> templateBlock = new ArrayList<StandaloneNode>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case TOKEN_WS:{
Token tok;
      RawTextBuilder builder = new RawTextBuilder(filePath, nodeIdGen, whitespaceMode);
      label_10:
      while (true) {
        // prefer staying in the loop
              tok = jj_consume_token(TOKEN_WS);
builder.addBasic(tok);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case TOKEN_WS:{
          ;
          break;
          }
        default:
          jj_la1[32] = jj_gen;
          break label_10;
        }
      }
rawText = builder.build();
      if (rawText != null) {
        firstNodeIsWhitespace = true;
        templateBlock.add(rawText);
      }
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      ;
    }
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_XID:
      case CMD_BEGIN_CSS:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_PLURAL:
      case CMD_BEGIN_SELECT:
      case CMD_BEGIN_SWITCH:
      case CMD_BEGIN_FOREACH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        ;
        break;
        }
      default:
        jj_la1[34] = jj_gen;
        break label_11;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_PLURAL:
      case CMD_BEGIN_SELECT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_PLURAL:{
          msgPluralOrSelectNode = MsgPlural();
          break;
          }
        case CMD_BEGIN_SELECT:{
          msgPluralOrSelectNode = MsgSelect();
          break;
          }
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        SkipWhitespace();
if (firstNodeIsWhitespace) {
        // The first node was just basic whitespace.  Which is allowed but ignored prior to a plural
        // or select.  So just drop it.
        templateBlock.remove(0);
        firstNodeIsWhitespace = false;
      }
      if (pluralOrSelectIndex == -1) {
        pluralOrSelectIndex = templateBlock.size();
      }
      templateBlock.add(msgPluralOrSelectNode);
        break;
        }
      case CMD_FULL_SP:
      case CMD_FULL_NIL:
      case CMD_FULL_LF:
      case CMD_FULL_CR:
      case CMD_FULL_TAB:
      case CMD_FULL_LB:
      case CMD_FULL_RB:
      case CMD_FULL_NBSP:
      case CMD_OPEN_LITERAL:
      case CMD_BEGIN_CALL:
      case CMD_BEGIN_DELCALL:
      case CMD_BEGIN_MSG:
      case CMD_BEGIN_XID:
      case CMD_BEGIN_CSS:
      case CMD_BEGIN_IF:
      case CMD_BEGIN_LET:
      case CMD_BEGIN_FOR:
      case CMD_BEGIN_SWITCH:
      case CMD_BEGIN_FOREACH:
      case CMD_OPEN_LOG:
      case CMD_FULL_DEBUGGER:
      case CMD_BEGIN_PRINT:
      case CMD_BEGIN_IMPLICIT_PRINT:
      case CMD_BEGIN_KEY:
      case CMD_BEGIN_VELOG:
      case TOKEN_WS:
      case TOKEN_NOT_WS:{
        stmt = TemplateBlockItem();
if (stmt != null) { templateBlock.add(stmt); }
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
// Plural/select are only allowed if they are the only child
    // However we do allow them to be prefixed or suffixed with arbitrary amounts of whitespace.
    if (pluralOrSelectIndex != -1) {
      StandaloneNode pluralOrSelect = templateBlock.get(pluralOrSelectIndex);
      for (int i = 0; i < templateBlock.size(); i++) {
        if (i == pluralOrSelectIndex) {
          continue;
        }
        errorReporter.report(
          // blame the current node
          templateBlock.get(i).getSourceLocation(),
          i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER,
          pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
      }
      // return the single plural or select and drop the other items.  We have either reported
      // errors or have ignored them because they are purely whitespace.
      {if ("" != null) return ImmutableList.of(pluralOrSelect);}
    }
    {if ("" != null) return templateBlock;}
    throw new Error("Missing return statement in function");
  }

  final private MsgPluralNode MsgPlural() throws ParseException {Token tagBegin, tagEnd;
  Token defaultTag;
  ExprNode pluralExpr;
  ExprNode caseExpr;
  CommandTagAttribute offsetAttr = null;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_PLURAL);
    try {
      pluralExpr = Expr();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:
      case IDENT:{
        offsetAttr = Attribute();
        break;
        }
      default:
        jj_la1[37] = jj_gen;
        ;
      }
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
pluralExpr = errorExpr(tagBegin);
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
int offset = 0;

    if (offsetAttr != null) {
      if (pluralExpr.getSourceLocation().isJustBefore(offsetAttr.getName().location())) {
        errorReporter.report(
            offsetAttr.getName().location(),
            PARSER_ERROR,
            offsetAttr.getName().identifier(),
            "whitespace");
      }

      if (!offsetAttr.getName().identifier().equals("offset")) {
        errorReporter.report(
            offsetAttr.getName().location(),
            CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE,
            offsetAttr.getName().identifier(),
            "plural",
            "offset");
        offsetAttr = null;
      }
    }

    if (offsetAttr != null) {
      offset = offsetAttr.valueAsInteger(errorReporter, 0);
      if (offset <= 0) {
        errorReporter.report(offsetAttr.getValueLocation(), PLURAL_OFFSET_OUT_OF_BOUNDS);
        offset = 0;
      }
    }

    MsgPluralNode pluralNode =
        new MsgPluralNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), pluralExpr, offset);
    SkipWhitespace();
    try {
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[38] = jj_gen;
          break label_12;
        }
        tagBegin = jj_consume_token(CMD_BEGIN_CASE);
        caseExpr = Expr();
        tagEnd = jj_consume_token(CMD_END);
int value;
        if (!(caseExpr instanceof IntegerNode)) {
          errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED);
          value = 0;
        } else {
          value = (int) ((IntegerNode) caseExpr).getValue();
          if (value < 0) {
            errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
            value = 0;
          }
        }

        MsgPluralCaseNode caseNode =
            new MsgPluralCaseNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), value);
        pluralNode.addChild(caseNode);
        templateBlock = TemplateBlockForMsg();
if (templateBlock.size() == 1 &&
            (templateBlock.get(0) instanceof MsgPluralNode ||
             templateBlock.get(0) instanceof MsgSelectNode )) {
          errorReporter.report(
              templateBlock.get(0).getSourceLocation(),
              PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
        }
        caseNode.addChildren(templateBlock);
      }
      defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
MsgPluralDefaultNode defaultNode =
          new MsgPluralDefaultNode(nodeIdGen.genId(), createSrcLoc(defaultTag));
      pluralNode.addChild(defaultNode);
      templateBlock = TemplateBlockForMsg();
if (templateBlock.size() == 1 &&
          (templateBlock.get(0) instanceof MsgPluralNode ||
           templateBlock.get(0) instanceof MsgSelectNode )) {
        errorReporter.report(
            templateBlock.get(0).getSourceLocation(),
            PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK);
      }
      defaultNode.addChildren(templateBlock);
      jj_consume_token(CMD_CLOSE_PLURAL);
    } catch (ParseException e) {
// report and keep going to maintain previous behavior around reporting errors for unexpected
    // textual content before the first {case} tag
    reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_PLURAL);
    }
{if ("" != null) return pluralNode;}
    throw new Error("Missing return statement in function");
  }

  final private MsgSelectNode MsgSelect() throws ParseException {Token tagBegin, tagEnd;
  Token defaultTag;
  ExprNode selectExpr;
  ExprNode caseExpr;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_SELECT);
    try {
      selectExpr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
selectExpr = errorExpr(tagBegin);
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
MsgSelectNode selectNode =
        new MsgSelectNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), selectExpr);
    SkipWhitespace();
    try {
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[39] = jj_gen;
          break label_13;
        }
        tagBegin = jj_consume_token(CMD_BEGIN_CASE);
        caseExpr = Expr();
        tagEnd = jj_consume_token(CMD_END);
String value = ParseErrors.validateSelectCaseLabel(caseExpr, errorReporter);
        MsgSelectCaseNode caseNode =
            new MsgSelectCaseNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), value);
        selectNode.addChild(caseNode);
        templateBlock = TemplateBlockForMsg();
caseNode.addChildren(templateBlock);
      }
      defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
MsgSelectDefaultNode defaultNode =
          new MsgSelectDefaultNode(nodeIdGen.genId(), createSrcLoc(defaultTag));
      selectNode.addChild(defaultNode);
      templateBlock = TemplateBlockForMsg();
defaultNode.addChildren(templateBlock);
      jj_consume_token(CMD_CLOSE_SELECT);
    } catch (ParseException e) {
reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_SELECT);
    }
{if ("" != null) return selectNode;}
    throw new Error("Missing return statement in function");
  }

  final private PrintNode PrintStmt() throws ParseException {Token tagBegin;
  Token tagEnd;
  boolean isImplicit;
  ExprNode expr = null;
  List<PrintDirectiveNode> directives = ImmutableList.of();
  List<CommandTagAttribute> attributes = ImmutableList.of();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_PRINT:{
      tagBegin = jj_consume_token(CMD_BEGIN_PRINT);
isImplicit = false;
      break;
      }
    case CMD_BEGIN_IMPLICIT_PRINT:{
      tagBegin = jj_consume_token(CMD_BEGIN_IMPLICIT_PRINT);
isImplicit = true;
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    try {
      expr = Expr();
      directives = PrintDirectives();
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
PrintNode node = new PrintNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagEnd),
        isImplicit,
        expr,
        attributes,
        errorReporter);
    node.addChildren(directives);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private List<PrintDirectiveNode> PrintDirectives() throws ParseException {PrintDirectiveNode node;
  List<PrintDirectiveNode> directives = ImmutableList.of();
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[41] = jj_gen;
        break label_14;
      }
      node = PrintDirective();
if (directives.isEmpty()) {
        directives = new ArrayList<PrintDirectiveNode>();
      }
      directives.add(node);
    }
{if ("" != null) return directives;}
    throw new Error("Missing return statement in function");
  }

  final private PrintDirectiveNode PrintDirective() throws ParseException {Token vbar, directive;
  ImmutableList<ExprNode> args = ImmutableList.of();
    vbar = jj_consume_token(VBAR);
    directive = jj_consume_token(IDENT);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      args = ExprList();
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
if (!Tokens.areAdjacent(vbar, directive)) {
      errorReporter.report(createSrcLoc(vbar), UNEXPECTED_PIPE);
    }
    SourceLocation loc = createSrcLoc(vbar, directive);
    Identifier ident = Identifier.create("|" + directive.image, loc);
    if (!args.isEmpty()) {
      loc.extend(args.get(args.size() - 1).getSourceLocation());
    }
    {if ("" != null) return new PrintDirectiveNode(nodeIdGen.genId(), /* name= */ ident, /* location= */ loc, args);}
    throw new Error("Missing return statement in function");
  }

  final private KeyNode KeyStmt() throws ParseException {Token tagBegin;
  Token tagEnd;
  ExprNode expr = null;
    tagBegin = jj_consume_token(CMD_BEGIN_KEY);
    try {
      expr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
KeyNode node = new KeyNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagEnd),
        expr);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private LogNode XidStmt() throws ParseException {Token tagBegin, tagEnd;
    tagBegin = jj_consume_token(CMD_BEGIN_XID);
tagEnd = skipToTemplateToken(CMD_END);
SourceLocation location = createSrcLoc(tagBegin, tagEnd);
    errorReporter.report(location, CSS_XID_MIGRATION, "xid", "no longer supported");
    {if ("" != null) return new LogNode(nodeIdGen.genId(), location);}
    throw new Error("Missing return statement in function");
  }

  final private LogNode CssStmt() throws ParseException {Token tagBegin, tagEnd;
    tagBegin = jj_consume_token(CMD_BEGIN_CSS);
tagEnd = skipToTemplateToken(CMD_END);
SourceLocation location = createSrcLoc(tagBegin, tagEnd);
    errorReporter.report(location, CSS_XID_MIGRATION, "css", "no longer supported");
    {if ("" != null) return new LogNode(nodeIdGen.genId(), location);}
    throw new Error("Missing return statement in function");
  }

  final private LetNode LetStmt() throws ParseException {Token tagBegin, tagEnd, nameTok = null;
  ExprNode valueExpr = null;
  CommandTagAttribute attr = null;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    tagBegin = jj_consume_token(CMD_BEGIN_LET);
    try {
      nameTok = jj_consume_token(DOLLAR_IDENT);
    } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    SourceLocation loc = createSrcLoc(tagBegin, tagEnd);
    {if ("" != null) return new LetValueNode(-1, loc, "$error", loc, errorExpr(tagBegin));}
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      try {
        jj_consume_token(COLON);
        valueExpr = Expr();
        tagEnd = jj_consume_token(CMD_SELF_CLOSE);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
      if (valueExpr == null) {
        valueExpr = errorExpr(tagEnd);
      }
      }
{if ("" != null) return new LetValueNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagEnd),
          nameTok.image,
          createSrcLoc(nameTok),
          valueExpr);}
      break;
      }
    case CMD_END:
    case NAME:
    case IDENT:{
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAME:
        case IDENT:{
          attr = Attribute();
          break;
          }
        default:
          jj_la1[43] = jj_gen;
          ;
        }
        tagEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END, CMD_SELF_CLOSE);
      }
      templateBlock = TemplateBlock();
      jj_consume_token(CMD_CLOSE_LET);
LetContentNode node =
          new LetContentNode(
              nodeIdGen.genId(),
              createSrcLoc(tagBegin, tagEnd),
              nameTok.image,
              createSrcLoc(nameTok),
              attr,
              errorReporter);
      node.addChildren(templateBlock);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private IfNode IfStmt() throws ParseException {Token tagBegin, tagEnd;
  Token elseTag;
  ExprNode ifExpr;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_IF);
    try {
      ifExpr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
ifExpr = errorExpr(tagBegin);
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
SourceLocation location = createSrcLoc(tagBegin, tagEnd);
    IfNode ifNode = new IfNode(nodeIdGen.genId(), location);
    IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), location, "if", ifExpr);
    ifNode.addChild(ifCondNode);
    templateBlock = TemplateBlock();
ifCondNode.addChildren(templateBlock);
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_ELSEIF:{
        ;
        break;
        }
      default:
        jj_la1[45] = jj_gen;
        break label_15;
      }
      tagBegin = jj_consume_token(CMD_BEGIN_ELSEIF);
      try {
        ifExpr = Expr();
        tagEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
ifExpr = errorExpr(tagBegin);
      tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
      }
location = createSrcLoc(tagBegin, tagEnd);
      ifCondNode = new IfCondNode(nodeIdGen.genId(), location, "elseif", ifExpr);
      ifNode.addChild(ifCondNode);
      templateBlock = TemplateBlock();
ifCondNode.addChildren(templateBlock);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_ELSE:{
      elseTag = jj_consume_token(CMD_FULL_ELSE);
IfElseNode ifElseNode = new IfElseNode(nodeIdGen.genId(), createSrcLoc(elseTag));
      ifNode.addChild(ifElseNode);
      templateBlock = TemplateBlock();
ifElseNode.addChildren(templateBlock);
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_IF);
{if ("" != null) return ifNode;}
    throw new Error("Missing return statement in function");
  }

  final private VeLogNode VeLogStmt() throws ParseException {ExprNode veDataExpr = null;
  Token tagBegin, tagEnd;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_VELOG);
    try {
      veDataExpr = Expr();
      attributes = Attributes();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
if (veDataExpr == null) {
      veDataExpr = errorExpr(tagBegin);
    }
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
    templateBlock = TemplateBlock();
    jj_consume_token(CMD_CLOSE_VELOG);
VeLogNode node = new VeLogNode(
        nodeIdGen.genId(),
        createSrcLoc(tagBegin, tagEnd),
        veDataExpr,
        attributes,
        errorReporter);
    node.addChildren(templateBlock);
    {if ("" != null) return node;}
    throw new Error("Missing return statement in function");
  }

  final private SwitchNode SwitchStmt() throws ParseException {Token tagBegin, tagEnd;
  Token defaultTag;
  ExprNode switchExpr;
  ImmutableList<ExprNode> caseExprs;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_SWITCH);
    try {
      switchExpr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
switchExpr = errorExpr(tagBegin);
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);
    }
SwitchNode switchNode =
        new SwitchNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), switchExpr);
    SkipWhitespace();
    try {
      label_16:
      while (true) {
        tagBegin = jj_consume_token(CMD_BEGIN_CASE);
        caseExprs = ExprList();
        tagEnd = jj_consume_token(CMD_END);
SwitchCaseNode caseNode =
            new SwitchCaseNode(nodeIdGen.genId(), createSrcLoc(tagBegin, tagEnd), caseExprs);
        switchNode.addChild(caseNode);
        templateBlock = TemplateBlock();
caseNode.addChildren(templateBlock);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_BEGIN_CASE:{
          ;
          break;
          }
        default:
          jj_la1[47] = jj_gen;
          break label_16;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_FULL_DEFAULT:{
        defaultTag = jj_consume_token(CMD_FULL_DEFAULT);
SwitchDefaultNode defaultNode =
            new SwitchDefaultNode(nodeIdGen.genId(), createSrcLoc(defaultTag));
        switchNode.addChild(defaultNode);
        templateBlock = TemplateBlock();
defaultNode.addChildren(templateBlock);
        break;
        }
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      jj_consume_token(CMD_CLOSE_SWITCH);
    } catch (ParseException e) {
reportTemplateBodyErrorAndSkipTo(e, CMD_CLOSE_SWITCH);
    }
{if ("" != null) return switchNode;}
    throw new Error("Missing return statement in function");
  }

  final private ForNode ForStmt() throws ParseException {Token tagBegin, tagEnd, ifemptyTag, nameTok;
  ExprNode expr = null;
  String name = null;
  SourceLocation nameLocation = null;
  List<StandaloneNode> templateBlock;
    tagBegin = jj_consume_token(CMD_BEGIN_FOR);
    try {
      nameTok = jj_consume_token(DOLLAR_IDENT);
name = nameTok.image;
        nameLocation = createSrcLoc(nameTok);
      Keyword("in");
      expr = Expr();
      tagEnd = jj_consume_token(CMD_END);
    } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END);

    if (name == null) {
      name = "$error";
      nameLocation = createSrcLoc(tagBegin);
    }
    if (expr == null) {
      expr = errorExpr(tagBegin);
    }
    }
ForNode forNode =
        new ForNode(
            nodeIdGen.genId(),
            createSrcLoc(tagBegin, tagEnd),
            expr);
    ForNonemptyNode nonEmpty =
        new ForNonemptyNode(
            nodeIdGen.genId(),
            name,
            nameLocation);
    forNode.addChild(nonEmpty);
    templateBlock = TemplateBlock();
nonEmpty.addChildren(templateBlock);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_FULL_IFEMPTY:{
      ifemptyTag = jj_consume_token(CMD_FULL_IFEMPTY);
      templateBlock = TemplateBlock();
ForIfemptyNode ifempty =
          new ForIfemptyNode(nodeIdGen.genId(), createSrcLoc(ifemptyTag));
      ifempty.addChildren(templateBlock);
      forNode.addChild(ifempty);
      break;
      }
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    jj_consume_token(CMD_CLOSE_FOR);
{if ("" != null) return forNode;}
    throw new Error("Missing return statement in function");
  }

  final private LogNode ForeachStmt() throws ParseException {Token tok;
    tok = jj_consume_token(CMD_BEGIN_FOREACH);
SourceLocation location = createSrcLoc(tok);
    errorReporter.report(location, FOREACH_IS_DISABLED);
    skipToTemplateToken(CMD_CLOSE_FOREACH);
    {if ("" != null) return new LogNode(nodeIdGen.genId(), location);}
    throw new Error("Missing return statement in function");
  }

  final private CallNode CallStmt() throws ParseException {Token tagBegin, tagEnd;
  Identifier calleeName = null;
  List<CommandTagAttribute> attributes = ImmutableList.of();
  List<CallParamNode> params = ImmutableList.of();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case CMD_BEGIN_CALL:{
      // {call}
          tagBegin = jj_consume_token(CMD_BEGIN_CALL);
      try {
        calleeName = TemplateName();
        attributes = Attributes();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_SELF_CLOSE:{
          tagEnd = jj_consume_token(CMD_SELF_CLOSE);
          break;
          }
        case CMD_END:{
          tagEnd = jj_consume_token(CMD_END);
          params = CallParams();
          jj_consume_token(CMD_CLOSE_CALL);
          break;
          }
        default:
          jj_la1[50] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_CLOSE_CALL);
      if (calleeName == null) {
        calleeName = Identifier.create(".error", createSrcLoc(tagBegin));
      }
      }
String fullName =
          SoyParseUtils.calculateFullCalleeName(calleeName, headerInfo, errorReporter);
      CallBasicNode node = new CallBasicNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagEnd),
          calleeName,
          fullName,
          attributes,
          errorReporter);
      node.addChildren(params);
      {if ("" != null) return node;}
      break;
      }
    case CMD_BEGIN_DELCALL:{
      // {delcall}
          tagBegin = jj_consume_token(CMD_BEGIN_DELCALL);
      try {
        calleeName = TemplateName();
        attributes = Attributes();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case CMD_SELF_CLOSE:{
          tagEnd = jj_consume_token(CMD_SELF_CLOSE);
          break;
          }
        case CMD_END:{
          tagEnd = jj_consume_token(CMD_END);
          params = CallParams();
          jj_consume_token(CMD_CLOSE_DELCALL);
          break;
          }
        default:
          jj_la1[51] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_CLOSE_DELCALL);
      if (calleeName == null) {
        calleeName = Identifier.create("error", createSrcLoc(tagBegin));
      }
      }
if (calleeName.type() == Identifier.Type.DOT_IDENT) {
        errorReporter.report(calleeName.location(), INVALID_CALLEE_NAME, calleeName.identifier());
      }

      CallDelegateNode node = new CallDelegateNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagEnd),
          calleeName,
          attributes,
          errorReporter);
      node.addChildren(params);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private List<CallParamNode> CallParams() throws ParseException {List<CallParamNode> params = ImmutableList.of();
  CallParamNode paramNode;
    SkipWhitespace();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case CMD_BEGIN_PARAM:{
        ;
        break;
        }
      default:
        jj_la1[53] = jj_gen;
        break label_17;
      }
      paramNode = CallParam();
if (params.isEmpty()) {
        params = new ArrayList<CallParamNode>();
      }
      params.add(paramNode);
      SkipWhitespace();
    }
{if ("" != null) return params;}
    throw new Error("Missing return statement in function");
  }

  final private CallParamNode CallParam() throws ParseException {Token tagBegin, tagEnd;
  Identifier key;
  ExprNode valueExpr = null;
  CommandTagAttribute attr = null;
  List<StandaloneNode> templateBlock = ImmutableList.of();
    tagBegin = jj_consume_token(CMD_BEGIN_PARAM);
    try {
      key = Identifier();
    } catch (ParseException e) {
key = Identifier.create("error", createSrcLoc(tagBegin));
    tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
    {if ("" != null) return new CallParamValueNode(-1, createSrcLoc(tagBegin, tagEnd), key, errorExpr(tagBegin));}
    }
if (key.type() != Identifier.Type.SINGLE_IDENT) {
      errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      try {
        jj_consume_token(COLON);
        valueExpr = Expr();
        tagEnd = jj_consume_token(CMD_SELF_CLOSE);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_SELF_CLOSE, CMD_END);
      if (valueExpr == null) {
        valueExpr = errorExpr(tagEnd);
      }
      }
{if ("" != null) return new CallParamValueNode(
          nodeIdGen.genId(),
          createSrcLoc(tagBegin, tagEnd),
          key,
          valueExpr);}
      break;
      }
    case CMD_END:
    case NAME:
    case IDENT:{
      try {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAME:
        case IDENT:{
          attr = Attribute();
          break;
          }
        default:
          jj_la1[54] = jj_gen;
          ;
        }
        tagEnd = jj_consume_token(CMD_END);
      } catch (ParseException e) {
tagEnd = reportTemplateBodyErrorAndSkipTo(e, CMD_END, CMD_SELF_CLOSE);
      }
      templateBlock = TemplateBlock();
      jj_consume_token(CMD_CLOSE_PARAM);
CallParamContentNode node =
          new CallParamContentNode(
              nodeIdGen.genId(),
              createSrcLoc(tagBegin, tagEnd),
              key,
              attr,
              errorReporter);
      node.addChildren(templateBlock);
      {if ("" != null) return node;}
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private LogNode LogStmt() throws ParseException {Token open;
  List<StandaloneNode> templateBlock;
    open = jj_consume_token(CMD_OPEN_LOG);
LogNode logNode = new LogNode(nodeIdGen.genId(), createSrcLoc(open));
    templateBlock = TemplateBlock();
logNode.addChildren(templateBlock);
    jj_consume_token(CMD_CLOSE_LOG);
{if ("" != null) return logNode;}
    throw new Error("Missing return statement in function");
  }

  final private DebuggerNode DebuggerStmt() throws ParseException {Token token;
    token = jj_consume_token(CMD_FULL_DEBUGGER);
{if ("" != null) return new DebuggerNode(nodeIdGen.genId(), createSrcLoc(token));}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ExprInput() throws ParseException {ExprNode expr;
    expr = Expr();
    jj_consume_token(0);
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ImmutableList<ExprNode> ExprList() throws ParseException {ExprNode expr;
  ImmutableList.Builder<ExprNode> exprList = ImmutableList.builder();
    expr = Expr();
exprList.add(expr);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[56] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      expr = Expr();
exprList.add(expr);
    }
{if ("" != null) return exprList.build();}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Expr() throws ParseException {ExprNode expr;
    expr = PrecExpr1();
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr1() throws ParseException {ExprNode expr1, expr2;
  Token op;
ExprNode expr;
    expr = PrecExpr2();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case QMARK:
    case QCOLON:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case QCOLON:{
        op = jj_consume_token(QCOLON);
        expr1 = PrecExpr1();
expr = Operator.NULL_COALESCING.createNode(createSrcLoc(op), expr, expr1);
        break;
        }
      case QMARK:{
        jj_consume_token(QMARK);
        expr1 = PrecExpr1();
        jj_consume_token(COLON);
        expr2 = PrecExpr1();
expr = Operator.CONDITIONAL.createNode(
        expr.getSourceLocation().extend(expr2.getSourceLocation()), expr, expr1, expr2);
        break;
        }
      default:
        jj_la1[57] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[58] = jj_gen;
      ;
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr2() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr3();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[59] = jj_gen;
        break label_19;
      }
      op = jj_consume_token(OR);
      rightHand = PrecExpr3();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        2,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr3() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr4();
    label_20:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[60] = jj_gen;
        break label_20;
      }
      op = jj_consume_token(AND);
      rightHand = PrecExpr4();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        3,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr4() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr5();
    label_21:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_EQ:
      case NOT_EQ:{
        ;
        break;
        }
      default:
        jj_la1[61] = jj_gen;
        break label_21;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOUBLE_EQ:{
        op = jj_consume_token(DOUBLE_EQ);
        break;
        }
      case NOT_EQ:{
        op = jj_consume_token(NOT_EQ);
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr5();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        4,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr5() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr6();
    label_22:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LANGLE:
      case RANGLE:
      case LT_EQ:
      case GT_EQ:{
        ;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        break label_22;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LANGLE:{
        op = jj_consume_token(LANGLE);
        break;
        }
      case RANGLE:{
        op = jj_consume_token(RANGLE);
        break;
        }
      case LT_EQ:{
        op = jj_consume_token(LT_EQ);
        break;
        }
      case GT_EQ:{
        op = jj_consume_token(GT_EQ);
        break;
        }
      default:
        jj_la1[64] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr6();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        5,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr6() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr7();
    label_23:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[65] = jj_gen;
        break label_23;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        op = jj_consume_token(PLUS);
        break;
        }
      case MINUS:{
        op = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr7();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        6,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr7() throws ParseException {ExprNode rightHand;
  Token op;
ExprNode expr;
    expr = PrecExpr8();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:
      case DIV:
      case MOD:{
        ;
        break;
        }
      default:
        jj_la1[67] = jj_gen;
        break label_24;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case TIMES:{
        op = jj_consume_token(TIMES);
        break;
        }
      case DIV:{
        op = jj_consume_token(DIV);
        break;
        }
      case MOD:{
        op = jj_consume_token(MOD);
        break;
        }
      default:
        jj_la1[68] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      rightHand = PrecExpr8();
expr = createOperatorNode(
        createSrcLoc(op),
        op.image,
        7,
        expr,
        rightHand);
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr8() throws ParseException {Token op;
ExprNode expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case LBRACKET:
    case LPAREN:
    case IDENT:
    case IJ:
    case DOLLAR_IDENT:{
      expr = PrecExpr9();
      break;
      }
    case MINUS:
    case NOT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:{
        op = jj_consume_token(NOT);
        break;
        }
      case MINUS:{
        op = jj_consume_token(MINUS);
        break;
        }
      default:
        jj_la1[69] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expr = PrecExpr8();
if (op.kind == MINUS && expr instanceof IntegerNode) {
        SourceLocation newLoc = createSrcLoc(op).extend(expr.getSourceLocation());
        long value = -1 * ((IntegerNode) expr).getValue();
        expr = new IntegerNode(value, newLoc);
      } else if (op.kind == MINUS && expr instanceof FloatNode) {
        SourceLocation newLoc = createSrcLoc(op).extend(expr.getSourceLocation());
        double value = -1 * ((FloatNode) expr).getValue();
        expr = new FloatNode(value, newLoc);
      } else {
        expr = createOperatorNode(
            createSrcLoc(op),
            op.image,
            8,
            expr);
      }
      break;
      }
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode PrecExpr9() throws ParseException {ExprNode expr, keyExpr;
  Token ident, open, close, op;
    expr = Primary();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case QDOT:
      case LBRACKET:
      case QLBRACKET:{
        ;
        break;
        }
      default:
        jj_la1[71] = jj_gen;
        break label_25;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:
      case QDOT:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOT:{
          op = jj_consume_token(DOT);
          break;
          }
        case QDOT:{
          op = jj_consume_token(QDOT);
          break;
          }
        default:
          jj_la1[72] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        ident = jj_consume_token(IDENT);
// TODO(lukes):  add the source location of the ident as a separate field.  This would be
      // more useful for error messages about the access
      expr =
          new FieldAccessNode(
              expr,
              ident.image,
              createSrcLoc(op, ident),
              op.kind == QDOT);
        break;
        }
      case LBRACKET:
      case QLBRACKET:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case LBRACKET:{
          open = jj_consume_token(LBRACKET);
          break;
          }
        case QLBRACKET:{
          open = jj_consume_token(QLBRACKET);
          break;
          }
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        keyExpr = Expr();
        close = jj_consume_token(RBRACKET);
expr =
          new ItemAccessNode(
              expr,
              keyExpr,
              createSrcLoc(open, close),
              open.kind == QLBRACKET);
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode Primary() throws ParseException {ExprNode primary;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      jj_consume_token(LPAREN);
      primary = Expr();
      jj_consume_token(RPAREN);
      break;
      }
    case IJ:{
      primary = IjRef();
      break;
      }
    case DOLLAR_IDENT:{
      primary = VarRef();
      break;
      }
    case IDENT:{
      primary = GlobalOrFunctionCallLike();
      break;
      }
    case LBRACKET:{
      primary = ListLiteral();
      break;
      }
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:{
      primary = Primitive();
      break;
      }
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return primary;}
    throw new Error("Missing return statement in function");
  }

  final private VarRefNode IjRef() throws ParseException {Token ij;
  Token ident;
    ij = jj_consume_token(IJ);
    try {
      jj_consume_token(DOT);
      ident = jj_consume_token(IDENT);
{if ("" != null) return new VarRefNode(ident.image, createSrcLoc(ij, ident), true, null);}
    } catch (ParseException e) {
SourceLocation loc = createSrcLoc(ij);
    errorReporter.report(loc, INVALID_VAR_NAME_IJ);
    {if ("" != null) return new VarRefNode("ij", loc, false, null);}
    }
    throw new Error("Missing return statement in function");
  }

  final private VarRefNode VarRef() throws ParseException {Token ident;
    ident = jj_consume_token(DOLLAR_IDENT);
{if ("" != null) return new VarRefNode(ident.image.substring(1), createSrcLoc(ident), false, null);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode GlobalOrFunctionCallLike() throws ParseException {Identifier ident;
  Token openParen = null, closeParen = null, paramName;
  ExprNode key, val;
  List<ExprNode> params = new ArrayList<ExprNode>();
  Set<String> paramNames;
  List<Identifier> paramIds;
    ident = Identifier();
boolean isRecord = "record".equals(ident.identifier());
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LPAREN:{
      openParen = jj_consume_token(LPAREN);
      if (ident.identifier().equals("map")) {
{if ("" != null) return MapLiteral(ident);}
      } else if (ident.identifier().equals("ve")) {
{if ("" != null) return VeLiteral(ident);}
      } else {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NULL:
        case TRUE:
        case FALSE:
        case DEC_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case SINGLE_QUOTE:
        case DOUBLE_QUOTE:
        case MINUS:
        case NOT:
        case LBRACKET:
        case LPAREN:
        case IDENT:
        case IJ:
        case DOLLAR_IDENT:{
          // this can be any expr, for a function call; for proto init or record literal, must be a
                  // single-ident global
                  key = Expr();
          if (isRecord || getToken(1).kind == COLON) {
            jj_consume_token(COLON);
            val = Expr();
if (!(key instanceof GlobalNode)
                || !BaseUtils.isIdentifier(((GlobalNode) key).getName())) {
              errorReporter.report(
                  key.getSourceLocation(),
                  INVALID_KEY_NAME,
                  isRecord ? "record key name" : "param name",
                  key.toSourceString(),
                  isRecord
                      ? " A record key must be a valid Soy identifier. Did you mean to use a map?"
                      : "");
              key = GlobalNode.error(key.getSourceLocation());
            }

            paramNames = new HashSet<String>();
            paramIds = new ArrayList<Identifier>();

            paramNames.add(((GlobalNode) key).getName());
            paramIds.add(
                Identifier.create(((GlobalNode) key).getName(), key.getSourceLocation()));
            params.add(val);
            label_26:
            while (true) {
              if (getToken(1).kind == COMMA && getToken(2).kind != RPAREN) {
                ;
              } else {
                break label_26;
              }
              jj_consume_token(COMMA);
              paramName = jj_consume_token(IDENT);
if (!paramNames.add(paramName.image)) {
                errorReporter.report(
                    createSrcLoc(paramName),
                    DUPLICATE_KEY_NAME,
                    isRecord ? "record key" : "param name",
                    paramName.image);
              } else {
                paramIds.add(Identifier.create(paramName.image, createSrcLoc(paramName)));
              }
              jj_consume_token(COLON);
              val = Expr();
params.add(val);
            }
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:{
              jj_consume_token(COMMA);
              break;
              }
            default:
              jj_la1[76] = jj_gen;
              ;
            }
            // trailing comma
            
                      closeParen = jj_consume_token(RPAREN);
AbstractParentExprNode node;
            SourceLocation loc = ident.location().extend(createSrcLoc(closeParen));
            if (isRecord) {
              node = new RecordLiteralNode(ident, paramIds, loc);
            } else {
              // TODO(user): Also add type, then remove code from RETV
              node = new ProtoInitNode(
                  headerInfo.resolveAlias(ident.identifier()), paramIds, loc);
            }
            node.addChildren(params);
            {if ("" != null) return node;}
          } else {
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case COMMA:
            case RPAREN:{
params.add(key);
              label_27:
              while (true) {
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case COMMA:{
                  ;
                  break;
                  }
                default:
                  jj_la1[77] = jj_gen;
                  break label_27;
                }
                jj_consume_token(COMMA);
                val = Expr();
params.add(val);
              }
              closeParen = jj_consume_token(RPAREN);
SourceLocation loc = ident.location().extend(createSrcLoc(closeParen));
            FunctionNode fnNode = new FunctionNode(ident, loc);
            fnNode.addChildren(params);
            {if ("" != null) return fnNode;}
              break;
              }
            default:
              jj_la1[78] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          break;
          }
        default:
          jj_la1[79] = jj_gen;
          ;
        }
      }
      closeParen = jj_consume_token(RPAREN);
      break;
      }
    default:
      jj_la1[80] = jj_gen;
      ;
    }
// If we did not find parens, this is a global node
    if (openParen == null) {
      {if ("" != null) return new GlobalNode(headerInfo.resolveAlias(ident.identifier()), ident.location());}
    }

    // Check if this is a record. If not, look up ident in the type registry to see if it's a proto.
    // Otherwise, it is a function.
    SourceLocation loc = ident.location().extend(createSrcLoc(closeParen));
    if (isRecord) {
      {if ("" != null) return new RecordLiteralNode(ident, ImmutableList.of(), loc);}
    }
    {if ("" != null) return new FunctionNode(ident, loc);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode MapLiteral(Identifier ident) throws ParseException {ExprNode key, val;
  Token closeParen;
  ImmutableMap.Builder<ExprNode, ExprNode> kvPairs = ImmutableMap.builder();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case MINUS:
    case NOT:
    case LBRACKET:
    case LPAREN:
    case IDENT:
    case IJ:
    case DOLLAR_IDENT:{
      key = Expr();
      jj_consume_token(COLON);
      val = Expr();
kvPairs.put(key, val);
      label_28:
      while (true) {
        if (getToken(1).kind == COMMA && getToken(2).kind != RPAREN) {
          ;
        } else {
          break label_28;
        }
        jj_consume_token(COMMA);
        key = Expr();
        jj_consume_token(COLON);
        val = Expr();
kvPairs.put(key, val);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      ;
    }
    closeParen = jj_consume_token(RPAREN);
// Note: the case where there are no keys or values is ambiguous.
    // It could be a 0-arg function call to a function called "map".
    // (Function calls and map literals are usually distinguished by their parameter syntax
    // (positional vs. named), but that's not helpful when there are no params.)
    SourceLocation srcLoc = ident.location().extend(createSrcLoc(closeParen));
    {if ("" != null) return new MapLiteralNode(ident, kvPairs.build(), srcLoc);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode VeLiteral(Identifier ident) throws ParseException {Identifier name;
  Token closeParen;
    name = Identifier();
    closeParen = jj_consume_token(RPAREN);
SourceLocation srcLoc = ident.location().extend(createSrcLoc(closeParen));
    {if ("" != null) return new VeLiteralNode(ident, name, srcLoc);}
    throw new Error("Missing return statement in function");
  }

  final private ExprNode ListLiteral() throws ParseException {Token begin, end;
  ExprNode itemExpr;
  List<ExprNode> items = ImmutableList.of();
    begin = jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case RBRACKET:{
      // empty list
          end = jj_consume_token(RBRACKET);
{if ("" != null) return new ListLiteralNode(items, createSrcLoc(begin, end));}
      break;
      }
    case NULL:
    case TRUE:
    case FALSE:
    case DEC_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:
    case MINUS:
    case NOT:
    case LBRACKET:
    case LPAREN:
    case IDENT:
    case IJ:
    case DOLLAR_IDENT:{
      // The first item of a non-empty list will be an expression
          itemExpr = Expr();
items = new ArrayList<ExprNode>();
      items.add(itemExpr);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        // If there's a colon here, this could be an attempt at the old legacy_object_map or record
              // literal syntax, so report a custom error.
              // TODO(b/80429224): Remove this custom error message after 8 June 2019.
              end = jj_consume_token(COLON);
errorReporter.report(createSrcLoc(end), OLD_RECORD_LITERAL_SYNTAX);
        skipToTemplateToken();
        break;
        }
      default:
        jj_la1[84] = jj_gen;
        label_29:
        while (true) {
          if (getToken(1).kind == COMMA && getToken(2).kind != RBRACKET) {
            ;
          } else {
            break label_29;
          }
          jj_consume_token(COMMA);
          itemExpr = Expr();
items.add(itemExpr);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[83] = jj_gen;
          ;
        }
      }
      end = jj_consume_token(RBRACKET);
{if ("" != null) return new ListLiteralNode(items, createSrcLoc(begin, end));}
      break;
      }
    default:
      jj_la1[85] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final private PrimitiveNode Primitive() throws ParseException {Token tok;
  PrimitiveNode primitive;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NULL:{
      tok = jj_consume_token(NULL);
primitive = new NullNode(createSrcLoc(tok));
      break;
      }
    case TRUE:{
      tok = jj_consume_token(TRUE);
primitive = new BooleanNode(true, createSrcLoc(tok));
      break;
      }
    case FALSE:{
      tok = jj_consume_token(FALSE);
primitive = new BooleanNode(false, createSrcLoc(tok));
      break;
      }
    case DEC_INTEGER:{
      tok = jj_consume_token(DEC_INTEGER);
SourceLocation loc = createSrcLoc(tok);
      Long parsed = Longs.tryParse(tok.image, 10);
      if (parsed == null || !IntegerNode.isInRange(parsed)) {
        errorReporter.report(loc, INTEGER_OUT_OF_RANGE);
        parsed = 0L;
      }
      primitive = new IntegerNode(parsed, loc);
      break;
      }
    case HEX_INTEGER:{
      tok = jj_consume_token(HEX_INTEGER);
SourceLocation loc = createSrcLoc(tok);
      Long parsed = Longs.tryParse(tok.image.substring(2), 16);
      if (parsed == null || !IntegerNode.isInRange(parsed)) {
        errorReporter.report(loc, INTEGER_OUT_OF_RANGE);
        parsed = 0L;
      }
      primitive = new IntegerNode(parsed, loc);
      break;
      }
    case FLOAT:{
      tok = jj_consume_token(FLOAT);
primitive = new FloatNode(Double.parseDouble(tok.image), createSrcLoc(tok));
      break;
      }
    case SINGLE_QUOTE:
    case DOUBLE_QUOTE:{
      primitive = StringLiteral();
      break;
      }
    default:
      jj_la1[86] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return primitive;}
    throw new Error("Missing return statement in function");
  }

  final private StringNode StringLiteral() throws ParseException {Token quote, value;
  QuoteStyle quoteStyle;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SINGLE_QUOTE:{
      quote = jj_consume_token(SINGLE_QUOTE);
token_source.pushState(IN_SQ_STRING);
      value = jj_consume_token(SQ_STRING);
quoteStyle = QuoteStyle.SINGLE;
      break;
      }
    case DOUBLE_QUOTE:{
      quote = jj_consume_token(DOUBLE_QUOTE);
token_source.pushState(IN_DQ_STRING);
      value = jj_consume_token(DQ_STRING);
quoteStyle = QuoteStyle.DOUBLE;
      break;
      }
    default:
      jj_la1[87] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
SourceLocation loc = createSrcLoc(quote, value);
    // strip the final character which is the closing quotation mark.
    String rawString = value.image.substring(0, value.image.length() - 1);
    String unescaped = SoyParseUtils.unescapeString(rawString, errorReporter, loc);
    {if ("" != null) return new StringNode(unescaped, quoteStyle, loc);}
    throw new Error("Missing return statement in function");
  }

  final private Identifier Identifier() throws ParseException {Token first, next = null;
  StringBuilder sb = null;  // lazily allocated

    first = jj_consume_token(IDENT);
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[88] = jj_gen;
        break label_30;
      }
      jj_consume_token(DOT);
      next = jj_consume_token(IDENT);
if (sb == null) {
        sb = new StringBuilder();
        sb.append(first.image);
      }
      sb.append('.').append(next.image);
    }
{if ("" != null) return sb == null
      ? Identifier.create(first.image, createSrcLoc(first))
      : Identifier.create(sb.toString(), createSrcLoc(first, next));}
    throw new Error("Missing return statement in function");
  }

  final private Token Keyword(String keyword) throws ParseException {Token ident;
    ident = jj_consume_token(IDENT);
if (!ident.image.equals(keyword)) {
      {if (true) throw generateParseException();}
    }
    {if ("" != null) return ident;}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode TypeExpr() throws ParseException {TypeNode first;
  TypeNode next;
  // lazily allocate the list since most of the time this isn't actually a Union
  List<TypeNode> members = null;
    first = PrimaryType();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case VBAR:{
        ;
        break;
        }
      default:
        jj_la1[89] = jj_gen;
        break label_31;
      }
      jj_consume_token(VBAR);
      next = PrimaryType();
if (members == null) {
        members = new ArrayList<TypeNode>();
        members.add(first);
      }
      members.add(next);
    }
{if ("" != null) return members == null ? first : UnionTypeNode.create(members);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode PrimaryType() throws ParseException {TypeNode type;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      type = NamedType();
      break;
      }
    case NULL:{
      type = NullType();
      break;
      }
    case QMARK:{
      type = UnknownType();
      break;
      }
    case LBRACKET:{
      type = RecordType();
      break;
      }
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return type;}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode RecordType() throws ParseException {List<RecordTypeNode.Property> properties = ImmutableList.of();
  Token open, close;
  RecordTypeNode.Property prop;
    open = jj_consume_token(LBRACKET);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IDENT:{
      prop = RecordField();
properties = new ArrayList<RecordTypeNode.Property>();
      properties.add(prop);
      label_32:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          ;
          break;
          }
        default:
          jj_la1[91] = jj_gen;
          break label_32;
        }
        jj_consume_token(COMMA);
        prop = RecordField();
properties.add(prop);
      }
      break;
      }
    default:
      jj_la1[92] = jj_gen;
      ;
    }
    close = jj_consume_token(RBRACKET);
{if ("" != null) return RecordTypeNode.create(createSrcLoc(open, close), properties);}
    throw new Error("Missing return statement in function");
  }

  final private RecordTypeNode.Property RecordField() throws ParseException {Token fieldName;
  TypeNode fieldType;
    fieldName = jj_consume_token(IDENT);
    jj_consume_token(COLON);
    fieldType = TypeExpr();
{if ("" != null) return RecordTypeNode.Property.create(createSrcLoc(fieldName), fieldName.image, fieldType);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode NullType() throws ParseException {Token tok;
    tok = jj_consume_token(NULL);
{if ("" != null) return NamedTypeNode.create(createSrcLoc(tok), tok.image);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode NamedType() throws ParseException {Token open, close;
  Identifier identifier;
  SourceLocation fullLocation;

  TypeNode arg;
  List<TypeNode> genericArgs = ImmutableList.of();
    identifier = Identifier();
// TODO(lukes): we support aliasing list and map.... but why...?
    identifier = Identifier.create(
        headerInfo.resolveAlias(identifier.identifier()),
        identifier.location());
    fullLocation = identifier.location();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case LANGLE:{
      open = jj_consume_token(LANGLE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NULL:
      case QMARK:
      case LBRACKET:
      case IDENT:{
        arg = TypeExpr();
genericArgs = new ArrayList<TypeNode>();
        genericArgs.add(arg);
        label_33:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            ;
            break;
            }
          default:
            jj_la1[93] = jj_gen;
            break label_33;
          }
          jj_consume_token(COMMA);
          arg = TypeExpr();
genericArgs.add(arg);
        }
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      close = jj_consume_token(RANGLE);
{if ("" != null) return GenericTypeNode.create(
          fullLocation.extend(createSrcLoc(close)),
          identifier,
          genericArgs);}
      break;
      }
    default:
      jj_la1[95] = jj_gen;
      ;
    }
{if ("" != null) return NamedTypeNode.create(identifier);}
    throw new Error("Missing return statement in function");
  }

  final private TypeNode UnknownType() throws ParseException {Token tok;
    tok = jj_consume_token(QMARK);
{if ("" != null) return NamedTypeNode.create(createSrcLoc(tok), "?");}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public SoyFileParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[96];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x1000,0x400,0x3800000,0x0,0x0,0x0,0x0,0x0,0x6000,0x6000,0x6000,0x3800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x0,0xe0000000,0xe0000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7f8,0xff8,0xff8,0x3,0x0,0x3,0x3,0x0,0x0,0x28e43ff8,0x28e43ff8,0x28e43000,0x8000000,0x643000,0x20800000,0x80000,0x0,0x0,0xa8e43ff8,0x80000000,0xa8e43ff8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x2000000,0x0,0x0,0x0,0x0,0x0,0x3000,0x10000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x100000,0x100000,0xe0000000,0xe0000000,0x0,0x0,0x0,0x0,0x1100000,0x1000000,0x8000000,0x18000000,0x0,0x18000000,0x18000000,0x8000000,0x8000000,0x8000000,0x0,0x0,0x600000,0x1801f488,0x1801f488,0x1f488,0x19400,0x6000,0x88,0x0,0x8000000,0x8000000,0x1801f48a,0x2,0x1801f48a,0x100000,0x20,0x20,0x6000,0x0,0x0,0x100000,0x140000,0x0,0x0,0x20,0x40,0x100,0xc0000,0xc0000,0x0,0x0,0x100000,0x140000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe0000000,0x0,0x0,0x0,0x0,0xe0000000,0x0,0x0,0x0,0xe0000000,0x0,0x0,0xe0000000,0x0,0x0,0xe0000000,0xe0000000,0x0,0x0,0x0,0x20000000,0x0,0x0,0x0,0x20000000,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x9100001f,0x9100001f,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x5000,0x5000,0x8000,0x10000,0x60000,0x60000,0x780000,0x780000,0x1800000,0x1800000,0xe000000,0xe000000,0x11000000,0x9100001f,0xe0000000,0x60000000,0x80000000,0xe0000000,0x8000001f,0x0,0x0,0x0,0x9100001f,0x0,0x0,0x9100001f,0x0,0x2000,0x9100001f,0x1f,0x18,0x20000000,0x0,0x80001000,0x0,0x0,0x0,0x80001000,0x80000,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x0,0x0,0x0,0x80,0x80,0x80,0x388,0x388,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x0,0x0,0x0,0x20,0x0,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80,0x80,0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x388,0x2,0x0,0x2,0x2,0x388,0x4,0x4,0x14,0x388,0x8,0x4,0x388,0x4,0x0,0x389,0x0,0x0,0x0,0x20,0x80,0x4,0x80,0x4,0x80,0x0,};
   }

  /** Constructor with InputStream. */
  public SoyFileParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public SoyFileParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public SoyFileParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new SoyFileParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
      jj_input_stream = new SimpleCharStream(stream, 1, 1);
   } else {
      jj_input_stream.ReInit(stream, 1, 1);
   }
   if (token_source == null) {
      token_source = new SoyFileParserTokenManager(jj_input_stream);
   }

    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public SoyFileParser(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(SoyFileParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 96; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk_f() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[155];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 96; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 155; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
