/*
 * Copyright 2012 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.template.soy.i18ndirectives;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyPrintDirective;

/** Lists all i18n directives. */
public final class I18nDirectives {
  private I18nDirectives() {}

  public static ImmutableSet<SoyPrintDirective> directives(Supplier<String> localeProvider) {
    return ImmutableSet.of(new FormatNumDirective(localeProvider));
  }
}
