/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.FieldVisitor;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SanitizedType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.StringType;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public final class SoyProtoType
implements SoyType {
    private final Descriptors.Descriptor typeDescriptor;
    private final ImmutableMap<String, FieldWithType> fields;

    public SoyProtoType(final SoyTypeRegistry typeRegistry, Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions) {
        this.typeDescriptor = descriptor;
        this.fields = Field.getFieldsForType(descriptor, extensions, new Field.Factory<FieldWithType>(){
            TypeVisitor visitor;
            {
                this.visitor = new TypeVisitor(typeRegistry);
            }

            @Override
            public FieldWithType create(Descriptors.FieldDescriptor fieldDescriptor) {
                return new NormalFieldWithType(fieldDescriptor, this.visitor);
            }

            @Override
            public FieldWithType createAmbiguousFieldSet(Set<FieldWithType> fields) {
                return new AmbiguousFieldWithType(fields);
            }
        });
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.PROTO;
    }

    @Override
    public boolean isAssignableFrom(SoyType fromType) {
        return fromType == this;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    public String getDescriptorExpression() {
        Descriptors.Descriptor descriptor = this.typeDescriptor;
        while (descriptor.getContainingType() != null) {
            descriptor = descriptor.getContainingType();
        }
        return JavaQualifiedNames.getQualifiedName(descriptor) + ".getDescriptor()";
    }

    public Descriptors.FieldDescriptor getFieldDescriptor(String fieldName) {
        return ((FieldWithType)this.fields.get((Object)fieldName)).getDescriptor();
    }

    @Nullable
    public SoyType getFieldType(String fieldName) {
        FieldWithType field = (FieldWithType)this.fields.get((Object)fieldName);
        return field != null ? field.getType() : null;
    }

    public ImmutableSet<String> getFieldNames() {
        return this.fields.keySet();
    }

    public String getNameForBackend(SoyBackendKind backend) {
        switch (backend) {
            case JS_SRC: {
                return ProtoUtils.calculateQualifiedJsName((Descriptors.GenericDescriptor)this.typeDescriptor);
            }
            case TOFU: 
            case JBC_SRC: {
                return JavaQualifiedNames.getClassName(this.typeDescriptor);
            }
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.typeDescriptor.getFullName();
    }

    public boolean shouldCheckFieldPresenceToEmulateJspbNullability(String fieldName) {
        return ((FieldWithType)this.fields.get((Object)fieldName)).shouldCheckFieldPresenceToEmulateJspbNullability();
    }

    private static final class AmbiguousFieldWithType
    extends FieldWithType {
        final Set<FieldWithType> fields;

        AmbiguousFieldWithType(Set<FieldWithType> fields) {
            super(fields.iterator().next().getDescriptor());
            this.fields = fields;
        }

        @Override
        SoyType getType() {
            throw AmbiguousFieldWithType.ambiguousFieldsError(this.getName(), this.fields);
        }
    }

    private static final class NormalFieldWithType
    extends FieldWithType {
        @GuardedBy(value="this")
        SoyType type;
        @GuardedBy(value="this")
        TypeVisitor visitor;

        NormalFieldWithType(Descriptors.FieldDescriptor fieldDesc, TypeVisitor visitor) {
            super(fieldDesc);
            this.visitor = visitor;
        }

        @Override
        synchronized SoyType getType() {
            if (this.type == null) {
                this.type = FieldVisitor.visitField(this.getDescriptor(), this.visitor);
                this.visitor = null;
            }
            return this.type;
        }
    }

    private static abstract class FieldWithType
    extends Field {
        FieldWithType(Descriptors.FieldDescriptor fieldDesc) {
            super(fieldDesc);
        }

        abstract SoyType getType();
    }

    private static final class TypeVisitor
    extends FieldVisitor<SoyType> {
        private final SoyTypeRegistry registry;

        TypeVisitor(SoyTypeRegistry registry) {
            this.registry = registry;
        }

        @Override
        protected SoyType visitMap(Descriptors.FieldDescriptor mapField, SoyType keyType, SoyType valueType) {
            return this.registry.getOrCreateMapType(keyType, valueType);
        }

        @Override
        protected SoyType visitJspbMap(Descriptors.FieldDescriptor field, SoyType valueType) {
            return this.registry.getOrCreateLegacyObjectMapType(StringType.getInstance(), valueType);
        }

        @Override
        protected SoyType visitRepeated(SoyType value) {
            return this.registry.getOrCreateListType(value);
        }

        @Override
        protected SoyType visitMessage(Descriptors.Descriptor messageType) {
            return this.registry.getType(messageType.getFullName());
        }

        @Override
        protected SoyType visitEnum(Descriptors.EnumDescriptor enumType) {
            return this.registry.getType(enumType.getFullName());
        }

        @Override
        protected SoyType visitLongAsInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitUnsignedLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitLongAsString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitBool() {
            return BoolType.getInstance();
        }

        @Override
        protected SoyType visitInt() {
            return IntType.getInstance();
        }

        @Override
        protected SoyType visitBytes() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitString() {
            return StringType.getInstance();
        }

        @Override
        protected SoyType visitDoubleAsFloat() {
            return FloatType.getInstance();
        }

        @Override
        protected SoyType visitFloat() {
            return FloatType.getInstance();
        }

        @Override
        protected SoyType visitSafeHtml() {
            return SanitizedType.HtmlType.getInstance();
        }

        @Override
        protected SoyType visitSafeScript() {
            return SanitizedType.JsType.getInstance();
        }

        @Override
        protected SoyType visitSafeStyle() {
            return SanitizedType.CssType.getInstance();
        }

        @Override
        protected SoyType visitSafeStyleSheet() {
            return SanitizedType.CssType.getInstance();
        }

        @Override
        protected SoyType visitSafeUrl() {
            return SanitizedType.UriType.getInstance();
        }

        @Override
        protected SoyType visitTrustedResourceUrl() {
            return SanitizedType.TrustedResourceUriType.getInstance();
        }
    }
}

