/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.tofu.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.sharedpasses.render.EvalVisitorFactoryImpl;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitor;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuException;
import com.google.template.soy.tofu.internal.NamespacedTofu;
import java.util.Map;
import javax.annotation.Nullable;

public final class BaseTofu
implements SoyTofu {
    private final GuiceSimpleScope apiCallScope;
    private final TemplateRegistry templateRegistry;
    private final ImmutableMap<String, ImmutableSortedSet<String>> templateToIjParamsInfoMap;

    public BaseTofu(GuiceSimpleScope apiCallScope, TemplateRegistry templates, ImmutableMap<String, ImmutableSortedSet<String>> templateToIjParamsInfoMap) {
        this.apiCallScope = apiCallScope;
        this.templateRegistry = templates;
        this.templateToIjParamsInfoMap = templateToIjParamsInfoMap;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public SoyTofu forNamespace(@Nullable String namespace) {
        return namespace == null ? this : new NamespacedTofu(this, namespace);
    }

    @Override
    public SoyTofu.Renderer newRenderer(SoyTemplateInfo templateInfo) {
        return new RendererImpl(this, templateInfo.getName());
    }

    @Override
    public SoyTofu.Renderer newRenderer(String templateName) {
        return new RendererImpl(this, templateName);
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(SoyTemplateInfo templateInfo) {
        return this.getUsedIjParamsForTemplate(templateInfo.getName());
    }

    @Override
    public ImmutableSortedSet<String> getUsedIjParamsForTemplate(String templateName) {
        ImmutableSortedSet ijParams = (ImmutableSortedSet)this.templateToIjParamsInfoMap.get((Object)templateName);
        if (ijParams == null) {
            throw new SoyTofuException("Template '" + templateName + "' not found.");
        }
        return ijParams;
    }

    private TemplateNode renderMain(Appendable outputBuf, String templateName, @Nullable SoyRecord data, @Nullable SoyRecord ijData, @Nullable Predicate<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap idRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo) {
        if (activeDelPackageNames == null) {
            activeDelPackageNames = Predicates.alwaysFalse();
        }
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            ApiCallScopeUtils.seedSharedParams(inScope, msgBundle);
            TemplateNode templateNode = this.renderMainHelper(this.templateRegistry, outputBuf, templateName, data, ijData, (Predicate<String>)activeDelPackageNames, msgBundle, idRenamingMap, cssRenamingMap, debugSoyTemplateInfo);
            return templateNode;
        }
    }

    private TemplateNode renderMainHelper(TemplateRegistry templateRegistry, Appendable outputBuf, String templateName, @Nullable SoyRecord data, @Nullable SoyRecord ijData, Predicate<String> activeDelPackageNames, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap idRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo) {
        TemplateBasicNode template = templateRegistry.getBasicTemplate(templateName);
        if (template == null) {
            throw new SoyTofuException("Attempting to render undefined template '" + templateName + "'.");
        }
        if (template.getVisibility() == Visibility.PRIVATE) {
            throw new SoyTofuException("Attempting to render private template '" + templateName + "'.");
        }
        if (data == null) {
            data = SoyValueConverter.EMPTY_DICT;
        }
        if (ijData == null) {
            ijData = SoyValueConverter.EMPTY_DICT;
        }
        try {
            RenderVisitor rv = new RenderVisitor(new EvalVisitorFactoryImpl(), outputBuf, templateRegistry, data, ijData, activeDelPackageNames, msgBundle, idRenamingMap, cssRenamingMap, debugSoyTemplateInfo);
            rv.exec(template);
        }
        catch (RenderException re) {
            throw new SoyTofuException(re);
        }
        return template;
    }

    @Override
    @Deprecated
    public String render(SoyTemplateInfo templateInfo, @Nullable SoyRecord data, @Nullable SoyMsgBundle msgBundle) {
        return new RendererImpl(this, templateInfo.getName()).setData(data).setMsgBundle(msgBundle).render();
    }

    @Override
    @Deprecated
    public String render(String templateName, @Nullable Map<String, ?> data, @Nullable SoyMsgBundle msgBundle) {
        return new RendererImpl(this, templateName).setData(data).setMsgBundle(msgBundle).render();
    }

    @Override
    @Deprecated
    public String render(String templateName, @Nullable SoyRecord data, @Nullable SoyMsgBundle msgBundle) {
        return new RendererImpl(this, templateName).setData(data).setMsgBundle(msgBundle).render();
    }

    private static class RendererImpl
    implements SoyTofu.Renderer {
        private final BaseTofu baseTofu;
        private final String templateName;
        private SoyRecord data;
        private SoyRecord ijData;
        private SoyMsgBundle msgBundle;
        private SoyIdRenamingMap idRenamingMap;
        private SoyCssRenamingMap cssRenamingMap;
        private Predicate<String> activeDelPackageNames;
        private SanitizedContent.ContentKind expectedContentKind;
        private boolean contentKindExplicitlySet;
        private boolean debugSoyTemplateInfo;

        public RendererImpl(BaseTofu baseTofu, String templateName) {
            this.baseTofu = baseTofu;
            this.templateName = templateName;
            this.expectedContentKind = SanitizedContent.ContentKind.HTML;
        }

        @Override
        public SoyTofu.Renderer setData(Map<String, ?> data) {
            this.data = data == null ? null : SoyValueConverter.INSTANCE.newDictFromMap(data);
            return this;
        }

        @Override
        public SoyTofu.Renderer setData(SoyRecord data) {
            this.data = data;
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(Map<String, ?> ijData) {
            this.ijData = ijData == null ? null : SoyValueConverter.INSTANCE.newDictFromMap(ijData);
            return this;
        }

        @Override
        public SoyTofu.Renderer setIjData(SoyRecord ijData) {
            this.ijData = ijData;
            return this;
        }

        @Override
        public SoyTofu.Renderer setActiveDelegatePackageSelector(Predicate<String> activeDelegatePackageNames) {
            this.activeDelPackageNames = activeDelegatePackageNames;
            return this;
        }

        @Override
        public SoyTofu.Renderer setMsgBundle(SoyMsgBundle msgBundle) {
            this.msgBundle = msgBundle;
            return this;
        }

        @Override
        public SoyTofu.Renderer setIdRenamingMap(SoyIdRenamingMap idRenamingMap) {
            this.idRenamingMap = idRenamingMap;
            return this;
        }

        @Override
        public SoyTofu.Renderer setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.cssRenamingMap = cssRenamingMap;
            return this;
        }

        @Override
        public SoyTofu.Renderer setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.debugSoyTemplateInfo = debugSoyTemplateInfo;
            return this;
        }

        @Override
        public SoyTofu.Renderer setContentKind(SanitizedContent.ContentKind contentKind) {
            this.expectedContentKind = (SanitizedContent.ContentKind)((Object)Preconditions.checkNotNull((Object)((Object)contentKind)));
            this.contentKindExplicitlySet = true;
            return this;
        }

        @Override
        public String render() {
            StringBuilder sb = new StringBuilder();
            this.render(sb);
            return sb.toString();
        }

        @Override
        public SanitizedContent.ContentKind render(Appendable out) {
            TemplateNode template = this.baseTofu.renderMain(out, this.templateName, this.data, this.ijData, (Predicate<String>)this.activeDelPackageNames, this.msgBundle, this.idRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo);
            if (this.contentKindExplicitlySet || template.getContentKind() != null) {
                this.enforceContentKind(template);
            }
            return template.getContentKind() != null ? SanitizedContent.ContentKind.valueOf(template.getContentKind().name()) : null;
        }

        @Override
        public SanitizedContent renderStrict() {
            StringBuilder sb = new StringBuilder();
            TemplateNode template = this.baseTofu.renderMain(sb, this.templateName, this.data, this.ijData, (Predicate<String>)this.activeDelPackageNames, this.msgBundle, this.idRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo);
            this.enforceContentKind(template);
            return UnsafeSanitizedContentOrdainer.ordainAsSafe(sb.toString(), this.expectedContentKind);
        }

        private void enforceContentKind(TemplateNode template) {
            if (this.expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (template.getContentKind() == null) {
                throw new SoyTofuException("Expected template to be autoescape=\"strict\" but was autoescape=\"" + template.getAutoescapeMode().getAttributeValue() + "\": " + template.getTemplateName());
            }
            SanitizedContentKind expectedAsSanitizedContentKind = SanitizedContentKind.valueOf(this.expectedContentKind.name());
            if (expectedAsSanitizedContentKind != template.getContentKind()) {
                throw new SoyTofuException("Expected template to be kind=\"" + expectedAsSanitizedContentKind.asAttributeValue() + "\" but was kind=\"" + template.getContentKind().asAttributeValue() + "\": " + template.getTemplateName());
            }
        }
    }
}

