/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.AutoValue_TemplateDelegateNode_DelTemplateKey;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import javax.annotation.Nullable;

public final class TemplateDelegateNode
extends TemplateNode
implements SoyNode.ExprHolderNode {
    private final String delTemplateName;
    @Nullable
    private final ExprRootNode delTemplateVariantExpr;
    private DelTemplateKey delTemplateKey;
    private final TemplateNode.Priority delPriority;

    TemplateDelegateNode(TemplateDelegateNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, @Nullable ExprRootNode delTemplateVariantExpr, TemplateNode.Priority delPriority, ImmutableList<TemplateParam> params) {
        super(nodeBuilder, "deltemplate", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.delTemplateName = (String)Preconditions.checkNotNull((Object)delTemplateName);
        this.delTemplateVariantExpr = delTemplateVariantExpr;
        this.delPriority = (TemplateNode.Priority)((Object)Preconditions.checkNotNull((Object)((Object)delPriority)));
    }

    private TemplateDelegateNode(TemplateDelegateNode orig, CopyState copyState) {
        super(orig, copyState);
        this.delTemplateName = orig.delTemplateName;
        this.delTemplateVariantExpr = orig.delTemplateVariantExpr == null ? null : orig.delTemplateVariantExpr.copy(copyState);
        this.delTemplateKey = orig.delTemplateKey;
        this.delPriority = orig.delPriority;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    @Override
    public String getTemplateNameForUserMsgs() {
        return this.getDelTemplateKey().toString();
    }

    public String getDelTemplateVariant() {
        return this.getDelTemplateKey().variant();
    }

    @VisibleForTesting
    DelTemplateKey getDelTemplateKey() {
        if (this.delTemplateKey != null) {
            return this.delTemplateKey;
        }
        return this.resolveVariantExpression();
    }

    public TemplateNode.Priority getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode copy(CopyState copyState) {
        return new TemplateDelegateNode(this, copyState);
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.delTemplateVariantExpr == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)this.delTemplateVariantExpr);
    }

    private DelTemplateKey resolveVariantExpression() {
        if (this.delTemplateVariantExpr == null) {
            this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, "");
            return this.delTemplateKey;
        }
        ExprNode exprNode = this.delTemplateVariantExpr.getRoot();
        if (exprNode instanceof GlobalNode) {
            GlobalNode globalNode = (GlobalNode)exprNode;
            if (globalNode.isResolved()) {
                exprNode = globalNode.getValue();
            } else {
                return DelTemplateKey.create(this.delTemplateName, globalNode.getName());
            }
        }
        if (exprNode instanceof IntegerNode) {
            long variantValue = ((IntegerNode)exprNode).getValue();
            this.delTemplateKey = DelTemplateKey.create(this.delTemplateName, String.valueOf(variantValue));
        } else {
            this.delTemplateKey = exprNode instanceof StringNode ? DelTemplateKey.create(this.delTemplateName, ((StringNode)exprNode).getValue()) : DelTemplateKey.create(this.delTemplateName, exprNode.toSourceString());
        }
        return this.delTemplateKey;
    }

    public static abstract class DelTemplateKey {
        public static DelTemplateKey create(String name, String variant) {
            return new AutoValue_TemplateDelegateNode_DelTemplateKey(name, variant);
        }

        DelTemplateKey() {
        }

        public abstract String name();

        public abstract String variant();

        public String toString() {
            return this.name() + (this.variant().isEmpty() ? "" : ":" + this.variant());
        }
    }
}

