/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class MsgSelectNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    public static final String FALLBACK_BASE_SELECT_VAR_NAME = "STATUS";
    private final ExprRootNode selectExpr;
    @Nullable
    private final String baseSelectVarName;

    public MsgSelectNode(int id, SourceLocation location, ExprNode selectExpr) {
        super(id, location, "select");
        this.selectExpr = new ExprRootNode(selectExpr);
        this.baseSelectVarName = null;
    }

    public MsgSelectNode(int id, SourceLocation sourceLocation, ExprRootNode selectExpr, @Nullable String baseSelectVarName) {
        super(id, sourceLocation, "select");
        this.selectExpr = selectExpr;
        this.baseSelectVarName = baseSelectVarName;
    }

    private MsgSelectNode(MsgSelectNode orig, CopyState copyState) {
        super(orig, copyState);
        this.selectExpr = orig.selectExpr.copy(copyState);
        this.baseSelectVarName = orig.baseSelectVarName;
        copyState.updateRefs(orig, this);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_SELECT_NODE;
    }

    public ExprRootNode getExpr() {
        return this.selectExpr;
    }

    @Override
    public String getBaseVarName() {
        return this.baseSelectVarName != null ? this.baseSelectVarName : MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(this.selectExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME);
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other) {
        if (!(other instanceof MsgSelectNode)) {
            return false;
        }
        MsgSelectNode that = (MsgSelectNode)other;
        return ExprEquivalence.get().equivalent(this.selectExpr, that.selectExpr);
    }

    @Override
    public String getCommandText() {
        return this.baseSelectVarName == null ? this.selectExpr.toSourceString() : this.selectExpr.toSourceString() + " phname=\"" + this.baseSelectVarName + "\"";
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.selectExpr);
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgSelectNode copy(CopyState copyState) {
        return new MsgSelectNode(this, copyState);
    }
}

