/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.shared.restricted.SoyDeprecated;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Set;

public final class PluginResolver {
    private static final SoyErrorKind UNKNOWN_PLUGIN = SoyErrorKind.of("Unknown {0} ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DEPRECATED_PLUGIN = SoyErrorKind.of("{0} is deprecated: {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION, SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind INCORRECT_NUM_ARGS = SoyErrorKind.of("{0} called with {1} arguments (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private final Mode mode;
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private final ImmutableMap<String, ? extends SoyFunction> functions;
    private final ErrorReporter reporter;

    public static PluginResolver nullResolver(Mode mode, ErrorReporter reporter) {
        return new PluginResolver(mode, (ImmutableMap<String, ? extends SoyPrintDirective>)ImmutableMap.of(), (ImmutableMap<String, ? extends SoyFunction>)ImmutableMap.of(), reporter);
    }

    public PluginResolver(Mode mode, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives, ImmutableMap<String, ? extends SoyFunction> functions, ErrorReporter reporter) {
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.printDirectives = (ImmutableMap)Preconditions.checkNotNull(printDirectives);
        this.functions = (ImmutableMap)Preconditions.checkNotNull(functions);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
    }

    public SoyPrintDirective lookupPrintDirective(String name, int numArgs, SourceLocation location) {
        SoyPrintDirective soyPrintDirective = (SoyPrintDirective)this.printDirectives.get((Object)name);
        if (soyPrintDirective == null) {
            if (this.mode == Mode.REQUIRE_DEFINITIONS || this.mode == Mode.ALLOW_UNDEFINED_FUNCTIONS_FOR_V1_SUPPORT) {
                this.reporter.report(location, UNKNOWN_PLUGIN, "print directive", name, SoyErrors.getDidYouMeanMessage((Iterable<String>)this.printDirectives.keySet(), name));
            }
            soyPrintDirective = PluginResolver.createPlaceholderPrintDirective(name, numArgs);
        }
        this.checkNumArgs("print directive", soyPrintDirective.getValidArgsSizes(), numArgs, location);
        this.warnIfDeprecated(name, soyPrintDirective, location);
        return soyPrintDirective;
    }

    public SoyFunction lookupSoyFunction(String name, int numArgs, SourceLocation location) {
        SoyFunction soyFunction = (SoyFunction)this.functions.get((Object)name);
        if (soyFunction == null) {
            if (this.mode == Mode.REQUIRE_DEFINITIONS) {
                this.reporter.report(location, UNKNOWN_PLUGIN, "function", name, SoyErrors.getDidYouMeanMessage((Iterable<String>)this.functions.keySet(), name));
            }
            soyFunction = PluginResolver.createPlaceholderSoyFunction(name, numArgs);
        }
        this.checkNumArgs("function", soyFunction.getValidArgsSizes(), numArgs, location);
        this.warnIfDeprecated(name, soyFunction, location);
        return soyFunction;
    }

    private void checkNumArgs(String pluginKind, Set<Integer> arities, int actualNumArgs, SourceLocation location) {
        if (!arities.contains(actualNumArgs)) {
            this.reporter.report(location, INCORRECT_NUM_ARGS, pluginKind, actualNumArgs, Joiner.on((String)" or ").join(arities));
        }
    }

    private void warnIfDeprecated(String name, Object plugin, SourceLocation location) {
        SoyDeprecated deprecatedNotice = plugin.getClass().getAnnotation(SoyDeprecated.class);
        if (deprecatedNotice != null) {
            this.reporter.warn(location, DEPRECATED_PLUGIN, name, deprecatedNotice.value());
        }
    }

    private static SoyPrintDirective createPlaceholderPrintDirective(final String name, int arity) {
        final ImmutableSet validArgSizes = ImmutableSet.of((Object)arity);
        return new SoyPrintDirective(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return validArgSizes;
            }

            @Override
            public boolean shouldCancelAutoescape() {
                return false;
            }
        };
    }

    private static SoyFunction createPlaceholderSoyFunction(final String name, int arity) {
        final ImmutableSet validArgSizes = ImmutableSet.of((Object)arity);
        return new SoyFunction(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return validArgSizes;
            }
        };
    }

    public static enum Mode {
        ALLOW_UNDEFINED,
        REQUIRE_DEFINITIONS,
        ALLOW_UNDEFINED_FUNCTIONS_FOR_V1_SUPPORT;

    }
}

