/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.LazySanitizedContents;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.data.internal.AugmentedParamStore;
import com.google.template.soy.data.internal.BasicParamStore;
import com.google.template.soy.data.internal.ParamStore;
import com.google.template.soy.data.internal.RenderableThunk;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.RangeArgs;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.sharedpasses.render.CountingFlushableAppendable;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.EvalVisitor;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.RenderVisitorAssistantForMsgs;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;

public class RenderVisitor
extends AbstractSoyNodeVisitor<Void> {
    protected final EvalVisitor.EvalVisitorFactory evalVisitorFactory;
    protected final TemplateRegistry templateRegistry;
    protected final SoyRecord data;
    protected final SoyRecord ijData;
    protected Environment env;
    protected final Predicate<String> activeDelPackageSelector;
    protected final SoyMsgBundle msgBundle;
    protected final SoyIdRenamingMap xidRenamingMap;
    protected final SoyCssRenamingMap cssRenamingMap;
    protected boolean debugSoyTemplateInfo;
    private EvalVisitor evalVisitor;
    private RenderVisitorAssistantForMsgs assistantForMsgs;
    protected Deque<Appendable> outputBufStack;
    private Appendable currOutputBuf;
    private CountingFlushableAppendable flushable;

    public RenderVisitor(EvalVisitor.EvalVisitorFactory evalVisitorFactory, Appendable outputBuf, @Nullable TemplateRegistry templateRegistry, SoyRecord data, @Nullable SoyRecord ijData, @Nullable Predicate<String> activeDelPackageSelector, @Nullable SoyMsgBundle msgBundle, @Nullable SoyIdRenamingMap xidRenamingMap, @Nullable SoyCssRenamingMap cssRenamingMap, boolean debugSoyTemplateInfo) {
        Preconditions.checkNotNull((Object)data);
        this.evalVisitorFactory = evalVisitorFactory;
        this.templateRegistry = templateRegistry;
        this.data = data;
        this.ijData = ijData;
        this.activeDelPackageSelector = activeDelPackageSelector;
        this.msgBundle = msgBundle;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
        this.evalVisitor = null;
        this.assistantForMsgs = null;
        this.outputBufStack = new ArrayDeque<Appendable>();
        if (outputBuf instanceof Flushable) {
            this.flushable = outputBuf instanceof CountingFlushableAppendable ? (CountingFlushableAppendable)outputBuf : new CountingFlushableAppendable(outputBuf);
            outputBuf = this.flushable;
        }
        this.pushOutputBuf(outputBuf);
    }

    @Override
    public Void exec(SoyNode node) {
        if (this.flushable != null) {
            SoyFutureValueProvider.FutureBlockCallback old = SoyFutureValueProvider.futureBlockCallback.get();
            SoyFutureValueProvider.futureBlockCallback.set(this.flushable);
            super.exec(node);
            SoyFutureValueProvider.futureBlockCallback.set(old);
        } else {
            super.exec(node);
        }
        return null;
    }

    protected RenderVisitor createHelperInstance(Appendable outputBuf, SoyRecord data) {
        return new RenderVisitor(this.evalVisitorFactory, outputBuf, this.templateRegistry, data, this.ijData, this.activeDelPackageSelector, this.msgBundle, this.xidRenamingMap, this.cssRenamingMap, this.debugSoyTemplateInfo);
    }

    void visitForUseByAssistants(SoyNode node) {
        this.visit(node);
    }

    private void renderTemplate(TemplateNode template, ImmutableList<TemplateParam> paramsToTypeCheck) {
        this.env = Environment.create(template, this.data, this.ijData);
        this.checkStrictParamTypes(template, paramsToTypeCheck);
        this.visitChildren(template);
        this.env = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.renderTemplate(node, node.getParams());
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        RenderVisitor.append(this.currOutputBuf, node.getRawText());
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        if (this.assistantForMsgs == null) {
            this.assistantForMsgs = new RenderVisitorAssistantForMsgs(this, this.msgBundle);
        }
        if (!node.getEscapingDirectives().isEmpty()) {
            this.pushOutputBuf(new StringBuilder());
        }
        this.assistantForMsgs.visitForUseByMaster(node);
        if (!node.getEscapingDirectives().isEmpty()) {
            SoyValue wholeMsg = StringData.forValue(this.popOutputBuf().toString());
            for (SoyPrintDirective directive : node.getEscapingDirectives()) {
                wholeMsg = this.applyDirective(directive, wholeMsg, (List<SoyValue>)ImmutableList.of(), node);
            }
            RenderVisitor.append(this.currOutputBuf, wholeMsg.stringValue());
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        SoyValue result = this.eval(node.getExpr(), node);
        if (result instanceof UndefinedData) {
            throw RenderException.createWithSource("In 'print' tag, expression \"" + node.getExpr().toSourceString() + "\" evaluates to undefined.", node);
        }
        for (PrintDirectiveNode directiveNode : node.getChildren()) {
            List<ExprRootNode> argsExprs = directiveNode.getArgs();
            ArrayList argsSoyDatas = Lists.newArrayListWithCapacity((int)argsExprs.size());
            for (ExprRootNode argExpr : argsExprs) {
                argsSoyDatas.add(this.eval(argExpr, directiveNode));
            }
            result = this.applyDirective(directiveNode.getPrintDirective(), result, argsSoyDatas, node);
        }
        RenderVisitor.append(this.currOutputBuf, result, node);
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.env.bind(node.getVar(), this.lazyEval(node.getExpr(), node));
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.env.bind(node.getVar(), this.renderRenderUnitNode(node));
    }

    @Override
    protected void visitIfNode(IfNode node) {
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                if (!this.eval(icn.getExpr(), node).coerceToBoolean()) continue;
                this.visit(icn);
                return;
            }
            if (child instanceof IfElseNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitSwitchNode(SwitchNode node) {
        SoyValue switchValue = this.eval(node.getExpr(), node);
        for (SoyNode child : node.getChildren()) {
            if (child instanceof SwitchCaseNode) {
                SwitchCaseNode scn = (SwitchCaseNode)child;
                for (ExprNode caseExpr : scn.getExprList()) {
                    if (!SharedRuntime.equal(switchValue, this.eval(caseExpr, scn))) continue;
                    this.visit(scn);
                    return;
                }
                continue;
            }
            if (child instanceof SwitchDefaultNode) {
                this.visit(child);
                return;
            }
            throw new AssertionError();
        }
    }

    @Override
    protected void visitForNode(ForNode node) {
        Optional<RangeArgs> exprAsRangeArgs = RangeArgs.createFromNode(node);
        if (exprAsRangeArgs.isPresent()) {
            RangeArgs args = (RangeArgs)exprAsRangeArgs.get();
            int step = args.increment().isPresent() ? this.evalRangeArg(node, (ExprNode)args.increment().get()) : 1;
            int start = args.start().isPresent() ? this.evalRangeArg(node, (ExprNode)args.start().get()) : 0;
            int end = this.evalRangeArg(node, args.limit());
            int length = end - start;
            if ((length ^ step) < 0) {
                if (node.numChildren() == 2) {
                    this.visit((SoyNode)node.getChild(1));
                }
            } else {
                ForNonemptyNode child = (ForNonemptyNode)node.getChild(0);
                int size = length / step + (length % step == 0 ? 0 : 1);
                for (int i = 0; i < size; ++i) {
                    this.executeForeachBody(child, i, IntegerData.forValue(start + step * i), size);
                }
            }
        } else {
            SoyValue dataRefValue = this.eval(node.getExpr(), node);
            if (!(dataRefValue instanceof SoyList)) {
                throw RenderException.createWithSource("In 'foreach' command " + node.toSourceString() + ", the data reference does not resolve to a SoyList (encountered type " + dataRefValue.getClass().getName() + ").", node);
            }
            SoyList foreachList = (SoyList)dataRefValue;
            int listLength = foreachList.length();
            if (listLength > 0) {
                ForNonemptyNode child = (ForNonemptyNode)node.getChild(0);
                for (int i = 0; i < listLength; ++i) {
                    this.executeForeachBody(child, i, foreachList.getProvider(i), listLength);
                }
            } else if (node.numChildren() == 2) {
                this.visit((SoyNode)node.getChild(1));
            }
        }
    }

    private void executeForeachBody(ForNonemptyNode child, int i, SoyValueProvider value, int size) {
        LoopVar var = child.getVar();
        this.env.bind(var, value);
        this.env.bindCurrentIndex(var, i);
        this.env.bindIsLast(var, size - 1 == i);
        this.visitChildren(child);
    }

    private int evalRangeArg(SoyNode node, ExprNode rangeArg) {
        SoyValue rangeArgValue = this.eval(rangeArg, node);
        if (!(rangeArgValue instanceof IntegerData)) {
            throw RenderException.create("In 'range' expression \"" + rangeArg.toSourceString() + "\" does not resolve to an integer.").addStackTraceElement(node.getNearestAncestor(TemplateNode.class), rangeArg.getSourceLocation());
        }
        return rangeArgValue.integerValue();
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        TemplateBasicNode callee = this.templateRegistry.getBasicTemplate(node.getCalleeName());
        if (callee == null) {
            throw RenderException.createWithSource("Attempting to render undefined template '" + node.getCalleeName() + "'.", node);
        }
        this.visitCallNodeHelper(node, callee);
    }

    @Override
    protected void visitCallDelegateNode(CallDelegateNode node) {
        TemplateDelegateNode callee;
        String variant;
        ExprRootNode variantExpr = node.getDelCalleeVariantExpr();
        if (variantExpr == null) {
            variant = "";
        } else {
            try {
                SoyValue variantData = this.eval(variantExpr, node);
                variant = variantData instanceof IntegerData ? String.valueOf(variantData.longValue()) : variantData.stringValue();
            }
            catch (SoyDataException e) {
                throw RenderException.createWithSource(String.format("Variant expression \"%s\" doesn't evaluate to a valid type (Only string and integer are supported).", variantExpr.toSourceString()), e, node);
            }
        }
        TemplateDelegateNode.DelTemplateKey delegateKey = TemplateDelegateNode.DelTemplateKey.create(node.getDelCalleeName(), variant);
        try {
            callee = this.templateRegistry.selectDelTemplate(delegateKey, this.activeDelPackageSelector);
        }
        catch (IllegalArgumentException e) {
            throw RenderException.createWithSource(e.getMessage(), e, node);
        }
        if (callee == null) {
            if (node.allowEmptyDefault()) {
                return;
            }
            throw RenderException.createWithSource("Found no active impl for delegate call to \"" + node.getDelCalleeName() + (variant.isEmpty() ? "" : ":" + variant) + "\" (and delcall does not set allowemptydefault=\"true\").", node);
        }
        this.visitCallNodeHelper(node, callee);
    }

    private void visitCallNodeHelper(CallNode node, TemplateNode callee) {
        SoyRecord callData;
        SoyRecord dataToPass;
        if (node.isPassingAllData()) {
            dataToPass = this.data;
        } else if (node.isPassingData()) {
            SoyValue dataRefValue = this.eval(node.getDataExpr(), node);
            if (!(dataRefValue instanceof SoyRecord)) {
                throw RenderException.create("In 'call' command " + node.toSourceString() + ", the data reference does not resolve to a SoyRecord.").addStackTraceElement(node);
            }
            dataToPass = (SoyRecord)dataRefValue;
        } else {
            dataToPass = null;
        }
        int numChildren = node.numChildren();
        if (numChildren == 0) {
            callData = dataToPass == null ? ParamStore.EMPTY_INSTANCE : dataToPass;
        } else {
            ParamStore mutableCallData = dataToPass == null ? new BasicParamStore(numChildren) : new AugmentedParamStore(dataToPass, numChildren);
            for (CallParamNode child : node.getChildren()) {
                if (child instanceof CallParamValueNode) {
                    mutableCallData.setField(child.getKey().identifier(), this.lazyEval(((CallParamValueNode)child).getExpr(), child));
                    continue;
                }
                if (child instanceof CallParamContentNode) {
                    mutableCallData.setField(child.getKey().identifier(), this.renderRenderUnitNode((CallParamContentNode)child));
                    continue;
                }
                throw new AssertionError();
            }
            callData = mutableCallData;
        }
        if (node.getEscapingDirectives().isEmpty()) {
            RenderVisitor rv = this.createHelperInstance(this.currOutputBuf, callData);
            try {
                rv.renderTemplate(callee, node.getParamsToRuntimeCheck(callee));
            }
            catch (RenderException re) {
                throw re.addStackTraceElement(node);
            }
        }
        StringBuilder calleeBuilder = new StringBuilder();
        RenderVisitor rv = this.createHelperInstance(calleeBuilder, callData);
        try {
            rv.renderTemplate(callee, node.getParamsToRuntimeCheck(callee));
        }
        catch (RenderException re) {
            throw re.addStackTraceElement(node);
        }
        SoyValue resultData = callee.getContentKind() != null ? UnsafeSanitizedContentOrdainer.ordainAsSafe(calleeBuilder.toString(), SanitizedContent.ContentKind.valueOf(callee.getContentKind().name())) : StringData.forValue(calleeBuilder.toString());
        for (SoyPrintDirective directive : node.getEscapingDirectives()) {
            resultData = this.applyDirective(directive, resultData, (List<SoyValue>)ImmutableList.of(), node);
        }
        RenderVisitor.append(this.currOutputBuf, resultData, node);
    }

    @Override
    protected void visitCallParamNode(CallParamNode node) {
        throw new AssertionError();
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        ExprRootNode logonlyExpression = node.getLogonlyExpression();
        if (logonlyExpression != null && this.eval(logonlyExpression, node).booleanValue()) {
            throw RenderException.createWithSource("Cannot set logonly=\"true\" unless there is a logger configured, but tofu doesn't support loggers", node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitLogNode(LogNode node) {
        this.renderBlock(node, System.out);
        System.out.println();
    }

    @Override
    protected void visitDebuggerNode(DebuggerNode node) {
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void pushOutputBuf(Appendable outputBuf) {
        this.outputBufStack.push(outputBuf);
        this.currOutputBuf = outputBuf;
    }

    private Appendable popOutputBuf() {
        Appendable poppedOutputBuf = this.outputBufStack.pop();
        this.currOutputBuf = this.outputBufStack.peek();
        return poppedOutputBuf;
    }

    Appendable getCurrOutputBufForUseByAssistants() {
        return this.currOutputBuf;
    }

    private void renderBlock(SoyNode.BlockNode block, Appendable to) {
        this.pushOutputBuf(to);
        this.visitChildren(block);
        this.popOutputBuf();
    }

    private SoyValue renderRenderUnitNode(final SoyNode.RenderUnitNode renderUnitNode) {
        RenderableThunk thunk = new RenderableThunk(){

            @Override
            protected void doRender(Appendable appendable) throws IOException {
                RenderVisitor.this.renderBlock(renderUnitNode, appendable);
            }
        };
        SanitizedContentKind contentKind = renderUnitNode.getContentKind();
        if (contentKind != null) {
            return LazySanitizedContents.forThunk(thunk, SanitizedContent.ContentKind.valueOf(contentKind.name()));
        }
        return StringData.forThunk(thunk);
    }

    private SoyValue eval(ExprNode expr, SoyNode node) {
        if (expr == null) {
            throw RenderException.create("Cannot evaluate expression in V1 syntax.").addStackTraceElement(node);
        }
        if (this.evalVisitor == null) {
            this.evalVisitor = this.evalVisitorFactory.create(this.env, this.ijData, this.cssRenamingMap, this.xidRenamingMap, this.msgBundle, this.debugSoyTemplateInfo);
        }
        try {
            return (SoyValue)this.evalVisitor.exec(expr);
        }
        catch (RenderException e) {
            throw RenderException.createFromRenderException("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage(), e, node);
        }
        catch (Exception e) {
            throw RenderException.createWithSource("When evaluating \"" + expr.toSourceString() + "\": " + e.getMessage(), e, node);
        }
    }

    private SoyValueProvider lazyEval(final ExprNode expr, final SoyNode node) {
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return RenderVisitor.this.eval(expr, node);
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    SoyValue evalForUseByAssistants(ExprNode expr, SoyNode node) {
        return this.eval(expr, node);
    }

    static void append(Appendable outputBuf, CharSequence cs) {
        try {
            outputBuf.append(cs);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static void append(Appendable outputBuf, SoyValue value, SoyNode node) {
        try {
            value.render(outputBuf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (RenderException e) {
            throw e.addStackTraceElement(node);
        }
    }

    private SoyValue applyDirective(SoyPrintDirective directive, SoyValue value, List<SoyValue> args, SoyNode node) {
        if (!(directive instanceof SoyJavaPrintDirective)) {
            throw RenderException.createWithSource("Failed to find Soy print directive with name '" + directive + "' (tag " + node.toSourceString() + ")", node);
        }
        if (!directive.getValidArgsSizes().contains(args.size())) {
            throw RenderException.createWithSource("Print directive '" + directive + "' used with the wrong number of arguments (tag " + node.toSourceString() + ").", node);
        }
        try {
            return ((SoyJavaPrintDirective)directive).applyForJava(value, args);
        }
        catch (RuntimeException e) {
            throw RenderException.createWithSource(String.format("Failed in applying directive '%s' in tag \"%s\" due to exception: %s", directive, node.toSourceString(), e.getMessage()), e, node);
        }
    }

    private void checkStrictParamTypes(TemplateNode node, ImmutableList<TemplateParam> params) {
        for (TemplateParam param : params) {
            this.checkStrictParamType(node, param, this.env.getVarProvider(param));
        }
        for (TemplateParam param : node.getInjectedParams()) {
            this.checkStrictParamType(node, param, this.env.getVarProvider(param));
        }
    }

    private void checkStrictParamType(final TemplateNode node, final TemplateParam param, @Nullable SoyValueProvider paramValue) {
        SoyAbstractCachingValueProvider typedValue;
        SoyType.Kind kind = param.type().getKind();
        if (kind == SoyType.Kind.ANY || kind == SoyType.Kind.UNKNOWN) {
            return;
        }
        if (paramValue == null) {
            paramValue = NullData.INSTANCE;
        } else if (paramValue instanceof SoyAbstractCachingValueProvider && !(typedValue = (SoyAbstractCachingValueProvider)paramValue).isComputed()) {
            typedValue.addValueAssertion(new SoyAbstractCachingValueProvider.ValueAssertion(){

                @Override
                public void check(SoyValue value) {
                    RenderVisitor.this.checkValueType(param, value, node);
                }
            });
            return;
        }
        this.checkValueType(param, paramValue.resolve(), node);
    }

    private void checkValueType(TemplateParam param, SoyValue value, TemplateNode node) {
        if (!TofuTypeChecks.isInstance(param.type(), value)) {
            throw RenderException.createWithSource("Parameter type mismatch: attempt to bind value '" + (value instanceof UndefinedData ? "(undefined)" : value) + "' to parameter '" + param.name() + "' which has declared type '" + param.type() + "'.", node);
        }
    }
}

