/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.shared.restricted.SoyFunction;
import java.util.Set;
import javax.annotation.Nullable;

public enum BuiltinFunction implements SoyFunction
{
    IS_FIRST("isFirst"),
    IS_LAST("isLast"),
    INDEX("index"),
    QUOTE_KEYS_IF_JS("quoteKeysIfJs"),
    CHECK_NOT_NULL("checkNotNull"),
    CSS("css"),
    XID("xid"),
    V1_EXPRESSION("v1Expression"),
    REMAINDER("remainder"),
    MSG_ID("msgId"),
    IS_PRIMARY_MSG_IN_USE("$$isPrimaryMsgInUse");

    private static final ImmutableMap<String, BuiltinFunction> NONPLUGIN_FUNCTIONS_BY_NAME;
    private final String functionName;

    public static ImmutableSet<String> names() {
        return NONPLUGIN_FUNCTIONS_BY_NAME.keySet();
    }

    @Nullable
    public static BuiltinFunction forFunctionName(String functionName) {
        return (BuiltinFunction)NONPLUGIN_FUNCTIONS_BY_NAME.get((Object)functionName);
    }

    private BuiltinFunction(String name) {
        this.functionName = name;
    }

    @Override
    public String getName() {
        return this.functionName;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        switch (this) {
            case CSS: {
                return ImmutableSet.of((Object)1, (Object)2);
            }
            case IS_PRIMARY_MSG_IN_USE: {
                return ImmutableSet.of((Object)3);
            }
        }
        return ImmutableSet.of((Object)1);
    }

    static {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (BuiltinFunction nonpluginFn : BuiltinFunction.values()) {
            mapBuilder.put((Object)nonpluginFn.functionName, (Object)nonpluginFn);
        }
        NONPLUGIN_FUNCTIONS_BY_NAME = mapBuilder.build();
    }
}

