/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Optional;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;

final class VeLogValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind NO_CONFIG_FOR_ELEMENT = SoyErrorKind.of("Could not find logging configuration for this element.{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_CONFIG = SoyErrorKind.of("Unexpected ''data'' attribute for logging element ''{0}'', there is no configured ''proto_extension_type'' in the logging configuration for this element. Did you forget to configure it?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind WRONG_TYPE = SoyErrorKind.of("Expected an expression of type ''{0}'', instead got ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind REQUIRE_STRICTHTML = SoyErrorKind.of("The '{'velog ...'}' command can only be used in templates with stricthtml=\"true\".", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_LOGGING_FUNCTION_LOCATION = SoyErrorKind.of("The logging function ''{0}'' can only be evaluated in a print command that is the only direct child of an html attribute value.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind NO_PRINT_DIRECTIVES = SoyErrorKind.of("The logging function ''{0}'' can only be evaluated in a print command with no print directives.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter reporter;
    private final ValidatedLoggingConfig loggingConfig;

    VeLogValidationPass(ErrorReporter reporter, ValidatedLoggingConfig loggingConfig) {
        this.reporter = reporter;
        this.loggingConfig = loggingConfig;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        if (file.getSoyFileKind() != SoyFileKind.SRC) {
            return;
        }
        for (TemplateNode template : file.getChildren()) {
            for (VeLogNode node : SoyTreeUtils.getAllNodesOfType(template, VeLogNode.class)) {
                if (template.isStrictHtml()) {
                    this.validateNodeAgainstConfig(node);
                    continue;
                }
                this.reporter.report(node.getName().location(), REQUIRE_STRICTHTML, new Object[0]);
            }
            for (SoyNode.ExprHolderNode holderNode : SoyTreeUtils.getAllNodesOfType(template, SoyNode.ExprHolderNode.class)) {
                for (ExprRootNode rootNode : holderNode.getExprList()) {
                    for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(rootNode, FunctionNode.class)) {
                        if (!(function.getSoyFunction() instanceof LoggingFunction)) continue;
                        this.validateLoggingFunction(holderNode, function);
                    }
                }
            }
        }
    }

    private void validateLoggingFunction(SoyNode.ExprHolderNode holderNode, FunctionNode function) {
        if (function.getParent().getKind() != ExprNode.Kind.EXPR_ROOT_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It is part of complex expression.");
            return;
        }
        if (holderNode.getKind() != SoyNode.Kind.PRINT_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It isn't in a print node.");
            return;
        }
        PrintNode printNode = (PrintNode)holderNode;
        if (printNode.numChildren() != 0) {
            this.reporter.report(((PrintDirectiveNode)printNode.getChild(0)).getSourceLocation(), NO_PRINT_DIRECTIVES, function.getFunctionName());
        }
        if (holderNode.getParent().getKind() != SoyNode.Kind.HTML_ATTRIBUTE_VALUE_NODE) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It isn't the direct child of an attribute value.");
            return;
        }
        if (holderNode.getParent().numChildren() > 1) {
            this.reporter.report(function.getSourceLocation(), INVALID_LOGGING_FUNCTION_LOCATION, function.getFunctionName(), " It has sibling nodes in the attribute value.");
            return;
        }
    }

    private void validateNodeAgainstConfig(VeLogNode node) {
        ValidatedLoggingConfig.ValidatedLoggableElement config = this.loggingConfig.getElement(node.getName().identifier());
        if (config == null) {
            this.reporter.report(node.getName().location(), NO_CONFIG_FOR_ELEMENT, SoyErrors.getDidYouMeanMessage(this.loggingConfig.allKnownIdentifiers(), node.getName().identifier()));
        } else {
            SoyType type;
            node.setLoggingId(config.getId());
            if (node.getConfigExpression() != null) {
                type = node.getConfigExpression().getType();
                Optional<String> protoName = config.getProtoName();
                if (!protoName.isPresent()) {
                    this.reporter.report(node.getConfigExpression().getSourceLocation(), UNEXPECTED_CONFIG, node.getName().identifier());
                } else if (!(type.getKind() == SoyType.Kind.ERROR || type.getKind() == SoyType.Kind.PROTO && ((SoyProtoType)type).getDescriptor().getFullName().equals(protoName.get()))) {
                    this.reporter.report(node.getConfigExpression().getSourceLocation(), WRONG_TYPE, protoName.get(), type);
                }
            }
            if (node.getLogonlyExpression() != null && (type = node.getLogonlyExpression().getType()).getKind() != SoyType.Kind.BOOL) {
                this.reporter.report(node.getLogonlyExpression().getSourceLocation(), WRONG_TYPE, BoolType.getInstance(), type);
            }
        }
    }
}

