/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

final class RewriteGenderMsgsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind MORE_THAN_THREE_TOTAL_GENDERS = SoyErrorKind.of("A message can only contain at most 3 genders between the ''genders'' attribute and ''select'' command.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MORE_THAN_TWO_GENDER_EXPRS_WITH_PLURAL = SoyErrorKind.of("A msg with ''plural'' can contain at most 2 gender expressions between the ''genders'' attribute and ''select'' command (otherwise, combinatorial explosion would cause a gigantic generated message).", new SoyErrorKind.StyleAllowance[0]);
    private static final String FALLBACK_BASE_SELECT_VAR_NAME = "GENDER";
    private final ErrorReporter errorReporter;
    private final IdGenerator nodeIdGen;

    public RewriteGenderMsgsVisitor(IdGenerator nodeIdGen, ErrorReporter errorReporter) {
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
    }

    @Override
    protected void visitMsgNode(MsgNode msg) {
        List genderExprs = msg.getAndRemoveGenderExprs();
        if (genderExprs == null) {
            return;
        }
        genderExprs = Lists.reverse(genderExprs);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        List<String> baseSelectVarNames = MsgSubstUnitBaseVarNameUtils.genNoncollidingBaseNamesForExprs(ExprRootNode.unwrap(genderExprs), FALLBACK_BASE_SELECT_VAR_NAME, this.errorReporter);
        if (this.errorReporter.errorsSince(checkpoint)) {
            return;
        }
        for (int i = 0; i < genderExprs.size(); ++i) {
            ExprRootNode genderExpr = (ExprRootNode)genderExprs.get(i);
            String baseSelectVarName = baseSelectVarNames.get(i);
            if (MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(genderExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME).equals(baseSelectVarName) && MsgSubstUnitBaseVarNameUtils.genShortestBaseNameForExpr(genderExpr.getRoot(), FALLBACK_BASE_SELECT_VAR_NAME).equals(baseSelectVarName)) {
                baseSelectVarName = null;
            }
            this.splitMsgForGender(msg, genderExpr, baseSelectVarName);
        }
        this.checkExceedsMaxGenders((MsgSelectNode)msg.getChild(0), 1);
    }

    private void splitMsgForGender(MsgNode msg, ExprRootNode genderExpr, @Nullable String baseSelectVarName) {
        ImmutableList origChildren = ImmutableList.copyOf((Collection)msg.getChildren());
        msg.clearChildren();
        MsgSelectCaseNode femaleCase = new MsgSelectCaseNode(this.nodeIdGen.genId(), msg.getSourceLocation(), "female");
        femaleCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectCaseNode maleCase = new MsgSelectCaseNode(this.nodeIdGen.genId(), msg.getSourceLocation(), "male");
        maleCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectDefaultNode defaultCase = new MsgSelectDefaultNode(this.nodeIdGen.genId(), msg.getSourceLocation());
        defaultCase.addChildren(SoyTreeUtils.cloneListWithNewIds(origChildren, this.nodeIdGen));
        MsgSelectNode selectNode = new MsgSelectNode(this.nodeIdGen.genId(), msg.getSourceLocation(), genderExpr, baseSelectVarName);
        selectNode.addChild(femaleCase);
        selectNode.addChild(maleCase);
        selectNode.addChild(defaultCase);
        msg.addChild(selectNode);
    }

    private boolean checkExceedsMaxGenders(MsgSelectNode selectNode, int depth) {
        for (int caseNum = 0; caseNum < selectNode.numChildren(); ++caseNum) {
            if (((CaseOrDefaultNode)selectNode.getChild(caseNum)).numChildren() <= 0) continue;
            SoyNode.StandaloneNode caseNodeChild = (SoyNode.StandaloneNode)((CaseOrDefaultNode)selectNode.getChild(caseNum)).getChild(0);
            if (caseNodeChild instanceof MsgPluralNode && depth >= 3) {
                this.errorReporter.report(selectNode.getSourceLocation(), MORE_THAN_TWO_GENDER_EXPRS_WITH_PLURAL, new Object[0]);
                return false;
            }
            if (!(caseNodeChild instanceof MsgSelectNode)) continue;
            if (depth >= 3) {
                this.errorReporter.report(selectNode.getSourceLocation(), MORE_THAN_THREE_TOTAL_GENDERS, new Object[0]);
                return false;
            }
            boolean validSubtree = this.checkExceedsMaxGenders((MsgSelectNode)caseNodeChild, depth + 1);
            if (validSubtree) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

