/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

final class Inferences {
    @Nullable
    private final Inferences parent;
    private final IdGenerator idGen;
    private final ListMultimap<String, TemplateNode> templatesByName = MultimapBuilder.linkedHashKeys().arrayListValues().build();
    private final Map<String, Context> templateNameToEndContext = Maps.newLinkedHashMap();
    private final Map<SoyNode, ImmutableList<EscapingMode>> nodeToEscapingModes = Maps.newIdentityHashMap();
    private final Map<SoyNode, Context> nodeToContext = Maps.newIdentityHashMap();
    private final Map<CallNode, String> callNodeToDerivedCalleeName = Maps.newIdentityHashMap();
    private final Set<String> templatesChecked = Sets.newHashSet();

    public Inferences(Inferences parent) {
        this.parent = parent;
        this.idGen = parent.idGen;
    }

    public Inferences(IdGenerator idGen, ImmutableListMultimap<String, TemplateNode> templatesByName) {
        this.parent = null;
        this.idGen = idGen;
        this.templatesByName.putAll(templatesByName);
    }

    public void recordTemplateEndContext(String templateName, Context context) {
        this.templateNameToEndContext.put(templateName, context);
    }

    List<TemplateNode> lookupTemplates(String templateName) {
        Inferences inferences = this;
        while (inferences != null) {
            List tn = inferences.templatesByName.get((Object)templateName);
            if (!tn.isEmpty()) {
                return tn;
            }
            inferences = inferences.parent;
        }
        return ImmutableList.of();
    }

    public Context getTemplateEndContext(String templateName) {
        Inferences inferences = this;
        while (inferences != null) {
            Context oc = inferences.templateNameToEndContext.get(templateName);
            if (oc != null) {
                return oc;
            }
            inferences = inferences.parent;
        }
        return null;
    }

    public ImmutableList<EscapingMode> getEscapingMode(PrintNode printNode) {
        Inferences inferences = this;
        while (inferences != null) {
            ImmutableList<EscapingMode> escapingModes = inferences.nodeToEscapingModes.get(printNode);
            if (escapingModes != null) {
                return escapingModes;
            }
            inferences = inferences.parent;
        }
        ImmutableList.Builder modes = ImmutableList.builder();
        for (PrintDirectiveNode directiveNode : printNode.getChildren()) {
            EscapingMode mode = EscapingMode.fromDirective(directiveNode.getName());
            if (mode != null) {
                modes.add((Object)mode);
                continue;
            }
            if (directiveNode.getPrintDirective() == null || !directiveNode.getPrintDirective().shouldCancelAutoescape()) continue;
            modes.add((Object)EscapingMode.NO_AUTOESCAPE);
        }
        return modes.build();
    }

    public void setEscapingDirectives(SoyNode node, Context context, List<EscapingMode> escapingModes) {
        Preconditions.checkArgument((node instanceof PrintNode || node instanceof CallNode || node instanceof MsgFallbackGroupNode ? 1 : 0) != 0, (Object)"Escaping directives may only be set for {print}, {msg}, or {call} nodes");
        if (escapingModes != null) {
            this.nodeToEscapingModes.put(node, (ImmutableList<EscapingMode>)ImmutableList.copyOf(escapingModes));
        }
        this.nodeToContext.put(node, context);
    }

    public ImmutableList<EscapingMode> getEscapingModesForNode(SoyNode node) {
        ImmutableList modes = this.nodeToEscapingModes.get(node);
        if (modes == null) {
            modes = ImmutableList.of();
        }
        return modes;
    }

    @VisibleForTesting
    Context getContextForNode(SoyNode node) {
        return this.nodeToContext.get(node);
    }

    public void retargetCall(CallNode cn, String derivedCalleeName) {
        this.callNodeToDerivedCalleeName.put(cn, derivedCalleeName);
    }

    @Nullable
    public String getDerivedCalleeNameForCall(CallNode callNode) {
        return this.callNodeToDerivedCalleeName.get(callNode);
    }

    public List<TemplateNode> cloneTemplates(String baseName, String derivedName, CallNode callNode) {
        if (!this.lookupTemplates(derivedName).isEmpty()) {
            throw new AssertionError((Object)(derivedName + " already has templates: " + this.lookupTemplates(derivedName)));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (TemplateNode tn : this.lookupTemplates(baseName)) {
            TemplateNode clone;
            if (SoyTreeUtils.hasHtmlNodes(tn)) {
                throw SoyAutoescapeException.createWithNode("Non-strict template '" + baseName + "' contains HTML nodes but does not specify the kind. This is no longer allowed, please migrate the template to strict and specify a content kind by adding a kind=\"(html|attributes|js|css|uri)\" attribute", callNode);
            }
            TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo = tn.getSoyFileHeaderInfo();
            TemplateNode trivialClonedTemplate = SoyTreeUtils.cloneWithNewIds(tn, this.idGen);
            int cloneId = trivialClonedTemplate.getId();
            if (tn instanceof TemplateBasicNode) {
                String derivedPartialName = tn.getPartialTemplateName() != null ? derivedName.substring(soyFileHeaderInfo.namespace.length()) : null;
                clone = ((TemplateBasicNodeBuilder)new TemplateBasicNodeBuilder(soyFileHeaderInfo, ErrorReporter.exploding()).setId(cloneId).setSourceLocation(tn.getSourceLocation()).setCmdTextInfo(derivedName, derivedPartialName, tn.getVisibility(), tn.getAutoescapeMode(), tn.getContentKind(), tn.getRequiredCssNamespaces()).addParams(trivialClonedTemplate.getAllParams())).build();
                if (!derivedName.equals(clone.getTemplateName()) || !Objects.equals(derivedPartialName, clone.getPartialTemplateName())) {
                    throw new AssertionError();
                }
            } else if (tn instanceof TemplateDelegateNode) {
                TemplateDelegateNode tdn = (TemplateDelegateNode)tn;
                clone = ((TemplateDelegateNodeBuilder)new TemplateDelegateNodeBuilder(soyFileHeaderInfo, ErrorReporter.exploding()).setId(cloneId).setSourceLocation(tn.getSourceLocation()).setCmdTextInfo(derivedName, tdn.getDelTemplateVariant(), tdn.getDelPriority(), tn.getAutoescapeMode(), tn.getContentKind(), tn.getRequiredCssNamespaces()).addParams(trivialClonedTemplate.getAllParams())).build();
                if (!derivedName.equals(((TemplateDelegateNode)clone).getDelTemplateName())) {
                    throw new AssertionError();
                }
            } else {
                throw new AssertionError((Object)("Unknown template node type: " + tn.getClass()));
            }
            clone.addChildren(trivialClonedTemplate.getChildren());
            clone.setMaxLocalVariableTableSize(tn.getMaxLocalVariableTableSize());
            Iterator<TemplateParam> tnIterator = tn.getAllParams().iterator();
            Iterator<TemplateParam> cloneIterator = clone.getAllParams().iterator();
            while (tnIterator.hasNext()) {
                cloneIterator.next().setLocalVariableIndex(tnIterator.next().localVariableIndex());
            }
            b.add((Object)clone);
        }
        ImmutableList clones = b.build();
        this.templatesByName.putAll((Object)derivedName, (Iterable)clones);
        return clones;
    }

    public void foldIntoParent() {
        this.parent.nodeToEscapingModes.putAll(this.nodeToEscapingModes);
        this.parent.templateNameToEndContext.putAll(this.templateNameToEndContext);
        this.parent.callNodeToDerivedCalleeName.putAll(this.callNodeToDerivedCalleeName);
        this.parent.templatesByName.putAll(this.templatesByName);
        this.parent.templatesChecked.addAll(this.templatesChecked);
    }

    public List<TemplateNode> getAllTemplates() {
        return ImmutableList.copyOf((Collection)this.templatesByName.values());
    }

    public void recordTemplateChecked(String templateName) {
        this.templatesChecked.add(templateName);
    }

    public boolean wasTemplateChecked(String templateName) {
        return this.templatesChecked.contains(templateName);
    }

    public IdGenerator getIdGenerator() {
        return this.idGen;
    }
}

