/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.parsepasses.contextautoesc.InferenceEngine;
import com.google.template.soy.parsepasses.contextautoesc.Inferences;
import com.google.template.soy.parsepasses.contextautoesc.PerformDeprecatedNonContextualAutoescapeVisitor;
import com.google.template.soy.parsepasses.contextautoesc.Rewriter;
import com.google.template.soy.parsepasses.contextautoesc.SoyAutoescapeException;
import com.google.template.soy.parsepasses.contextautoesc.TemplateCallGraph;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ContextualAutoescaper {
    @VisibleForTesting
    static final String AUTOESCAPE_ERROR_PREFIX = "Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n";
    private static final SoyErrorKind AUTOESCAPE_ERROR = SoyErrorKind.of("Invalid or ambiguous syntax prevents Soy from escaping this template correctly:\n{0}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ImmutableMap<String, ? extends SoyPrintDirective> printDirectives;
    private Inferences inferences;
    private static final Predicate<TemplateNode> REQUIRES_INFERENCE = new Predicate<TemplateNode>(){

        public boolean apply(TemplateNode templateNode) {
            return templateNode.getAutoescapeMode() == AutoescapeMode.STRICT || templateNode.getAutoescapeMode() == AutoescapeMode.CONTEXTUAL;
        }
    };

    public ContextualAutoescaper(ImmutableMap<String, ? extends SoyPrintDirective> soyDirectivesMap) {
        this.printDirectives = soyDirectivesMap;
    }

    public List<TemplateNode> rewrite(SoyFileSetNode fileSet, ErrorReporter errorReporter) {
        ImmutableList files = ImmutableList.copyOf(fileSet.getChildren());
        ImmutableListMultimap<String, TemplateNode> templatesByName = ContextualAutoescaper.findTemplates((Iterable<? extends SoyFileNode>)files);
        Inferences inferences = new Inferences(fileSet.getNodeIdGenerator(), templatesByName);
        List<TemplateNode> allTemplates = inferences.getAllTemplates();
        TemplateCallGraph callGraph = new TemplateCallGraph(templatesByName);
        Collection thatRequireInference = Collections2.filter(allTemplates, REQUIRES_INFERENCE);
        Set<TemplateNode> templateNodesToType = callGraph.callersOf(thatRequireInference);
        templateNodesToType.addAll(thatRequireInference);
        HashSet<SourceLocation> errorLocations = new HashSet<SourceLocation>();
        for (TemplateNode templateNode : templateNodesToType) {
            try {
                Context startContext = templateNode.getContentKind() != null ? Context.getStartContextForContentKind(templateNode.getContentKind()) : Context.HTML_PCDATA;
                InferenceEngine.inferTemplateEndContext(templateNode, startContext, inferences, errorReporter);
            }
            catch (SoyAutoescapeException e) {
                this.reportError(errorReporter, errorLocations, e);
            }
        }
        if (!errorLocations.isEmpty()) {
            return ImmutableList.of();
        }
        this.inferences = inferences;
        this.runVisitorOnAllTemplatesIncludingNewOnes(inferences, new NonContextualTypedRenderUnitNodesVisitor(errorReporter));
        List<TemplateNode> extraTemplates = new Rewriter(inferences, this.printDirectives).rewrite(fileSet);
        this.runVisitorOnAllTemplatesIncludingNewOnes(inferences, new PerformDeprecatedNonContextualAutoescapeVisitor(fileSet.getNodeIdGenerator()));
        return extraTemplates;
    }

    private void runVisitorOnAllTemplatesIncludingNewOnes(Inferences inferences, AbstractSoyNodeVisitor<?> visitor) {
        List<TemplateNode> allTemplatesIncludingNewOnes = inferences.getAllTemplates();
        for (TemplateNode templateNode : allTemplatesIncludingNewOnes) {
            visitor.exec(templateNode);
        }
    }

    public Context getTemplateEndContext(String templateName) {
        return this.inferences.getTemplateEndContext(templateName);
    }

    private void reportError(ErrorReporter errorReporter, Set<SourceLocation> errorLocations, SoyAutoescapeException e) {
        String message = "- " + e.getOriginalMessage();
        while (e.getCause() instanceof SoyAutoescapeException) {
            e = (SoyAutoescapeException)e.getCause();
            message = message + "\n- " + e.getMessage();
        }
        SourceLocation location = (SourceLocation)Preconditions.checkNotNull((Object)e.getSourceLocation());
        if (!errorLocations.add(location)) {
            return;
        }
        errorReporter.report(location, AUTOESCAPE_ERROR, message);
    }

    private static ImmutableListMultimap<String, TemplateNode> findTemplates(Iterable<? extends SoyFileNode> files) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (SoyFileNode soyFileNode : files) {
            for (TemplateNode template : soyFileNode.getChildren()) {
                String templateName = template instanceof TemplateBasicNode ? template.getTemplateName() : ((TemplateDelegateNode)template).getDelTemplateName();
                builder.put((Object)templateName, (Object)template);
            }
        }
        return builder.build();
    }

    private final class NonContextualTypedRenderUnitNodesVisitor
    extends AbstractSoyNodeVisitor<Void> {
        final ErrorReporter errorReporter;

        NonContextualTypedRenderUnitNodesVisitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            if (node.getAutoescapeMode() == AutoescapeMode.NONCONTEXTUAL) {
                this.visitChildren(node);
            }
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitRenderUnitNode(node);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitRenderUnitNode(node);
        }

        protected void visitRenderUnitNode(SoyNode.RenderUnitNode node) {
            if (node.getContentKind() != null) {
                InferenceEngine.inferStrictRenderUnitNode(AutoescapeMode.NONCONTEXTUAL, node, ContextualAutoescaper.this.inferences, this.errorReporter);
            } else {
                this.visitChildren(node);
            }
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

