/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.logging.AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement;
import com.google.template.soy.logging.LoggableElement;
import com.google.template.soy.logging.LoggingConfig;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public final class ValidatedLoggingConfig {
    public static final ValidatedLoggingConfig EMPTY = new ValidatedLoggingConfig((ImmutableMap<String, ValidatedLoggableElement>)ImmutableMap.of());
    private final ImmutableMap<String, ValidatedLoggableElement> elementsByName;

    public static ValidatedLoggingConfig create(LoggingConfig configProto) {
        LinkedHashMap<String, ValidatedLoggableElement> elementsByName = new LinkedHashMap<String, ValidatedLoggableElement>();
        LinkedHashMap<Long, ValidatedLoggableElement> elementsById = new LinkedHashMap<Long, ValidatedLoggableElement>();
        for (LoggableElement element : ImmutableSet.copyOf(configProto.getElementList())) {
            String name = element.getName();
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(name), (String)"'%s' is not a valid identifier", (Object)name);
            ValidatedLoggableElement elementConfig = ValidatedLoggableElement.create(element);
            ValidatedLoggableElement oldWithSameId = elementsById.put(elementConfig.getId(), elementConfig);
            if (oldWithSameId != null) {
                throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same id %d: %s and %s", elementConfig.getId(), oldWithSameId.getName(), elementConfig.getName()));
            }
            ValidatedLoggableElement oldWithSameName = elementsByName.put(elementConfig.getName(), elementConfig);
            if (oldWithSameName == null) continue;
            throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same name %s, their ids are %d and %d", elementConfig.getName(), oldWithSameName.getId(), elementConfig.getId()));
        }
        return new ValidatedLoggingConfig((ImmutableMap<String, ValidatedLoggableElement>)ImmutableMap.copyOf(elementsByName));
    }

    private ValidatedLoggingConfig(ImmutableMap<String, ValidatedLoggableElement> elementsByName) {
        this.elementsByName = elementsByName;
    }

    @Nullable
    public ValidatedLoggableElement getElement(String identifier) {
        return (ValidatedLoggableElement)this.elementsByName.get((Object)identifier);
    }

    public ImmutableSet<String> allKnownIdentifiers() {
        return this.elementsByName.keySet();
    }

    public static abstract class ValidatedLoggableElement {
        static ValidatedLoggableElement create(LoggableElement element) {
            return new AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement(element.getName(), element.getId(), (Optional<String>)(element.getProtoType().isEmpty() ? Optional.absent() : Optional.of((Object)element.getProtoType())));
        }

        ValidatedLoggableElement() {
        }

        public abstract String getName();

        public abstract long getId();

        public abstract Optional<String> getProtoName();
    }
}

