/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyToJsVariableMappings {
    private final Map<String, CodeChunk.WithValue> mappings;
    private final Map<MsgFallbackGroupNode, CodeChunk.WithValue> isPrimaryMsgInUseForFallbackGroup = new IdentityHashMap<MsgFallbackGroupNode, CodeChunk.WithValue>();

    private SoyToJsVariableMappings(ImmutableMap<String, ? extends CodeChunk.WithValue> initialMappings) {
        this.mappings = new HashMap<String, CodeChunk.WithValue>((Map<String, ? extends CodeChunk.WithValue>)initialMappings);
    }

    public static SoyToJsVariableMappings forNewTemplate() {
        return new SoyToJsVariableMappings((ImmutableMap<String, ? extends CodeChunk.WithValue>)ImmutableMap.of());
    }

    @VisibleForTesting
    static SoyToJsVariableMappings startingWith(ImmutableMap<String, ? extends CodeChunk.WithValue> initialMappings) {
        return new SoyToJsVariableMappings(initialMappings);
    }

    public SoyToJsVariableMappings put(String var, CodeChunk.WithValue translation) {
        this.mappings.put(var, translation);
        return this;
    }

    public SoyToJsVariableMappings setIsPrimaryMsgInUse(MsgFallbackGroupNode msg, CodeChunk.WithValue var) {
        this.isPrimaryMsgInUseForFallbackGroup.put(msg, var);
        return this;
    }

    public CodeChunk.WithValue get(String name) {
        return (CodeChunk.WithValue)Preconditions.checkNotNull((Object)this.mappings.get(name));
    }

    public CodeChunk.WithValue isPrimaryMsgInUse(MsgFallbackGroupNode msg) {
        return this.isPrimaryMsgInUseForFallbackGroup.get(msg);
    }

    @Nullable
    public CodeChunk.WithValue maybeGet(String name) {
        return this.mappings.get(name);
    }
}

