/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Call;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Id;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_ProtoCall;
import com.google.template.soy.jssrc.internal.JsRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class NullSafeAccumulator {
    private final CodeChunk.WithValue base;
    private final List<ChainAccess> chain;
    @Nullable
    private CodeChunk.WithValue unpackFunction;
    @Nullable
    private AccessType accessType;

    NullSafeAccumulator(CodeChunk.WithValue base) {
        this.base = base;
        this.chain = new ArrayList<ChainAccess>();
    }

    NullSafeAccumulator dotAccess(FieldAccess access, boolean nullSafe) {
        ProtoCall protoCall;
        CodeChunk.WithValue maybeUnpack;
        if (access instanceof ProtoCall && (maybeUnpack = (protoCall = (ProtoCall)access).unpackFunction()) != null) {
            Preconditions.checkState((this.unpackFunction == null ? 1 : 0) != 0, (String)"this chain will already unpack with %s", (Object)this.unpackFunction);
            this.unpackFunction = maybeUnpack;
            this.accessType = protoCall.accessType();
        }
        this.chain.add(access.toChainAccess(nullSafe));
        return this;
    }

    NullSafeAccumulator mapGetAccess(CodeChunk.WithValue mapKeyCode, boolean nullSafe) {
        this.chain.add(FieldAccess.call("get", mapKeyCode).toChainAccess(nullSafe));
        this.accessType = AccessType.SINGULAR;
        return this;
    }

    NullSafeAccumulator bracketAccess(CodeChunk.WithValue arg, boolean nullSafe) {
        this.chain.add(new Bracket(arg, nullSafe));
        this.accessType = AccessType.SINGULAR;
        return this;
    }

    CodeChunk.WithValue result(CodeChunk.Generator codeGenerator) {
        CodeChunk.WithValue accessChain = NullSafeAccumulator.buildAccessChain(this.base, codeGenerator, this.chain.iterator());
        if (this.unpackFunction == null) {
            return accessChain;
        }
        return this.accessType.unpackResult(accessChain, this.unpackFunction);
    }

    private static CodeChunk.WithValue buildAccessChain(CodeChunk.WithValue base, CodeChunk.Generator generator, Iterator<ChainAccess> chain) {
        if (!chain.hasNext()) {
            return base;
        }
        ChainAccess link = chain.next();
        if (link.nullSafe) {
            if (!base.isCheap()) {
                base = generator.declarationBuilder().setRhs(base).build().ref();
            }
            return CodeChunk.ifExpression(base.doubleEqualsNull(), CodeChunk.LITERAL_NULL).else_(NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain)).build(generator);
        }
        return NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain);
    }

    static enum AccessType {
        SINGULAR{

            @Override
            CodeChunk.WithValue unpackResult(CodeChunk.WithValue accessChain, CodeChunk.WithValue unpackFunction) {
                return unpackFunction.call(accessChain);
            }
        }
        ,
        REPEATED{

            @Override
            CodeChunk.WithValue unpackResult(CodeChunk.WithValue accessChain, CodeChunk.WithValue unpackFunction) {
                return JsRuntime.GOOG_ARRAY_MAP.call(accessChain, unpackFunction);
            }
        }
        ,
        MAP{

            @Override
            CodeChunk.WithValue unpackResult(CodeChunk.WithValue accessChain, CodeChunk.WithValue unpackFunction) {
                return JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(accessChain, unpackFunction);
            }
        };


        abstract CodeChunk.WithValue unpackResult(CodeChunk.WithValue var1, CodeChunk.WithValue var2);

        private static AccessType get(Descriptors.FieldDescriptor desc) {
            if (desc.isMapField()) {
                return MAP;
            }
            if (desc.isRepeated()) {
                return REPEATED;
            }
            return SINGULAR;
        }
    }

    static abstract class ProtoCall
    extends FieldAccess {
        ProtoCall() {
        }

        abstract String getter();

        @Nullable
        abstract CodeChunk.WithValue getterArg();

        @Nullable
        abstract AccessType accessType();

        @Nullable
        abstract CodeChunk.WithValue unpackFunction();

        static ProtoCall create(String fieldName, Descriptors.FieldDescriptor desc) {
            CodeChunk.WithValue arg;
            String getter;
            if (desc.isExtension()) {
                getter = "getExtension";
                arg = JsRuntime.extensionField(desc);
            } else {
                getter = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                arg = null;
            }
            CodeChunk.WithValue unpackFunction = ProtoCall.getUnpackFunction(desc);
            return new AutoValue_NullSafeAccumulator_ProtoCall(getter, arg, unpackFunction == null ? null : AccessType.get(desc), unpackFunction);
        }

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.getterArg(), nullSafe);
        }

        @Nullable
        private static CodeChunk.WithValue getUnpackFunction(Descriptors.FieldDescriptor desc) {
            if (ProtoUtils.isSanitizedContentField(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType());
            }
            if (ProtoUtils.isSanitizedContentMap(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(ProtoUtils.getMapValueMessageType(desc));
            }
            return null;
        }
    }

    static abstract class Call
    extends FieldAccess {
        Call() {
        }

        abstract String getter();

        @Nullable
        abstract CodeChunk.WithValue arg();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.arg(), nullSafe);
        }
    }

    static abstract class Id
    extends FieldAccess {
        Id() {
        }

        abstract String fieldName();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new Dot(this.fieldName(), nullSafe);
        }
    }

    static abstract class FieldAccess {
        FieldAccess() {
        }

        @ForOverride
        abstract ChainAccess toChainAccess(boolean var1);

        static FieldAccess id(String fieldName) {
            return new AutoValue_NullSafeAccumulator_Id(fieldName);
        }

        static FieldAccess call(String getter, CodeChunk.WithValue arg) {
            return new AutoValue_NullSafeAccumulator_Call(getter, arg);
        }

        static FieldAccess protoCall(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.create(fieldName, desc);
        }
    }

    private static final class DotCall
    extends ChainAccess {
        final String getter;
        @Nullable
        final CodeChunk.WithValue arg;

        DotCall(String getter, @Nullable CodeChunk.WithValue arg, boolean nullSafe) {
            super(nullSafe);
            this.getter = getter;
            this.arg = arg;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return this.arg == null ? prevTip.dotAccess(this.getter).call(new CodeChunk.WithValue[0]) : prevTip.dotAccess(this.getter).call(this.arg);
        }
    }

    private static final class Dot
    extends ChainAccess {
        final String id;

        Dot(String id, boolean nullSafe) {
            super(nullSafe);
            this.id = id;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return prevTip.dotAccess(this.id);
        }
    }

    private static final class Bracket
    extends ChainAccess {
        final CodeChunk.WithValue value;

        Bracket(CodeChunk.WithValue value, boolean nullSafe) {
            super(nullSafe);
            this.value = value;
        }

        @Override
        CodeChunk.WithValue extend(CodeChunk.WithValue prevTip) {
            return prevTip.bracketAccess(this.value);
        }
    }

    private static abstract class ChainAccess {
        final boolean nullSafe;

        abstract CodeChunk.WithValue extend(CodeChunk.WithValue var1);

        ChainAccess(boolean nullSafe) {
            this.nullSafe = nullSafe;
        }
    }
}

