/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.DelTemplateNamer;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.VeLogInstrumentationVisitor;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.InsertMsgsVisitor;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class JsSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SoyTypeRegistry typeRegistry;

    public JsSrcMain(GuiceSimpleScope apiCallScope, SoyTypeRegistry typeRegistry) {
        this.apiCallScope = apiCallScope;
        this.typeRegistry = typeRegistry;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle, ErrorReporter errorReporter) {
        Preconditions.checkState((!jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir() || jsSrcOptions.shouldProvideRequireSoyNamespaces() || jsSrcOptions.shouldProvideRequireJsFunctions() ? 1 : 0) != 0, (Object)"Do not specify useGoogIsRtlForBidiGlobalDir without either shouldProvideRequireSoyNamespaces or shouldProvideRequireJsFunctions.");
        new VeLogInstrumentationVisitor(templateRegistry).exec(soyTree);
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(jsSrcOptions.getBidiGlobalDir(), jsSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(inScope, msgBundle, bidiGlobalDir);
            if (jsSrcOptions.shouldGenerateGoogMsgDefs()) {
                Preconditions.checkState((bidiGlobalDir != null ? 1 : 0) != 0, (Object)"If enabling shouldGenerateGoogMsgDefs, must also set bidi global directionality.");
            } else {
                Preconditions.checkState((bidiGlobalDir == null || bidiGlobalDir.isStaticValue() ? 1 : 0) != 0, (Object)"If using bidiGlobalIsRtlCodeSnippet, must also enable shouldGenerateGoogMsgDefs.");
                new InsertMsgsVisitor(msgBundle, errorReporter).insertMsgs(soyTree);
            }
            new CombineConsecutiveRawTextNodesPass().run(soyTree);
            List<String> list = JsSrcMain.createVisitor(jsSrcOptions, this.typeRegistry).gen(soyTree, templateRegistry, errorReporter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyJsSrcOptions jsSrcOptions, @Nullable String locale, @Nullable SoyMsgBundle msgBundle, String outputPathFormat, String inputPathsPrefix, ErrorReporter errorReporter) throws IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, templateRegistry, jsSrcOptions, msgBundle, errorReporter);
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != jsFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), jsFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(locale, outputPathFormat, inputPathsPrefix, (ImmutableList<SoyFileNode>)srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);){
                boolean isFirst = true;
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
        }
    }

    static GenJsCodeVisitor createVisitor(final SoyJsSrcOptions options, SoyTypeRegistry typeRegistry) {
        GenJsExprsVisitor.GenJsExprsVisitorFactory genJsExprsVisitorFactory;
        final DelTemplateNamer delTemplateNamer = new DelTemplateNamer();
        final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor = new IsComputableAsJsExprsVisitor();
        CanInitOutputVarVisitor canInitOutputVarVisitor = new CanInitOutputVarVisitor(isComputableAsJsExprsVisitor);
        class GenCallCodeUtilsSupplier
        implements Supplier<GenCallCodeUtils> {
            GenJsExprsVisitor.GenJsExprsVisitorFactory factory;

            GenCallCodeUtilsSupplier() {
            }

            public GenCallCodeUtils get() {
                return new GenCallCodeUtils(options, delTemplateNamer, isComputableAsJsExprsVisitor, this.factory);
            }
        }
        GenCallCodeUtilsSupplier supplier = new GenCallCodeUtilsSupplier();
        supplier.factory = genJsExprsVisitorFactory = new GenJsExprsVisitor.GenJsExprsVisitorFactory(options, supplier, isComputableAsJsExprsVisitor);
        return new GenJsCodeVisitor(options, delTemplateNamer, supplier.get(), isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, typeRegistry);
    }
}

