/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Concatenation;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;

@Immutable
abstract class Concatenation
extends Operation {
    Concatenation() {
    }

    static Concatenation create(Iterable<? extends CodeChunk.WithValue> parts) {
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        for (CodeChunk.WithValue withValue : parts) {
            initialStatements.addAll(withValue.initialStatements());
            if (withValue instanceof Concatenation) {
                partsBuilder.addAll(((Concatenation)withValue).parts());
                continue;
            }
            if (withValue instanceof BinaryOperation) {
                BinaryOperation binaryOp = (BinaryOperation)withValue;
                if (binaryOp.operator().equals(Operator.PLUS.getTokenString())) {
                    partsBuilder.add((Object)binaryOp.arg1());
                    partsBuilder.add((Object)binaryOp.arg2());
                    continue;
                }
                partsBuilder.add((Object)withValue);
                continue;
            }
            partsBuilder.add((Object)withValue);
        }
        return new AutoValue_Concatenation((ImmutableList<CodeChunk>)initialStatements.build(), (ImmutableList<CodeChunk.WithValue>)partsBuilder.build());
    }

    abstract ImmutableList<CodeChunk.WithValue> parts();

    @Override
    int precedence() {
        return Operator.PLUS.getPrecedence();
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.PLUS.getAssociativity();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue part : this.parts()) {
            part.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.parts().isEmpty()) {
            ctx.append("''");
        } else if (this.parts().size() == 1) {
            ctx.appendOutputExpression((CodeChunk.WithValue)this.parts().get(0));
        } else {
            this.formatOperand((CodeChunk.WithValue)this.parts().get(0), OperandPosition.LEFT, ctx);
            for (int i = 1; i < this.parts().size(); ++i) {
                ctx.append(" + ");
                this.formatOperand((CodeChunk.WithValue)this.parts().get(i), OperandPosition.RIGHT, ctx);
            }
        }
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk.WithValue part : this.parts()) {
            ctx.appendInitialStatements(part);
        }
    }
}

