/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.DetachState;
import com.google.template.soy.jbcsrc.PrintDirectives;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralCaseSpec;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralRemainderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.msgs.restricted.SoyMsgSelectPart;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;

final class MsgCompiler {
    private static final ConstructorRef SOY_MSG_PLACEHOLDER_PART = ConstructorRef.create(SoyMsgPlaceholderPart.class, String.class, String.class);
    private static final ConstructorRef SOY_MSG_PLURAL_REMAINDER_PART = ConstructorRef.create(SoyMsgPluralRemainderPart.class, String.class);
    private static final ConstructorRef SOY_MSG_PURAL_PART = ConstructorRef.create(SoyMsgPluralPart.class, String.class, Integer.TYPE, Iterable.class);
    private static final ConstructorRef SOY_MSG_SELECT_PART = ConstructorRef.create(SoyMsgSelectPart.class, String.class, Iterable.class);
    private static final MethodRef SOY_MSG_RAW_TEXT_PART_OF = MethodRef.create(SoyMsgRawTextPart.class, "of", String.class);
    private static final MethodRef CASE_CREATE = MethodRef.create(SoyMsgPart.Case.class, "create", Object.class, Iterable.class);
    private static final ConstructorRef SOY_MSG_PLURAL_CASE_SPEC_TYPE = ConstructorRef.create(SoyMsgPluralCaseSpec.class, SoyMsgPluralCaseSpec.Type.class);
    private static final ConstructorRef SOY_MSG_PLURAL_CASE_SPEC_LONG = ConstructorRef.create(SoyMsgPluralCaseSpec.class, Long.TYPE);
    private final Expression thisVar;
    private final DetachState detachState;
    private final TemplateVariableManager variables;
    private final TemplateParameterLookup parameterLookup;
    private final AppendableExpression appendableExpression;
    private final SoyNodeToStringCompiler soyNodeCompiler;

    MsgCompiler(Expression thisVar, DetachState detachState, TemplateVariableManager variables, TemplateParameterLookup parameterLookup, AppendableExpression appendableExpression, SoyNodeToStringCompiler soyNodeCompiler) {
        this.thisVar = (Expression)Preconditions.checkNotNull((Object)thisVar);
        this.detachState = (DetachState)Preconditions.checkNotNull((Object)detachState);
        this.variables = (TemplateVariableManager)Preconditions.checkNotNull((Object)variables);
        this.parameterLookup = (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameterLookup);
        this.appendableExpression = (AppendableExpression)Preconditions.checkNotNull((Object)appendableExpression);
        this.soyNodeCompiler = (SoyNodeToStringCompiler)Preconditions.checkNotNull((Object)soyNodeCompiler);
    }

    Statement compileMessage(MsgUtils.MsgPartsAndIds partsAndId, MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives) {
        Expression soyMsgDefaultParts = this.compileDefaultMessagePartsConstant(partsAndId);
        Expression soyMsgParts = this.parameterLookup.getRenderContext().getSoyMsgParts(partsAndId.id, soyMsgDefaultParts);
        Statement printMsg = msg.isRawTextMsg() ? this.handleBasicTranslation((List<SoyPrintDirective>)escapingDirectives, soyMsgParts) : this.handleTranslationWithPlaceholders(msg, escapingDirectives, soyMsgParts, this.parameterLookup.getRenderContext().getULocale(), partsAndId.parts);
        return Statement.concat(printMsg.withSourceLocation(msg.getSourceLocation()), this.detachState.detachLimited(this.appendableExpression));
    }

    private Expression compileDefaultMessagePartsConstant(MsgUtils.MsgPartsAndIds partsAndId) {
        return this.variables.addStaticField("msg_parts_" + partsAndId.id, this.partsToPartsList(partsAndId.parts)).accessor();
    }

    private Expression partsToPartsList(ImmutableList<SoyMsgPart> parts) throws AssertionError {
        ArrayList<Expression> partsExprs = new ArrayList<Expression>(parts.size());
        for (SoyMsgPart part : parts) {
            partsExprs.add(this.partToPartExpression(part));
        }
        return BytecodeUtils.asImmutableList(partsExprs);
    }

    private Expression partToPartExpression(SoyMsgPart part) {
        if (part instanceof SoyMsgPlaceholderPart) {
            return SOY_MSG_PLACEHOLDER_PART.construct(BytecodeUtils.constant(((SoyMsgPlaceholderPart)part).getPlaceholderName()), BytecodeUtils.constantNull(BytecodeUtils.STRING_TYPE));
        }
        if (part instanceof SoyMsgPluralPart) {
            SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)part;
            ArrayList<Expression> caseExprs = new ArrayList<Expression>(pluralPart.getCases().size());
            for (SoyMsgPart.Case item : pluralPart.getCases()) {
                Expression spec = ((SoyMsgPluralCaseSpec)item.spec()).getType() == SoyMsgPluralCaseSpec.Type.EXPLICIT ? SOY_MSG_PLURAL_CASE_SPEC_LONG.construct(BytecodeUtils.constant(((SoyMsgPluralCaseSpec)item.spec()).getExplicitValue())) : SOY_MSG_PLURAL_CASE_SPEC_TYPE.construct(FieldRef.enumReference(((SoyMsgPluralCaseSpec)item.spec()).getType()).accessor());
                caseExprs.add(CASE_CREATE.invoke(spec, this.partsToPartsList(item.parts())));
            }
            return SOY_MSG_PURAL_PART.construct(BytecodeUtils.constant(pluralPart.getPluralVarName()), BytecodeUtils.constant(pluralPart.getOffset()), BytecodeUtils.asList(caseExprs));
        }
        if (part instanceof SoyMsgPluralRemainderPart) {
            return SOY_MSG_PLURAL_REMAINDER_PART.construct(BytecodeUtils.constant(((SoyMsgPluralRemainderPart)part).getPluralVarName()));
        }
        if (part instanceof SoyMsgRawTextPart) {
            return SOY_MSG_RAW_TEXT_PART_OF.invoke(BytecodeUtils.constant(((SoyMsgRawTextPart)part).getRawText(), this.variables));
        }
        if (part instanceof SoyMsgSelectPart) {
            SoyMsgSelectPart selectPart = (SoyMsgSelectPart)part;
            ArrayList<Expression> caseExprs = new ArrayList<Expression>(selectPart.getCases().size());
            for (SoyMsgPart.Case item : selectPart.getCases()) {
                caseExprs.add(CASE_CREATE.invoke(item.spec() == null ? BytecodeUtils.constantNull(BytecodeUtils.STRING_TYPE) : BytecodeUtils.constant((String)item.spec()), this.partsToPartsList(item.parts())));
            }
            return SOY_MSG_SELECT_PART.construct(BytecodeUtils.constant(selectPart.getSelectVarName()), BytecodeUtils.asList(caseExprs));
        }
        throw new AssertionError((Object)("unrecognized part: " + part));
    }

    private Statement handleBasicTranslation(List<SoyPrintDirective> escapingDirectives, Expression soyMsgParts) {
        SoyExpression text = SoyExpression.forString(soyMsgParts.invoke(MethodRef.LIST_GET, BytecodeUtils.constant(0)).checkedCast(SoyMsgRawTextPart.class).invoke(MethodRef.SOY_MSG_RAW_TEXT_PART_GET_RAW_TEXT, new Expression[0]));
        for (SoyPrintDirective directive : escapingDirectives) {
            text = this.parameterLookup.getRenderContext().applyPrintDirective(directive, text);
        }
        return this.appendableExpression.appendString(text.coerceToString()).toStatement();
    }

    private Statement handleTranslationWithPlaceholders(MsgNode msg, ImmutableList<SoyPrintDirective> escapingDirectives, Expression soyMsgParts, Expression locale, ImmutableList<SoyMsgPart> parts) {
        Statement render;
        Expression placeholderMap = this.variables.getMsgPlaceholderMapField().accessor(this.thisVar);
        LinkedHashMap<String, Statement> placeholderNameToPutStatement = new LinkedHashMap<String, Statement>();
        this.putPlaceholdersIntoMap(placeholderMap, msg, (Iterable<? extends SoyMsgPart>)parts, (Map<String, Statement>)placeholderNameToPutStatement);
        Preconditions.checkState((!placeholderNameToPutStatement.isEmpty() ? 1 : 0) != 0);
        this.variables.setMsgPlaceholderMapMinSize(placeholderNameToPutStatement.size());
        Statement populateMap = Statement.concat(placeholderNameToPutStatement.values());
        Statement clearMap = placeholderMap.invokeVoid(MethodRef.LINKED_HASH_MAP_CLEAR, new Expression[0]);
        if (PrintDirectives.areAllPrintDirectivesStreamable(escapingDirectives)) {
            SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions wrappedAppendable = PrintDirectives.applyStreamingEscapingDirectives(escapingDirectives, this.appendableExpression, this.parameterLookup.getRenderContext(), this.variables);
            Statement initAppendable = Statement.NULL_STATEMENT;
            Statement clearAppendable = Statement.NULL_STATEMENT;
            Expression appendableExpression = wrappedAppendable.appendable();
            if (wrappedAppendable.closeable()) {
                TemplateVariableManager.Scope scope = this.variables.enterScope();
                TemplateVariableManager.Variable appendableVar = scope.createTemporary("msg_appendable", wrappedAppendable.appendable());
                initAppendable = appendableVar.initializer();
                appendableExpression = appendableVar.local();
                clearAppendable = Statement.concat(appendableVar.local().checkedCast(BytecodeUtils.CLOSEABLE_TYPE).invokeVoid(MethodRef.CLOSEABLE_CLOSE, new Expression[0]), scope.exitScope());
            }
            render = Statement.concat(initAppendable, MethodRef.RUNTIME_RENDER_SOY_MSG_PARTS_WITH_PLACEHOLDERS.invokeVoid(soyMsgParts, locale, placeholderMap, appendableExpression), clearAppendable);
        } else {
            Statement renderToBuffer = MethodRef.RUNTIME_RENDER_SOY_MSG_PARTS_WITH_PLACEHOLDERS.invokeVoid(soyMsgParts, locale, placeholderMap, this.tempBuffer());
            SoyExpression value = SoyExpression.forString(this.tempBuffer().invoke(MethodRef.ADVISING_STRING_BUILDER_GET_AND_CLEAR, new Expression[0]));
            for (SoyPrintDirective directive : escapingDirectives) {
                value = this.parameterLookup.getRenderContext().applyPrintDirective(directive, value);
            }
            render = Statement.concat(renderToBuffer, this.appendableExpression.appendString(value.coerceToString()).toStatement());
        }
        return Statement.concat(populateMap, render, clearMap);
    }

    private void putPlaceholdersIntoMap(Expression mapExpression, MsgNode originalMsg, Iterable<? extends SoyMsgPart> parts, Map<String, Statement> placeholderNameToPutStatement) {
        for (SoyMsgPart soyMsgPart : parts) {
            if (soyMsgPart instanceof SoyMsgRawTextPart || soyMsgPart instanceof SoyMsgPluralRemainderPart) continue;
            if (soyMsgPart instanceof SoyMsgPluralPart) {
                this.putPluralPartIntoMap(mapExpression, originalMsg, placeholderNameToPutStatement, (SoyMsgPluralPart)soyMsgPart);
                continue;
            }
            if (soyMsgPart instanceof SoyMsgSelectPart) {
                this.putSelectPartIntoMap(mapExpression, originalMsg, placeholderNameToPutStatement, (SoyMsgSelectPart)soyMsgPart);
                continue;
            }
            if (soyMsgPart instanceof SoyMsgPlaceholderPart) {
                this.putPlaceholderIntoMap(mapExpression, originalMsg, placeholderNameToPutStatement, (SoyMsgPlaceholderPart)soyMsgPart);
                continue;
            }
            throw new AssertionError((Object)("unexpected child: " + soyMsgPart));
        }
    }

    private void putSelectPartIntoMap(Expression mapExpression, MsgNode originalMsg, Map<String, Statement> placeholderNameToPutStatement, SoyMsgSelectPart select) {
        MsgSelectNode repSelectNode = originalMsg.getRepSelectNode(select.getSelectVarName());
        if (!placeholderNameToPutStatement.containsKey(select.getSelectVarName())) {
            Label reattachPoint = new Label();
            Expression value = this.soyNodeCompiler.compileToString(repSelectNode.getExpr(), reattachPoint);
            placeholderNameToPutStatement.put(select.getSelectVarName(), this.putToMap(mapExpression, select.getSelectVarName(), value).labelStart(reattachPoint));
        }
        for (SoyMsgPart.Case caseOrDefault : select.getCases()) {
            this.putPlaceholdersIntoMap(mapExpression, originalMsg, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts(), placeholderNameToPutStatement);
        }
    }

    private void putPluralPartIntoMap(Expression mapExpression, MsgNode originalMsg, Map<String, Statement> placeholderNameToPutStatement, SoyMsgPluralPart plural) {
        MsgPluralNode repPluralNode = originalMsg.getRepPluralNode(plural.getPluralVarName());
        if (!placeholderNameToPutStatement.containsKey(plural.getPluralVarName())) {
            Label reattachPoint = new Label();
            Expression value = this.soyNodeCompiler.compileToInt(repPluralNode.getExpr(), reattachPoint);
            placeholderNameToPutStatement.put(plural.getPluralVarName(), this.putToMap(mapExpression, plural.getPluralVarName(), value).labelStart(reattachPoint).withSourceLocation(repPluralNode.getSourceLocation()));
        }
        for (SoyMsgPart.Case caseOrDefault : plural.getCases()) {
            this.putPlaceholdersIntoMap(mapExpression, originalMsg, (Iterable<? extends SoyMsgPart>)caseOrDefault.parts(), placeholderNameToPutStatement);
        }
    }

    private void putPlaceholderIntoMap(Expression mapExpression, MsgNode originalMsg, Map<String, Statement> placeholderNameToPutStatement, SoyMsgPlaceholderPart placeholder) throws AssertionError {
        String placeholderName = placeholder.getPlaceholderName();
        if (!placeholderNameToPutStatement.containsKey(placeholderName)) {
            Statement putEntyInMap;
            MsgPlaceholderNode repPlaceholderNode = originalMsg.getRepPlaceholderNode(placeholder.getPlaceholderName());
            if (repPlaceholderNode.numChildren() == 0) {
                throw new IllegalStateException("empty rep node for: " + placeholderName);
            }
            SoyNode.StandaloneNode initialNode = (SoyNode.StandaloneNode)repPlaceholderNode.getChild(0);
            if (initialNode instanceof MsgHtmlTagNode) {
                putEntyInMap = this.addHtmlTagNodeToPlaceholderMap(mapExpression, placeholderName, (MsgHtmlTagNode)initialNode);
            } else if (initialNode instanceof CallNode) {
                putEntyInMap = this.addCallNodeToPlaceholderMap(mapExpression, placeholderName, (CallNode)initialNode);
            } else if (initialNode instanceof PrintNode) {
                putEntyInMap = this.addPrintNodeToPlaceholderMap(mapExpression, placeholderName, (PrintNode)initialNode);
            } else if (initialNode instanceof RawTextNode) {
                putEntyInMap = this.addRawTextNodeToPlaceholderMap(mapExpression, placeholderName, (RawTextNode)initialNode);
            } else {
                throw new AssertionError((Object)("Unexpected child: " + initialNode.getClass()));
            }
            placeholderNameToPutStatement.put(placeholder.getPlaceholderName(), putEntyInMap.withSourceLocation(repPlaceholderNode.getSourceLocation()));
        }
    }

    private Statement addRawTextNodeToPlaceholderMap(Expression mapExpression, String mapKey, RawTextNode rawText) {
        return mapExpression.invoke(MethodRef.LINKED_HASH_MAP_PUT, BytecodeUtils.constant(mapKey), BytecodeUtils.constant(rawText.getRawText(), this.variables)).toStatement().withSourceLocation(rawText.getSourceLocation());
    }

    private Statement addHtmlTagNodeToPlaceholderMap(Expression mapExpression, String mapKey, MsgHtmlTagNode htmlTagNode) {
        Statement putStatement;
        Optional<String> rawText = this.tryGetRawTextContent(htmlTagNode);
        if (rawText.isPresent()) {
            putStatement = mapExpression.invoke(MethodRef.LINKED_HASH_MAP_PUT, BytecodeUtils.constant(mapKey), BytecodeUtils.constant((String)rawText.get())).toStatement();
        } else {
            Statement renderIntoBuffer = this.soyNodeCompiler.compileToBuffer(htmlTagNode, this.tempBuffer());
            Statement putBuffer = this.putBufferIntoMapForPlaceholder(mapExpression, mapKey);
            putStatement = Statement.concat(renderIntoBuffer, putBuffer);
        }
        return putStatement.withSourceLocation(htmlTagNode.getSourceLocation());
    }

    private Statement addCallNodeToPlaceholderMap(Expression mapExpression, String mapKey, CallNode callNode) {
        Statement renderIntoBuffer = this.soyNodeCompiler.compileToBuffer(callNode, this.tempBuffer());
        Statement putBuffer = this.putBufferIntoMapForPlaceholder(mapExpression, mapKey);
        return Statement.concat(renderIntoBuffer, putBuffer).withSourceLocation(callNode.getSourceLocation());
    }

    private Statement addPrintNodeToPlaceholderMap(Expression mapExpression, String mapKey, PrintNode printNode) {
        Label reattachPoint = new Label();
        Expression compileToString = this.soyNodeCompiler.compileToString(printNode, reattachPoint);
        return this.putToMap(mapExpression, mapKey, compileToString).labelStart(reattachPoint).withSourceLocation(printNode.getSourceLocation());
    }

    private Statement putToMap(Expression mapExpression, String mapKey, Expression valueExpression) {
        return mapExpression.invoke(MethodRef.LINKED_HASH_MAP_PUT, BytecodeUtils.constant(mapKey), valueExpression).toStatement();
    }

    private AppendableExpression tempBuffer() {
        return AppendableExpression.forStringBuilder(this.variables.getTempBufferField().accessor(this.thisVar));
    }

    private Statement putBufferIntoMapForPlaceholder(Expression mapExpression, String mapKey) {
        return mapExpression.invoke(MethodRef.LINKED_HASH_MAP_PUT, BytecodeUtils.constant(mapKey), this.tempBuffer().invoke(MethodRef.ADVISING_STRING_BUILDER_GET_AND_CLEAR, new Expression[0])).toStatement();
    }

    private Optional<String> tryGetRawTextContent(SoyNode.ParentSoyNode<?> initialNode) {
        if (initialNode.numChildren() == 1 && initialNode.getChild(0) instanceof RawTextNode) {
            return Optional.of((Object)((RawTextNode)initialNode.getChild(0)).getRawText());
        }
        return Optional.absent();
    }

    static interface SoyNodeToStringCompiler {
        public Expression compileToString(ExprRootNode var1, Label var2);

        public Expression compileToString(PrintNode var1, Label var2);

        public Expression compileToInt(ExprRootNode var1, Label var2);

        public Statement compileToBuffer(CallNode var1, AppendableExpression var2);

        public Statement compileToBuffer(MsgHtmlTagNode var1, AppendableExpression var2);
    }
}

