/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.html.HtmlEscapers;
import com.google.template.soy.data.Dir;
import com.google.template.soy.internal.i18n.AutoValue_BidiFormatter_BidiWrappingText;
import com.google.template.soy.internal.i18n.BidiUtils;
import javax.annotation.Nullable;

public class BidiFormatter {
    private static final BidiFormatter DEFAULT_LTR_INSTANCE = new BidiFormatter(Dir.LTR);
    private static final BidiFormatter DEFAULT_RTL_INSTANCE = new BidiFormatter(Dir.RTL);
    private final Dir contextDir;

    public static BidiFormatter getInstance(Dir contextDir) {
        switch (contextDir) {
            case LTR: {
                return DEFAULT_LTR_INSTANCE;
            }
            case RTL: {
                return DEFAULT_RTL_INSTANCE;
            }
        }
        throw new IllegalArgumentException("invalid context directionality: " + (Object)((Object)contextDir));
    }

    private BidiFormatter(@Nullable Dir contextDir) {
        this.contextDir = contextDir;
    }

    public String knownDirAttr(Dir dir) {
        Preconditions.checkNotNull((Object)((Object)dir));
        if (dir != this.contextDir) {
            return dir == Dir.LTR ? "dir=\"ltr\"" : (dir == Dir.RTL ? "dir=\"rtl\"" : "");
        }
        return "";
    }

    public String spanWrap(@Nullable Dir dir, String str, boolean isHtml) {
        BidiWrappingText wrappingText = this.spanWrappingText(dir, str, isHtml);
        if (!isHtml) {
            str = HtmlEscapers.htmlEscaper().escape(str);
        }
        return wrappingText.beforeText() + str + wrappingText.afterText();
    }

    public BidiWrappingText spanWrappingText(@Nullable Dir dir, String str, boolean isHtml) {
        boolean dirCondition;
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        StringBuilder beforeText = new StringBuilder();
        StringBuilder afterText = new StringBuilder();
        boolean bl = dirCondition = dir != Dir.NEUTRAL && dir != this.contextDir;
        if (dirCondition) {
            beforeText.append("<span dir=\"").append(dir == Dir.RTL ? "rtl" : "ltr").append("\">");
            afterText.append("</span>");
        }
        afterText.append(this.markAfter(dir, str, isHtml));
        return BidiWrappingText.create(beforeText.toString(), afterText.toString());
    }

    public String unicodeWrap(@Nullable Dir dir, String str, boolean isHtml) {
        BidiWrappingText wrappingText = this.unicodeWrappingText(dir, str, isHtml);
        return wrappingText.beforeText() + str + wrappingText.afterText();
    }

    public BidiWrappingText unicodeWrappingText(@Nullable Dir dir, String str, boolean isHtml) {
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        StringBuilder beforeText = new StringBuilder();
        StringBuilder afterText = new StringBuilder();
        if (dir != Dir.NEUTRAL && dir != this.contextDir) {
            beforeText.append(dir == Dir.RTL ? (char)'\u202b' : '\u202a');
            afterText.append('\u202c');
        }
        afterText.append(this.markAfter(dir, str, isHtml));
        return BidiWrappingText.create(beforeText.toString(), afterText.toString());
    }

    public String markAfter(@Nullable Dir dir, String str, boolean isHtml) {
        if (dir == null) {
            dir = BidiFormatter.estimateDirection(str, isHtml);
        }
        if (this.contextDir == Dir.LTR && (dir == Dir.RTL || BidiUtils.getExitDir(str, isHtml) == Dir.RTL)) {
            return BidiUtils.Format.LRM_STRING;
        }
        if (this.contextDir == Dir.RTL && (dir == Dir.LTR || BidiUtils.getExitDir(str, isHtml) == Dir.LTR)) {
            return BidiUtils.Format.RLM_STRING;
        }
        return "";
    }

    @VisibleForTesting
    static Dir estimateDirection(String str, boolean isHtml) {
        return BidiUtils.estimateDirection(str, isHtml);
    }

    public static abstract class BidiWrappingText {
        static BidiWrappingText create(String beforeText, String afterText) {
            return new AutoValue_BidiFormatter_BidiWrappingText(beforeText, afterText);
        }

        public abstract String beforeText();

        public abstract String afterText();
    }
}

