/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.NodeVisitor;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class RemoveUnnecessaryEscapingDirectives {
    private static final NodeVisitor<Node, SoyTreeUtils.VisitDirective> VISITOR = new NodeVisitor<Node, SoyTreeUtils.VisitDirective>(){

        @Override
        public SoyTreeUtils.VisitDirective exec(Node node) {
            if (node instanceof ExprNode) {
                return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
            }
            SoyNode soyNode = (SoyNode)node;
            switch (soyNode.getKind()) {
                case PRINT_NODE: {
                    PrintNode printNode = (PrintNode)soyNode;
                    for (int i = 0; i < printNode.numChildren(); ++i) {
                        PrintDirectiveNode pdn = (PrintDirectiveNode)printNode.getChild(i);
                        if (!pdn.isSynthetic() || !RemoveUnnecessaryEscapingDirectives.canSkip(pdn.getPrintDirective())) continue;
                        printNode.removeChild(i);
                        --i;
                    }
                    return SoyTreeUtils.VisitDirective.SKIP_CHILDREN;
                }
                case CALL_BASIC_NODE: 
                case CALL_DELEGATE_NODE: {
                    CallNode callNode = (CallNode)soyNode;
                    callNode.setEscapingDirectives((ImmutableList<SoyPrintDirective>)RemoveUnnecessaryEscapingDirectives.filterEscapingDirectives((ImmutableList<SoyPrintDirective>)callNode.getEscapingDirectives()));
                    return SoyTreeUtils.VisitDirective.CONTINUE;
                }
                case MSG_FALLBACK_GROUP_NODE: {
                    MsgFallbackGroupNode msgNode = (MsgFallbackGroupNode)soyNode;
                    msgNode.setEscapingDirectives((ImmutableList<SoyPrintDirective>)RemoveUnnecessaryEscapingDirectives.filterEscapingDirectives((ImmutableList<SoyPrintDirective>)msgNode.getEscapingDirectives()));
                    return SoyTreeUtils.VisitDirective.CONTINUE;
                }
            }
            return SoyTreeUtils.VisitDirective.CONTINUE;
        }
    };
    private static final ImmutableSet<String> SKIPPABLE_ESCAPING_MODES = ImmutableSet.of((Object)EscapingMode.ESCAPE_HTML.directiveName, (Object)EscapingMode.NORMALIZE_HTML.directiveName, (Object)EscapingMode.ESCAPE_HTML_RCDATA.directiveName, (Object)EscapingMode.ESCAPE_HTML_ATTRIBUTE.directiveName, (Object)EscapingMode.ESCAPE_HTML_ATTRIBUTE_NOSPACE.directiveName, (Object)EscapingMode.FILTER_HTML_ATTRIBUTES.directiveName, (Object[])new String[0]);

    RemoveUnnecessaryEscapingDirectives() {
    }

    void run(SoyFileSetNode fileSet) {
        for (SoyFileNode file : Iterables.filter(fileSet.getChildren(), SoyFileNode.MATCH_SRC_FILENODE)) {
            SoyTreeUtils.visitAllNodes(file, VISITOR);
        }
    }

    private static ImmutableList<SoyPrintDirective> filterEscapingDirectives(ImmutableList<SoyPrintDirective> escapingDirectives) {
        for (int i = 0; i < escapingDirectives.size(); ++i) {
            SoyPrintDirective directive = (SoyPrintDirective)escapingDirectives.get(i);
            if (!RemoveUnnecessaryEscapingDirectives.canSkip(directive)) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)escapingDirectives.subList(0, i));
            while (i < escapingDirectives.size()) {
                directive = (SoyPrintDirective)escapingDirectives.get(i);
                if (!RemoveUnnecessaryEscapingDirectives.canSkip(directive)) {
                    builder.add((Object)directive);
                }
                ++i;
            }
            return builder.build();
        }
        return escapingDirectives;
    }

    private static boolean canSkip(SoyPrintDirective printDirective) {
        return SKIPPABLE_ESCAPING_MODES.contains((Object)printDirective.getName());
    }
}

