/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.HtmlContextVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.RemoveUnnecessaryEscapingDirectives;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.incrementaldomsrc.UnescapingVisitor;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class IncrementalDomSrcMain {
    private final GuiceSimpleScope apiCallScope;
    private final SoyTypeRegistry typeRegistry;

    public IncrementalDomSrcMain(@ApiCallScopeBindingAnnotations.ApiCall GuiceSimpleScope apiCallScope, SoyTypeRegistry typeRegistry) {
        this.apiCallScope = apiCallScope;
        this.typeRegistry = typeRegistry;
    }

    public List<String> genJsSrc(SoyFileSetNode soyTree, TemplateRegistry registry, SoyIncrementalDomSrcOptions options, ErrorReporter errorReporter) {
        SoyJsSrcOptions incrementalJSSrcOptions = options.toJsSrcOptions();
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromJsOptions(incrementalJSSrcOptions.getBidiGlobalDir(), incrementalJSSrcOptions.getUseGoogIsRtlForBidiGlobalDir());
            ApiCallScopeUtils.seedSharedParams(inScope, null, bidiGlobalDir);
            new HtmlContextVisitor(errorReporter).exec(soyTree);
            if (errorReporter.hasErrors()) {
                List<String> list = Collections.emptyList();
                return list;
            }
            new UnescapingVisitor().exec(soyTree);
            new RemoveUnnecessaryEscapingDirectives().run(soyTree);
            new CombineConsecutiveRawTextNodesPass().run(soyTree);
            List<String> list = IncrementalDomSrcMain.createVisitor(incrementalJSSrcOptions, this.typeRegistry).gen(soyTree, registry, errorReporter);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void genJsFiles(SoyFileSetNode soyTree, TemplateRegistry templateRegistry, SoyIncrementalDomSrcOptions jsSrcOptions, String outputPathFormat, ErrorReporter errorReporter) throws IOException {
        List<String> jsFileContents = this.genJsSrc(soyTree, templateRegistry, jsSrcOptions, errorReporter);
        if (errorReporter.hasErrors()) {
            return;
        }
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        if (srcsToCompile.size() != jsFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), jsFileContents.size()));
        }
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, "", (ImmutableList<SoyFileNode>)srcsToCompile);
        for (String outputFilePath : outputs.keySet()) {
            try (BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);){
                boolean isFirst = true;
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        out.write("\n;\n");
                    }
                    out.write(jsFileContents.get(inputFileIndex));
                }
            }
        }
    }

    static GenIncrementalDomCodeVisitor createVisitor(final SoyJsSrcOptions options, SoyTypeRegistry typeRegistry) {
        GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genJsExprsVisitorFactory;
        final IncrementalDomDelTemplateNamer delTemplateNamer = new IncrementalDomDelTemplateNamer();
        final IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor = new IsComputableAsIncrementalDomExprsVisitor();
        CanInitOutputVarVisitor canInitOutputVarVisitor = new CanInitOutputVarVisitor(isComputableAsJsExprsVisitor);
        class GenCallCodeUtilsSupplier
        implements Supplier<IncrementalDomGenCallCodeUtils> {
            GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory factory;

            GenCallCodeUtilsSupplier() {
            }

            public IncrementalDomGenCallCodeUtils get() {
                return new IncrementalDomGenCallCodeUtils(options, delTemplateNamer, isComputableAsJsExprsVisitor, this.factory);
            }
        }
        GenCallCodeUtilsSupplier supplier = new GenCallCodeUtilsSupplier();
        supplier.factory = genJsExprsVisitorFactory = new GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory(options, supplier, isComputableAsJsExprsVisitor);
        return new GenIncrementalDomCodeVisitor(options, delTemplateNamer, supplier.get(), isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genJsExprsVisitorFactory, typeRegistry);
    }
}

