/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.incrementaldomsrc.AssistantForHtmlMsgs;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomExprsVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomCodeBuilder;
import com.google.template.soy.incrementaldomsrc.IncrementalDomDelTemplateNamer;
import com.google.template.soy.incrementaldomsrc.IncrementalDomGenCallCodeUtils;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.incrementaldomsrc.IsComputableAsIncrementalDomExprsVisitor;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.CanInitOutputVarVisitor;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslateExprNodeVisitor;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class GenIncrementalDomCodeVisitor
extends GenJsCodeVisitor {
    private static final SoyErrorKind PRINT_ATTR_INVALID_KIND = SoyErrorKind.of("For Incremental DOM, '{print}' statements in attributes context can only be of kind attributes (since they must compile to semantic attribute declarations).{0} is not allowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NULL_COALESCING_NON_EMPTY = SoyErrorKind.of("The only supported conditional for attribute and HTML values in incremental DOM is '{'$value ?: '''''}'.  The right operand must be empty.", new SoyErrorKind.StyleAllowance[0]);
    private static final String NAMESPACE_EXTENSION = ".incrementaldom";
    private static final String KEY_ATTRIBUTE_NAME = "key";

    GenIncrementalDomCodeVisitor(SoyJsSrcOptions jsSrcOptions, IncrementalDomDelTemplateNamer incrementalDomDelTemplateNamer, IncrementalDomGenCallCodeUtils genCallCodeUtils, IsComputableAsIncrementalDomExprsVisitor isComputableAsJsExprsVisitor, CanInitOutputVarVisitor canInitOutputVarVisitor, GenIncrementalDomExprsVisitor.GenIncrementalDomExprsVisitorFactory genIncrementalDomExprsVisitorFactory, SoyTypeRegistry typeRegistry) {
        super(jsSrcOptions, incrementalDomDelTemplateNamer, genCallCodeUtils, isComputableAsJsExprsVisitor, canInitOutputVarVisitor, genIncrementalDomExprsVisitorFactory, typeRegistry);
    }

    @Override
    protected JsCodeBuilder createCodeBuilder() {
        return new IncrementalDomCodeBuilder();
    }

    @Override
    protected IncrementalDomCodeBuilder createChildJsCodeBuilder() {
        return new IncrementalDomCodeBuilder(this.getJsCodeBuilder());
    }

    @Override
    protected IncrementalDomCodeBuilder getJsCodeBuilder() {
        return (IncrementalDomCodeBuilder)super.getJsCodeBuilder();
    }

    @Override
    protected void visit(SoyNode node) {
        try {
            super.visit(node);
        }
        catch (RuntimeException e) {
            throw new Error("error from : " + (Object)((Object)node.getKind()) + " @ " + node.getSourceLocation(), e);
        }
    }

    @Override
    protected String getGoogModuleNamespace(String soyNamespace) {
        return soyNamespace + NAMESPACE_EXTENSION;
    }

    @Override
    protected String getTemplateReturnType(TemplateNode node) {
        if (this.isTextContent(node.getContentKind())) {
            return super.getTemplateReturnType(node);
        }
        return "void";
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.getJsCodeBuilder().setContentKind(node.getContentKind());
        super.visitTemplateNode(node);
    }

    @Override
    protected CodeChunk generateFunctionBody(TemplateNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        boolean isTextTemplate = this.isTextContent(node.getContentKind());
        CodeChunk typeChecks = this.genParamTypeChecks(node);
        if (isTextTemplate) {
            jsCodeBuilder.pushOutputVar("output").setOutputVarInited();
        }
        CodeChunk body = this.visitChildrenReturningCodeChunk(node);
        if (isTextTemplate) {
            VariableDeclaration declare = VariableDeclaration.builder("output").setRhs(CodeChunk.LITERAL_EMPTY_STRING).build();
            jsCodeBuilder.popOutputVar();
            body = CodeChunk.statements(declare, body, CodeChunk.return_(this.sanitize(declare.ref(), node.getContentKind())));
        }
        return CodeChunk.statements(typeChecks, body);
    }

    @Override
    protected void visitChildren(SoyNode.ParentSoyNode<?> node) {
        for (SoyNode child : node.getChildren()) {
            this.visit(child);
        }
    }

    private void visitLetParamContentNode(SoyNode.RenderUnitNode node, String generatedVarName) {
        CodeChunk definition;
        Preconditions.checkState((node.getContentKind() != null ? 1 : 0) != 0);
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind prevContentKind = jsCodeBuilder.getContentKind();
        jsCodeBuilder.setContentKind(node.getContentKind());
        switch (node.getContentKind()) {
            case HTML: 
            case ATTRIBUTES: {
                definition = VariableDeclaration.builder(generatedVarName).setRhs(CodeChunk.function((Iterable<String>)ImmutableList.of(), this.visitChildrenReturningCodeChunk(node))).build();
                break;
            }
            default: {
                String outputVarName = generatedVarName + "_output";
                jsCodeBuilder.pushOutputVar(outputVarName).setOutputVarInited();
                definition = CodeChunk.statements(VariableDeclaration.builder(outputVarName).setRhs(CodeChunk.LITERAL_EMPTY_STRING).build(), this.visitChildrenReturningCodeChunk(node), VariableDeclaration.builder(generatedVarName).setRhs(JsRuntime.sanitizedContentOrdainerFunctionForInternalBlocks(node.getContentKind()).call(CodeChunk.id(outputVarName))).build());
                jsCodeBuilder.popOutputVar();
            }
        }
        jsCodeBuilder.setContentKind(prevContentKind);
        jsCodeBuilder.append(definition);
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        String generatedVarName = node.getUniqueVarName();
        this.visitLetParamContentNode(node, generatedVarName);
        this.templateTranslationContext.soyToJsVariableMappings().put(node.getVarName(), CodeChunk.id(generatedVarName));
    }

    @Override
    protected void visitCallParamContentNode(CallParamContentNode node) {
        String generatedVarName = "param" + node.getId();
        this.visitLetParamContentNode(node, generatedVarName);
    }

    @Override
    protected void visitCallNode(CallNode node) {
        for (CallParamNode child : node.getChildren()) {
            if (!(child instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(child)).booleanValue()) continue;
            this.visit(child);
        }
        CodeChunk.WithValue call = this.genCallCodeUtils.gen(node, this.templateAliases, this.templateTranslationContext, this.errorReporter);
        switch (this.getJsCodeBuilder().getContentKind()) {
            case ATTRIBUTES: {
                this.getJsCodeBuilder().append(call);
                break;
            }
            case HTML: {
                Optional<SanitizedContentKind> kind = this.templateRegistry.getCallContentKind(node);
                if (!kind.isPresent()) {
                    call = IncrementalDomRuntime.SOY_IDOM_RENDER_DYNAMIC_CONTENT.call(call);
                } else if (this.isTextContent((SanitizedContentKind)((Object)kind.get()))) {
                    call = this.generateTextCall(call);
                }
                this.getJsCodeBuilder().append(call);
                break;
            }
            case JS: 
            case URI: 
            case TRUSTED_RESOURCE_URI: 
            case CSS: 
            case TEXT: {
                this.getJsCodeBuilder().addChunkToOutputVar(call);
            }
        }
    }

    @Override
    protected void visitIfNode(IfNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        SanitizedContentKind currentContentKind = jsCodeBuilder.getContentKind();
        if (!this.isTextContent(currentContentKind)) {
            super.generateNonExpressionIfNode(node);
        } else {
            super.visitIfNode(node);
        }
    }

    private CodeChunk.WithValue generateTextCall(CodeChunk.WithValue textValue) {
        CodeChunk.Generator cg = this.templateTranslationContext.codeGenerator();
        CodeChunk.WithValue var = cg.declarationBuilder().setRhs(textValue).build().ref();
        return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(var).withInitialStatements((Iterable<? extends CodeChunk>)ImmutableList.of((Object)JsRuntime.GOOG_ASSERTS_ASSERT.call(var.doubleNotEquals(CodeChunk.LITERAL_NULL))));
    }

    private boolean isTextContent(SanitizedContentKind contentKind) {
        return contentKind != SanitizedContentKind.HTML && contentKind != SanitizedContentKind.ATTRIBUTES;
    }

    @Override
    protected void visitHtmlAttributeNode(HtmlAttributeNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.hasValue() || ((SoyNode.StandaloneNode)node.getChild(0)).getKind() == SoyNode.Kind.RAW_TEXT_NODE) {
            RawTextNode attrName = (RawTextNode)node.getChild(0);
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ATTR.call(CodeChunk.stringLiteral(attrName.getRawText()), CodeChunkUtils.concatChunksForceString(this.getAttributeValues(node))));
        } else {
            this.visitChildren(node);
        }
    }

    @Override
    protected void visitHtmlAttributeValueNode(HtmlAttributeValueNode node) {
        this.visitChildren(node);
    }

    private List<CodeChunk.WithValue> getAttributeValues(HtmlAttributeNode node) {
        if (!node.hasValue()) {
            return ImmutableList.of((Object)CodeChunk.LITERAL_EMPTY_STRING);
        }
        HtmlAttributeValueNode value = (HtmlAttributeValueNode)node.getChild(1);
        if (!this.isComputableAsJsExprsVisitor.execOnChildren(value).booleanValue()) {
            String outputVar = "html_attribute_" + node.getId();
            this.getJsCodeBuilder().pushOutputVar(outputVar).setOutputVarInited();
            SanitizedContentKind prev = this.getJsCodeBuilder().getContentKind();
            this.getJsCodeBuilder().setContentKind(SanitizedContentKind.TEXT);
            CodeChunk appends = this.visitChildrenReturningCodeChunk(value);
            this.getJsCodeBuilder().popOutputVar();
            this.getJsCodeBuilder().setContentKind(prev);
            return ImmutableList.of((Object)CodeChunk.id(outputVar).withInitialStatements((Iterable<? extends CodeChunk>)ImmutableList.of((Object)VariableDeclaration.builder(outputVar).setRhs(CodeChunk.LITERAL_EMPTY_STRING).build(), (Object)appends)));
        }
        return this.genJsExprsVisitor.execOnChildren(value);
    }

    private void emitOpenStartEndAndVisitSubtree(HtmlOpenTagNode node, String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        ArrayList<CodeChunk.WithValue> args = new ArrayList<CodeChunk.WithValue>();
        args.add(CodeChunk.stringLiteral(tagName));
        CodeChunk.WithValue keyValue = this.maybeGetKeyNodeValue(node);
        if (keyValue != null) {
            args.add(keyValue);
        }
        jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN_START.call(args));
        jsCodeBuilder.increaseIndentTwice();
        for (int i = 1; i < node.numChildren(); ++i) {
            this.visit((SoyNode)node.getChild(i));
        }
        jsCodeBuilder.decreaseIndentTwice();
        jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN_END.call(new CodeChunk.WithValue[0]));
    }

    @Override
    protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        String tagName = node.getTagName().getStaticTagName();
        if (node.numChildren() == 1) {
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_OPEN.call((Iterable<? extends CodeChunk.WithValue>)ImmutableList.of((Object)CodeChunk.stringLiteral(tagName))));
        } else {
            this.emitOpenStartEndAndVisitSubtree(node, tagName);
        }
        if (node.isSelfClosing() || node.getTagName().isDefinitelyVoid()) {
            this.emitClose(tagName);
        }
    }

    @Nullable
    private CodeChunk.WithValue maybeGetKeyNodeValue(HtmlOpenTagNode parentNode) {
        HtmlAttributeNode keyAttr = parentNode.getDirectAttributeNamed(KEY_ATTRIBUTE_NAME);
        if (keyAttr != null) {
            Object chunks = ImmutableList.of();
            if (keyAttr.hasValue()) {
                HtmlAttributeValueNode value = (HtmlAttributeValueNode)keyAttr.getChild(1);
                Preconditions.checkState((boolean)this.isComputableAsJsExprsVisitor.execOnChildren(value), (Object)"Attribute values that cannot be evalutated to simple expressions is not yet supported  for Incremental DOM code generation");
                chunks = this.genJsExprsVisitor.execOnChildren(value);
            }
            return CodeChunkUtils.concatChunksForceString((List<? extends CodeChunk.WithValue>)chunks);
        }
        return null;
    }

    @Override
    protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
        if (!node.getTagName().isDefinitelyVoid()) {
            this.emitClose(node.getTagName().getStaticTagName());
        }
    }

    private void emitClose(String tagName) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_ELEMENT_CLOSE.call(CodeChunk.stringLiteral(tagName)));
    }

    @Override
    protected void visitRawTextNode(RawTextNode node) {
        CodeChunk.WithValue textArg = CodeChunk.stringLiteral(node.getRawText());
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (node.getHtmlContext() == HtmlContext.HTML_PCDATA) {
            jsCodeBuilder.append(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(textArg));
        } else {
            jsCodeBuilder.addChunkToOutputVar(textArg);
        }
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        ExprNode firstNode = node.getExpr().getRoot();
        switch (node.getHtmlContext()) {
            case HTML_TAG: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.ATTRIBUTES, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                this.errorReporter.report(node.getSourceLocation(), PRINT_ATTR_INVALID_KIND, new Object[]{firstNode.getType().getKind()});
                break;
            }
            case HTML_PCDATA: {
                if (this.tryGenerateFunctionCall(SoyType.Kind.HTML, firstNode) != GenerateFunctionCallResult.INDIRECT_NODE) break;
                List<CodeChunk.WithValue> chunks = this.genJsExprsVisitor.exec(node);
                CodeChunk.WithValue printCall = IncrementalDomRuntime.SOY_IDOM_PRINT.call(CodeChunkUtils.concatChunks(chunks));
                IncrementalDomCodeBuilder codeBuilder = this.getJsCodeBuilder();
                codeBuilder.append(printCall);
                break;
            }
            default: {
                super.visitPrintNode(node);
            }
        }
    }

    @Override
    protected void visitVeLogNode(VeLogNode node) {
        if (node.getLogonlyExpression() != null) {
            TranslateExprNodeVisitor visitor = new TranslateExprNodeVisitor(this.jsSrcOptions, this.templateTranslationContext, this.errorReporter);
            CodeChunk.WithValue isLogOnly = (CodeChunk.WithValue)visitor.exec(node.getLogonlyExpression());
            CodeChunk.WithValue errorMessage = CodeChunk.stringLiteral("Cannot set logonly=\"true\" unless there is a logger configured, but incrementaldom doesn't support loggers");
            this.getJsCodeBuilder().append(CodeChunk.ifStatement(isLogOnly, CodeChunk.throw_(CodeChunk.new_(CodeChunk.id("Error").call(errorMessage)))).build());
        }
        this.visitChildren(node);
    }

    private GenerateFunctionCallResult tryGenerateFunctionCall(SoyType.Kind expectedKind, ExprNode expr) {
        IncrementalDomCodeBuilder jsCodeBuilder = this.getJsCodeBuilder();
        if (expr instanceof VarRefNode && expr.getType().getKind() == expectedKind) {
            VarRefNode varRefNode = (VarRefNode)expr;
            CodeChunk.WithValue call = this.templateTranslationContext.soyToJsVariableMappings().get(varRefNode.getName()).call(new CodeChunk.WithValue[0]);
            jsCodeBuilder.append(call);
            return GenerateFunctionCallResult.EMITTED;
        }
        if (!(expr instanceof OperatorNodes.NullCoalescingOpNode)) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        OperatorNodes.NullCoalescingOpNode opNode = (OperatorNodes.NullCoalescingOpNode)expr;
        if (!(opNode.getLeftChild() instanceof VarRefNode) || !(opNode.getRightChild() instanceof StringNode) || opNode.getLeftChild().getType().getKind() != expectedKind) {
            return GenerateFunctionCallResult.INDIRECT_NODE;
        }
        if (!((StringNode)opNode.getRightChild()).getValue().isEmpty()) {
            this.errorReporter.report(expr.getSourceLocation(), NULL_COALESCING_NON_EMPTY, new Object[0]);
            return GenerateFunctionCallResult.ILLEGAL_NODE;
        }
        VarRefNode varRefNode = (VarRefNode)opNode.getLeftChild();
        CodeChunk.WithValue varName = this.templateTranslationContext.soyToJsVariableMappings().get(varRefNode.getName());
        CodeChunk conditionalCall = CodeChunk.ifStatement(varName, varName.call(new CodeChunk.WithValue[0])).build();
        jsCodeBuilder.append(conditionalCall);
        return GenerateFunctionCallResult.EMITTED;
    }

    @Override
    protected void visitMsgFallbackGroupNode(MsgFallbackGroupNode node) {
        switch (node.getHtmlContext()) {
            case HTML_PCDATA: {
                CodeChunk chunk = new AssistantForHtmlMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupCode(node);
                this.getJsCodeBuilder().append(chunk);
                break;
            }
            case HTML_NORMAL_ATTR_VALUE: {
                CodeChunk.WithValue msgExpression = new AssistantForAttributeMsgs(this, this.jsSrcOptions, this.genCallCodeUtils, this.isComputableAsJsExprsVisitor, this.templateAliases, this.genJsExprsVisitor, this.templateTranslationContext, this.errorReporter).generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(msgExpression));
                break;
            }
            default: {
                CodeChunk.WithValue msgExpression = this.getAssistantForMsgs().generateMsgGroupVariable(node);
                this.getJsCodeBuilder().addChunkToOutputVar(msgExpression);
            }
        }
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        this.visitChildren(node);
    }

    private static final class AssistantForAttributeMsgs
    extends GenJsCodeVisitorAssistantForMsgs {
        AssistantForAttributeMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
            super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
        }

        @Override
        protected CodeChunk.WithValue genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
            CodeChunk.WithValue toEscape = super.genGoogMsgPlaceholder(msgPhNode);
            return JsRuntime.SOY_ESCAPE_HTML.call(toEscape);
        }
    }

    private static enum GenerateFunctionCallResult {
        EMITTED,
        ILLEGAL_NODE,
        INDIRECT_NODE;

    }
}

