/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.incrementaldomsrc.GenIncrementalDomCodeVisitor;
import com.google.template.soy.incrementaldomsrc.IncrementalDomRuntime;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.DoWhile;
import com.google.template.soy.jssrc.dsl.SwitchBuilder;
import com.google.template.soy.jssrc.dsl.VariableDeclaration;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitorAssistantForMsgs;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import java.util.ArrayList;
import java.util.Map;

final class AssistantForHtmlMsgs
extends GenJsCodeVisitorAssistantForMsgs {
    private final Map<String, MsgPlaceholderNode> placeholderNames = Maps.newHashMap();
    private static final String PLACEHOLDER_WRAPPER = "\u0001";
    private static final String PLACEHOLDER_REGEX = "/\\x01\\d+\\x01/g";

    AssistantForHtmlMsgs(GenIncrementalDomCodeVisitor master, SoyJsSrcOptions jsSrcOptions, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
        super(master, jsSrcOptions, genCallCodeUtils, isComputableAsJsExprsVisitor, functionAliases, genJsExprsVisitor, translationContext, errorReporter);
    }

    @Override
    public CodeChunk.WithValue generateMsgGroupVariable(MsgFallbackGroupNode node) {
        throw new IllegalStateException("This class should only be used for via the new idom entry-point.");
    }

    CodeChunk generateMsgGroupCode(MsgFallbackGroupNode node) {
        Preconditions.checkState((boolean)this.placeholderNames.isEmpty(), (Object)"This class is not reusable.");
        Preconditions.checkArgument((node.getHtmlContext() == HtmlContext.HTML_PCDATA ? 1 : 0) != 0, (Object)"AssistantForHtmlMsgs is only for HTML {msg}s.");
        CodeChunk.WithValue translationVar = super.generateMsgGroupVariable(node);
        if (this.placeholderNames.isEmpty()) {
            CodeChunk.WithValue unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar);
            return IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(unescape);
        }
        if (!translationVar.isCheap()) {
            translationVar = this.translationContext.codeGenerator().declarationBuilder().setRhs(translationVar).build().ref();
        }
        VariableDeclaration regexVar = VariableDeclaration.builder("partRe_" + node.getId()).setRhs(CodeChunk.regexLiteral(PLACEHOLDER_REGEX)).build();
        VariableDeclaration matchVar = VariableDeclaration.builder("match_" + node.getId()).build();
        VariableDeclaration lastIndexVar = VariableDeclaration.builder("lastIndex_" + node.getId()).setRhs(CodeChunk.number(0L)).build();
        ArrayList<CodeChunk> doBody = new ArrayList<CodeChunk>();
        doBody.add(matchVar.ref().assign(regexVar.ref().dotAccess("exec").call(translationVar).or(CodeChunk.id("undefined"), this.translationContext.codeGenerator())));
        CodeChunk.WithValue endIndex = matchVar.ref().and(matchVar.ref().dotAccess("index"), this.translationContext.codeGenerator());
        CodeChunk.WithValue unescape = JsRuntime.GOOG_STRING_UNESCAPE_ENTITIES.call(translationVar.dotAccess("substring").call(lastIndexVar.ref(), endIndex));
        doBody.add(IncrementalDomRuntime.INCREMENTAL_DOM_TEXT.call(unescape));
        doBody.add(lastIndexVar.ref().assign(regexVar.ref().dotAccess("lastIndex")));
        SwitchBuilder switchBuilder = CodeChunk.switch_(matchVar.ref().and(matchVar.ref().bracketAccess(CodeChunk.number(0L)), this.translationContext.codeGenerator()));
        for (Map.Entry<String, MsgPlaceholderNode> ph : this.placeholderNames.entrySet()) {
            switchBuilder.case_(CodeChunk.stringLiteral(ph.getKey()), this.master.visitForUseByAssistantsAsCodeChunk(ph.getValue()));
        }
        doBody.add(switchBuilder.build());
        return CodeChunk.statements(CodeChunk.statements(translationVar.initialStatements()), regexVar, lastIndexVar, matchVar, DoWhile.builder().setCondition(matchVar.ref()).setBody(CodeChunk.statements(doBody)).build());
    }

    @Override
    protected CodeChunk.WithValue genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        String name = PLACEHOLDER_WRAPPER + this.placeholderNames.size() + PLACEHOLDER_WRAPPER;
        this.placeholderNames.put(name, msgPhNode);
        return CodeChunk.stringLiteral(name);
    }
}

