/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;

final class ExplodingErrorReporter
extends ErrorReporter {
    static final ErrorReporter EXPLODING = new ExplodingErrorReporter(false);
    static final ErrorReporter EXPLODING_IGNORE_WARNINGS = new ExplodingErrorReporter(true);
    private final boolean ignoreWarnings;

    private ExplodingErrorReporter(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    @Override
    public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        Preconditions.checkNotNull((Object)sourceLocation);
        throw new AssertionError((Object)String.format("Unexpected error: %s at %s", error.format(args), sourceLocation));
    }

    @Override
    public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
        Preconditions.checkNotNull((Object)sourceLocation);
        if (!this.ignoreWarnings) {
            throw new AssertionError((Object)String.format("Unexpected warning: %s at %s", error.format(args), sourceLocation));
        }
    }

    @Override
    int getCurrentNumberOfErrors() {
        return 0;
    }

    @Override
    public ImmutableList<SoyError> getErrors() {
        return ImmutableList.of();
    }

    @Override
    public ImmutableList<SoyError> getWarnings() {
        return ImmutableList.of();
    }
}

