/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.shared.Names;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SoyProtoValueImpl
extends SoyAbstractValue
implements SoyProtoValue,
SoyLegacyObjectMap,
SoyRecord {
    private static final long LOGGING_FREQUENCY = TimeUnit.MINUTES.toMillis(1L);
    private static final Logger logger = Logger.getLogger(SoyProtoValueImpl.class.getName());
    private static final ConcurrentHashMap<String, Long> protoNameToLastLogTimeForRecordAccess = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Long> protoNameToLastLogTimeForMapAccess = new ConcurrentHashMap();
    private static final LoadingCache<Descriptors.Descriptor, ProtoClass> classCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoClass>(){
        final Field.Factory<FieldWithInterpreter> factory = new Field.Factory<FieldWithInterpreter>(){

            @Override
            public FieldWithInterpreter create(Descriptors.FieldDescriptor fieldDescriptor) {
                return new NormalFieldWithInterpreter(fieldDescriptor);
            }

            @Override
            public FieldWithInterpreter createAmbiguousFieldSet(Set<FieldWithInterpreter> fields) {
                return new AmbiguousFieldWithInterpreter(fields);
            }
        };

        public ProtoClass load(Descriptors.Descriptor descriptor) throws Exception {
            LinkedHashSet<Descriptors.FieldDescriptor> extensions = new LinkedHashSet<Descriptors.FieldDescriptor>();
            return new ProtoClass(SoyProtoValueImpl.getDefaultInstance(descriptor), Field.getFieldsForType(descriptor, extensions, this.factory));
        }
    });
    private final Message proto;
    private ProtoClass clazz;
    private Object locationKey;

    @VisibleForTesting
    static void clearLoggingData() {
        protoNameToLastLogTimeForRecordAccess.clear();
        protoNameToLastLogTimeForMapAccess.clear();
    }

    private static Message getDefaultInstance(Descriptors.Descriptor key) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> messageClass = Class.forName(JavaQualifiedNames.getClassName(key));
        return (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
    }

    public static SoyProtoValueImpl create(Message proto) {
        return new SoyProtoValueImpl(proto);
    }

    private SoyProtoValueImpl(Message proto) {
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
    }

    private ProtoClass clazz() {
        ProtoClass localClazz = this.clazz;
        if (localClazz == null) {
            this.clazz = localClazz = (ProtoClass)classCache.getUnchecked((Object)this.proto.getDescriptorForType());
        }
        return localClazz;
    }

    @Override
    public Message getProto() {
        return this.proto;
    }

    @Override
    public SoyValue getProtoField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        if (field.shouldCheckFieldPresenceToEmulateJspbNullability() && !this.proto.hasField(field.getDescriptor())) {
            return NullData.INSTANCE;
        }
        return field.interpretField(this.proto).resolve();
    }

    public void setAccessLocationKey(Object location) {
        this.locationKey = location;
    }

    @Override
    @Deprecated
    public boolean hasField(String name) {
        this.asRecord();
        return this.doHasField(name);
    }

    private boolean doHasField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            return false;
        }
        return field.hasField(this.proto);
    }

    @Override
    @Deprecated
    public SoyValue getField(String name) {
        this.asRecord();
        return this.doGetField(name);
    }

    private SoyValue doGetField(String name) {
        SoyValueProvider valueProvider = this.doGetFieldProvider(name);
        return valueProvider != null ? valueProvider.resolve() : null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getFieldProvider(String name) {
        this.asRecord();
        return this.doGetFieldProvider(name);
    }

    private SoyValueProvider doGetFieldProvider(String name) {
        if (!this.doHasField(name)) {
            return null;
        }
        return ((FieldWithInterpreter)this.clazz().fields.get((Object)name)).interpretField(this.proto).resolve();
    }

    @Override
    @Deprecated
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    @Deprecated
    public Collection<SoyValue> getItemKeys() {
        this.asMap();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : this.clazz().fields.keySet()) {
            if (!this.doHasField(key)) continue;
            builder.add((Object)StringData.forValue(key));
        }
        return builder.build();
    }

    @Override
    @Deprecated
    public boolean hasItem(SoyValue key) {
        this.asMap();
        return this.doHasField(key.stringValue());
    }

    @Override
    @Deprecated
    public SoyValue getItem(SoyValue key) {
        this.asMap();
        return this.doGetField(key.stringValue());
    }

    @Override
    @Deprecated
    public SoyValueProvider getItemProvider(SoyValue key) {
        this.asMap();
        return this.doGetFieldProvider(key.stringValue());
    }

    private void asMap() {
        this.asDeprecatedType("map", protoNameToLastLogTimeForMapAccess);
    }

    private void asRecord() {
        this.asDeprecatedType("record", protoNameToLastLogTimeForRecordAccess);
    }

    private void asDeprecatedType(String type, ConcurrentHashMap<String, Long> lastAccessMap) {
        Object locationKey = this.getAndClearLocationKey();
        String fullName = this.clazz().fullName;
        Long lastTime = lastAccessMap.get(fullName);
        long nowMillis = System.currentTimeMillis();
        if (lastTime == null || lastTime < nowMillis - LOGGING_FREQUENCY) {
            Long replaced = lastAccessMap.put(fullName, nowMillis);
            if (!Objects.equal((Object)replaced, (Object)lastTime)) {
                return;
            }
            if (logger.isLoggable(Level.WARNING)) {
                if (locationKey == null) {
                    Exception e = new Exception("bad proto access");
                    Names.rewriteStackTrace(e);
                    logger.log(Level.WARNING, String.format("Accessing a proto of type %s as a %s is deprecated. Add static types to fix.", fullName, type), e);
                } else {
                    logger.log(Level.WARNING, String.format("Accessing a proto of type %s as a %s is deprecated. Add static types to fix.\n\t%s", fullName, type, locationKey));
                }
            }
        }
    }

    private Object getAndClearLocationKey() {
        Object key = this.locationKey;
        if (key != null) {
            this.locationKey = null;
        }
        return key;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValueImpl)other).proto;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        TextFormat.print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    public String toString() {
        return String.format("SoyProtoValue<%s>", this.proto.getDescriptorForType().getFullName());
    }

    public int hashCode() {
        return this.proto.hashCode();
    }

    public static final class Builder {
        private final ProtoClass clazz;
        private final Message.Builder builder;

        public Builder(Descriptors.Descriptor soyProto) {
            this.clazz = (ProtoClass)classCache.getUnchecked((Object)soyProto);
            this.builder = this.clazz.defaultInstance.newBuilderForType();
        }

        public Builder setField(String field, SoyValue value) {
            ((FieldWithInterpreter)this.clazz.fields.get((Object)field)).assignField(this.builder, value);
            return this;
        }

        public SoyProtoValueImpl build() {
            SoyProtoValueImpl soyProtoValueImpl = new SoyProtoValueImpl(this.builder.build());
            soyProtoValueImpl.clazz = this.clazz;
            return soyProtoValueImpl;
        }
    }

    private static final class AmbiguousFieldWithInterpreter
    extends FieldWithInterpreter {
        final Set<FieldWithInterpreter> fields;

        AmbiguousFieldWithInterpreter(Set<FieldWithInterpreter> fields) {
            super(fields.iterator().next().getDescriptor());
            this.fields = fields;
        }

        @Override
        SoyValue interpretField(Message owner) {
            throw AmbiguousFieldWithInterpreter.ambiguousFieldsError(this.getName(), this.fields);
        }

        @Override
        void assignField(Message.Builder builder, SoyValue value) {
            throw AmbiguousFieldWithInterpreter.ambiguousFieldsError(this.getName(), this.fields);
        }

        @Override
        boolean hasField(Message proto) {
            for (FieldWithInterpreter field : this.fields) {
                if (!field.hasField(proto)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class NormalFieldWithInterpreter
    extends FieldWithInterpreter {
        @LazyInit
        ProtoFieldInterpreter interpreter;

        NormalFieldWithInterpreter(Descriptors.FieldDescriptor fieldDesc) {
            super(fieldDesc);
        }

        private ProtoFieldInterpreter impl() {
            ProtoFieldInterpreter local = this.interpreter;
            if (local == null) {
                local = ProtoFieldInterpreter.create(this.getDescriptor());
            }
            return local;
        }

        @Override
        public SoyValue interpretField(Message message) {
            return this.impl().soyFromProto(message.getField(this.getDescriptor()));
        }

        @Override
        public void assignField(Message.Builder builder, SoyValue value) {
            builder.setField(this.getDescriptor(), this.impl().protoFromSoy(value));
        }

        @Override
        boolean hasField(Message proto) {
            return !this.shouldCheckFieldPresenceToEmulateJspbNullability() || proto.hasField(this.getDescriptor());
        }
    }

    private static abstract class FieldWithInterpreter
    extends Field {
        FieldWithInterpreter(Descriptors.FieldDescriptor fieldDesc) {
            super(fieldDesc);
        }

        abstract SoyValue interpretField(Message var1);

        abstract void assignField(Message.Builder var1, SoyValue var2);

        abstract boolean hasField(Message var1);
    }

    private static final class ProtoClass {
        final ImmutableMap<String, FieldWithInterpreter> fields;
        final Message defaultInstance;
        final String fullName;

        ProtoClass(Message defaultInstance, ImmutableMap<String, FieldWithInterpreter> fields) {
            this.fullName = defaultInstance.getDescriptorForType().getFullName();
            this.defaultInstance = (Message)Preconditions.checkNotNull((Object)defaultInstance);
            this.fields = (ImmutableMap)Preconditions.checkNotNull(fields);
        }
    }
}

