/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.conformance.AutoValue_RuleWithWhitelists;
import com.google.template.soy.conformance.Rule;

abstract class RuleWithWhitelists {
    RuleWithWhitelists() {
    }

    static RuleWithWhitelists create(Rule<? extends Node> rule, ImmutableList<String> whitelistedPaths, ImmutableList<String> onlyApplyToPaths) {
        return new AutoValue_RuleWithWhitelists(rule, whitelistedPaths, onlyApplyToPaths);
    }

    abstract Rule<? extends Node> getRule();

    abstract ImmutableList<String> getWhitelistedPaths();

    abstract ImmutableList<String> getOnlyApplyToPaths();

    boolean shouldCheckConformanceFor(String filePath) {
        for (String whitelistedPath : this.getWhitelistedPaths()) {
            if (!filePath.contains(whitelistedPath)) continue;
            return false;
        }
        ImmutableList<String> onlyApplyToPaths = this.getOnlyApplyToPaths();
        if (onlyApplyToPaths.isEmpty()) {
            return true;
        }
        for (String onlyApplyToPath : onlyApplyToPaths) {
            if (!filePath.contains(onlyApplyToPath)) continue;
            return true;
        }
        return false;
    }
}

