/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.ListType;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyFunctionSignature(name="range", value={@Signature(parameterTypes={"number"}, returnType="list<int>"), @Signature(parameterTypes={"number", "number"}, returnType="list<int>"), @Signature(parameterTypes={"number", "number", "number"}, returnType="list<int>")})
public final class RangeFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    RangeFunction() {
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        ListType intList = ListType.of(IntType.getInstance());
        switch (args.size()) {
            case 1: {
                return SoyExpression.forList(intList, JbcSrcMethods.RANGE_1.invoke(RangeFunction.asInt(args.get(0))));
            }
            case 2: {
                return SoyExpression.forList(intList, JbcSrcMethods.RANGE_2.invoke(RangeFunction.asInt(args.get(0)), RangeFunction.asInt(args.get(1))));
            }
            case 3: {
                return SoyExpression.forList(intList, JbcSrcMethods.RANGE_3.invoke(RangeFunction.asInt(args.get(0)), RangeFunction.asInt(args.get(1)), RangeFunction.asInt(args.get(2))));
            }
        }
        throw new AssertionError();
    }

    private static Expression asInt(SoyExpression soyExpression) {
        return BytecodeUtils.numericConversion(soyExpression.unboxAs(Long.TYPE), Type.INT_TYPE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return new PyFunctionExprBuilder("xrange").addArgs(args).asPyExpr();
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        return new JsExpr("goog.array.range(" + Joiner.on((String)", ").join(Iterables.transform(args, (Function)new Function<JsExpr, String>(){

            public String apply(JsExpr input) {
                return input.getText();
            }
        })) + ")", Integer.MAX_VALUE);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        List<IntegerData> list;
        switch (args.size()) {
            case 1: {
                list = BasicFunctionsRuntime.range(args.get(0).integerValue());
                break;
            }
            case 2: {
                list = BasicFunctionsRuntime.range(args.get(0).integerValue(), args.get(1).integerValue());
                break;
            }
            case 3: {
                list = BasicFunctionsRuntime.range(args.get(0).integerValue(), args.get(1).integerValue(), args.get(2).integerValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return ListImpl.forProviderList(list);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"goog.array");
    }

    private static final class JbcSrcMethods {
        static final MethodRef RANGE_1 = MethodRef.create(BasicFunctionsRuntime.class, "range", Integer.TYPE).asNonNullable();
        static final MethodRef RANGE_2 = MethodRef.create(BasicFunctionsRuntime.class, "range", Integer.TYPE, Integer.TYPE).asNonNullable();
        static final MethodRef RANGE_3 = MethodRef.create(BasicFunctionsRuntime.class, "range", Integer.TYPE, Integer.TYPE, Integer.TYPE).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

