/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Doubles;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.shared.restricted.TypedSoyFunction;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.SoyTypes;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
@SoyFunctionSignature(name="parseFloat", value={@Signature(parameterTypes={"string"}, returnType="float")})
public final class ParseFloatFunction
extends TypedSoyFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    ParseFloatFunction() {
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        String stringValue = args.get(0).stringValue();
        Double d = Doubles.tryParse((String)stringValue);
        return d == null || d.isNaN() ? NullData.INSTANCE : FloatData.forValue(d);
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg = args.get(0).getText();
        return new JsExpr(String.format("soy.$$parseFloat(%s)", arg), Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        return new PyExpr(String.format("runtime.parse_float(%s)", args.get(0).getText()), Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(SoyTypes.makeNullable(FloatType.getInstance()), JbcSrcMethods.PARSE_FLOAT.invoke(args.get(0).unboxAs(String.class)));
    }

    private static final class JbcSrcMethods {
        static final MethodRef PARSE_FLOAT = MethodRef.create(BasicFunctionsRuntime.class, "parseFloat", String.class);

        private JbcSrcMethods() {
        }
    }
}

