/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.AutoValue_Identifier;
import com.google.template.soy.base.internal.BaseUtils;

public abstract class Identifier {
    public static Identifier create(String identifier, SourceLocation location) {
        Preconditions.checkArgument((!identifier.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Identifier(identifier, location);
    }

    public abstract String identifier();

    public abstract SourceLocation location();

    public String toString() {
        return this.identifier();
    }

    public Type type() {
        int dotIndex = this.identifier().indexOf(46);
        if (dotIndex == 0) {
            Preconditions.checkArgument((boolean)BaseUtils.isIdentifierWithLeadingDot(this.identifier()));
            return Type.DOT_IDENT;
        }
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(this.identifier()));
        return dotIndex == -1 ? Type.SINGLE_IDENT : Type.DOTTED_IDENT;
    }

    public Identifier extractPartAfterLastDot() {
        String part = BaseUtils.extractPartAfterLastDot(this.identifier());
        return Identifier.create(part, this.location().offsetStartCol(this.identifier().length() - part.length()));
    }

    public static enum Type {
        SINGLE_IDENT,
        DOT_IDENT,
        DOTTED_IDENT;

    }
}

