/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.inject.Injector;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.SoyCmdLineParser;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Option;

public final class SoyMsgPruner
extends AbstractSoyCompiler {
    @Option(name="--allowExternalCalls", usage="Whether to allow external calls. New projects should set this to false, and existing projects should remove existing external calls and then set this to false. It will save you a lot of headaches. Currently defaults to true for backward compatibility.")
    private boolean allowExternalCalls = true;
    @Option(name="--inputMessageFiles", usage="[Required] The list of files to prune", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> inputMsgFiles = new ArrayList<File>();
    @Option(name="--outputMessageFiles", usage="[Required] The names of the files to output.  There should be one of these (in the same order) for every inputMessageFile", handler=SoyCmdLineParser.FileListOptionHandler.class)
    private List<File> outputMsgFiles = new ArrayList<File>();
    @Option(name="--messagePlugin", usage="Specifies the full class name of a  BidirectionalSoyMsgPlugin.")
    private SoyMsgPlugin messagePlugin;

    public static void main(String[] args) throws IOException {
        new SoyMsgPruner().runMain(args);
    }

    SoyMsgPruner(ClassLoader loader) {
        super(loader);
    }

    SoyMsgPruner() {
    }

    @Override
    void validateFlags() {
        if (this.inputMsgFiles.size() != this.outputMsgFiles.size()) {
            SoyMsgPruner.exitWithError("Must provide exactly one input file for every output file.");
        }
        if (this.messagePlugin == null) {
            SoyMsgPruner.exitWithError("Must specify a --messagePlugin.");
        }
        for (File f : this.inputMsgFiles) {
            if (f.exists()) continue;
            SoyMsgPruner.exitWithError("FileNotFound: " + f);
        }
    }

    @Override
    void compile(SoyFileSet.Builder sfsBuilder, Injector injector) throws IOException {
        sfsBuilder.setAllowExternalCalls(this.allowExternalCalls);
        SoyFileSet sfs = sfsBuilder.build();
        SoyMsgBundleHandler msgBundleHandler = new SoyMsgBundleHandler(this.messagePlugin);
        for (int i = 0; i < this.inputMsgFiles.size(); ++i) {
            File inputMsgFilePath = this.inputMsgFiles.get(i);
            SoyMsgBundle origTransMsgBundle = msgBundleHandler.createFromFile(inputMsgFilePath);
            if (origTransMsgBundle.getLocaleString() == null) {
                throw new IOException("Error opening or parsing message file " + inputMsgFilePath);
            }
            SoyMsgBundle prunedTransSoyMsgBundle = sfs.pruneTranslatedMsgs(origTransMsgBundle);
            File outputMsgFilePath = this.outputMsgFiles.get(i);
            msgBundleHandler.writeToTranslatedMsgsFile(prunedTransSoyMsgBundle, new SoyMsgBundleHandler.OutputFileOptions(), outputMsgFilePath);
        }
    }
}

