/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.inject.Module;
import com.google.template.soy.CommandLineError;
import com.google.template.soy.msgs.SoyMsgPlugin;
import java.io.File;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

final class SoyCmdLineParser
extends CmdLineParser {
    private final ClassLoader pluginLoader;

    SoyCmdLineParser(Object bean, ClassLoader loader) {
        super(bean);
        this.pluginLoader = loader;
    }

    private static <T> T instantiateObject(String moduleFlagName, String objectType, Class<T> clazz, ClassLoader loader, String moduleName) {
        try {
            return Class.forName(moduleName, true, loader).asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new CommandLineError(String.format("Cannot instantiate %s \"%s\" registered with flag --%s.  Please make sure that the %s exists and is on the compiler classpath.\nCaused by: %s", objectType, moduleName, moduleFlagName, objectType, e));
        }
    }

    static {
        CmdLineParser.registerHandler(Module.class, ModuleOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(SoyMsgPlugin.class, MsgPluginOptionHandler.class);
    }

    public static final class MsgPluginOptionHandler
    extends OptionHandler<SoyMsgPlugin> {
        public MsgPluginOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super SoyMsgPlugin> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue(SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "msg plugin", SoyMsgPlugin.class, ((SoyCmdLineParser)this.owner).pluginLoader, parameter));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "com.foo.bar.BazModule";
        }
    }

    public static final class ModuleOptionHandler
    extends OptionHandler<Module> {
        public ModuleOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (parameter.isEmpty()) {
                this.setter.addValue(null);
            } else {
                this.setter.addValue(SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "plugin module", Module.class, ((SoyCmdLineParser)this.owner).pluginLoader, parameter));
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "com.foo.bar.BazModule";
        }
    }

    public static final class FileListOptionHandler
    extends ListOptionHandler<File> {
        public FileListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super File> setter) {
            super(parser, option, setter);
        }

        @Override
        File parseItem(String item) {
            return new File(item);
        }
    }

    public static final class ModuleListOptionHandler
    extends ListOptionHandler<Module> {
        public ModuleListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Module> setter) {
            super(parser, option, setter);
        }

        @Override
        Module parseItem(String item) {
            return (Module)SoyCmdLineParser.instantiateObject(((NamedOptionDef)this.option).name(), "plugin module", Module.class, ((SoyCmdLineParser)this.owner).pluginLoader, item);
        }
    }

    public static final class StringListOptionHandler
    extends ListOptionHandler<String> {
        public StringListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super String> setter) {
            super(parser, option, setter);
        }

        @Override
        String parseItem(String item) {
            return item;
        }
    }

    static abstract class ListOptionHandler<T>
    extends OptionHandler<T> {
        ListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super T> setter) {
            super(parser, option, setter);
        }

        abstract T parseItem(String var1);

        public int parseArguments(Parameters params) throws CmdLineException {
            String parameter = params.getParameter(0);
            if (!parameter.isEmpty()) {
                for (String item : parameter.split(",")) {
                    this.setter.addValue(this.parseItem(item));
                }
            }
            return 1;
        }

        public String getDefaultMetaVariable() {
            return "ITEM,ITEM,...";
        }
    }

    public static final class BooleanOptionHandler
    extends OptionHandler<Boolean> {
        public BooleanOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Boolean> setter) {
            super(parser, option, setter);
        }

        public int parseArguments(Parameters params) throws CmdLineException {
            boolean hasParam;
            boolean value;
            try {
                String nextArg = params.getParameter(0);
                if (nextArg.equalsIgnoreCase("true") || nextArg.equals("1")) {
                    value = true;
                    hasParam = true;
                } else if (nextArg.equalsIgnoreCase("false") || nextArg.equals("0")) {
                    value = false;
                    hasParam = true;
                } else {
                    value = true;
                    hasParam = false;
                }
            }
            catch (CmdLineException e) {
                value = true;
                hasParam = false;
            }
            this.setter.addValue((Object)value);
            return hasParam ? 1 : 0;
        }

        public String getDefaultMetaVariable() {
            return null;
        }
    }
}

